/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.rider.utils.ConnectionException;
import com.jetbrains.rider.utils.DownloadHelperKt;
import com.jetbrains.rider.utils.DownloadStatusHandler;
import com.jetbrains.rider.utils.DownloadStatusHandlerSus;
import com.jetbrains.rider.utils.FetchUrlSizeException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a2\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a:\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00112\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0012\u001a*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u001a8\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u001a\u001a\u00020\u000f2\b\b\u0002\u0010\u001b\u001a\u00020\u0016H\u0002\u001a8\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010!\u001a\u00020\u0001H\u0007\u001a4\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\f\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\"\u001a\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\u001d\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 \u001a\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\u001d\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 \u001a$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010&\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0002\u001a\u001e\u0010'\u001a\u00020\u000b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0002\u001a.\u0010-\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\f\u001a\u00020\rH\u0007\u001a\n\u0010/\u001a\u00020\u000f*\u000200\u001a4\u0010-\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\f\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u00101\u001a6\u00102\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020,2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\f\u001a\u00020\rH\u0003\u001a<\u00102\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020,2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\f\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u00105\u00a8\u00066"}, d2={"isFileDownloadedAndConsistent", "", "url", "", "file", "Ljava/io/File;", "authToken", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "cleanup", "downloadUrlToFile", "", "handler", "Lcom/jetbrains/rider/utils/DownloadStatusHandler;", "retryCount", "", "downloadUrlToFileSus", "Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;", "(Ljava/lang/String;Ljava/io/File;Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryEstablishConnection", "Ljava/net/URLConnection;", "currentSize", "", "size", "isUrlReachable", "fetchUrlSize", "retries", "delay", "unarchive", "archiveFile", "destinationFolder", "excludeFileList", "", "unarchiveHere", "(Ljava/io/File;Ljava/io/File;Ljava/util/List;Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFilesCountFromArchive", "getFilesFromZip", "getFilesFromTarGz", "tagGzFile", "unixPermissionsCrutch", "zipFsPosixPermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "outputPath", "Ljava/nio/file/Path;", "unzip", "outputFolder", "getPerm", "Ljava/util/zip/ZipEntry;", "(Ljava/io/File;Ljava/lang/String;Ljava/util/List;Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "untar", "tempFolder", "symlinkBase", "(Ljava/io/File;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/util/List;Lcom/jetbrains/rider/utils/DownloadStatusHandlerSus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDownloadHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadHelper.kt\ncom/jetbrains/rider/utils/DownloadHelperKt\n+ 2 steps.kt\ncom/intellij/platform/util/progress/StepsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,628:1\n31#2,2:629\n31#2,2:631\n31#2,2:634\n1#3:633\n*S KotlinDebug\n*F\n+ 1 DownloadHelper.kt\ncom/jetbrains/rider/utils/DownloadHelperKt\n*L\n146#1:629,2\n447#1:631,2\n571#1:634,2\n*E\n"})
public final class DownloadHelperKt {
    public static final boolean isFileDownloadedAndConsistent(@NotNull String url2, @NotNull File file, @Nullable String authToken, @Nullable Logger logger, boolean cleanup) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists() && DownloadHelperKt.fetchUrlSize$default(url2, authToken, logger, 0, 0L, 24, null) == file.length()) {
            return true;
        }
        if (cleanup) {
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Files.deleteIfExists(path);
        }
        return false;
    }

    public static /* synthetic */ boolean isFileDownloadedAndConsistent$default(String string, File file, String string2, Logger logger, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return DownloadHelperKt.isFileDownloadedAndConsistent(string, file, string2, logger, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Use suspend one")
    public static final void downloadUrlToFile(@NotNull String url2, @NotNull File file, @Nullable String authToken, @NotNull DownloadStatusHandler handler, int retryCount) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler.isCancelled()) {
            return;
        }
        if (file.exists()) {
            throw new Error("File " + file + " already exists");
        }
        long currentSize = 0L;
        long startTime = System.currentTimeMillis();
        int i = 1;
        if (i <= retryCount) {
            while (true) {
                Logger logger = handler.getLogger();
                if (logger != null) {
                    logger.info("DownloadHelper: Attempt " + i + " to download url: " + url2);
                }
                try {
                    long size = DownloadHelperKt.fetchUrlSize$default(url2, authToken, handler.getLogger(), 0, 0L, 24, null);
                    if (currentSize > size) {
                        currentSize = 0L;
                        Path path = file.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                        Files.deleteIfExists(path);
                    }
                    handler.reportProgress(size, currentSize);
                    Logger logger2 = handler.getLogger();
                    if (logger2 != null) {
                        logger2.info("DownloadHelper: Downloading " + url2 + " -> " + file.getCanonicalPath());
                    }
                    Closeable closeable = new FileOutputStream(file, currentSize > 0L);
                    Throwable throwable = null;
                    try {
                        FileOutputStream output = (FileOutputStream)closeable;
                        boolean bl = false;
                        URLConnection conn = new URL(url2).openConnection();
                        if (currentSize > 0L) {
                            conn.setRequestProperty("Range", "bytes=" + currentSize + "-" + size);
                        }
                        if (authToken != null) {
                            conn.setRequestProperty("Authorization", "Bearer " + authToken);
                        }
                        conn.connect();
                        InputStream inputStream = conn.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                        Closeable closeable2 = inputStream;
                        int n = 8192;
                        closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n);
                        Throwable throwable2 = null;
                        try {
                            int len;
                            BufferedInputStream input = (BufferedInputStream)closeable2;
                            boolean bl2 = false;
                            int bufferSize = 0x100000;
                            byte[] buffer = new byte[bufferSize];
                            while ((len = input.read(buffer)) >= 1 && !handler.isCancelled()) {
                                output.write(buffer, 0, len);
                                handler.reportProgress(size, currentSize += (long)len);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        output = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (handler.isCancelled()) {
                        return;
                    }
                    if (file.length() != size) {
                        throw new Exception("DownloadHelper: Downloaded " + file.length() + " bytes from " + url2 + " but expected " + size);
                    }
                    long downloadTime = System.currentTimeMillis() - startTime;
                    double speed = downloadTime <= 0L ? 0.0 : (double)size * 1000.0 / (double)downloadTime / 1048576.0;
                    double sizeMB = (double)size / 1048576.0;
                    Logger logger3 = handler.getLogger();
                    if (logger3 != null) {
                        long l = downloadTime / (long)1000;
                        String string = "%.1f";
                        Object[] objectArray = new Object[]{sizeMB};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        string = "%.2f";
                        objectArray = new Object[]{speed};
                        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                        logger3.info("DownloadHelper: Downloaded " + url2 + " in " + l + "s, size " + string2 + " MB, avg " + string3 + " MB/s");
                    }
                }
                catch (Throwable e) {
                    if (i < retryCount) {
                        Logger logger4 = handler.getLogger();
                        if (logger4 != null) {
                            logger4.warn("DownloadHelper: Cannot download file " + e.getMessage(), e);
                        }
                    } else {
                        Logger logger5 = handler.getLogger();
                        if (logger5 != null) {
                            logger5.error("DownloadHelper: Cannot download file " + e.getMessage(), e);
                        }
                        throw e;
                    }
                    Thread.sleep((long)(i * (i + 1) / 2) * 1000L);
                    if (i == retryCount) break;
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static final Object downloadUrlToFileSus(@NotNull String url, @NotNull File file, @NotNull DownloadStatusHandlerSus handler, @Nullable String authToken, int retryCount, @NotNull Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static /* synthetic */ Object downloadUrlToFileSus$default(String string, File file, DownloadStatusHandlerSus downloadStatusHandlerSus, String string2, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        return DownloadHelperKt.downloadUrlToFileSus(string, file, downloadStatusHandlerSus, string2, n, (Continuation<? super Unit>)continuation);
    }

    private static final URLConnection tryEstablishConnection(String url2, long currentSize, long size, String authToken) {
        try {
            URLConnection conn = new URL(url2).openConnection();
            if (currentSize > 0L) {
                conn.setRequestProperty("Range", "bytes=" + currentSize + "-" + size);
            }
            if (authToken != null) {
                conn.setRequestProperty("Authorization", "Bearer " + authToken);
            }
            conn.setConnectTimeout(5000);
            conn.connect();
            Intrinsics.checkNotNull((Object)conn);
            return conn;
        }
        catch (Throwable e) {
            throw new ConnectionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isUrlReachable(@NotNull String url2, @Nullable String authToken) {
        URLConnection connection;
        block9: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            connection = new URL(url2).openConnection();
            try {
                if (!(connection instanceof HttpURLConnection)) break block9;
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
                if (authToken != null) {
                    ((HttpURLConnection)connection).setRequestProperty("Authorization", "Bearer " + authToken);
                }
                if (((HttpURLConnection)connection).getResponseCode() == 200) break block9;
                bl = false;
            }
            catch (Exception e) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    throw throwable;
                }
                HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return bl2;
            }
            HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return bl;
        }
        HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long fetchUrlSize(String url2, String authToken, Logger logger, int retries, long delay) {
        HttpURLConnection connection = null;
        int i = 1;
        if (i <= retries) {
            while (true) {
                try {
                    int responseCode;
                    URLConnection uRLConnection = new URL(url2).openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                    connection = (HttpURLConnection)uRLConnection;
                    connection.setRequestMethod("HEAD");
                    connection.setConnectTimeout(30000);
                    connection.setReadTimeout(30000);
                    if (authToken != null) {
                        connection.setRequestProperty("Authorization", "Bearer " + authToken);
                    }
                    if ((responseCode = connection.getResponseCode()) != 200) {
                        String msg = url2 + " returned code " + responseCode + ", accepting only 200";
                        throw new ConnectionException(msg);
                    }
                    long len = connection.getContentLengthLong();
                    if (len <= 0L) {
                        throw new ConnectionException("Unable to get size of " + url2);
                    }
                    long l = len;
                    connection.disconnect();
                    return l;
                }
                catch (Throwable e) {
                    try {
                        if (i < retries) {
                            Thread.sleep((long)(i * (i + 1) / 2) * 1000L);
                            Logger logger2 = logger;
                            if (logger2 != null) {
                                logger2.warn("Fetch URL size failed, retry " + i + "/" + retries + ": " + e.getMessage());
                            }
                        }
                        throw new FetchUrlSizeException(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        HttpURLConnection httpURLConnection = connection;
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                }
                if (i == retries) break;
                ++i;
            }
        }
        throw new IllegalStateException("Fetch URL size failed after " + retries + " attempts");
    }

    static /* synthetic */ long fetchUrlSize$default(String string, String string2, Logger logger, int n, long l, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 3;
        }
        if ((n2 & 0x10) != 0) {
            l = 5000L;
        }
        return DownloadHelperKt.fetchUrlSize(string, string2, logger, n, l);
    }

    @Deprecated(message="Use suspend one")
    public static final void unarchive(@NotNull File archiveFile, @NotNull File destinationFolder, @NotNull List<String> excludeFileList, @NotNull DownloadStatusHandler handler, boolean unarchiveHere) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)destinationFolder, (String)"destinationFolder");
        Intrinsics.checkNotNullParameter(excludeFileList, (String)"excludeFileList");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler.isCancelled()) {
            return;
        }
        File folderForExtract = unarchiveHere ? destinationFolder : new File(archiveFile.getParentFile(), FilesKt.getNameWithoutExtension((File)archiveFile) + ".temp");
        String string = archiveFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".tar.gz", (boolean)false, (int)2, null)) {
            Path path = folderForExtract.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path path2 = destinationFolder.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            DownloadHelperKt.untar(archiveFile, path, path2, excludeFileList, handler);
        } else {
            Object[] objectArray = new String[]{"zip", "nupkg"};
            if (ArraysKt.contains((Object[])objectArray, (Object)FilesKt.getExtension((File)archiveFile))) {
                String string2 = folderForExtract.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
                DownloadHelperKt.unzip(archiveFile, string2, excludeFileList, handler);
            } else {
                throw new Exception("Unknown archive extension: " + archiveFile);
            }
        }
        if (unarchiveHere) {
            return;
        }
        Files.move(folderForExtract.toPath(), destinationFolder.toPath(), new CopyOption[0]);
    }

    public static /* synthetic */ void unarchive$default(File file, File file2, List list, DownloadStatusHandler downloadStatusHandler, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        DownloadHelperKt.unarchive(file, file2, (List<String>)list, downloadStatusHandler, bl);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object unarchive(@NotNull File archiveFile, @NotNull File destinationFolder, @NotNull List<String> excludeFileList, @NotNull DownloadStatusHandlerSus handler, @NotNull Continuation<? super Unit> $completion) {
        block15: {
            block16: {
                if (!($completion instanceof unarchive.1)) ** GOTO lbl-1000
                var9_5 = $completion;
                if ((var9_5.label & -2147483648) != 0) {
                    var9_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl($completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        int I$0;
                        /* synthetic */ Object result;
                        int label;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return DownloadHelperKt.unarchive(null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.L$0 = archiveFile;
                        $continuation.L$1 = destinationFolder;
                        $continuation.L$2 = excludeFileList;
                        $continuation.L$3 = handler;
                        $continuation.label = 1;
                        v0 = handler.isCancelled((Continuation<? super Boolean>)$continuation);
                        if (v0 == var10_7) {
                            return var10_7;
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        handler = (DownloadStatusHandlerSus)$continuation.L$3;
                        excludeFileList = (List)$continuation.L$2;
                        destinationFolder = (File)$continuation.L$1;
                        archiveFile = (File)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            return Unit.INSTANCE;
                        }
                        folderForExtract = new Ref.ObjectRef();
                        folderForExtract.element = new File(archiveFile.getParentFile(), FilesKt.getNameWithoutExtension((File)archiveFile) + ".temp");
                        i = 1;
                        while (((File)folderForExtract.element).exists() && !FilesKt.deleteRecursively((File)((File)folderForExtract.element))) {
                            folderForExtract.element = new File(archiveFile.getParentFile(), FilesKt.getNameWithoutExtension((File)archiveFile) + i + ".temp");
                            ++i;
                        }
                        v1 = archiveFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                        if (!StringsKt.endsWith$default((String)v1, (String)".tar.gz", (boolean)false, (int)2, null)) break;
                        v2 = ((File)folderForExtract.element).toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toPath(...)");
                        v3 = destinationFolder.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toPath(...)");
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)archiveFile);
                        $continuation.L$1 = destinationFolder;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)excludeFileList);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)handler);
                        $continuation.L$4 = folderForExtract;
                        $continuation.I$0 = i;
                        $continuation.label = 2;
                        v4 = DownloadHelperKt.untar(archiveFile, v2, v3, excludeFileList, handler, (Continuation<? super Unit>)$continuation);
                        if (v4 == var10_7) {
                            return var10_7;
                        }
                        break block15;
                    }
                    case 2: {
                        i = $continuation.I$0;
                        folderForExtract = (Ref.ObjectRef)$continuation.L$4;
                        handler = (DownloadStatusHandlerSus)$continuation.L$3;
                        excludeFileList = (List)$continuation.L$2;
                        destinationFolder = (File)$continuation.L$1;
                        archiveFile = (File)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        break block15;
                    }
                }
                var7_12 = new String[]{"zip", "nupkg"};
                if (!ArraysKt.contains((Object[])var7_12, (Object)FilesKt.getExtension((File)archiveFile))) break block16;
                v5 = ((File)folderForExtract.element).getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getCanonicalPath(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)archiveFile);
                $continuation.L$1 = destinationFolder;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)excludeFileList);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)handler);
                $continuation.L$4 = folderForExtract;
                $continuation.I$0 = i;
                $continuation.label = 3;
                v6 = DownloadHelperKt.unzip(archiveFile, v5, excludeFileList, handler, (Continuation<? super Unit>)$continuation);
                if (v6 == var10_7) {
                    return var10_7;
                }
                break block15;
                {
                    case 3: {
                        i = $continuation.I$0;
                        folderForExtract = (Ref.ObjectRef)$continuation.L$4;
                        handler = (DownloadStatusHandlerSus)$continuation.L$3;
                        excludeFileList = (List)$continuation.L$2;
                        destinationFolder = (File)$continuation.L$1;
                        archiveFile = (File)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
                        break block15;
                    }
                }
            }
            throw new Exception("Unknown archive extension: " + archiveFile);
        }
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)archiveFile);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)destinationFolder);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)excludeFileList);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)handler);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)folderForExtract);
        $continuation.I$0 = i;
        $continuation.label = 4;
        v7 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>((Ref.ObjectRef<File>)folderForExtract, destinationFolder, null){
            int label;
            final /* synthetic */ Ref.ObjectRef<File> $folderForExtract;
            final /* synthetic */ File $destinationFolder;
            {
                this.$folderForExtract = $folderForExtract;
                this.$destinationFolder = $destinationFolder;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return Files.move(((File)this.$folderForExtract.element).toPath(), this.$destinationFolder.toPath(), new CopyOption[0]);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Continuation)$continuation);
        if (v7 == var10_7) {
            return var10_7;
        }
        ** GOTO lbl113
        {
            case 4: {
                i = $continuation.I$0;
                folderForExtract = (Ref.ObjectRef)$continuation.L$4;
                handler = (DownloadStatusHandlerSus)$continuation.L$3;
                excludeFileList = (List)$continuation.L$2;
                destinationFolder = (File)$continuation.L$1;
                archiveFile = (File)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl113:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final List<String> getFilesCountFromArchive(@NotNull File archiveFile, @NotNull List<String> excludeFileList) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter(excludeFileList, (String)"excludeFileList");
        String string = archiveFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".tar.gz", (boolean)false, (int)2, null)) {
            list = DownloadHelperKt.getFilesFromTarGz(archiveFile, excludeFileList);
        } else {
            Object[] objectArray = new String[]{"zip", "nupkg"};
            if (ArraysKt.contains((Object[])objectArray, (Object)FilesKt.getExtension((File)archiveFile))) {
                list = DownloadHelperKt.getFilesFromZip(archiveFile, excludeFileList);
            } else {
                throw new Exception("Unknown archive type: " + archiveFile.getCanonicalPath());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<String> getFilesFromZip(@NotNull File archiveFile, @NotNull List<String> excludeFileList) {
        List list;
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter(excludeFileList, (String)"excludeFileList");
        Closeable closeable = new ZipFile(archiveFile);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            list = SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), arg_0 -> DownloadHelperKt.getFilesFromZip$lambda$0$0(excludeFileList, arg_0)), DownloadHelperKt::getFilesFromZip$lambda$0$1))));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> getFilesFromTarGz(File tagGzFile, List<String> excludeFileList) {
        List result2 = new ArrayList();
        Closeable closeable = new FileInputStream(tagGzFile);
        Throwable throwable = null;
        try {
            FileInputStream file = (FileInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new GzipCompressorInputStream((InputStream)file);
            Throwable throwable2 = null;
            try {
                GzipCompressorInputStream gzip = (GzipCompressorInputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = (Closeable)new TarArchiveInputStream((InputStream)gzip);
                Throwable throwable3 = null;
                try {
                    TarArchiveInputStream input = (TarArchiveInputStream)closeable3;
                    boolean bl3 = false;
                    while (input.getNextTarEntry() != null) {
                        TarArchiveEntry entry2;
                        if (entry2.isDirectory() || excludeFileList.contains(new File(entry2.getName()).getName())) continue;
                        String string = entry2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        result2.add(string);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)result2));
    }

    private static final void unixPermissionsCrutch(Set<? extends PosixFilePermission> zipFsPosixPermissions, Path outputPath) {
        try {
            Set<PosixFilePermission> actualPermissions = Files.getPosixFilePermissions(outputPath, new LinkOption[0]);
            Intrinsics.checkNotNull(actualPermissions);
            Set updatedPermissions = CollectionsKt.union((Iterable)actualPermissions, (Iterable)zipFsPosixPermissions);
            Files.setPosixFilePermissions(outputPath, updatedPermissions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Deprecated(message="Use suspend one")
    public static final void unzip(@NotNull File archiveFile, @NotNull String outputFolder, @NotNull List<String> excludeFileList, @NotNull DownloadStatusHandler handler) {
        block21: {
            Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
            Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
            Intrinsics.checkNotNullParameter(excludeFileList, (String)"excludeFileList");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            try {
                v0 = handler.getLogger();
                if (v0 != null) {
                    v0.info("Unzipping " + archiveFile + " to " + outputFolder);
                }
                fileTotalCount = ((Collection)DownloadHelperKt.getFilesFromZip(archiveFile, excludeFileList)).size();
                if (fileTotalCount == 0) {
                    return;
                }
                fileCount = 0.0;
                handler.reportProgress(fileTotalCount, (long)fileCount);
                zipFs = SystemInfo.isUnix != false ? FileSystems.newFileSystem(archiveFile.toPath(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"enablePosixFileAttributes", (Object)"true"))) : null;
                var6_8 = new ZipInputStream(new FileInputStream(archiveFile));
                var7_9 = null;
                try {
                    zipFile = (ZipInputStream)var6_8;
                    $i$a$-use-DownloadHelperKt$unzip$1 = false;
                    entry = null;
                    entry = zipFile.getNextEntry();
                    while (entry != null && !handler.isCancelled()) {
                        v1 = handler.getLogger();
                        if (v1 != null) {
                            v1.trace("Current entry: " + entry);
                        }
                        var11_15 /* !! */  = new String[]{entry.getName()};
                        outputPath = Paths.get(outputFolder, var11_15 /* !! */ );
                        if (entry.isDirectory()) ** GOTO lbl-1000
                        v2 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                        v3 = File.separator;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"separator");
                        if (StringsKt.endsWith$default((String)v2, (String)v3, (boolean)false, (int)2, null)) lbl-1000:
                        // 2 sources

                        {
                            v4 = Files.createDirectories(outputPath, new FileAttribute[0]);
                        } else {
                            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                            handler.reportProgress(fileTotalCount, (long)(fileCount += 1.0));
                            var11_15 /* !! */  = Files.newOutputStream(outputPath, new OpenOption[0]);
                            var13_17 = null;
                            try {
                                outputStream = (OutputStream)var11_15 /* !! */ ;
                                $i$a$-use-DownloadHelperKt$unzip$1$1 = false;
                                outputStream = zipFile.transferTo((OutputStream)outputStream);
                            }
                            catch (Throwable var15_21) {
                                var13_17 = var15_21;
                                throw var15_21;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var11_15 /* !! */ , (Throwable)var13_17);
                            }
                            v4 = (Comparable)outputStream;
                        }
                        if (zipFs != null) {
                            $i$a$-let-DownloadHelperKt$unzip$1$2 = false;
                            v5 = Files.getPosixFilePermissions(zipFs.getPath(entry.getName(), new String[0]), new LinkOption[0]);
                            Intrinsics.checkNotNullExpressionValue(v5, (String)"getPosixFilePermissions(...)");
                            Intrinsics.checkNotNull((Object)outputPath);
                            DownloadHelperKt.unixPermissionsCrutch(v5, outputPath);
                        }
                        zipFile.closeEntry();
                        entry = zipFile.getNextEntry();
                    }
                    var8_10 = Unit.INSTANCE;
                }
                catch (Throwable var9_12) {
                    var7_9 = var9_12;
                    throw var9_12;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var6_8, (Throwable)var7_9);
                }
            }
            catch (Throwable e) {
                FilesKt.deleteRecursively((File)new File(outputFolder));
                throw new Exception("Can't unzip " + archiveFile, e);
            }
            v6 = handler.getLogger();
            if (v6 == null) break block21;
            v6.info("File " + archiveFile + " was successfully unzipped to " + outputFolder);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int getPerm(@NotNull ZipEntry $this$getPerm) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$getPerm, (String)"<this>");
        Field it = $this$getPerm.getClass().getDeclaredField("extraAttributes");
        boolean bl = false;
        it.setAccessible(true);
        int value = it.getInt($this$getPerm);
        return (int)var3_3;
    }

    /*
     * Exception decompiling
     */
    private static final Object unzip(File archiveFile, String outputFolder, List<String> excludeFileList, DownloadStatusHandlerSus handler, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK], 3[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Use suspend one")
    private static final void untar(File archiveFile, Path tempFolder, Path symlinkBase, List<String> excludeFileList, DownloadStatusHandler handler) {
        try {
            int fileTotalCount = ((Collection)DownloadHelperKt.getFilesFromTarGz(archiveFile, excludeFileList)).size();
            if (fileTotalCount == 0) {
                return;
            }
            double fileCount = 0.0;
            handler.reportProgress(fileTotalCount, (long)fileCount);
            Closeable closeable = new FileInputStream(archiveFile);
            Throwable throwable = null;
            try {
                FileInputStream stream = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = stream;
                int n = 8192;
                closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n);
                Throwable throwable2 = null;
                try {
                    BufferedInputStream buffered = (BufferedInputStream)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = (Closeable)new GzipCompressorInputStream((InputStream)buffered);
                    Throwable throwable3 = null;
                    try {
                        GzipCompressorInputStream gzip = (GzipCompressorInputStream)closeable3;
                        boolean bl3 = false;
                        Closeable closeable4 = (Closeable)new TarArchiveInputStream((InputStream)gzip);
                        Throwable throwable4 = null;
                        try {
                            TarArchiveInputStream input = (TarArchiveInputStream)closeable4;
                            boolean bl4 = false;
                            while (input.getNextTarEntry() != null && !handler.isCancelled()) {
                                Object object;
                                Object object2;
                                Object object3;
                                TarArchiveEntry entry2;
                                if (!entry2.isDirectory()) {
                                    handler.reportProgress(fileTotalCount, (long)(fileCount += 1.0));
                                }
                                if (entry2.isDirectory()) {
                                    tempFolder.resolve(entry2.getName()).toFile().mkdirs();
                                    continue;
                                }
                                Path destination = tempFolder.resolve(entry2.getName());
                                Object object4 = entry2.getLinkName();
                                if (object4 == null || StringsKt.isBlank((CharSequence)object4)) {
                                    Intrinsics.checkNotNull((Object)destination);
                                    object4 = PathKt.outputStream((Path)destination);
                                    object3 = null;
                                    try {
                                        OutputStream it = (OutputStream)object4;
                                        boolean bl5 = false;
                                        FileUtil.copy((InputStream)((InputStream)input), (int)((int)entry2.getSize()), (OutputStream)it);
                                        object2 = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable5) {
                                        object3 = throwable5;
                                        throw throwable5;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)object4, (Throwable)object3);
                                    }
                                    if (SystemInfo.isUnix && (entry2.getMode() & 0x49) != 0) {
                                        object4 = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE};
                                        Files.setPosixFilePermissions(destination, SetsKt.setOf((Object[])object4));
                                    }
                                    object = Unit.INSTANCE;
                                    continue;
                                }
                                String baseLinkPath = "/Library/Frameworks";
                                if (Paths.get(entry2.getLinkName(), new String[0]).startsWith(baseLinkPath)) {
                                    Path path;
                                    Path relLinkPath = Paths.get(baseLinkPath, new String[0]).relativize(Paths.get(entry2.getLinkName(), new String[0]));
                                    Intrinsics.checkNotNull((Object)destination);
                                    object2 = destination;
                                    Intrinsics.checkNotNullExpressionValue((Object)symlinkBase.resolve(relLinkPath), (String)"resolve(...)");
                                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                    Path path2 = Files.createSymbolicLink((Path)object2, path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                                    object = path2;
                                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createSymbolicLink(...)");
                                    continue;
                                }
                                Intrinsics.checkNotNull((Object)destination);
                                object3 = destination;
                                Intrinsics.checkNotNullExpressionValue((Object)symlinkBase.resolve(entry2.getName()).getParent().resolve(entry2.getLinkName()), (String)"resolve(...)");
                                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                Path path = Files.createSymbolicLink((Path)object3, (Path)object2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                                object = path;
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createSymbolicLink(...)");
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable6) {
                            throwable4 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable7) {
                        throwable3 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            throw new Exception("Can't untar " + archiveFile + ": " + e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    private static final Object untar(File archiveFile, Path tempFolder, Path symlinkBase, List<String> excludeFileList, DownloadStatusHandlerSus handler, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 5[TRYBLOCK], 6[TRYBLOCK], 3[TRYBLOCK], 4[TRYBLOCK], 1[TRYBLOCK]], but top level block is 42[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final boolean getFilesFromZip$lambda$0$0(List $excludeFileList, ZipEntry it) {
        return !it.isDirectory() && !$excludeFileList.contains(new File(it.getName()).getName());
    }

    private static final String getFilesFromZip$lambda$0$1(ZipEntry it) {
        return it.getName();
    }

    public static final /* synthetic */ URLConnection access$tryEstablishConnection(String url2, long currentSize, long size, String authToken) {
        return DownloadHelperKt.tryEstablishConnection(url2, currentSize, size, authToken);
    }

    public static final /* synthetic */ Object access$unzip(File archiveFile, String outputFolder, List excludeFileList, DownloadStatusHandlerSus handler, Continuation $completion) {
        return DownloadHelperKt.unzip(archiveFile, outputFolder, excludeFileList, handler, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$untar(File archiveFile, Path tempFolder, Path symlinkBase, List excludeFileList, DownloadStatusHandlerSus handler, Continuation $completion) {
        return DownloadHelperKt.untar(archiveFile, tempFolder, symlinkBase, excludeFileList, handler, (Continuation<? super Unit>)$completion);
    }
}

