/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils.threading;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u0012*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0012B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u000bJ\b\u0010\u0010\u001a\u00020\u0005H\u0002J\b\u0010\u0011\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/utils/threading/BackgroundProcessQueue;", "T", "", "processor", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "queue", "Lkotlin/collections/ArrayDeque;", "isRunning", "", "enqueue", "item", "(Ljava/lang/Object;)V", "isReady", "processQueue", "runBackgroundProcess", "Companion", "intellij.rider.rdclient.dotnet"})
public final class BackgroundProcessQueue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<T, Unit> processor;
    @NotNull
    private final ArrayDeque<T> queue;
    private boolean isRunning;
    @NotNull
    private static final Logger LOG;

    public BackgroundProcessQueue(@NotNull Function1<? super T, Unit> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.processor = processor;
        this.queue = new ArrayDeque(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(T item) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        ArrayDeque<T> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            boolean bl = false;
            this.queue.addLast(item);
            Unit unit = Unit.INSTANCE;
        }
        this.processQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        ArrayDeque<T> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            boolean bl = false;
            boolean bl2 = !this.isRunning && this.queue.isEmpty();
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processQueue() {
        ArrayDeque<T> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            boolean bl = false;
            if (!this.isRunning && !this.queue.isEmpty()) {
                this.isRunning = true;
                this.runBackgroundProcess();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void runBackgroundProcess() {
        ApplicationKt.getApplication().executeOnPooledThread(() -> BackgroundProcessQueue.runBackgroundProcess$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void runBackgroundProcess$lambda$0(BackgroundProcessQueue this$0) {
        while (true) {
            Object object;
            ArrayDeque arrayDeque = this$0.queue;
            synchronized (arrayDeque) {
                Object object2;
                boolean bl = false;
                if (this$0.queue.isEmpty()) {
                    this$0.isRunning = false;
                    object2 = null;
                } else {
                    object2 = this$0.queue.removeFirstOrNull();
                }
                object = object2;
            }
            if (object == null) break;
            try {
                Object item;
                this$0.processor.invoke(item);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(BackgroundProcessQueue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/utils/threading/BackgroundProcessQueue$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

