/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0082\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/AssemblyVersion;", "", "major", "", "minor", "build", "revision", "<init>", "(IIII)V", "getMajor", "()I", "getMinor", "getBuild", "getRevision", "compareTo", "other", "toString", "", "Companion", "intellij.rider.rdclient.dotnet"})
public final class AssemblyVersion
implements Comparable<AssemblyVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int build;
    private final int revision;

    public AssemblyVersion(int major, int minor, int build2, int revision) {
        this.major = major;
        this.minor = minor;
        this.build = build2;
        this.revision = revision;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getBuild() {
        return this.build;
    }

    public final int getRevision() {
        return this.revision;
    }

    @Override
    public int compareTo(@NotNull AssemblyVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int compareMajor = Intrinsics.compare((int)this.major, (int)other.major);
        if (compareMajor != 0) {
            return compareMajor;
        }
        int compareMinor = Intrinsics.compare((int)this.minor, (int)other.minor);
        if (compareMinor != 0) {
            return compareMinor;
        }
        int compareBuild = Intrinsics.compare((int)this.build, (int)other.build);
        if (compareBuild != 0) {
            return compareBuild;
        }
        return Intrinsics.compare((int)this.revision, (int)other.revision);
    }

    @NotNull
    public String toString() {
        return this.major + "." + this.minor + "." + this.build + "." + this.revision;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/AssemblyVersion$Companion;", "", "<init>", "()V", "parse", "Lcom/jetbrains/rider/AssemblyVersion;", "versionString", "", "tryGetVersion", "", "index", "versions", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AssemblyVersion parse(@Nullable String versionString) {
            if (versionString == null) {
                return new AssemblyVersion(0, 0, 0, 0);
            }
            char[] cArray = new char[]{'.'};
            List versions = StringsKt.split$default((CharSequence)versionString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            int major = this.tryGetVersion(0, versions);
            int minor = this.tryGetVersion(1, versions);
            int build2 = this.tryGetVersion(2, versions);
            int revision = this.tryGetVersion(3, versions);
            return new AssemblyVersion(major, minor, build2, revision);
        }

        private final int tryGetVersion(int index, List<String> versions) {
            if (index >= versions.size()) {
                return 0;
            }
            Integer n = StringsKt.toIntOrNull((String)versions.get(index));
            return n != null ? n : 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

