/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.PathInfo;
import com.jetbrains.rider.environment.RiderEnvironment;
import com.jetbrains.rider.util.OSKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\nH\u00c6\u0003J?\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0014\u0010&\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010(\u001a\u00020)H\u00d6\u0081\u0004J\n\u0010*\u001a\u00020\u0007H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/CustomInfo;", "", "binDirectory", "Lcom/jetbrains/rider/PathInfo;", "runOnNetCore", "", "dotnetDir", "", "useNativeLauncher", "environment", "Lcom/jetbrains/rider/environment/RiderEnvironment;", "<init>", "(Lcom/jetbrains/rider/PathInfo;ZLjava/lang/String;ZLcom/jetbrains/rider/environment/RiderEnvironment;)V", "getBinDirectory", "()Lcom/jetbrains/rider/PathInfo;", "getRunOnNetCore", "()Z", "getDotnetDir", "()Ljava/lang/String;", "getUseNativeLauncher", "getEnvironment", "()Lcom/jetbrains/rider/environment/RiderEnvironment;", "cpu", "Lcom/jetbrains/rider/CPUKind;", "getCpu", "()Lcom/jetbrains/rider/CPUKind;", "os", "Lcom/jetbrains/rider/util/OSKind;", "getOs", "()Lcom/jetbrains/rider/util/OSKind;", "dotnetExecutable", "getDotnetExecutable", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
public final class CustomInfo {
    @NotNull
    private final PathInfo binDirectory;
    private final boolean runOnNetCore;
    @Nullable
    private final String dotnetDir;
    private final boolean useNativeLauncher;
    @Nullable
    private final RiderEnvironment environment;

    public CustomInfo(@NotNull PathInfo binDirectory, boolean runOnNetCore, @Nullable String dotnetDir, boolean useNativeLauncher, @Nullable RiderEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        this.binDirectory = binDirectory;
        this.runOnNetCore = runOnNetCore;
        this.dotnetDir = dotnetDir;
        this.useNativeLauncher = useNativeLauncher;
        this.environment = environment;
    }

    @NotNull
    public final PathInfo getBinDirectory() {
        return this.binDirectory;
    }

    public final boolean getRunOnNetCore() {
        return this.runOnNetCore;
    }

    @Nullable
    public final String getDotnetDir() {
        return this.dotnetDir;
    }

    public final boolean getUseNativeLauncher() {
        return this.useNativeLauncher;
    }

    @Nullable
    public final RiderEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final CPUKind getCpu() {
        return this.binDirectory.getCpuKind();
    }

    @NotNull
    public final OSKind getOs() {
        return this.binDirectory.getCpuKind().getOsKind();
    }

    @Nullable
    public final String getDotnetExecutable() {
        return this.dotnetDir != null ? this.dotnetDir + this.getOs().getPlatform().fileSeparator + "dotnet" + (this.getOs() == OSKind.Windows ? ".exe" : "") : null;
    }

    @NotNull
    public final PathInfo component1() {
        return this.binDirectory;
    }

    public final boolean component2() {
        return this.runOnNetCore;
    }

    @Nullable
    public final String component3() {
        return this.dotnetDir;
    }

    public final boolean component4() {
        return this.useNativeLauncher;
    }

    @Nullable
    public final RiderEnvironment component5() {
        return this.environment;
    }

    @NotNull
    public final CustomInfo copy(@NotNull PathInfo binDirectory, boolean runOnNetCore, @Nullable String dotnetDir, boolean useNativeLauncher, @Nullable RiderEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        return new CustomInfo(binDirectory, runOnNetCore, dotnetDir, useNativeLauncher, environment);
    }

    public static /* synthetic */ CustomInfo copy$default(CustomInfo customInfo, PathInfo pathInfo, boolean bl, String string, boolean bl2, RiderEnvironment riderEnvironment, int n, Object object) {
        if ((n & 1) != 0) {
            pathInfo = customInfo.binDirectory;
        }
        if ((n & 2) != 0) {
            bl = customInfo.runOnNetCore;
        }
        if ((n & 4) != 0) {
            string = customInfo.dotnetDir;
        }
        if ((n & 8) != 0) {
            bl2 = customInfo.useNativeLauncher;
        }
        if ((n & 0x10) != 0) {
            riderEnvironment = customInfo.environment;
        }
        return customInfo.copy(pathInfo, bl, string, bl2, riderEnvironment);
    }

    @NotNull
    public String toString() {
        return "CustomInfo(binDirectory=" + this.binDirectory + ", runOnNetCore=" + this.runOnNetCore + ", dotnetDir=" + this.dotnetDir + ", useNativeLauncher=" + this.useNativeLauncher + ", environment=" + this.environment + ")";
    }

    public int hashCode() {
        int result2 = this.binDirectory.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.runOnNetCore);
        result2 = result2 * 31 + (this.dotnetDir == null ? 0 : this.dotnetDir.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.useNativeLauncher);
        result2 = result2 * 31 + (this.environment == null ? 0 : this.environment.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CustomInfo)) {
            return false;
        }
        CustomInfo customInfo = (CustomInfo)other;
        if (!Intrinsics.areEqual((Object)this.binDirectory, (Object)customInfo.binDirectory)) {
            return false;
        }
        if (this.runOnNetCore != customInfo.runOnNetCore) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dotnetDir, (Object)customInfo.dotnetDir)) {
            return false;
        }
        if (this.useNativeLauncher != customInfo.useNativeLauncher) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.environment, (Object)customInfo.environment);
    }
}

