/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.AssemblyVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/RiderVersions;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getExpectedBuildArtifactVersion", "Lcom/jetbrains/rider/AssemblyVersion;", "getBuildNumber", "tryParseEapNumber", "", "fullVersion", "", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderVersions.kt\ncom/jetbrains/rider/RiderVersions\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n654#2,5:71\n13#3:76\n13#4:77\n*S KotlinDebug\n*F\n+ 1 RiderVersions.kt\ncom/jetbrains/rider/RiderVersions\n*L\n63#1:71,5\n8#1:76\n8#1:77\n*E\n"})
public final class RiderVersions {
    @NotNull
    public static final RiderVersions INSTANCE = new RiderVersions();
    @NotNull
    private static final Logger logger;

    private RiderVersions() {
    }

    @NotNull
    public final AssemblyVersion getExpectedBuildArtifactVersion() {
        int n;
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        AssemblyVersion parsedNumber = this.getBuildNumber();
        if (PluginManagerCore.isRunningFromSources()) {
            n = -1;
        } else if (applicationInfo.isEAP()) {
            String string = applicationInfo.getFullVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
            n = this.tryParseEapNumber(string);
        } else {
            n = 65536;
        }
        int patch = n;
        return new AssemblyVersion(parsedNumber.getMajor(), parsedNumber.getMinor(), parsedNumber.getBuild(), patch);
    }

    @NotNull
    public final AssemblyVersion getBuildNumber() {
        Object object;
        Object minorVersionParts;
        char[] cArray;
        ApplicationInfoEx $this$getBuildNumber_u24lambda_u240 = ApplicationInfoEx.getInstanceEx();
        boolean bl = false;
        Object object2 = $this$getBuildNumber_u24lambda_u240.getMajorVersion();
        int major = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
        int minor = 0;
        int micro = 0;
        int patch = 0;
        Object object3 = $this$getBuildNumber_u24lambda_u240.getMinorVersion();
        if (object3 == null || (object3 = StringsKt.split$default((CharSequence)((CharSequence)object3), (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null)) == null) {
            object3 = CollectionsKt.emptyList();
        }
        if (CollectionsKt.any((Iterable)((Iterable)(minorVersionParts = object3)))) {
            Integer n = StringsKt.toIntOrNull((String)((String)minorVersionParts.get(0)));
            int n2 = minor = n != null ? n : 0;
            if (minorVersionParts.size() > 1) {
                Integer n3 = StringsKt.toIntOrNull((String)((String)minorVersionParts.get(1)));
                int n4 = micro = n3 != null ? n3 : 0;
                if (minorVersionParts.size() > 2) {
                    Integer n5 = StringsKt.toIntOrNull((String)((String)minorVersionParts.get(2)));
                    patch = n5 != null ? n5 : 0;
                    return new AssemblyVersion(major, minor, micro, patch);
                }
                Object object4 = $this$getBuildNumber_u24lambda_u240.getMicroVersion();
                patch = object4 != null && (object4 = StringsKt.toIntOrNull((String)object4)) != null ? (Integer)object4 : 0;
                return new AssemblyVersion(major, minor, micro, patch);
            }
        } else {
            minor = 0;
        }
        micro = (object = $this$getBuildNumber_u24lambda_u240.getMicroVersion()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
        Object object5 = $this$getBuildNumber_u24lambda_u240.getPatchVersion();
        patch = object5 != null && (object5 = StringsKt.toIntOrNull((String)object5)) != null ? (Integer)object5 : 0;
        return new AssemblyVersion(major, minor, micro, patch);
    }

    private final int tryParseEapNumber(String fullVersion) {
        String string;
        block2: {
            int eapIndex = StringsKt.indexOf$default((CharSequence)fullVersion, (String)"eap", (int)0, (boolean)true, (int)2, null);
            if (eapIndex == -1) {
                logger.warn("Unable to find eap marker inside full version " + fullVersion);
                return -1;
            }
            String versionSuffix = ((Object)StringsKt.trim((CharSequence)StringsKt.drop((String)fullVersion, (int)(eapIndex + 3)))).toString();
            logger.info("IDE version: " + fullVersion + ", eap suffix: " + versionSuffix);
            String $this$takeWhile$iv = versionSuffix;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (Character.isDigit(it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block2;
            }
            string = $this$takeWhile$iv;
        }
        String eapVersionString = string;
        Integer n = StringsKt.toIntOrNull((String)eapVersionString);
        int eapVersion = n != null ? n : -1;
        logger.info("EAP version: " + eapVersion);
        return eapVersion;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderVersions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderVersions.logger = logger;
    }
}

