/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.actions.impl;

import com.intellij.codeInsight.actions.MultiCaretCodeInsightAction;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.lang.ProtocolLanguageManager;
import com.jetbrains.rdclient.actions.ActionCallStrategy;
import com.jetbrains.rdclient.actions.base.BackendDelegatingActionCustomization;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.editorActions.RiderTypingPolicy;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H'J\b\u0010\u0016\u001a\u00020\u0017H&\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/actions/impl/RiderCommentActionBase;", "Lcom/jetbrains/rdclient/actions/base/BackendDelegatingActionCustomization;", "<init>", "()V", "frontendUpdate", "", "frontendActionId", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "inputEvent", "Ljava/awt/event/InputEvent;", "getActionCallStrategy", "Lcom/jetbrains/rdclient/actions/ActionCallStrategy;", "executeBackend", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getMainMenuPresentationText", "getFrontendAction", "Lcom/intellij/codeInsight/actions/MultiCaretCodeInsightAction;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCommentActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCommentActionBase.kt\ncom/jetbrains/rider/actions/impl/RiderCommentActionBase\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,63:1\n30#2,2:64\n*S KotlinDebug\n*F\n+ 1 RiderCommentActionBase.kt\ncom/jetbrains/rider/actions/impl/RiderCommentActionBase\n*L\n43#1:64,2\n*E\n"})
public abstract class RiderCommentActionBase
extends BackendDelegatingActionCustomization {
    public boolean frontendUpdate(@NotNull String frontendActionId, @NotNull DataContext dataContext, @Nullable Presentation presentation, @NotNull String place, @Nullable InputEvent inputEvent) {
        boolean hasEditor;
        block4: {
            Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            if (Intrinsics.areEqual((Object)"MainMenu", (Object)place)) {
                Presentation presentation2 = presentation;
                if (presentation2 != null) {
                    presentation2.setText(this.getMainMenuPresentationText());
                }
            }
            if (!super.frontendUpdate(frontendActionId, dataContext, presentation, place, inputEvent)) {
                return false;
            }
            hasEditor = dataContext.getData(CommonDataKeys.EDITOR) != null;
            Presentation presentation3 = presentation;
            if (presentation3 != null) {
                presentation3.setEnabled(hasEditor);
            }
            Presentation presentation4 = presentation;
            if (presentation4 == null) break block4;
            presentation4.setVisible(hasEditor);
        }
        return hasEditor;
    }

    @NotNull
    public ActionCallStrategy getActionCallStrategy(@NotNull DataContext dataContext, @NotNull String frontendActionId) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (editor == null || project == null) {
            return ActionCallStrategy.FrontendOnly;
        }
        int caretCount = editor.getCaretModel().getCaretCount();
        if (caretCount > 1) {
            return ActionCallStrategy.FrontendOnly;
        }
        Language language = DocumentUtilKt.getLanguage((Editor)editor);
        if (language == null) {
            return ActionCallStrategy.FrontendOnly;
        }
        Language language2 = language;
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<ProtocolLanguageManager> serviceClass$iv = ProtocolLanguageManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        boolean isProtocolLanguage = ((ProtocolLanguageManager)object).isProtocolLanguage(language2);
        if (isProtocolLanguage && !RiderTypingPolicy.Companion.forceFrontendExecutionFor(language2)) {
            return ActionCallStrategy.BackendOnly;
        }
        return ActionCallStrategy.FrontendOnly;
    }

    public void executeBackend(@NotNull AnActionEvent e, @NotNull String frontendActionId) {
        Integer caretCount;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Editor editor = (Editor)e.getDataContext().getData(CommonDataKeys.EDITOR);
        Integer n = editor != null && (editor = editor.getCaretModel()) != null ? Integer.valueOf(editor.getCaretCount()) : (caretCount = null);
        if (caretCount != null && caretCount > 1) {
            this.getFrontendAction().actionPerformed(e);
            return;
        }
        super.executeBackend(e, frontendActionId);
    }

    @NlsActions.ActionText
    @NotNull
    public abstract String getMainMenuPresentationText();

    @NotNull
    public abstract MultiCaretCodeInsightAction getFrontendAction();
}

