/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.colorSchemes;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.jetbrains.rdclient.highlighting.FrontendHighlighterAttributeCustomizer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/colorSchemes/FrontendRainbowHighlighterCustomizer;", "Lcom/jetbrains/rdclient/highlighting/FrontendHighlighterAttributeCustomizer;", "<init>", "()V", "RAINBOW_HIGHLIGHTER_NAME_PREFIX", "", "getTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "externalName", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "attributeId", "getRainbowAttributesKey", "getScheme", "Ljava/util/function/Supplier;", "intellij.rider.rdclient.dotnet"})
public final class FrontendRainbowHighlighterCustomizer
implements FrontendHighlighterAttributeCustomizer {
    @NotNull
    private final String RAINBOW_HIGHLIGHTER_NAME_PREFIX;

    public FrontendRainbowHighlighterCustomizer() {
        this.RAINBOW_HIGHLIGHTER_NAME_PREFIX = "ReSharper.RAINBOW_SHARP";
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey(@NotNull String externalName) {
        Intrinsics.checkNotNullParameter((Object)externalName, (String)"externalName");
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        return this.getRainbowAttributesKey(externalName, () -> FrontendRainbowHighlighterCustomizer.getTextAttributesKey$lambda$0(scheme));
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey(@NotNull EditorColorsScheme scheme, @NotNull String externalName, @NotNull String attributeId) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)externalName, (String)"externalName");
        Intrinsics.checkNotNullParameter((Object)attributeId, (String)"attributeId");
        return this.getRainbowAttributesKey(externalName, () -> FrontendRainbowHighlighterCustomizer.getTextAttributesKey$lambda$1(scheme));
    }

    private final TextAttributesKey getRainbowAttributesKey(String externalName, Supplier<EditorColorsScheme> getScheme) {
        if (StringsKt.startsWith$default((String)externalName, (String)this.RAINBOW_HIGHLIGHTER_NAME_PREFIX, (boolean)false, (int)2, null)) {
            String string = externalName.substring(this.RAINBOW_HIGHLIGHTER_NAME_PREFIX.length(), externalName.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int colorIndex = Integer.parseInt(string);
            return RainbowHighlighter.getRainbowAttrWithLazyCreation((TextAttributesScheme)((TextAttributesScheme)getScheme.get()), (int)colorIndex);
        }
        return null;
    }

    private static final EditorColorsScheme getTextAttributesKey$lambda$0(EditorColorsScheme $scheme) {
        return $scheme;
    }

    private static final EditorColorsScheme getTextAttributesKey$lambda$1(EditorColorsScheme $scheme) {
        return $scheme;
    }
}

