/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.completion.ml.MLRankingIgnorable;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.CompleteData;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.CompletionList;
import com.jetbrains.rd.ide.model.CompletionMode;
import com.jetbrains.rd.ide.model.CompletionModel;
import com.jetbrains.rd.ide.model.CompletionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.CompletionParameters;
import com.jetbrains.rd.ide.model.CompletionSessionModel;
import com.jetbrains.rd.ide.model.CompletionTuple;
import com.jetbrains.rd.ide.model.FocusBehaviour;
import com.jetbrains.rd.ide.model.ScoringHint;
import com.jetbrains.rd.ide.model.SessionState;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rdclient.protocol.RdDispatcherExKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.SyncEventWithInterrupt;
import com.jetbrains.rider.completion.CompletionSessionParameters;
import com.jetbrains.rider.completion.CompletionSessionState;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.ModelUtilKt;
import com.jetbrains.rider.completion.ProtocolLookupItem;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 l2\u00020\u0001:\u0004ijklB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0014J\u0016\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014J6\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\"J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J4\u0010%\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020&2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\"H\u0014J>\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\r2\u0014\u00100\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000102\u0012\u0004\u0012\u00020&01H\u0002J6\u00103\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0014\u00100\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000102\u0012\u0004\u0012\u00020&012\u0006\u0010/\u001a\u00020\rH\u0014J\u0018\u00104\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0014J\u0018\u00107\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u001eH\u0014J \u00109\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010:\u001a\u00020 H\u0014J\u0010\u0010;\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*H\u0016J@\u0010<\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\r2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020 0A2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020&0CJ:\u0010D\u001a\u00020\u000b2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020&0CH\u0002J\u0010\u0010F\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010G\u001a\u00020&2\b\u0010H\u001a\u0004\u0018\u00010IH\u0002J\u0016\u0010J\u001a\u00020\u000b2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u000e\u0010L\u001a\u00020M2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010N\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010O\u001a\u00020\"J\u000e\u0010P\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\"J\u001c\u0010Q\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u000b0SJ\u0016\u0010T\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010U\u001a\u00020\rJ\b\u0010V\u001a\u00020\u000bH\u0014J.\u0010W\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010U\u001a\u00020\r2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020 0AH\u0002J&\u0010X\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010@\u001a\b\u0012\u0004\u0012\u00020 0AH\u0002J\u000e\u0010Y\u001a\u00020Z2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010[\u001a\u00020 2\u0006\u0010\\\u001a\u00020]2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010^\u001a\u00020_H\u0016J\u0014\u0010`\u001a\u0004\u0018\u00010\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0004J>\u0010a\u001a\u00020\"2\u0006\u0010b\u001a\u00020 2\u0006\u0010c\u001a\u00020d2\u0006\u0010^\u001a\u00020_2\u0006\u0010e\u001a\u00020 2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010f\u001a\u00020&H\u0016J\u0016\u0010g\u001a\u00020\u000b2\u0006\u0010h\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "viewCompletionSession", "", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "completionTuple", "Lcom/jetbrains/rd/ide/model/CompletionTuple;", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearState", "completionStateData", "Lcom/jetbrains/rider/completion/CompletionStateData;", "stateCleared", "itemsReceived", "lookupItems", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "ensureCompletionIsRunning", "completionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "invocationCount", "", "customPrefix", "", "customHost", "adjustCompletionType", "shouldRestartCompletionSession", "", "isAutoPopup", "createLookupItem", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "completionItem", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "priority", "", "currentSessionLifetime", "completeCall", "Lcom/jetbrains/rd/framework/IRdCall;", "Lcom/jetbrains/rd/ide/model/CompleteData;", "createProtocolLookupItem", "restartRightAway", "completionParameters", "Lcom/jetbrains/rider/completion/CompletionSessionParameters;", "shouldBeTriggered", "type", "completionStarted", "offset", "beforeCompletionItemInserted", "consumeItems", "consumer", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "consumerLifetime", "cursor", "Lcom/intellij/openapi/util/Ref;", "filterAndCustomAction", "Lkotlin/Function1;", "addWithPrefix", "items", "isConsumerReady", "shouldCancelItemConsuming", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "dumpCurrentState", "lightItemsRef", "getCompleteItemCookie", "Ljava/io/Closeable;", "terminateCurrentCompletion", "reason", "terminateSessionsForAllEditors", "onCurrentSessionTerminated", "action", "Lkotlin/Function0;", "waitForFirstResults", "lifetime", "onCompletionTimeout", "waitForNextResults", "getNewLookupItems", "getBackendFocusBehaviour", "Lcom/jetbrains/rd/ide/model/FocusBehaviour;", "getIdentifierEnd", "caret", "Lcom/intellij/openapi/editor/Caret;", "psiFile", "Lcom/intellij/psi/PsiFile;", "tryGetCompletionPrefixFromLookup", "getCompletionPrefix", "documentOffset", "document", "Lcom/intellij/openapi/editor/Document;", "completionOffset", "mayTrustLookup", "fireCurrentLookupItemChanged", "currentCompletionItem", "PerClientState", "MyFrontendTextControlHostListener", "CompleteItemCookie", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFrontendCompletionHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCompletionHost.kt\ncom/jetbrains/rider/completion/FrontendCompletionHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n*L\n1#1,750:1\n13#2:751\n13#3:752\n67#3,4:753\n67#3,4:757\n67#3,4:761\n67#3,4:765\n67#3,4:769\n67#3,4:773\n67#3,4:777\n67#3,4:781\n67#3,4:786\n67#3,4:790\n67#3,4:794\n67#3,4:798\n67#3,4:802\n67#3,4:806\n67#3,4:813\n67#3,4:817\n67#3,4:826\n67#3,4:834\n67#3,4:838\n67#3,4:842\n67#3,4:846\n67#3,4:850\n1#4:785\n1849#5,3:810\n1586#5:830\n1661#5,3:831\n39#6,5:821\n*S KotlinDebug\n*F\n+ 1 FrontendCompletionHost.kt\ncom/jetbrains/rider/completion/FrontendCompletionHost\n*L\n93#1:751\n93#1:752\n128#1:753,4\n221#1:757,4\n225#1:761,4\n258#1:765,4\n277#1:769,4\n338#1:773,4\n342#1:777,4\n382#1:781,4\n402#1:786,4\n424#1:790,4\n431#1:794,4\n449#1:798,4\n463#1:802,4\n480#1:806,4\n506#1:813,4\n531#1:817,4\n168#1:826,4\n177#1:834,4\n190#1:838,4\n196#1:842,4\n201#1:846,4\n209#1:850,4\n505#1:810,3\n169#1:830\n169#1:831,3\n701#1:821,5\n*E\n"})
public abstract class FrontendCompletionHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String triggerCompletionKey = "rider.completion.shouldTriggerCompletion";
    @TestOnly
    private static boolean backendCompletionDisabled;

    public FrontendCompletionHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendCompletionHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void viewCompletionSession(Lifetime sessionLifetime, CompletionTuple completionTuple, TextControlModel textControlModel, Editor editor) {
        Logger logger;
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        CompletionParameters completionParameters = completionTuple.getParameters();
        int currentSessionId = completionStateData.getSessionId().incrementAndGet();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Start viewing completion session #" + currentSessionId + " for synced offset " + completionParameters.getOffset() + " and type " + completionParameters.getMode());
        }
        CompletionSessionModel completionSessionModel = completionTuple.getSession();
        ClientProjectSession session2 = FrontendSessionsUtilKt.getFrontendProjectSession((Project)this.project);
        sessionLifetime.onTermination(() -> FrontendCompletionHost.viewCompletionSession$lambda$1(this, completionStateData));
        completionSessionModel.getRefreshFrontend().advise(sessionLifetime, arg_0 -> FrontendCompletionHost.viewCompletionSession$lambda$2(this, completionStateData, sessionLifetime, arg_0));
        completionSessionModel.getCompletionItems().adviseOn(sessionLifetime, RdDispatcherExKt.getBackgroundScheduler((IScheduler)FrontendSessionsUtilKt.getProtocol((ClientProjectSession)session2).getScheduler()), arg_0 -> FrontendCompletionHost.viewCompletionSession$lambda$3(session2, this, completionStateData, sessionLifetime, completionSessionModel, currentSessionId, arg_0));
        completionSessionModel.isSoft().adviseOn(sessionLifetime, RdDispatcherExKt.getBackgroundScheduler((IScheduler)FrontendSessionsUtilKt.getProtocol((ClientProjectSession)session2).getScheduler()), arg_0 -> FrontendCompletionHost.viewCompletionSession$lambda$4(this, completionStateData, arg_0));
        completionSessionModel.getSessionState().adviseOn(sessionLifetime, RdDispatcherExKt.getBackgroundScheduler((IScheduler)FrontendSessionsUtilKt.getProtocol((ClientProjectSession)session2).getScheduler()), arg_0 -> FrontendCompletionHost.viewCompletionSession$lambda$5(this, completionStateData, currentSessionId, textControlModel, arg_0));
        completionSessionModel.getReadyToReceiveItems().set((Object)true);
        this.completionStarted(sessionLifetime, editor, completionParameters.getOffset());
        Logger $this$trace$iv2 = this.logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("finished viewing the completion session " + currentSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearState(CompletionStateData completionStateData) {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("clearing state of completion state data");
        }
        Object object = completionStateData.getLock();
        synchronized (object) {
            boolean bl = false;
            CompletionStateData $this$clearState_u24lambda_u241_u240 = completionStateData;
            boolean bl2 = false;
            $this$clearState_u24lambda_u241_u240.setLightItemsCount(0);
            $this$clearState_u24lambda_u241_u240.getState().setValue((Object)CompletionSessionState.Inactive);
            $this$clearState_u24lambda_u241_u240.getAllLookupItems().clear();
            $this$clearState_u24lambda_u241_u240.setFocusBehaviour(FocusBehaviour.Hard);
            Unit unit = Unit.INSTANCE;
        }
        this.stateCleared();
    }

    protected void stateCleared() {
    }

    protected void itemsReceived(@NotNull List<? extends LookupElement> lookupItems) {
        Intrinsics.checkNotNullParameter(lookupItems, (String)"lookupItems");
    }

    public final void ensureCompletionIsRunning(@NotNull Editor editor, @NotNull CompletionType completionType, int invocationCount, @Nullable String customPrefix, @Nullable String customHost) {
        boolean isAutoPopup;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("ensureCompletionIsRunning: start");
        }
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionType adjustedCompletionType = this.adjustCompletionType(completionType, invocationCount);
        boolean bl = isAutoPopup = invocationCount == 0;
        if (this.shouldRestartCompletionSession(editor, adjustedCompletionType, isAutoPopup, customPrefix, customHost)) {
            CompletionMode completionMode;
            CompletionParameters completionParameters;
            CompletionTuple completionTuple;
            IProperty iProperty;
            CompletionModel completionModel;
            this.terminateCurrentCompletion(editor, "'Ensure completion is running' reschedules the completion. State : " + completionStateData.getState() + ", CurrentCompletionMode: " + (textControlModel != null && (completionModel = CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel)) != null && (iProperty = completionModel.getCompletionSession()) != null && (completionTuple = (CompletionTuple)iProperty.getValue()) != null && (completionParameters = completionTuple.getParameters()) != null && (completionMode = completionParameters.getMode()) != null ? completionMode.name() : null) + ", Requested Completion Type: " + completionType);
            this.restartRightAway(editor, new CompletionSessionParameters(adjustedCompletionType, invocationCount, customPrefix, customHost));
        } else {
            Logger $this$trace$iv2 = this.logger;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl2 = false;
                logger.trace("Keeping current completion session with state " + completionStateData.getState().getValue());
            }
        }
    }

    public static /* synthetic */ void ensureCompletionIsRunning$default(FrontendCompletionHost frontendCompletionHost, Editor editor, CompletionType completionType, int n, String string, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ensureCompletionIsRunning");
        }
        if ((n2 & 8) != 0) {
            string = null;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        frontendCompletionHost.ensureCompletionIsRunning(editor, completionType, n, string, string2);
    }

    @NotNull
    protected CompletionType adjustCompletionType(@NotNull CompletionType completionType, int invocationCount) {
        Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
        return completionType == CompletionType.BASIC && invocationCount == 2 ? CompletionType.CLASS_NAME : completionType;
    }

    protected boolean shouldRestartCompletionSession(@NotNull Editor editor, @NotNull CompletionType completionType, boolean isAutoPopup, @Nullable String customPrefix, @Nullable String customHost) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
        return true;
    }

    private final LookupElement createLookupItem(ClientProjectSession session2, CompletionItem completionItem, double priority, Lifetime currentSessionLifetime, IRdCall<? super CompleteData, Boolean> completeCall) {
        LookupElement lookupElement;
        if (completionItem.getId() < 0) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)completionItem.getShortText());
            Intrinsics.checkNotNull((Object)lookupElementBuilder);
            lookupElement = (LookupElement)lookupElementBuilder;
        } else {
            lookupElement = this.createProtocolLookupItem(session2, completionItem, completeCall, currentSessionLifetime);
        }
        LookupElement coreItem = lookupElement;
        LookupElement lookupElement2 = PrioritizedLookupElement.withPriority((LookupElement)coreItem, (double)priority);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"withPriority(...)");
        return lookupElement2;
    }

    @NotNull
    protected LookupElement createProtocolLookupItem(@NotNull ClientProjectSession session2, @NotNull CompletionItem completionItem, @NotNull IRdCall<? super CompleteData, Boolean> completeCall, @NotNull Lifetime currentSessionLifetime) {
        LookupElement lookupElement;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)completionItem, (String)"completionItem");
        Intrinsics.checkNotNullParameter(completeCall, (String)"completeCall");
        Intrinsics.checkNotNullParameter((Object)currentSessionLifetime, (String)"currentSessionLifetime");
        ProtocolLookupItem item = new ProtocolLookupItem(session2, completionItem, completeCall, currentSessionLifetime);
        if (completionItem.getScoringHints().contains(ScoringHint.MLIgnore)) {
            LookupElement lookupElement2 = MLRankingIgnorable.wrap((LookupElement)((LookupElement)item));
            Intrinsics.checkNotNull((Object)lookupElement2);
            lookupElement = lookupElement2;
        } else {
            lookupElement = (LookupElement)item;
        }
        return lookupElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restartRightAway(@NotNull Editor editor, @NotNull CompletionSessionParameters completionParameters) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)completionParameters, (String)"completionParameters");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        if (completionStateData.getSaveSession()) {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace("trying to restart current session while completing an item");
            }
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("restartRightAway.before");
        }
        IdeBackend backend = IdeBackend.Companion.getInstance(this.project);
        if (!backend.isCompletionEnabled(editor)) {
            return;
        }
        if (!this.shouldBeTriggered(editor, completionParameters.getType())) {
            return;
        }
        CompletionMode completionMode = UtilsKt.toCompletionMode(completionParameters.getType());
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel == null) {
            return;
        }
        TextControlModel textControlModel2 = textControlModel;
        int prefixOffset = PlatformTextControlUtilsKt.getStartOffset(editor);
        String prefix = completionParameters.getPrefix();
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile(editor);
        if (psiFile != null) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            prefix = this.getCompletionPrefix(prefixOffset, document, psiFile, ModelUtilKt.getCurrentOffsetSafe(textControlModel2), editor, completionParameters.isAutoPopup());
        }
        CompletionParameters params = new CompletionParameters(completionMode, completionParameters.isAutoPopup(), completionParameters.getInvocationCount(), prefixOffset, prefix, completionParameters.getCustomHost(), editor.getCaretModel().getCaretCount() > 1);
        LifetimeDefinition completionSessionLifetime = PerClientState.Companion.getInstance(this.project).getCompletionSessionLifetimes().next();
        IProperty completionSession = CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession();
        CompletionTuple tuple = new CompletionTuple(params);
        Logger $this$trace$iv2 = this.logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("restartRightAway. start session with offset " + tuple.getParameters().getOffset() + " and type " + tuple.getParameters().getMode());
        }
        Object object = completionStateData.getLock();
        synchronized (object) {
            boolean bl = false;
            completionStateData.getState().setValue((Object)CompletionSessionState.InProgress);
            Unit unit = Unit.INSTANCE;
        }
        completionSessionLifetime.bracket(() -> FrontendCompletionHost.restartRightAway$lambda$4(completionSession, tuple), () -> FrontendCompletionHost.restartRightAway$lambda$5(editor, this));
    }

    protected boolean shouldBeTriggered(@NotNull Editor editor, @NotNull CompletionType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return false;
        }
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        if (completionStateData.getSaveSession()) {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("trying to restart current session while completing an item");
            }
            return false;
        }
        return Registry.Companion.is(triggerCompletionKey) && !backendCompletionDisabled;
    }

    protected void completionStarted(@NotNull Lifetime sessionLifetime, @NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
    }

    public void beforeCompletionItemInserted(@NotNull ClientProjectSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
    }

    public final boolean consumeItems(@NotNull Editor editor, @NotNull CompletionResultSet consumer2, @NotNull Lifetime consumerLifetime, @NotNull Ref<Integer> cursor, @NotNull Function1<? super LookupElement, Boolean> filterAndCustomAction) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)consumerLifetime, (String)"consumerLifetime");
        Intrinsics.checkNotNullParameter(cursor, (String)"cursor");
        Intrinsics.checkNotNullParameter(filterAndCustomAction, (String)"filterAndCustomAction");
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("consuming items. Wait for items to be fetched.... Session state is " + completionStateData.getState().getValue());
        }
        if (!completionStateData.getHasSession()) {
            return false;
        }
        List<LookupElement> list = this.waitForNextResults(completionStateData, consumerLifetime, cursor);
        if (list == null) {
            return false;
        }
        List<LookupElement> items = list;
        Logger $this$trace$iv2 = this.logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("Items fetched. Consuming them....");
        }
        this.dumpCurrentState(items);
        this.addWithPrefix(items, consumer2, completionStateData, filterAndCustomAction);
        this.logger.trace("Items consumed");
        return this.isConsumerReady(editor);
    }

    private final void addWithPrefix(List<? extends LookupElement> items, CompletionResultSet consumer2, CompletionStateData completionStateData, Function1<? super LookupElement, Boolean> filterAndCustomAction) {
        Logger logger;
        int count = 0;
        ArrayList<LookupElement> lightItemsArrayList = new ArrayList<LookupElement>();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("adding " + items.size() + " items to consumer. Light items count = " + completionStateData.getLightItemsCount());
        }
        LookupEx activeLookup = LookupManager.getInstance((Project)this.project).getActiveLookup();
        int seldomCounter = 0;
        for (LookupElement lookupElement : items) {
            if (++seldomCounter % 100 == 0) {
                ProgressManager.checkCanceled();
            }
            if (!((Boolean)filterAndCustomAction.invoke((Object)lookupElement)).booleanValue()) continue;
            if (++count > completionStateData.getLightItemsCount()) {
                if (!((Collection)lightItemsArrayList).isEmpty()) {
                    Logger $this$trace$iv2 = this.logger;
                    boolean $i$f$trace2 = false;
                    if ($this$trace$iv2.isTraceEnabled()) {
                        logger = $this$trace$iv2;
                        boolean bl = false;
                        logger.trace("addAllElements for " + lightItemsArrayList.size() + " light items items...");
                    }
                    if (this.shouldCancelItemConsuming(activeLookup instanceof LookupImpl ? (LookupImpl)activeLookup : null)) {
                        return;
                    }
                    consumer2.addAllElements((Iterable)lightItemsArrayList);
                    lightItemsArrayList.clear();
                }
                if (this.shouldCancelItemConsuming(activeLookup instanceof LookupImpl ? (LookupImpl)activeLookup : null)) {
                    return;
                }
                consumer2.consume(lookupElement);
                continue;
            }
            lightItemsArrayList.add(lookupElement);
        }
        if (!((Collection)lightItemsArrayList).isEmpty()) {
            Logger $this$trace$iv3 = this.logger;
            boolean bl = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                logger = $this$trace$iv3;
                boolean bl2 = false;
                logger.trace("added " + lightItemsArrayList + " only light items");
            }
            if (this.shouldCancelItemConsuming(activeLookup instanceof LookupImpl ? (LookupImpl)activeLookup : null)) {
                return;
            }
            consumer2.addAllElements((Iterable)lightItemsArrayList);
        }
    }

    protected boolean isConsumerReady(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return true;
    }

    private final boolean shouldCancelItemConsuming(LookupImpl lookup) {
        if (ApplicationKt.getApplication().isUnitTestMode() && lookup != null && Disposer.isDisposed((Disposable)((Disposable)lookup))) {
            this.logger.trace("Disposing lookup detected. Stop adding items");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void dumpCurrentState(List<? extends LookupElement> lightItemsRef) {
        if (this.logger.isTraceEnabled()) {
            void $this$fold$iv;
            Iterable iterable = CollectionsKt.take((Iterable)lightItemsRef, (int)40);
            String initial$iv = "\n";
            boolean $i$f$fold = false;
            Object accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void lookupElement;
                LookupElement lookupElement2 = (LookupElement)element$iv;
                String s = accumulator$iv;
                boolean bl = false;
                accumulator$iv = s + "'" + lookupElement.getLookupString() + "'\n";
            }
            String dump2 = accumulator$iv;
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                LookupElement lookupElement = (LookupElement)CollectionsKt.lastOrNull(lightItemsRef);
                logger.trace(StringsKt.trimIndent((String)("\n          Dumping items:\n          " + dump2 + "\n          last item is " + (lookupElement != null ? lookupElement.getLookupString() : null) + "\n        ")));
            }
        }
    }

    @NotNull
    public final Closeable getCompleteItemCookie(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!completionStateData.getHasSession()) {
            return FrontendCompletionHost::getCompleteItemCookie$lambda$0;
        }
        return new CompleteItemCookie(editor, this);
    }

    public final void terminateCurrentCompletion(@NotNull Editor editor, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        if (completionStateData.getSaveSession()) {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("trying to terminate current session while completing an item");
            }
            return;
        }
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel == null) {
            return;
        }
        TextControlModel textControlModel2 = textControlModel;
        this.logger.trace("Completion session is about to be terminated. Reason:\n " + reason);
        CompletionTuple completionTuple = (CompletionTuple)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().getValue();
        boolean bl = completionTuple != null ? !completionTuple.isBound() : false;
        if (bl) {
            this.logger.trace("Terminating session on unbound state");
            return;
        }
        CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().setValue(null);
    }

    public final void terminateSessionsForAllEditors(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        for (Editor editor : editorArray) {
            if (!Intrinsics.areEqual((Object)this.project, (Object)editor.getProject())) continue;
            Intrinsics.checkNotNull((Object)editor);
            this.terminateCurrentCompletion(editor, reason);
        }
    }

    public final void onCurrentSessionTerminated(@NotNull Editor editor, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel == null) {
            throw new IllegalStateException("you cannot call this api without completion session".toString());
        }
        TextControlModel textControlModel2 = textControlModel;
        IProperty value = CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession();
        LifetimeDefinition def = this.getServiceLifetime().createNested();
        InterfacesKt.viewNotNull((IViewable)((IViewable)value), (Lifetime)def.getLifetime(), (arg_0, arg_1) -> FrontendCompletionHost.onCurrentSessionTerminated$lambda$0(action2, def, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForFirstResults(@NotNull Editor editor, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        Object object = completionStateData.getLock();
        synchronized (object) {
            block8: {
                block7: {
                    boolean bl = false;
                    CompletionStateData $this$waitForFirstResults_u24lambda_u240_u240 = completionStateData;
                    boolean bl2 = false;
                    if (!((Collection)$this$waitForFirstResults_u24lambda_u240_u240.getAllLookupItems()).isEmpty() || ((CompletionSessionState)((Object)$this$waitForFirstResults_u24lambda_u240_u240.getState().getValue())).compareTo((Enum)CompletionSessionState.Completed) >= 0) break block7;
                    if ($this$waitForFirstResults_u24lambda_u240_u240.getState().getValue() != CompletionSessionState.Inactive) break block8;
                }
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        SyncEventWithInterrupt syncLock = new SyncEventWithInterrupt();
        int fullTimeout = 15000;
        long millisecondsNow = System.currentTimeMillis();
        syncLock.waitFor(lifetime, false, () -> FrontendCompletionHost.waitForFirstResults$lambda$1(completionStateData, millisecondsNow, fullTimeout, this, syncLock));
    }

    protected void onCompletionTimeout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<LookupElement> waitForNextResults(CompletionStateData completionStateData, Lifetime lifetime, Ref<Integer> cursor) {
        Object object = completionStateData.getLock();
        synchronized (object) {
            block4: {
                boolean bl = false;
                CompletionStateData $this$waitForNextResults_u24lambda_u240_u240 = completionStateData;
                boolean bl2 = false;
                if (((CompletionSessionState)((Object)$this$waitForNextResults_u24lambda_u240_u240.getState().getValue())).compareTo((Enum)CompletionSessionState.Completed) < 0 && $this$waitForNextResults_u24lambda_u240_u240.getState().getValue() != CompletionSessionState.Inactive) break block4;
                List<LookupElement> list = this.getNewLookupItems(completionStateData, cursor);
                return list;
            }
            Unit unit = Unit.INSTANCE;
        }
        SyncEventWithInterrupt syncLock = new SyncEventWithInterrupt();
        int fullTimeout = 15000;
        long millisecondsNow = System.currentTimeMillis();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        syncLock.waitFor(lifetime, false, () -> FrontendCompletionHost.waitForNextResults$lambda$1(completionStateData, millisecondsNow, fullTimeout, this, result2, cursor, syncLock));
        return (List)result2.element;
    }

    private final List<LookupElement> getNewLookupItems(CompletionStateData completionStateData, Ref<Integer> cursor) {
        CompletionStateData $this$getNewLookupItems_u24lambda_u240 = completionStateData;
        boolean bl = false;
        if ($this$getNewLookupItems_u24lambda_u240.getAllLookupItems().size() > ((Number)cursor.get()).intValue()) {
            List<LookupElement> list = $this$getNewLookupItems_u24lambda_u240.getAllLookupItems();
            Object object = cursor.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            List result2 = CollectionsKt.toList((Iterable)list.subList(((Number)object).intValue(), $this$getNewLookupItems_u24lambda_u240.getAllLookupItems().size()));
            cursor.set((Object)$this$getNewLookupItems_u24lambda_u240.getAllLookupItems().size());
            return result2;
        }
        return null;
    }

    @NotNull
    public final FocusBehaviour getBackendFocusBehaviour(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        return completionStateData.getFocusBehaviour();
    }

    public int getIdentifierEnd(@NotNull Caret caret, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        int startFrom;
        int idEnd;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text = charSequence;
        for (idEnd = startFrom = caret.hasSelection() ? caret.getSelectionEnd() : caret.getOffset(); idEnd < text.length() && Character.isJavaIdentifierPart(text.charAt(idEnd)); ++idEnd) {
        }
        return idEnd;
    }

    @Nullable
    protected final String tryGetCompletionPrefixFromLookup(@Nullable Editor editor) {
        LookupElement currentItem;
        LookupEx lookup = LookupManagerImpl.Companion.getActiveLookup(editor);
        if (lookup != null && (currentItem = lookup.getCurrentItem()) != null) {
            String string = lookup.itemPattern(currentItem);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
            String currentLookupPrefix = string;
            if (StringsKt.contains$default((CharSequence)currentLookupPrefix, (char)' ', (boolean)false, (int)2, null)) {
                return currentLookupPrefix;
            }
        }
        return null;
    }

    @NotNull
    public String getCompletionPrefix(int documentOffset, @NotNull Document document, @NotNull PsiFile psiFile, int completionOffset, @Nullable Editor editor, boolean mayTrustLookup) {
        String string;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (mayTrustLookup && (string = this.tryGetCompletionPrefixFromLookup(editor)) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        String string2 = CompletionUtil.findIdentifierPrefix((Document)document, (int)documentOffset, (ElementPattern)((ElementPattern)StandardPatterns.character().javaIdentifierPart()), (ElementPattern)((ElementPattern)StandardPatterns.character().javaIdentifierStart()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"findIdentifierPrefix(...)");
        return string2;
    }

    public static /* synthetic */ String getCompletionPrefix$default(FrontendCompletionHost frontendCompletionHost, int n, Document document, PsiFile psiFile, int n2, Editor editor, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCompletionPrefix");
        }
        if ((n3 & 0x10) != 0) {
            editor = null;
        }
        if ((n3 & 0x20) != 0) {
            bl = true;
        }
        return frontendCompletionHost.getCompletionPrefix(n, document, psiFile, n2, editor, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireCurrentLookupItemChanged(@NotNull CompletionItem currentCompletionItem, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)currentCompletionItem, (String)"currentCompletionItem");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel == null) {
            return;
        }
        TextControlModel textControlModel2 = textControlModel;
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Unit unit;
            Lifetime lifetime = def$iv.getLifetime();
            boolean bl = false;
            IScheduler iScheduler = ApplicationProtocolKt.getProtocol(this.project).getScheduler();
            Intrinsics.checkNotNull((Object)iScheduler, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.protocol.IRdDispatcher");
            ((IRdDispatcher)iScheduler).allowBackgroundThreadAndSuppressPumping(lifetime);
            CompletionTuple completionTuple = (CompletionTuple)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().getValue();
            if (completionTuple != null && (completionTuple = completionTuple.getSession()) != null && (completionTuple = completionTuple.getCurrentSelectedItem()) != null) {
                completionTuple.set((Object)currentCompletionItem);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    private static final void viewCompletionSession$lambda$2$1$0(LifetimeDefinition $awaitRefreshItemsDef, FrontendCompletionHost this$0) {
        if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)$awaitRefreshItemsDef))) {
            return;
        }
        this$0.logger.debug("new items came from backend, schedule restart IJ completion");
        CompletionProgressIndicator completionProgressIndicator = CompletionServiceImpl.Companion.getCurrentCompletionProgressIndicator();
        if (completionProgressIndicator == null) {
            return;
        }
        CompletionProgressIndicator completionProgressIndicator2 = completionProgressIndicator;
        completionProgressIndicator2.scheduleRestart();
        LifetimeDefinition.terminate$default((LifetimeDefinition)$awaitRefreshItemsDef, (boolean)false, (int)1, null);
    }

    private static final Unit viewCompletionSession$lambda$2$1(LifetimeDefinition $awaitRefreshItemsDef, FrontendCompletionHost this$0, CompletionSessionState completionSessionState) {
        Intrinsics.checkNotNullParameter((Object)((Object)completionSessionState), (String)"completionSessionState");
        if (completionSessionState == CompletionSessionState.Completed) {
            ApplicationKt.getApplication().invokeLater(() -> FrontendCompletionHost.viewCompletionSession$lambda$2$1$0($awaitRefreshItemsDef, this$0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit viewCompletionSession$lambda$1(FrontendCompletionHost this$0, CompletionStateData $completionStateData) {
        this$0.logger.trace("sessionLifetimeDefinition is terminated");
        this$0.clearState($completionStateData);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit viewCompletionSession$lambda$2(FrontendCompletionHost this$0, CompletionStateData $completionStateData, Lifetime $sessionLifetime, String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this$0.logger.debug("refreshing frontend completion due to the reason [" + reason + "]");
        Object object = $completionStateData.getLock();
        synchronized (object) {
            boolean bl = false;
            $completionStateData.getState().setValue((Object)CompletionSessionState.InProgress);
            Unit unit = Unit.INSTANCE;
        }
        LifetimeDefinition awaitRefreshItemsDef = $sessionLifetime.createNested();
        $completionStateData.getState().advise((Lifetime)awaitRefreshItemsDef, arg_0 -> FrontendCompletionHost.viewCompletionSession$lambda$2$1(awaitRefreshItemsDef, this$0, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit viewCompletionSession$lambda$3(ClientProjectSession $session, FrontendCompletionHost this$0, CompletionStateData $completionStateData, Lifetime $sessionLifetime, CompletionSessionModel $completionSessionModel, int $currentSessionId, CompletionList completionList) {
        void $this$mapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)completionList, (String)"completionList");
        IScheduler.DefaultImpls.assertThread$default((IScheduler)RdDispatcherExKt.getBackgroundScheduler((IScheduler)FrontendSessionsUtilKt.getProtocol((ClientProjectSession)$session).getScheduler()), null, (int)1, null);
        List modelItems = completionList.getItems();
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            boolean bl = false;
            object.trace("Fetching items... " + ((Collection)modelItems).size() + " items received");
        }
        Iterable $this$map$iv = modelItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompletionItem completionItem = (CompletionItem)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this$0.createLookupItem($session, (CompletionItem)it, it.getPriority(), $sessionLifetime, (IRdCall<? super CompleteData, Boolean>)((IRdCall)$completionSessionModel.getComplete())));
        }
        List lookupItems = (List)destination$iv$iv;
        this$0.itemsReceived(lookupItems);
        Object object2 = $completionStateData.getLock();
        synchronized (object2) {
            Logger logger;
            block9: {
                boolean bl = false;
                if ($currentSessionId >= $completionStateData.getSessionId().get() && $completionStateData.getState().getValue() != CompletionSessionState.Inactive) break block9;
                Logger $this$trace$iv2 = this$0.logger;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl2 = false;
                    logger.trace("interrupted fetching items! processing session id: " + $currentSessionId + ", new sessionId: " + $completionStateData.getSessionId().get() + ". state = " + $completionStateData.getState().getValue());
                }
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            boolean wasEmpty = $completionStateData.getAllLookupItems().isEmpty();
            $completionStateData.getAllLookupItems().addAll(lookupItems);
            if (wasEmpty) {
                $completionStateData.getState().setValue((Object)CompletionSessionState.LightCompleted);
                $completionStateData.setLightItemsCount(lookupItems.size());
            }
            Logger $this$trace$iv3 = this$0.logger;
            boolean $i$f$trace3 = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                logger = $this$trace$iv3;
                boolean bl = false;
                logger.trace("done fetching basic items.");
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit viewCompletionSession$lambda$4(FrontendCompletionHost this$0, CompletionStateData $completionStateData, FocusBehaviour backendValue) {
        Intrinsics.checkNotNullParameter((Object)backendValue, (String)"backendValue");
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Got focusBehaviour == " + backendValue);
        }
        $completionStateData.setFocusBehaviour(backendValue);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit viewCompletionSession$lambda$5(FrontendCompletionHost this$0, CompletionStateData $completionStateData, int $currentSessionId, TextControlModel $textControlModel, SessionState param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("sessionState received: " + param);
        }
        Object object = $completionStateData.getLock();
        synchronized (object) {
            block9: {
                boolean bl = false;
                if ($currentSessionId >= $completionStateData.getSessionId().get() && CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)$textControlModel).getCompletionSession().getValue() != null) break block9;
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            Logger $this$trace$iv2 = this$0.logger;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                Logger logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("assigning session state to " + param + " under lock");
            }
            if (param == SessionState.ReturnedNull) {
                $completionStateData.getState().setValue((Object)CompletionSessionState.EmptyResultsList);
            } else if (param == SessionState.FullItemsPrepared) {
                $completionStateData.getState().setValue((Object)CompletionSessionState.Completed);
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit restartRightAway$lambda$4(IProperty $completionSession, CompletionTuple $tuple) {
        $completionSession.set((Object)$tuple);
        return Unit.INSTANCE;
    }

    private static final Unit restartRightAway$lambda$5(Editor $editor, FrontendCompletionHost this$0) {
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)$editor);
        if ((textControlModel != null && (textControlModel = CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel)) != null && (textControlModel = textControlModel.getCompletionSession()) != null ? (CompletionTuple)textControlModel.getValue() : null) != null) {
            this$0.terminateCurrentCompletion($editor, "NextCompletionSessionHasStarted");
        }
        return Unit.INSTANCE;
    }

    private static final void getCompleteItemCookie$lambda$0() {
    }

    private static final Unit onCurrentSessionTerminated$lambda$0$0(Function0 $action, LifetimeDefinition $def) {
        $action.invoke();
        LifetimeDefinition.terminate$default((LifetimeDefinition)$def, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCurrentSessionTerminated$lambda$0(Function0 $action, LifetimeDefinition $def, Lifetime sessionLifetime, CompletionTuple completionTuple) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)completionTuple, (String)"<unused var>");
        if (RLifetimeKt.isAlive((Lifetime)sessionLifetime)) {
            sessionLifetime.onTermination(() -> FrontendCompletionHost.onCurrentSessionTerminated$lambda$0$0($action, $def));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit waitForFirstResults$lambda$1(CompletionStateData $completionStateData, long $millisecondsNow, int $fullTimeout, FrontendCompletionHost this$0, SyncEventWithInterrupt $syncLock) {
        Object object = $completionStateData.getLock();
        synchronized (object) {
            boolean bl = false;
            CompletionStateData $this$waitForFirstResults_u24lambda_u241_u240_u240 = $completionStateData;
            boolean bl2 = false;
            if (!((Collection)$this$waitForFirstResults_u24lambda_u241_u240_u240.getAllLookupItems()).isEmpty() || ((CompletionSessionState)((Object)$this$waitForFirstResults_u24lambda_u241_u240_u240.getState().getValue())).compareTo((Enum)CompletionSessionState.Completed) >= 0 || $this$waitForFirstResults_u24lambda_u241_u240_u240.getState().getValue() == CompletionSessionState.Inactive) {
                $syncLock.set();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (System.currentTimeMillis() - $millisecondsNow > (long)$fullTimeout) {
            this$0.onCompletionTimeout();
            throw new TimeoutException("[Completion]Timeout in Protocol contributor. Full.");
        }
        ProgressManager.checkCanceled();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit waitForNextResults$lambda$1(CompletionStateData $completionStateData, long $millisecondsNow, int $fullTimeout, FrontendCompletionHost this$0, Ref.ObjectRef $result, Ref $cursor, SyncEventWithInterrupt $syncLock) {
        Object object = $completionStateData.getLock();
        synchronized (object) {
            boolean bl = false;
            CompletionStateData $this$waitForNextResults_u24lambda_u241_u240_u240 = $completionStateData;
            boolean bl2 = false;
            $result.element = this$0.getNewLookupItems($completionStateData, (Ref<Integer>)$cursor);
            if ($result.element != null || ((CompletionSessionState)((Object)$this$waitForNextResults_u24lambda_u241_u240_u240.getState().getValue())).compareTo((Enum)CompletionSessionState.Completed) >= 0 || $this$waitForNextResults_u24lambda_u241_u240_u240.getState().getValue() == CompletionSessionState.Inactive) {
                $syncLock.set();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (System.currentTimeMillis() - $millisecondsNow > (long)$fullTimeout) {
            this$0.onCompletionTimeout();
            throw new TimeoutException("[Completion]Timeout in protocol contributor. Full.");
        }
        ProgressManager.checkCanceled();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/completion/FrontendCompletionHost$Companion;", "", "<init>", "()V", "triggerCompletionKey", "", "backendCompletionDisabled", "", "getBackendCompletionDisabled", "()Z", "setBackendCompletionDisabled", "(Z)V", "getInstance", "Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "getInstanceOrNull", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getBackendCompletionDisabled() {
            return backendCompletionDisabled;
        }

        public final void setBackendCompletionDisabled(boolean bl) {
            backendCompletionDisabled = bl;
        }

        @NotNull
        public final FrontendCompletionHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getComponent(FrontendCompletionHost.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getComponent(...)");
            return (FrontendCompletionHost)((Object)object);
        }

        @Nullable
        public final FrontendCompletionHost tryGetInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (FrontendCompletionHost)((Object)project.getComponent(FrontendCompletionHost.class));
        }

        @Nullable
        public final FrontendCompletionHost getInstanceOrNull(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (FrontendCompletionHost)((Object)project.getComponent(FrontendCompletionHost.class));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/completion/FrontendCompletionHost$CompleteItemCookie;", "Ljava/io/Closeable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "completionHost", "Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rider/completion/FrontendCompletionHost;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getCompletionHost", "()Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "close", "", "intellij.rider.rdclient.dotnet"})
    private static final class CompleteItemCookie
    implements Closeable {
        @NotNull
        private final Editor editor;
        @NotNull
        private final FrontendCompletionHost completionHost;

        public CompleteItemCookie(@NotNull Editor editor, @NotNull FrontendCompletionHost completionHost) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)completionHost), (String)"completionHost");
            this.editor = editor;
            this.completionHost = completionHost;
            ApplicationManager.getApplication().assertIsDispatchThread();
            CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(this.editor);
            if (!completionStateData.getHasSession()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            completionStateData.setSaveSession(true);
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final FrontendCompletionHost getCompletionHost() {
            return this.completionHost;
        }

        @Override
        public void close() {
            CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(this.editor);
            completionStateData.setSaveSession(false);
            if (!completionStateData.getHasSession()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.completionHost.terminateCurrentCompletion(this.editor, "CompleteItemCookie.close");
            this.completionHost.restartRightAway(this.editor, new CompletionSessionParameters(CompletionType.BASIC, 0, null, null, 12, null));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/completion/FrontendCompletionHost$MyFrontendTextControlHostListener;", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHostListener;", "<init>", "()V", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rider.rdclient.dotnet"})
    public static final class MyFrontendTextControlHostListener
    implements FrontendTextControlHostListener {
        public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!UtilsKt.isTypingSessionCompletionEnabled()) {
                return;
            }
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            InterfacesKt.viewNotNull((IViewable)((IViewable)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)editorModel).getCompletionSession()), (Lifetime)lifetime, (arg_0, arg_1) -> MyFrontendTextControlHostListener.editorBound$lambda$0(project2, editorModel, editor, arg_0, arg_1));
        }

        private static final Unit editorBound$lambda$0(Project $project, TextControlModel $editorModel, Editor $editor, Lifetime completionSessionLifetime, CompletionTuple completionTuple) {
            Intrinsics.checkNotNullParameter((Object)completionSessionLifetime, (String)"completionSessionLifetime");
            Intrinsics.checkNotNullParameter((Object)completionTuple, (String)"completionTuple");
            Companion.getInstance($project).viewCompletionSession(completionSessionLifetime, completionTuple, $editorModel, $editor);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/completion/FrontendCompletionHost$PerClientState;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "completionSessionLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getCompletionSessionLifetimes", "()Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "Companion", "intellij.rider.rdclient.dotnet"})
    private static final class PerClientState
    extends LifetimedService {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SequentialLifetimes completionSessionLifetimes = new SequentialLifetimes(this.getServiceLifetime());

        @NotNull
        public final SequentialLifetimes getCompletionSessionLifetimes() {
            return this.completionSessionLifetimes;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/completion/FrontendCompletionHost$PerClientState$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/completion/FrontendCompletionHost$PerClientState;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
        @SourceDebugExtension(value={"SMAP\nFrontendCompletionHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCompletionHost.kt\ncom/jetbrains/rider/completion/FrontendCompletionHost$PerClientState$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,750:1\n30#2,2:751\n*S KotlinDebug\n*F\n+ 1 FrontendCompletionHost.kt\ncom/jetbrains/rider/completion/FrontendCompletionHost$PerClientState$Companion\n*L\n99#1:751,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PerClientState getInstance(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<PerClientState> serviceClass$iv = PerClientState.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (PerClientState)((Object)object);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

