/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.CommandDescriptor;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdCommandProcessor;
import com.jetbrains.rd.ide.model.RdCommandProcessor_GeneratedKt;
import com.jetbrains.rd.ide.model.SelectionRange;
import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.document.DocumentChangeModelConversion;
import com.jetbrains.rider.editorActions.UndoableEditorChange;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.rdclient.languages.RiderBreakingWorkflowChangeInterceptor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/editorActions/FairMergeStrategy;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentTypingSession", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "editorTypingSession", "Lcom/jetbrains/rd/ide/model/SelectionRange;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/rdtext/ITypingSession;Lcom/jetbrains/rd/rdtext/ITypingSession;)V", "remoteChanges", "", "Lcom/jetbrains/rider/editorActions/UndoableEditorChange;", "localChanges", "localInitialSelection", "getOrCreateUndoableEditorChange", "merge", "", "fireBeforeMerge", "fireAfterMerge", "revertLocalChanges", "intellij.rider.rdclient.dotnet"})
public final class FairMergeStrategy {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Editor editor;
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final List<UndoableEditorChange> remoteChanges;
    @NotNull
    private final List<RdTextChange> localChanges;
    @NotNull
    private final SelectionRange localInitialSelection;

    public FairMergeStrategy(@NotNull Lifetime lifetime, @NotNull Editor editor, @NotNull ClientAppSession session2, @NotNull ITypingSession<RdTextChange> documentTypingSession, @NotNull ITypingSession<SelectionRange> editorTypingSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(documentTypingSession, (String)"documentTypingSession");
        Intrinsics.checkNotNullParameter(editorTypingSession, (String)"editorTypingSession");
        this.lifetime = lifetime;
        this.editor = editor;
        this.session = session2;
        this.remoteChanges = new ArrayList();
        this.localChanges = new ArrayList();
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this.localInitialSelection = PlatformTextControlUtilsKt.createSelectionRange(caretModel);
        documentTypingSession.getOnRemoteChange().advise(this.lifetime, arg_0 -> FairMergeStrategy._init_$lambda$0(this, arg_0));
        documentTypingSession.getOnLocalChange().advise(this.lifetime, arg_0 -> FairMergeStrategy._init_$lambda$1(this, arg_0));
        editorTypingSession.getOnRemoteChange().advise(this.lifetime, arg_0 -> FairMergeStrategy._init_$lambda$2(this, arg_0));
    }

    private final UndoableEditorChange getOrCreateUndoableEditorChange() {
        CommandDescriptor currentCommand;
        RLifetimeKt.assertAlive((Lifetime)this.lifetime);
        RdCommandProcessor commandProcessorModel = RdCommandProcessor_GeneratedKt.getRdCommandProcessor((DocumentsOperationModel)DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)FrontendSessionsUtilKt.getProtocol((ClientAppSession)this.session)));
        CommandDescriptor commandDescriptor = currentCommand = (CommandDescriptor)commandProcessorModel.getCurrentCommand().getValue();
        String name = commandDescriptor != null ? commandDescriptor.getName() : null;
        UndoableEditorChange change = (UndoableEditorChange)CollectionsKt.lastOrNull(this.remoteChanges);
        if (change != null && Intrinsics.areEqual((Object)change.getUndoCommandName(), (Object)name)) {
            return change;
        }
        UndoableEditorChange newChange = new UndoableEditorChange(name);
        this.remoteChanges.add(newChange);
        return newChange;
    }

    public final void merge() {
        RLifetimeKt.assertAlive((Lifetime)this.lifetime);
        this.fireBeforeMerge();
        if (this.remoteChanges.isEmpty()) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> FairMergeStrategy.merge$lambda$0(this));
            return;
        }
        Project project = this.editor.getProject();
        Ref.BooleanRef isFirst = new Ref.BooleanRef();
        isFirst.element = true;
        for (UndoableEditorChange editorChange : this.remoteChanges) {
            Runnable doApply = () -> FairMergeStrategy.merge$lambda$1(this, isFirst, editorChange);
            ActionsKt.runWriteAction(() -> FairMergeStrategy.merge$lambda$2(isFirst, doApply, project, editorChange));
        }
    }

    private final void fireBeforeMerge() {
        RiderBreakingWorkflowChangeInterceptor.Companion.beforeExpectedChange(this.editor);
    }

    private final void fireAfterMerge() {
        RiderBreakingWorkflowChangeInterceptor.Companion.afterExpectedChange(this.editor);
    }

    private final void revertLocalChanges() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        for (RdTextChange change : CollectionsKt.asReversedMutable(this.localChanges)) {
            DocumentChangeModelConversion.INSTANCE.applyModelChange(RdTextChangeKt.reverse((RdTextChange)change), document2, false);
        }
        PlatformTextControlUtilsKt.applyTo(this.localInitialSelection, this.editor);
    }

    private static final Unit _init_$lambda$0(FairMergeStrategy this$0, RdTextChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        UndoableEditorChange editorChange = this$0.getOrCreateUndoableEditorChange();
        editorChange.appendDocumentChange(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(FairMergeStrategy this$0, RdTextChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.localChanges.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(FairMergeStrategy this$0, SelectionRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        UndoableEditorChange editorChange = this$0.getOrCreateUndoableEditorChange();
        editorChange.setLastSelection(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit merge$lambda$0$0(FairMergeStrategy this$0) {
        this$0.editor.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)true);
        try {
            this$0.revertLocalChanges();
        }
        finally {
            this$0.editor.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, null);
        }
        return Unit.INSTANCE;
    }

    private static final void merge$lambda$0(FairMergeStrategy this$0) {
        ActionsKt.runWriteAction(() -> FairMergeStrategy.merge$lambda$0$0(this$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void merge$lambda$1(FairMergeStrategy this$0, Ref.BooleanRef $isFirst, UndoableEditorChange $editorChange) {
        try {
            this$0.editor.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)true);
            Document document = this$0.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            if ($isFirst.element) {
                $isFirst.element = false;
                this$0.revertLocalChanges();
            }
            for (RdTextChange documentChange : $editorChange.getDocumentChanges()) {
                DocumentChangeModelConversion.INSTANCE.applyModelChange(documentChange, document2, false);
            }
        }
        finally {
            this$0.editor.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, null);
        }
        SelectionRange remoteSelection = $editorChange.getLastSelection();
        if (remoteSelection != null) {
            PlatformTextControlUtilsKt.applyTo(remoteSelection, this$0.editor);
        }
        EditorModificationUtil.scrollToCaret((Editor)this$0.editor);
        this$0.fireAfterMerge();
    }

    private static final Unit merge$lambda$2(Ref.BooleanRef $isFirst, Runnable $doApply, Project $project, UndoableEditorChange $editorChange) {
        if ($isFirst.element) {
            CommandProcessor.getInstance().runUndoTransparentAction($doApply);
        } else {
            CommandProcessor.getInstance().executeCommand($project, $doApply, $editorChange.getUndoCommandName(), null);
        }
        return Unit.INSTANCE;
    }
}

