/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.util.idea.LifetimedProjectComponent;
import com.jetbrains.rider.document.RiderDocumentBindingService;
import com.jetbrains.rider.editors.EditorsSynchronizerKt;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011J\b\u0010\u0012\u001a\u00020\u000eH\u0003J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/editors/EditorsSynchronizer;", "Lcom/jetbrains/rdclient/util/idea/LifetimedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "syncWithProjectModelQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "isProjectModelUpdated", "Lcom/jetbrains/rd/util/reactive/Property;", "", "queueReloadModelEditors", "", "runAfterProjectModelSync", "block", "Lkotlin/Function0;", "syncWithProjectModel", "syncWithProjectModelForNewBinding", "documentId", "Lcom/jetbrains/rider/model/RdFrontendDocumentId;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "WorkspaceModelEventsListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nEditorsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorsSynchronizer.kt\ncom/jetbrains/rider/editors/EditorsSynchronizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,147:1\n1#2:148\n1#2:164\n67#3,4:149\n67#3,4:181\n1642#4,10:153\n1915#4:163\n1916#4:165\n1652#4:166\n1525#4:167\n1557#4,3:168\n1560#4,3:178\n1586#4:185\n1661#4,3:186\n1807#4,3:189\n383#5,7:171\n*S KotlinDebug\n*F\n+ 1 EditorsSynchronizer.kt\ncom/jetbrains/rider/editors/EditorsSynchronizer\n*L\n87#1:164\n48#1:149,4\n90#1:181,4\n87#1:153,10\n87#1:163\n87#1:165\n87#1:166\n89#1:167\n89#1:168,3\n89#1:178,3\n95#1:185\n95#1:186,3\n121#1:189,3\n89#1:171,7\n*E\n"})
public final class EditorsSynchronizer
extends LifetimedProjectComponent {
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue syncWithProjectModelQueue;
    @NotNull
    private final Property<Boolean> isProjectModelUpdated;

    /*
     * WARNING - void declaration
     */
    public EditorsSynchronizer(@NotNull Project project) {
        void $this$syncWithProjectModelQueue_u24lambda_u240;
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)this.getComponentLifetime()), null, (int)1, null);
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("syncEditorsQueue", 1000, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, null, true).setRestartTimerOnAdd(false);
        EditorsSynchronizer editorsSynchronizer = this;
        boolean bl = false;
        $this$syncWithProjectModelQueue_u24lambda_u240.setPassThrough(false);
        editorsSynchronizer.syncWithProjectModelQueue = mergingUpdateQueue;
        this.isProjectModelUpdated = new Property((Object)true);
    }

    private final void queueReloadModelEditors() {
        Logger $this$trace$iv = EditorsSynchronizerKt.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("queueReloadModelEditors under " + ClientId.Companion.getCurrent());
        }
        this.isProjectModelUpdated.set((Object)false);
        this.syncWithProjectModelQueue.queue(new Update(this){
            final /* synthetic */ EditorsSynchronizer this$0;
            {
                this.this$0 = $receiver;
                super((Object)"QueueSyncEditors", false, 0, 6, null);
            }

            public void run() {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                if (commandProcessor.isCommandInProgress()) {
                    EditorsSynchronizerKt.getLogger().trace("we are currently under command " + commandProcessor.getCurrentCommandName() + " so postpone the sync");
                    EditorsSynchronizer.access$isProjectModelUpdated$p(this.this$0).set((Object)true);
                    EditorsSynchronizer.access$queueReloadModelEditors(this.this$0);
                    return;
                }
                Logger $this$trace$iv = EditorsSynchronizerKt.getLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Calling syncWithProjectModel under " + ClientId.Companion.getCurrent());
                }
                EditorsSynchronizer.access$syncWithProjectModel(this.this$0);
            }
        });
    }

    public final void runAfterProjectModelSync(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (((Boolean)this.isProjectModelUpdated.getValue()).booleanValue()) {
            EditorsSynchronizerKt.getLogger().trace("Execute block right away");
            block.invoke();
            return;
        }
        EditorsSynchronizerKt.getLogger().trace("PM in sync. Postpone block execution.");
        SourceExKt.adviseUntil((ISource)this.isProjectModelUpdated.getChange(), (Lifetime)((Lifetime)this.getComponentLifetime()), arg_0 -> EditorsSynchronizer.runAfterProjectModelSync$lambda$0(block, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void syncWithProjectModel() {
        Iterable it;
        Object object;
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        EditorsSynchronizerKt.getLogger().trace("start syncing model editors...");
        FrontendTextControlHost textControlHost = FrontendTextControlHost.Companion.getInstance(this.getProject());
        Iterable $this$mapNotNull$iv = textControlHost.getEditors();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EditorSynchronizer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Editor it2 = (Editor)element$iv$iv;
            boolean bl2 = false;
            if (DocumentExKt.getEditorSynchronizer((Editor)it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            EditorSynchronizer it3 = (EditorSynchronizer)element$iv$iv;
            boolean $i$a$-groupBy-EditorsSynchronizer$syncWithProjectModel$openedEditorsByDocument$42 = false;
            RdDocumentId key$iv$iv = it3.getTextControlId().getDocumentId();
            Object bl = destination$iv$iv;
            RdDocumentId key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            EditorSynchronizer $i$a$-groupBy-EditorsSynchronizer$syncWithProjectModel$openedEditorsByDocument$42 = (EditorSynchronizer)element$iv$iv;
            object = list$iv$iv;
            boolean bl5 = false;
            object.add(it.getEditor());
        }
        Object openedEditorsByDocument = destination$iv$iv;
        Logger $this$trace$iv = EditorsSynchronizerKt.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            boolean bl = false;
            int totalEditors = FileEditorManager.getInstance((Project)this.getProject()).getAllEditors().length;
            object.trace("All open editors count: " + totalEditors + ", opened backend editors: " + openedEditorsByDocument.size());
        }
        for (Map.Entry entry2 : openedEditorsByDocument.entrySet()) {
            VirtualFile virtualFile;
            Document document;
            void $this$mapTo$iv$iv;
            RdDocumentId documentId = (RdDocumentId)entry2.getKey();
            List ideaEditors = (List)entry2.getValue();
            Iterable $this$map$iv = ideaEditors;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                value$iv$iv$iv = (Editor)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(it4.getDocument());
            }
            if ((Document)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2))) == null || FileDocumentManager.getInstance().getFile(document) == null || !(documentId instanceof RdFrontendDocumentId)) continue;
            this.syncWithProjectModelForNewBinding((RdFrontendDocumentId)documentId, virtualFile);
        }
        EditorsSynchronizerKt.getLogger().trace("Syncing model editors has been finished");
        this.isProjectModelUpdated.set((Object)true);
    }

    /*
     * Unable to fully structure code
     */
    private final void syncWithProjectModelForNewBinding(RdFrontendDocumentId documentId, VirtualFile virtualFile) {
        block7: {
            upToDateEntities = WorkspaceModelExtensionsKt.getProjectModelEntities(WorkspaceModel.Companion.getInstance(this.getProject()), virtualFile, this.getProject());
            if (upToDateEntities.isEmpty()) {
                EditorsSynchronizerKt.getLogger().trace("Can't find project model entity for " + virtualFile + ", documentId: " + documentId);
                return;
            }
            riderDocumentIdFactory = RiderDocumentBindingService.Companion.getInstance(this.getProject());
            oldProjectModelId = riderDocumentIdFactory.getProjectModelId(documentId);
            if (oldProjectModelId == null || oldProjectModelId <= 0) ** GOTO lbl-1000
            $this$any$iv = upToDateEntities;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (ProjectModelEntity)element$iv;
                    $i$a$-any-EditorsSynchronizer$syncWithProjectModelForNewBinding$actualProjectModelId$1 = false;
                    v1 = ProjectModelEntityExtensionsKt.getId(it, this.getProject());
                    var13_12 = oldProjectModelId;
                    if (!(v1 != null && v1 == var13_12 && ProjectModelEntityExtensionsKt.isFromSolutionFolder(it) == false)) continue;
                    v0 = true;
                    break block7;
                }
                v0 = false;
            }
        }
        if (v0) {
            v2 = oldProjectModelId;
        } else lbl-1000:
        // 2 sources

        {
            v2 = actualProjectModelId = Integer.valueOf(com.jetbrains.rider.document.DocumentExKt.findBestProjectModelIdForDocument(upToDateEntities, this.getProject()));
        }
        if (actualProjectModelId == 0) {
            actualProjectModelId = null;
        }
        v3 = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPath(...)");
        riderDocumentIdFactory.updatePath(documentId, v3);
        riderDocumentIdFactory.updateProjectModelId(documentId, actualProjectModelId);
    }

    private static final boolean runAfterProjectModelSync$lambda$0(Function0 $block, boolean isUpdated) {
        if (!isUpdated) {
            return false;
        }
        ThreadingAssertions.assertEventDispatchThread();
        $block.invoke();
        return true;
    }

    public static final /* synthetic */ Property access$isProjectModelUpdated$p(EditorsSynchronizer $this) {
        return $this.isProjectModelUpdated;
    }

    public static final /* synthetic */ void access$syncWithProjectModel(EditorsSynchronizer $this) {
        $this.syncWithProjectModel();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/editors/EditorsSynchronizer$WorkspaceModelEventsListener;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "changed", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nEditorsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorsSynchronizer.kt\ncom/jetbrains/rider/editors/EditorsSynchronizer$WorkspaceModelEventsListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,147:1\n30#2,2:148\n*S KotlinDebug\n*F\n+ 1 EditorsSynchronizer.kt\ncom/jetbrains/rider/editors/EditorsSynchronizer$WorkspaceModelEventsListener\n*L\n144#1:148,2\n*E\n"})
    public static final class WorkspaceModelEventsListener
    implements WorkspaceModelChangeListener {
        @NotNull
        private final Project project;
        @NotNull
        private final CoroutineScope cs;

        public WorkspaceModelEventsListener(@NotNull Project project, @NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.project = project;
            this.cs = cs;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final CoroutineScope getCs() {
            return this.cs;
        }

        public void changed(@NotNull VersionedStorageChange event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            List changes = event.getChanges(ProjectModelEntity.class);
            if (changes.isEmpty()) {
                return;
            }
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<EditorsSynchronizer> serviceClass$iv = EditorsSynchronizer.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((EditorsSynchronizer)((Object)object)).queueReloadModelEditors();
        }
    }
}

