/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environment.remote.deploy.processing;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiHelpersKt;
import com.intellij.platform.eel.fs.StreamingWriteResult;
import com.intellij.platform.eel.fs.WriteOptionsBuilder;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.util.io.IoKt;
import com.jetbrains.rider.environment.remote.deploy.DeploymentEntry;
import com.jetbrains.rider.environment.remote.deploy.RiderRemoteEnvironmentDeploymentProvider;
import com.jetbrains.rider.environment.remote.deploy.files.RiderRemoteEnvironmentFolders;
import com.jetbrains.rider.environment.remote.deploy.processing.DeploymentResourceUploader;
import com.jetbrains.rider.environment.remote.deploy.processing.Unarchiver;
import com.jetbrains.rider.environment.remote.deploy.processing.expand.DeploymentEntryExpander;
import com.jetbrains.rider.environment.remote.deploy.processing.expand.ExpandedDeploymentEntry;
import com.jetbrains.rider.environment.remote.deploy.processing.expand.FileEntryExpander;
import com.jetbrains.rider.environment.remote.deploy.processing.expand.ZipArchiveExpander;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 (2\u00020\u0001:\u0003()*B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u001d\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0082@\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0082@\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00142\u0006\u0010!\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010'\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/environment/remote/deploy/processing/DeploymentResourceUploader;", "", "deploymentResource", "Lcom/jetbrains/rider/environment/remote/deploy/RiderRemoteEnvironmentDeploymentProvider$DeploymentResource;", "unarchiver", "Lcom/jetbrains/rider/environment/remote/deploy/processing/Unarchiver;", "eel", "Lcom/intellij/platform/eel/EelApi;", "targetDirectory", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/jetbrains/rider/environment/remote/deploy/RiderRemoteEnvironmentDeploymentProvider$DeploymentResource;Lcom/jetbrains/rider/environment/remote/deploy/processing/Unarchiver;Lcom/intellij/platform/eel/EelApi;Lcom/intellij/platform/eel/path/EelPath;)V", "markerFile", "Lcom/jetbrains/rider/environment/remote/deploy/processing/DeploymentResourceUploader$UploadMarkerFile;", "eelFs", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "upload", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeToArchive", "", "entriesFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/jetbrains/rider/environment/remote/deploy/DeploymentEntry;", "pathToArchive", "(Lkotlinx/coroutines/flow/Flow;Lcom/intellij/platform/eel/path/EelPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unarchive", "(Lcom/intellij/platform/eel/path/EelPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "postProcessDeployedFiles", "isUpToDate", "writeMarkerFile", "getFlowToUpload", "processEntry", "entry", "tar", "Lorg/apache/commons/compress/archivers/tar/TarArchiveOutputStream;", "(Lcom/jetbrains/rider/environment/remote/deploy/DeploymentEntry;Lorg/apache/commons/compress/archivers/tar/TarArchiveOutputStream;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeToStream", "Lcom/jetbrains/rider/environment/remote/deploy/processing/expand/ExpandedDeploymentEntry;", "isRunningFromSources", "Companion", "UploadMarkerFile", "ChannelOutputStream", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDeploymentResourceUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeploymentResourceUploader.kt\ncom/jetbrains/rider/environment/remote/deploy/processing/DeploymentResourceUploader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,233:1\n1#2:234\n23#3:235\n*S KotlinDebug\n*F\n+ 1 DeploymentResourceUploader.kt\ncom/jetbrains/rider/environment/remote/deploy/processing/DeploymentResourceUploader\n*L\n54#1:235\n*E\n"})
public final class DeploymentResourceUploader {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final RiderRemoteEnvironmentDeploymentProvider.DeploymentResource deploymentResource;
    @NotNull
    private final Unarchiver unarchiver;
    @NotNull
    private final EelApi eel;
    @NotNull
    private final EelPath targetDirectory;
    @NotNull
    private final UploadMarkerFile markerFile;
    @NotNull
    private final EelFileSystemApi eelFs;
    @NotNull
    private static final Logger LOG;

    public DeploymentResourceUploader(@NotNull RiderRemoteEnvironmentDeploymentProvider.DeploymentResource deploymentResource, @NotNull Unarchiver unarchiver, @NotNull EelApi eel, @NotNull EelPath targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)deploymentResource, (String)"deploymentResource");
        Intrinsics.checkNotNullParameter((Object)unarchiver, (String)"unarchiver");
        Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        this.deploymentResource = deploymentResource;
        this.unarchiver = unarchiver;
        this.eel = eel;
        this.targetDirectory = targetDirectory;
        this.markerFile = new UploadMarkerFile();
        this.eelFs = this.eel.getFs();
    }

    @Nullable
    public final Object upload(@NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ DeploymentResourceUploader this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DeploymentResourceUploader.access$getFlowToUpload(this.this$0, (Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = (Flow)v0;
                        if (v1 == null) {
                            return Boxing.boxBoolean((boolean)true);
                        }
                        entriesFlow = v1;
                        archiveName = FileUtil.sanitizeFileName((String)(DeploymentResourceUploader.access$getDeploymentResource$p(this.this$0).getId() + "-" + DeploymentResourceUploader.access$getDeploymentResource$p(this.this$0).getVersion())) + ".tar";
                        archivePath = DeploymentResourceUploader.access$getTargetDirectory$p(this.this$0).resolve((String)archiveName);
                        DeploymentResourceUploader.access$getLOG$cp().info("Starting processing for provider '" + DeploymentResourceUploader.access$getDeploymentResource$p(this.this$0).getName() + "' -> " + archivePath);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)entriesFlow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)archiveName);
                        this.L$2 = archivePath;
                        this.label = 2;
                        v2 = DeploymentResourceUploader.access$writeToArchive(this.this$0, entriesFlow, archivePath, (Continuation)this);
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl34
                    }
                    case 2: {
                        archivePath = (EelPath)this.L$2;
                        archiveName = (String)this.L$1;
                        entriesFlow = (Flow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl34:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)entriesFlow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)archiveName);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)archivePath);
                        this.label = 3;
                        v3 = DeploymentResourceUploader.access$unarchive(this.this$0, archivePath, (Continuation)this);
                        if (v3 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl48
                    }
                    case 3: {
                        archivePath = (EelPath)this.L$2;
                        archiveName = (String)this.L$1;
                        entriesFlow = (Flow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl48:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)entriesFlow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)archiveName);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)archivePath);
                        this.label = 4;
                        v4 = this.this$0.postProcessDeployedFiles((Continuation<? super Unit>)((Continuation)this));
                        if (v4 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl62
                    }
                    case 4: {
                        archivePath = (EelPath)this.L$2;
                        archiveName = (String)this.L$1;
                        entriesFlow = (Flow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl62:
                        // 2 sources

                        DeploymentResourceUploader.access$writeMarkerFile(this.this$0);
                        return Boxing.boxBoolean((boolean)false);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Object writeToArchive(Flow<? extends DeploymentEntry> entriesFlow, EelPath pathToArchive, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pathToArchive, entriesFlow, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DeploymentResourceUploader this$0;
            final /* synthetic */ EelPath $pathToArchive;
            final /* synthetic */ Flow<DeploymentEntry> $entriesFlow;
            {
                this.this$0 = $receiver;
                this.$pathToArchive = $pathToArchive;
                this.$entriesFlow = $entriesFlow;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        tarPieceChannel = ProduceKt.produce$default((CoroutineScope)$this$withContext, null, (int)20, (Function2)((Function2)new Function2<ProducerScope<? super ByteBuffer>, Continuation<? super Unit>, Object>(this.$entriesFlow, this.this$0, null){
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            int I$0;
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ Flow<DeploymentEntry> $entriesFlow;
                            final /* synthetic */ DeploymentResourceUploader this$0;
                            {
                                this.$entriesFlow = $entriesFlow;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             * Could not resolve type clashes
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (ProducerScope)this.L$0;
                                var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var4_4 /* !! */  = new ChannelOutputStream((SendChannel<? super ByteBuffer>)$this$produce.getChannel());
                                        var5_5 = 131072;
                                        outputStream = var4_4 /* !! */  instanceof BufferedOutputStream != false ? (BufferedOutputStream)var4_4 /* !! */  : new BufferedOutputStream(var4_4 /* !! */ , var5_5);
                                        var4_4 /* !! */  = (Closeable)new TarArchiveOutputStream((OutputStream)outputStream);
                                        var5_6 = this.$entriesFlow;
                                        var6_9 = this.this$0;
                                        var7_10 = null;
                                        tar = (TarArchiveOutputStream)var4_4 /* !! */ ;
                                        $i$a$-use-DeploymentResourceUploader$writeToArchive$2$tarPieceChannel$1$1 = 0;
                                        tar.setLongFileMode(3);
                                        tar.setBigNumberMode(2);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$produce);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)outputStream);
                                        this.L$2 = var4_4 /* !! */ ;
                                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)tar);
                                        this.I$0 = $i$a$-use-DeploymentResourceUploader$writeToArchive$2$tarPieceChannel$1$1;
                                        this.label = 1;
                                        v0 = var5_6.collect(new FlowCollector(var6_9, tar){
                                            final /* synthetic */ DeploymentResourceUploader this$0;
                                            final /* synthetic */ TarArchiveOutputStream $tar;
                                            {
                                                this.this$0 = $receiver;
                                                this.$tar = $tar;
                                            }

                                            public final Object emit(DeploymentEntry entry2, Continuation<? super Unit> $completion) {
                                                Object object = DeploymentResourceUploader.access$processEntry(this.this$0, entry2, this.$tar, $completion);
                                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                    return object;
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        ** if (v0 != var10_3) goto lbl28
lbl27:
                                        // 1 sources

                                        return var10_3;
lbl28:
                                        // 1 sources

                                        ** GOTO lbl39
                                    }
                                    case 1: {
                                        $i$a$-use-DeploymentResourceUploader$writeToArchive$2$tarPieceChannel$1$1 = this.I$0;
                                        tar = (TarArchiveOutputStream)this.L$3;
                                        var7_10 = null;
                                        var4_4 /* !! */  = (Closeable)this.L$2;
                                        outputStream = (BufferedOutputStream)this.L$1;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl39:
                                            // 2 sources

                                            var8_11 = Unit.INSTANCE;
                                            ** GOTO lbl49
                                        }
                                        catch (Throwable var9_14) {
                                            var7_10 = var9_14;
                                            throw var9_14;
                                        }
                                    }
                                    catch (Throwable var9_15) {
                                        throw var9_15;
                                    }
                                    {
                                        finally {
                                            CloseableKt.closeFinally((Closeable)var4_4 /* !! */ , (Throwable)var7_10);
                                        }
lbl49:
                                        // 1 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ProducerScope<? super ByteBuffer> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)tarPieceChannel);
                        this.label = 1;
                        v0 = DeploymentResourceUploader.access$getEelFs$p(this.this$0).streamingWrite(FlowKt.consumeAsFlow((ReceiveChannel)tarPieceChannel), new WriteOptionsBuilder(this.$pathToArchive).build(), (Continuation)this);
                        if (v0 == var6_3) {
                            return var6_3;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        tarPieceChannel = (ReceiveChannel)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if ((var5_7 = (writeResult = (StreamingWriteResult)v0)) instanceof StreamingWriteResult.Error) {
                            throw new IllegalStateException(("Streaming write failed writing file a remote machine: " + ((StreamingWriteResult.Error)writeResult).getError()).toString());
                        }
                        if (!(var5_7 instanceof StreamingWriteResult.Ok)) {
                            throw new NoWhenBranchMatchedException();
                        }
                        DeploymentResourceUploader.access$getLOG$cp().info("Completed processing for provider '" + DeploymentResourceUploader.access$getDeploymentResource$p(this.this$0).getName() + "'");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object unarchive(EelPath pathToArchive, Continuation<? super Unit> $completion) {
        if (!($completion instanceof unarchive.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DeploymentResourceUploader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DeploymentResourceUploader.access$unarchive(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                DeploymentResourceUploader.LOG.info("Unarchiving " + pathToArchive + " to " + this.targetDirectory);
                $continuation.L$0 = pathToArchive;
                $continuation.label = 1;
                v0 = this.unarchiver.unarchive(pathToArchive, this.targetDirectory, (Continuation<? super Unit>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                pathToArchive = (EelPath)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                DeploymentResourceUploader.LOG.info("Unarchived " + pathToArchive + " to " + this.targetDirectory);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object postProcessDeployedFiles(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof postProcessDeployedFiles.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DeploymentResourceUploader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.postProcessDeployedFiles((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                DeploymentResourceUploader.LOG.info("Begin post-processing of " + this.deploymentResource.getName());
                $continuation.label = 1;
                v0 = this.deploymentResource.postProcess(this.eel.getDescriptor(), this.targetDirectory, RiderRemoteEnvironmentFolders.INSTANCE, (Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                DeploymentResourceUploader.LOG.info("Post-processing of " + this.deploymentResource.getName() + " completed.");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object isUpToDate(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isUpToDate.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DeploymentResourceUploader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DeploymentResourceUploader.access$isUpToDate(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.markerFile.getVersion((Continuation<? super String>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(versionFromFile = (String)v0), (Object)(currentVersion = this.deploymentResource.getVersion()))) {
                    DeploymentResourceUploader.LOG.info("Files from provider '" + this.deploymentResource.getName() + "' - need to be uploaded because the version has changed. Expected: " + currentVersion + ", Actual: '" + versionFromFile + "'");
                    v1 = false;
                } else {
                    DeploymentResourceUploader.LOG.info("Skipping provider '" + this.deploymentResource.getName() + "' - version '" + currentVersion + "' already uploaded");
                    v1 = true;
                }
                return Boxing.boxBoolean((boolean)v1);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void writeMarkerFile() {
        this.markerFile.writeVersion();
    }

    /*
     * Unable to fully structure code
     */
    private final Object getFlowToUpload(Continuation<? super Flow<? extends DeploymentEntry>> $completion) {
        if (!($completion instanceof getFlowToUpload.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DeploymentResourceUploader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DeploymentResourceUploader.access$getFlowToUpload(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.isUpToDate((Continuation<? super Boolean>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                return ((Boolean)v0).booleanValue() ? (this.isRunningFromSources() ? this.deploymentResource.getEntriesForRunningFromSources(this.eel.getDescriptor(), RiderRemoteEnvironmentFolders.INSTANCE) : null) : this.deploymentResource.getEntries(this.eel.getDescriptor(), RiderRemoteEnvironmentFolders.INSTANCE);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object processEntry(DeploymentEntry entry2, TarArchiveOutputStream tar, Continuation<? super Unit> $completion) {
        DeploymentEntryExpander deploymentEntryExpander;
        DeploymentEntry deploymentEntry = entry2;
        if (deploymentEntry instanceof DeploymentEntry.FileOrFolder) {
            deploymentEntryExpander = new FileEntryExpander((DeploymentEntry.FileOrFolder)entry2);
        } else if (deploymentEntry instanceof DeploymentEntry.ZipArchive) {
            deploymentEntryExpander = new ZipArchiveExpander((DeploymentEntry.ZipArchive)entry2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DeploymentEntryExpander expander = deploymentEntryExpander;
        Object object = expander.expand().collect(new FlowCollector(this, tar){
            final /* synthetic */ DeploymentResourceUploader this$0;
            final /* synthetic */ TarArchiveOutputStream $tar;
            {
                this.this$0 = $receiver;
                this.$tar = $tar;
            }

            public final Object emit(ExpandedDeploymentEntry subEntry, Continuation<? super Unit> $completion) {
                DeploymentResourceUploader.access$writeToStream(this.this$0, subEntry, this.$tar);
                return Unit.INSTANCE;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeToStream(ExpandedDeploymentEntry entry2, TarArchiveOutputStream tar) {
        Object object;
        TarArchiveEntry $this$writeToStream_u24lambda_u240 = object = new TarArchiveEntry(entry2.getRelativePath());
        boolean bl = false;
        $this$writeToStream_u24lambda_u240.setSize(entry2.getSize());
        Integer n = entry2.getUnixMode();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$writeToStream_u24lambda_u240.setMode(it);
        }
        TarArchiveEntry tarEntry = object;
        tar.putArchiveEntry(tarEntry);
        object = entry2.getContent();
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)object;
            boolean bl3 = false;
            long l = ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)((OutputStream)tar), (int)8192);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        tar.closeArchiveEntry();
    }

    private final boolean isRunningFromSources() {
        return PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild();
    }

    public static final /* synthetic */ Object access$getFlowToUpload(DeploymentResourceUploader $this, Continuation $completion) {
        return $this.getFlowToUpload((Continuation<? super Flow<? extends DeploymentEntry>>)$completion);
    }

    public static final /* synthetic */ Object access$writeToArchive(DeploymentResourceUploader $this, Flow entriesFlow, EelPath pathToArchive, Continuation $completion) {
        return $this.writeToArchive((Flow<? extends DeploymentEntry>)entriesFlow, pathToArchive, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$unarchive(DeploymentResourceUploader $this, EelPath pathToArchive, Continuation $completion) {
        return $this.unarchive(pathToArchive, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$writeMarkerFile(DeploymentResourceUploader $this) {
        $this.writeMarkerFile();
    }

    public static final /* synthetic */ Object access$processEntry(DeploymentResourceUploader $this, DeploymentEntry entry2, TarArchiveOutputStream tar, Continuation $completion) {
        return $this.processEntry(entry2, tar, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ EelFileSystemApi access$getEelFs$p(DeploymentResourceUploader $this) {
        return $this.eelFs;
    }

    public static final /* synthetic */ Object access$isUpToDate(DeploymentResourceUploader $this, Continuation $completion) {
        return $this.isUpToDate((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ void access$writeToStream(DeploymentResourceUploader $this, ExpandedDeploymentEntry entry2, TarArchiveOutputStream tar) {
        $this.writeToStream(entry2, tar);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/environment/remote/deploy/processing/DeploymentResourceUploader$ChannelOutputStream;", "Ljava/io/OutputStream;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "Ljava/nio/ByteBuffer;", "<init>", "(Lkotlinx/coroutines/channels/SendChannel;)V", "write", "", "b", "", "", "off", "len", "writeBuffer", "buffer", "flush", "close", "intellij.rider.rdclient.dotnet"})
    private static final class ChannelOutputStream
    extends OutputStream {
        @NotNull
        private final SendChannel<ByteBuffer> channel;

        public ChannelOutputStream(@NotNull SendChannel<? super ByteBuffer> channel) {
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            this.channel = channel;
        }

        @Override
        public void write(int b) {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)b);
            buffer.flip();
            Intrinsics.checkNotNull((Object)buffer);
            this.writeBuffer(buffer);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            byte[] byArray = Arrays.copyOf(b, b.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            ByteBuffer buffer = ByteBuffer.wrap(byArray, off, len);
            Intrinsics.checkNotNull((Object)buffer);
            this.writeBuffer(buffer);
        }

        private final void writeBuffer(ByteBuffer buffer) {
            CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, buffer, null){
                int label;
                final /* synthetic */ ChannelOutputStream this$0;
                final /* synthetic */ ByteBuffer $buffer;
                {
                    this.this$0 = $receiver;
                    this.$buffer = $buffer;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = ChannelOutputStream.access$getChannel$p(this.this$0).send((Object)this.$buffer, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            SendChannel.DefaultImpls.close$default(this.channel, null, (int)1, null);
        }

        public static final /* synthetic */ SendChannel access$getChannel$p(ChannelOutputStream $this) {
            return $this.channel;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/environment/remote/deploy/processing/DeploymentResourceUploader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/environment/remote/deploy/processing/DeploymentResourceUploader$UploadMarkerFile;", "", "<init>", "(Lcom/jetbrains/rider/environment/remote/deploy/processing/DeploymentResourceUploader;)V", "MARKER_FILE_SUFFIX", "", "getVersion", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeVersion", "", "getMarkerFilePath", "Lcom/intellij/platform/eel/path/EelPath;", "intellij.rider.rdclient.dotnet"})
    private final class UploadMarkerFile {
        @NotNull
        private final String MARKER_FILE_SUFFIX;

        public UploadMarkerFile() {
            this.MARKER_FILE_SUFFIX = ".version";
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object getVersion(@NotNull Continuation<? super String> $completion) {
            if (!($completion instanceof getVersion.1)) ** GOTO lbl-1000
            var9_2 = $completion;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ UploadMarkerFile this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.getVersion((Continuation<? super String>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var3_5 = this;
                    var4_6 = DeploymentResourceUploader.this;
                    $this$getVersion_u24lambda_u240 = var3_5;
                    $i$a$-runCatching-DeploymentResourceUploader$UploadMarkerFile$getVersion$version$1 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getVersion_u24lambda_u240);
                    $continuation.I$0 = $i$a$-runCatching-DeploymentResourceUploader$UploadMarkerFile$getVersion$version$1;
                    $continuation.label = 1;
                    v0 = EelFileSystemApiHelpersKt.readFile((EelFileSystemApi)DeploymentResourceUploader.access$getEelFs$p(var4_6), (EelPath)$this$getVersion_u24lambda_u240.getMarkerFilePath()).eelIt((Continuation)$continuation);
                    ** if (v0 != var10_4) goto lbl25
lbl24:
                    // 1 sources

                    return var10_4;
lbl25:
                    // 1 sources

                    ** GOTO lbl33
                }
                case 1: {
                    $i$a$-runCatching-DeploymentResourceUploader$UploadMarkerFile$getVersion$version$1 = $continuation.I$0;
                    $this$getVersion_u24lambda_u240 = (UploadMarkerFile)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl33:
                        // 2 sources

                        readResult = (EelFileSystemApi.ReadFileResult)EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v0));
                        var5_7 = Result.constructor-impl((Object)StringsKt.trim((CharSequence)new String(IoKt.toByteArray$default((ByteBuffer)readResult.getBytes(), (boolean)false, (int)1, null), Charsets.UTF_8)).toString());
                    }
                    catch (Throwable $i$a$-runCatching-DeploymentResourceUploader$UploadMarkerFile$getVersion$version$1) {
                        var5_7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DeploymentResourceUploader$UploadMarkerFile$getVersion$version$1));
                    }
                    var3_5 = var5_7;
                    var4_6 = DeploymentResourceUploader.this;
                    v1 = Result.exceptionOrNull-impl((Object)var3_5);
                    if (v1 != null) {
                        it = var5_7 = v1;
                        $i$a$-onFailure-DeploymentResourceUploader$UploadMarkerFile$getVersion$version$2 = false;
                        if (it instanceof NoSuchFileException) {
                            DeploymentResourceUploader.access$getLOG$cp().info("No marker file found for provider '" + DeploymentResourceUploader.access$getDeploymentResource$p(var4_6).getName() + "'");
                        } else {
                            DeploymentResourceUploader.access$getLOG$cp().warn("Failed to read marker file for provider '" + DeploymentResourceUploader.access$getDeploymentResource$p(var4_6).getName() + "'", (Throwable)it);
                        }
                    }
                    version = var3_5;
                    return Result.isFailure-impl((Object)version) != false ? null : version;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public final void writeVersion() {
            try {
                Path markerPath = EelNioBridgeServiceKt.asNioPath((EelPath)this.getMarkerFilePath());
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
                PathsKt.writeText((Path)markerPath, (CharSequence)DeploymentResourceUploader.this.deploymentResource.getVersion(), (Charset)Charsets.UTF_8, (OpenOption[])openOptionArray);
                LOG.info("Written marker file for provider '" + DeploymentResourceUploader.this.deploymentResource.getName() + "' with version '" + DeploymentResourceUploader.this.deploymentResource.getVersion() + "'");
            }
            catch (Throwable e) {
                LOG.warn("Failed to write marker file for provider '" + DeploymentResourceUploader.this.deploymentResource.getName() + "'", e);
            }
        }

        private final EelPath getMarkerFilePath() {
            return DeploymentResourceUploader.this.targetDirectory.resolve(DeploymentResourceUploader.this.deploymentResource.getId() + this.MARKER_FILE_SUFFIX);
        }
    }
}

