/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environment.remote.deploy.processing.expand;

import com.intellij.openapi.util.io.FileUtilRt;
import com.jetbrains.rider.environment.remote.deploy.DeploymentEntry;
import com.jetbrains.rider.environment.remote.deploy.processing.expand.DeploymentEntryExpander;
import com.jetbrains.rider.environment.remote.deploy.processing.expand.ExpandedDeploymentEntry;
import com.jetbrains.rider.environment.remote.deploy.processing.expand.ZipUtilsKt;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/environment/remote/deploy/processing/expand/FileEntryExpander;", "Lcom/jetbrains/rider/environment/remote/deploy/processing/expand/DeploymentEntryExpander;", "entry", "Lcom/jetbrains/rider/environment/remote/deploy/DeploymentEntry$FileOrFolder;", "<init>", "(Lcom/jetbrains/rider/environment/remote/deploy/DeploymentEntry$FileOrFolder;)V", "expand", "Lkotlinx/coroutines/flow/Flow;", "Lcom/jetbrains/rider/environment/remote/deploy/processing/expand/ExpandedDeploymentEntry;", "walkDirectoryAndWrite", "Lcom/jetbrains/rider/environment/remote/deploy/processing/expand/FileEntryExpander$File;", "File", "intellij.rider.rdclient.dotnet"})
public final class FileEntryExpander
implements DeploymentEntryExpander {
    @NotNull
    private final DeploymentEntry.FileOrFolder entry;

    public FileEntryExpander(@NotNull DeploymentEntry.FileOrFolder entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        this.entry = entry2;
    }

    @Override
    @NotNull
    public Flow<ExpandedDeploymentEntry> expand() {
        return this.walkDirectoryAndWrite(this.entry);
    }

    private final Flow<File> walkDirectoryAndWrite(DeploymentEntry.FileOrFolder entry2) {
        return FlowKt.buffer$default((Flow)FlowKt.flowOn((Flow)FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super File>, Continuation<? super Unit>, Object>(entry2, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DeploymentEntry.FileOrFolder $entry;
            {
                this.$entry = $entry;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (FlowCollector)this.L$0;
                var13_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        baseDir = this.$entry.getPath().getParent();
                        it = this.$entry.getRelativeFolderPath();
                        $i$a$-let-FileEntryExpander$walkDirectoryAndWrite$1$relativePrefix$1 = false;
                        relativePrefix = ((CharSequence)it).length() > 0 && !StringsKt.endsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) ? it + "/" : it;
                        $this$forEach$iv = PathsKt.walk((Path)this.$entry.getPath(), (PathWalkOption[])new PathWalkOption[0]);
                        $i$f$forEach = 0;
                        var7_8 = $this$forEach$iv.iterator();
lbl13:
                        // 3 sources

                        while (var7_8.hasNext()) {
                            element$iv = var7_8.next();
                            file = (Path)element$iv;
                            $i$a$-forEach-FileEntryExpander$walkDirectoryAndWrite$1$1 = 0;
                            Intrinsics.checkNotNull((Object)baseDir);
                            Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.toSystemIndependentName((String)PathsKt.relativeTo((Path)file, (Path)baseDir).toString()), (String)"toSystemIndependentName(...)");
                            fullRelativePath = relativePrefix + relativePath;
                            this.L$0 = $this$flow;
                            this.L$1 = baseDir;
                            this.L$2 = relativePrefix;
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                            this.L$4 = var7_8;
                            this.L$5 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                            this.L$6 = SpillingKt.nullOutSpilledVariable((Object)file);
                            this.L$7 = SpillingKt.nullOutSpilledVariable((Object)fullRelativePath);
                            this.L$8 = SpillingKt.nullOutSpilledVariable((Object)relativePath);
                            this.I$0 = $i$f$forEach;
                            this.I$1 = $i$a$-forEach-FileEntryExpander$walkDirectoryAndWrite$1$1;
                            this.label = 1;
                            v0 = $this$flow.emit((Object)new File((String)fullRelativePath, file), (Continuation)this);
                            if (v0 != var13_3) continue;
                            return var13_3;
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-forEach-FileEntryExpander$walkDirectoryAndWrite$1$1 = this.I$1;
                        $i$f$forEach = this.I$0;
                        relativePath = (String)this.L$8;
                        fullRelativePath = (String)this.L$7;
                        file = (Path)this.L$6;
                        element$iv = this.L$5;
                        var7_8 = (Iterator)this.L$4;
                        $this$forEach$iv = (Sequence)this.L$3;
                        relativePrefix = (String)this.L$2;
                        baseDir = (Path)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl13
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super File> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getIO())), (int)30, null, (int)2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/environment/remote/deploy/processing/expand/FileEntryExpander$File;", "Lcom/jetbrains/rider/environment/remote/deploy/processing/expand/ExpandedDeploymentEntry;", "relativePath", "", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getRelativePath", "()Ljava/lang/String;", "getUnixMode", "", "()Ljava/lang/Integer;", "getSize", "", "getContent", "Ljava/io/InputStream;", "intellij.rider.rdclient.dotnet"})
    private static final class File
    implements ExpandedDeploymentEntry {
        @NotNull
        private final String relativePath;
        @NotNull
        private final Path file;

        public File(@NotNull String relativePath, @NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.relativePath = relativePath;
            this.file = file;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            return this.relativePath;
        }

        @Override
        @Nullable
        public Integer getUnixMode() {
            Integer n;
            FileStore fileStore = Files.getFileStore(this.file);
            Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"getFileStore(...)");
            if (fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(this.file, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue(set, (String)"getPosixFilePermissions(...)");
                n = ZipUtilsKt.toUnixMode(set);
            } else {
                n = null;
            }
            return n;
        }

        @Override
        public long getSize() {
            return Files.size(this.file);
        }

        @Override
        @NotNull
        public InputStream getContent() {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(this.file, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            return inputStream;
        }
    }
}

