/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.icons;

import com.jetbrains.rider.icons.ReSharperToIdeaIconRenamerKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FileWalkDirection;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0018\u0010\u0012\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/icons/ReSharperToIdeaIconRenamer;", "", "<init>", "()V", "supportedExtensions", "", "", "IGNORED_THEMES", "Lcom/jetbrains/rider/icons/ReSharperToIdeaIconRenamer$ReSharperThemes;", "renameRecursive", "", "source", "Ljava/io/File;", "target", "override", "", "toIdeaName", "fileName", "concat", "T", "", "ReSharperThemes", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperToIdeaIconRenamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperToIdeaIconRenamer.kt\ncom/jetbrains/rider/icons/ReSharperToIdeaIconRenamer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,108:1\n1342#2,2:109\n*S KotlinDebug\n*F\n+ 1 ReSharperToIdeaIconRenamer.kt\ncom/jetbrains/rider/icons/ReSharperToIdeaIconRenamer\n*L\n62#1:109,2\n*E\n"})
final class ReSharperToIdeaIconRenamer {
    @NotNull
    public static final ReSharperToIdeaIconRenamer INSTANCE = new ReSharperToIdeaIconRenamer();
    @NotNull
    private static final List<String> supportedExtensions = CollectionsKt.listOf((Object)"png");
    @NotNull
    private static final List<ReSharperThemes> IGNORED_THEMES = CollectionsKt.listOf((Object)((Object)ReSharperThemes.Color));

    private ReSharperToIdeaIconRenamer() {
    }

    public final void renameRecursive(@NotNull File source, @NotNull File target, boolean override) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        System.out.println((Object)("Starting copying *.[" + this.concat((Iterable)supportedExtensions) + "] files from '" + source + "' to '" + target + "'"));
        System.out.println((Object)("Ignored themes: [" + this.concat((Iterable)IGNORED_THEMES) + "]"));
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk((File)source, (FileWalkDirection)FileWalkDirection.TOP_DOWN);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String identifier;
            File it = (File)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)source)) continue;
            if (it.isDirectory()) {
                System.out.println((Object)("Processing " + it));
                File dir = new File(target, FilesKt.toRelativeString((File)it, (File)source));
                if (dir.mkdir() || !override) continue;
                FilesKt.deleteRecursively((File)dir);
                dir.mkdir();
                continue;
            }
            if (!supportedExtensions.contains(FilesKt.getExtension((File)it)) || INSTANCE.toIdeaName(FilesKt.getNameWithoutExtension((File)it)) == null) continue;
            String name = identifier + "." + FilesKt.getExtension((File)it);
            File file = it.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            String relative = FilesKt.toRelativeString((File)file, (File)source);
            FilesKt.copyTo$default((File)it, (File)new File(new File(target, relative), name), (boolean)true, (int)0, (int)4, null);
        }
    }

    public static /* synthetic */ void renameRecursive$default(ReSharperToIdeaIconRenamer reSharperToIdeaIconRenamer, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        reSharperToIdeaIconRenamer.renameRecursive(file, file2, bl);
    }

    private final String toIdeaName(String fileName) {
        int startIndex = StringsKt.indexOf$default((CharSequence)fileName, (char)'[', (int)0, (boolean)false, (int)6, null);
        int endIndex = StringsKt.indexOf$default((CharSequence)fileName, (char)']', (int)0, (boolean)false, (int)6, null);
        if (startIndex == -1 || endIndex == -1 || startIndex > endIndex) {
            ReSharperToIdeaIconRenamerKt.access$printErr("Proper theme pattern declaration '[SCHEME_NAME]' is missing in the file name '" + fileName + "'");
            return null;
        }
        String string = fileName.substring(0, startIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String name = string;
        String string2 = fileName.substring(startIndex + 1, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String themeName = string2;
        ReSharperThemes reSharperTheme = ReSharperThemes.Companion.tryRead(themeName);
        if (reSharperTheme == null) {
            String themes = this.concat(ArraysKt.asIterable((Object[])ReSharperThemes.values()));
            ReSharperToIdeaIconRenamerKt.access$printErr("'" + themeName + "' is not a valid ReSharper Theme. Try [" + themes + "]");
            return null;
        }
        if (IGNORED_THEMES.contains((Object)reSharperTheme)) {
            return null;
        }
        String scale = StringsKt.drop((String)fileName, (int)(endIndex + 1));
        return name + scale + reSharperTheme.toIdeaLafSuffix();
    }

    private final <T> String concat(Iterable<? extends T> $this$concat) {
        return CollectionsKt.joinToString$default($this$concat, (CharSequence)" ,", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/icons/ReSharperToIdeaIconRenamer$ReSharperThemes;", "", "<init>", "(Ljava/lang/String;I)V", "Color", "Gray", "GrayDark", "toIdeaLafSuffix", "", "Companion", "intellij.rider.rdclient.dotnet"})
    private static final class ReSharperThemes
    extends Enum<ReSharperThemes> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ ReSharperThemes Color;
        public static final /* enum */ ReSharperThemes Gray;
        public static final /* enum */ ReSharperThemes GrayDark;
        private static final /* synthetic */ ReSharperThemes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final String toIdeaLafSuffix() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> "";
                case 2 -> "";
                case 3 -> "_dark";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static ReSharperThemes[] values() {
            return (ReSharperThemes[])$VALUES.clone();
        }

        public static ReSharperThemes valueOf(String value) {
            return Enum.valueOf(ReSharperThemes.class, value);
        }

        @NotNull
        public static EnumEntries<ReSharperThemes> getEntries() {
            return $ENTRIES;
        }

        static {
            Color = new ReSharperThemes();
            Gray = new ReSharperThemes();
            GrayDark = new ReSharperThemes();
            $VALUES = reSharperThemesArray = new ReSharperThemes[]{ReSharperThemes.Color, ReSharperThemes.Gray, ReSharperThemes.GrayDark};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/icons/ReSharperToIdeaIconRenamer$ReSharperThemes$Companion;", "", "<init>", "()V", "tryRead", "Lcom/jetbrains/rider/icons/ReSharperToIdeaIconRenamer$ReSharperThemes;", "value", "", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - bad return control flow
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final ReSharperThemes tryRead(@NotNull String value) {
                ReSharperThemes reSharperThemes;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    String string = value;
                    switch (string.hashCode()) {
                        case 172583065: {
                            if (!string.equals("GrayDark")) {
                                return null;
                            }
                            break block6;
                        }
                        case 2227843: {
                            if (string.equals("Gray")) break;
                            return null;
                        }
                        case 65290051: {
                            if (!string.equals("Color")) return null;
                            reSharperThemes = Color;
                            return reSharperThemes;
                        }
                    }
                    reSharperThemes = Gray;
                    return reSharperThemes;
                }
                reSharperThemes = GrayDark;
                return reSharperThemes;
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReSharperThemes.values().length];
                try {
                    nArray[ReSharperThemes.Color.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReSharperThemes.Gray.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReSharperThemes.GrayDark.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

