/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchPathTree;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootEntry;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootType;
import com.jetbrains.rider.model.RdDeltaType;
import com.jetbrains.rider.vfs.VfsIgnoreChangesRequester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002J \u0010\"\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010(\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "index", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "<init>", "(Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;)V", "getIndex", "()Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "deltas", "Ljava/util/LinkedHashMap;", "", "Lcom/jetbrains/rider/model/RdDeltaType;", "Lkotlin/collections/LinkedHashMap;", "getDeltas", "()Ljava/util/LinkedHashMap;", "fileCreated", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileDeletion", "beforeFileMovement", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "fileMoved", "fileCopied", "Lcom/intellij/openapi/vfs/VirtualFileCopyEvent;", "contentsChanged", "beforePropertyChange", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "propertyChanged", "add", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "type", "addRecursively", "processRecursively", "rootEntry", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootEntry;", "processAllRecursively", "getChildrenFromIndex", "", "addInternal", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsDeltaCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsDeltaCollector.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,231:1\n67#2,4:232\n67#2,4:236\n67#2,4:240\n13#2:259\n1642#3,10:244\n1915#3:254\n1916#3:256\n1652#3:257\n1#4:255\n13#5:258\n*S KotlinDebug\n*F\n+ 1 VfsDeltaCollector.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector\n*L\n83#1:232,4\n87#1:236,4\n92#1:240,4\n21#1:259\n158#1:244,10\n158#1:254\n158#1:256\n158#1:257\n158#1:255\n21#1:258\n*E\n"})
public final class VfsDeltaCollector
implements VirtualFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VfsWatchPathTree index;
    @NotNull
    private final LinkedHashMap<String, RdDeltaType> deltas;
    @NotNull
    private static final Logger logger;

    public VfsDeltaCollector(@NotNull VfsWatchPathTree index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.index = index;
        this.deltas = new LinkedHashMap();
    }

    @NotNull
    public final VfsWatchPathTree getIndex() {
        return this.index;
    }

    @NotNull
    public final LinkedHashMap<String, RdDeltaType> getDeltas() {
        return this.deltas;
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.addRecursively(virtualFile, RdDeltaType.Created);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.addRecursively(virtualFile, RdDeltaType.Deleted);
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.addRecursively(virtualFile, RdDeltaType.Deleted);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.addRecursively(virtualFile, RdDeltaType.Created);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.addRecursively(virtualFile, RdDeltaType.Created);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.add(virtualFile, RdDeltaType.Changed);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            this.add(virtualFile, RdDeltaType.Deleted);
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getRequestor() instanceof VfsIgnoreChangesRequester) {
            return;
        }
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
            if (file.isDirectory()) {
                this.addRecursively(file, RdDeltaType.Created);
            } else {
                this.add(file, RdDeltaType.Created);
            }
        } else {
            this.add(file, RdDeltaType.Changed);
        }
    }

    private final void add(VirtualFile file, RdDeltaType type) {
        if (this.index.findWatchRoot(file) != null || this.index.containsRequestedFile(file)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Process " + file + " with type " + type.name());
            }
            this.addInternal(file, type);
        } else {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Skip " + file + " with type " + type.name() + ", no watch root found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addRecursively(VirtualFile file, RdDeltaType type) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Recursively process " + file);
        }
        long startTimeMs = System.currentTimeMillis();
        try {
            VfsWatchRootEntry vfsWatchRootEntry;
            VfsWatchRootEntry watchRoot = this.index.findWatchRoot(file);
            if (watchRoot != null && watchRoot.getType() == VfsWatchRootType.Recursive) {
                this.addInternal(file, type);
                this.processAllRecursively(file, type);
                return;
            }
            if (watchRoot != null && watchRoot.getType() == VfsWatchRootType.Flat) {
                this.addInternal(file, type);
            }
            if (this.index.getEntry(file) == null) {
                return;
            }
            VfsWatchRootEntry entry2 = vfsWatchRootEntry;
            this.processRecursively(file, type, entry2);
        }
        finally {
            Application application;
            int threshold = 200;
            long totalTimeMs = System.currentTimeMillis() - startTimeMs;
            if (totalTimeMs > (long)threshold && (application = ApplicationManager.getApplication()) != null && application.isUnitTestMode()) {
                logger.warn("Recursively process " + file + " took " + totalTimeMs + " ms, threshold " + threshold + " ms");
            }
        }
    }

    private final void processRecursively(VirtualFile file, RdDeltaType type, VfsWatchRootEntry rootEntry) {
        if (this.index.containsRequestedFile(file)) {
            this.addInternal(file, type);
        }
        for (VirtualFile child : this.getChildrenFromIndex(file)) {
            VfsWatchRootEntry childEntry;
            if (rootEntry.getType() == VfsWatchRootType.Flat) {
                this.addInternal(child, type);
            }
            String string = child.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (this.index.getChildEntry(rootEntry, string) == null) continue;
            if (childEntry.getType() == VfsWatchRootType.Recursive) {
                this.addInternal(child, type);
                this.processAllRecursively(child, type);
                continue;
            }
            if (childEntry.getType() == VfsWatchRootType.Flat) {
                this.addInternal(child, type);
            }
            this.processRecursively(child, type, childEntry);
        }
    }

    private final void processAllRecursively(VirtualFile file, RdDeltaType type) {
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS};
        VirtualFileVisitor.Option[] optionArray2 = optionArray;
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(this, type, optionArray2){
            final /* synthetic */ VfsDeltaCollector this$0;
            final /* synthetic */ RdDeltaType $type;
            {
                this.this$0 = $receiver;
                this.$type = $type;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                VfsDeltaCollector.access$addInternal(this.this$0, child, this.$type);
                return true;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> getChildrenFromIndex(VirtualFile file) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        VfsWatchRootEntry thisEntry;
        VfsWatchRootEntry vfsWatchRootEntry = thisEntry = this.index.getEntry(file);
        Set set = vfsWatchRootEntry != null ? vfsWatchRootEntry.getChildren() : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable iterable = set;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int it = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            String name = this.index.getNameById(it);
            if (name == null) {
                throw new IllegalStateException("Name cannot be null");
            }
            String[] stringArray = new String[]{file.getPath(), name};
            if (file.getFileSystem().findFileByPath(FileUtil.join((String[])stringArray)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List children2 = (List)destination$iv$iv;
        return children2;
    }

    private final void addInternal(VirtualFile file, RdDeltaType type) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        RdDeltaType existingType = this.deltas.get(path);
        if (existingType == RdDeltaType.Created) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    this.deltas.remove(path);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return;
        }
        if (existingType == RdDeltaType.Deleted) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 3: {
                    ((Map)this.deltas).put(path, RdDeltaType.Changed);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return;
        }
        if (existingType == RdDeltaType.Changed) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 3: {
                    break;
                }
                case 1: {
                    ((Map)this.deltas).put(path, RdDeltaType.Deleted);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return;
        }
        ((Map)this.deltas).put(path, type);
    }

    public static final /* synthetic */ void access$addInternal(VfsDeltaCollector $this, VirtualFile file, RdDeltaType type) {
        $this.addInternal(file, type);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VfsDeltaCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsDeltaCollector.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsDeltaCollector$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdDeltaType.values().length];
            try {
                nArray[RdDeltaType.Deleted.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDeltaType.Changed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdDeltaType.Created.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

