/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.intentions.altEnter;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.popups.CanceledPopupMenuMarker;
import com.jetbrains.ide.model.popups.IRdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdEmptyPopupMenuModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModelBase;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.services.popups.FrontendIntentionMenuContributorKt;
import com.jetbrains.rdclient.services.uiContext.UiContextManager;
import com.jetbrains.rider.actions.InterruptibleBackendActionHost;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import com.jetbrains.rider.editors.RiderBackendInteractionHelper;
import com.jetbrains.rider.intentions.altEnter.BulbMenuModelFactory;
import com.jetbrains.rider.intentions.altEnter.BulbMenuModelFactoryPriority;
import com.jetbrains.rider.intentions.altEnter.PopupInvocationRequest;
import com.jetbrains.rider.intentions.altEnter.PopupModel;
import com.jetbrains.rider.intentions.altEnter.ReSharperBulbMenu;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002!\"B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016JR\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010 \u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory;", "T", "Lcom/jetbrains/rider/intentions/altEnter/BulbMenuModelFactory;", "request", "Lcom/jetbrains/rider/intentions/altEnter/PopupInvocationRequest;", "<init>", "(Lcom/jetbrains/rider/intentions/altEnter/PopupInvocationRequest;)V", "priority", "", "getPriority", "()I", "create", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/rider/intentions/altEnter/PopupModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "processProtocolModel", "", "model", "Lcom/jetbrains/ide/model/popups/IRdPopupMenuModel;", "executionLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "waitLifetimeDef", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "executionLifetime", "result", "Lorg/jetbrains/concurrency/AsyncPromise;", "needsBackend", "StateHolder", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperAltEnterMenuModelFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperAltEnterMenuModelFactory.kt\ncom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,183:1\n16#2,2:184\n67#3,4:186\n67#3,4:190\n67#3,4:194\n67#3,4:198\n13#3:203\n13#4:202\n*S KotlinDebug\n*F\n+ 1 ReSharperAltEnterMenuModelFactory.kt\ncom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory\n*L\n66#1:184,2\n128#1:186,4\n133#1:190,4\n140#1:194,4\n82#1:198,4\n56#1:203\n56#1:202\n*E\n"})
public class ReSharperPopupMenuModelFactory<T>
implements BulbMenuModelFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PopupInvocationRequest<T> request;
    @NotNull
    private static final Logger LOG;

    public ReSharperPopupMenuModelFactory(@NotNull PopupInvocationRequest<T> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        this.request = request;
    }

    @Override
    public int getPriority() {
        return BulbMenuModelFactoryPriority.First.getValue();
    }

    @Override
    @NotNull
    public Promise<PopupModel> create(@NotNull Lifetime lifetime, @NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            LastFocusedEditorSuppressor.Companion.getInstance(project).forceReleaseSuppressionForLastFocusedEditor("Release all frontend changes before executing the action");
            ComponentManager $this$getService$iv = (ComponentManager)project;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(StateHolder.class);
            if (object == null) {
                throw new IllegalStateException("Service " + StateHolder.class + " not found in container " + $this$getService$iv);
            }
            StateHolder stateHolder = (StateHolder)((Object)object);
            LifetimeDefinition executionLifetimeDef = RLifetimeKt.defineIntersection((Lifetime)((Lifetime)stateHolder.getExecutionLifetimes().next()), (Lifetime)lifetime);
            Lifetime executionLifetime = executionLifetimeDef.getLifetime();
            LifetimeDefinition waitLifetimeDef = executionLifetime.createNested();
            IdeBackend backend = IdeBackend.Companion.getInstance(project);
            AsyncPromise result2 = new AsyncPromise();
            executionLifetime.onTermination(() -> ReSharperPopupMenuModelFactory.create$lambda$0(result2));
            ClientId clientId = ClientId.Companion.getCurrent();
            UiContextManager.Companion.getInstance(project).getAnyChange().advise(waitLifetimeDef.getLifetime(), arg_0 -> ReSharperPopupMenuModelFactory.create$lambda$1(clientId, executionLifetimeDef, arg_0));
            InterruptibleBackendActionHost.Companion.getInstance(project).showLongExecutionTooltip(waitLifetimeDef.getLifetime(), editor, RdClientDotnetBundle.INSTANCE.message("hint.text.waiting.for.intention.actions", new Object[0]), (Function0<Unit>)((Function0)() -> ReSharperPopupMenuModelFactory.create$lambda$2(executionLifetimeDef)));
            this.request.executePopupInvocation(executionLifetime, backend, editor, LOG, (Function1<IRdPopupMenuModel, Boolean>)((Function1)arg_0 -> ReSharperPopupMenuModelFactory.create$lambda$3(this, project, executionLifetimeDef, waitLifetimeDef, backend, executionLifetime, result2, editor, arg_0)));
            return (Promise)result2;
        }
        catch (Throwable t) {
            LOG.error(t);
            return Promises.rejectedPromise((Throwable)t);
        }
    }

    private final boolean processProtocolModel(IRdPopupMenuModel model2, Project project, LifetimeDefinition executionLifetimeDef, LifetimeDefinition waitLifetimeDef, IdeBackend backend, Lifetime executionLifetime, AsyncPromise<PopupModel> result2, Editor editor) {
        Logger logger;
        ApplicationKt.getApplication().assertIsDispatchThread();
        IRdPopupMenuModel iRdPopupMenuModel = model2;
        if (iRdPopupMenuModel == null) {
            return false;
        }
        IRdPopupMenuModel protocolModel = iRdPopupMenuModel;
        if (protocolModel instanceof CanceledPopupMenuMarker) {
            return false;
        }
        if (!FrontendIntentionMenuContributorKt.isCurrent((IRdPopupMenuModel)protocolModel, (Project)project)) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace("Popup menu model is out-of-date");
            }
            executionLifetimeDef.terminate(true);
            return true;
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)waitLifetimeDef, (boolean)false, (int)1, null);
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received popup menu model: " + IPrintableKt.printToString((Object)protocolModel));
        }
        if (ClientId.Companion.isCurrentlyUnderLocalId() && !RiderBackendInteractionHelper.Companion.getInstance(project).syncFromBackend(executionLifetime)) {
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("The action handshake is executing in the middle of another synchronous activity. Interrupt it.");
            }
            executionLifetimeDef.terminate(true);
            return true;
        }
        try {
            IRdPopupMenuModel iRdPopupMenuModel2 = protocolModel;
            if (iRdPopupMenuModel2 instanceof RdEmptyPopupMenuModel) {
                result2.setResult(null);
                executionLifetimeDef.terminate(true);
            } else if (iRdPopupMenuModel2 instanceof RdPopupMenuModel) {
                BoolPropertyExKt.whenTrue((IViewable)((IViewable)((RdPopupMenuModel)protocolModel).isPrepared()), (Lifetime)executionLifetimeDef.getLifetime(), arg_0 -> ReSharperPopupMenuModelFactory.processProtocolModel$lambda$3(project, editor, backend, executionLifetimeDef, protocolModel, result2, arg_0));
                IRdDispatcher rdDispatcher = IRdDispatcherKt.getAsRdDispatcher((IScheduler)backend.getProtocol().getScheduler());
                IRdDispatcherKt.pumpProtocolQueue((IRdDispatcher)rdDispatcher, (Lifetime)executionLifetimeDef.getLifetime());
            } else {
                executionLifetimeDef.terminate(true);
                LOG.error("Unexpected type: " + protocolModel.getClass().getTypeName());
            }
        }
        catch (Throwable t) {
            executionLifetimeDef.terminate(true);
            throw t;
        }
        return true;
    }

    @Override
    public boolean needsBackend() {
        return true;
    }

    private static final Unit create$lambda$1$1(LifetimeDefinition $executionLifetimeDef) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)$executionLifetimeDef, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$0(AsyncPromise $result) {
        LOG.info("Popup menu execution lifetime was terminated");
        if (Promises.isPending((Promise)((Promise)$result))) {
            $result.cancel();
        }
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$1(ClientId $clientId, LifetimeDefinition $executionLifetimeDef, boolean it) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Terminating popup menu execution lifetime because of UI context changes");
        }
        ClientId.Companion.withExplicitClientId($clientId, () -> ReSharperPopupMenuModelFactory.create$lambda$1$1($executionLifetimeDef));
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$2(LifetimeDefinition $executionLifetimeDef) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)$executionLifetimeDef, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean create$lambda$3(ReSharperPopupMenuModelFactory this$0, Project $project, LifetimeDefinition $executionLifetimeDef, LifetimeDefinition $waitLifetimeDef, IdeBackend $backend, Lifetime $executionLifetime, AsyncPromise $result, Editor $editor, IRdPopupMenuModel model2) {
        return this$0.processProtocolModel(model2, $project, $executionLifetimeDef, $waitLifetimeDef, $backend, $executionLifetime, (AsyncPromise<PopupModel>)$result, $editor);
    }

    private static final Unit processProtocolModel$lambda$3(Project $project, Editor $editor, IdeBackend $backend, LifetimeDefinition $executionLifetimeDef, IRdPopupMenuModel $protocolModel, AsyncPromise $result, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LOG.info("Backend bulb menu model is ready.");
        ReSharperBulbMenu menuModel = new ReSharperBulbMenu($project, $editor, $backend, $executionLifetimeDef, (RdPopupMenuModelBase)$protocolModel, $executionLifetimeDef.getLifetime());
        $result.setResult((Object)menuModel);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReSharperPopupMenuModelFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/ReSharperPopupMenuModelFactory$StateHolder;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "executionLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getExecutionLifetimes", "()Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "intellij.rider.rdclient.dotnet"})
    public static final class StateHolder
    extends LifetimedService {
        @NotNull
        private final SequentialLifetimes executionLifetimes = new SequentialLifetimes(this.getServiceLifetime());

        @NotNull
        public final SequentialLifetimes getExecutionLifetimes() {
            return this.executionLifetimes;
        }
    }
}

