/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.launchers;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.path.EelPath;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.PathInfo;
import com.jetbrains.rider.environment.RiderEnvironment;
import com.jetbrains.rider.launchers.extensions.PathInfoExtensionsKt;
import com.jetbrains.rider.launchers.inRiderEnv.CanRunInRiderEnvironment;
import com.jetbrains.rider.launchers.inRiderEnv.InRiderEnvironmentAssemblyLauncherBuilder;
import com.jetbrains.rider.launchers.remote.CanRunRemotely;
import com.jetbrains.rider.launchers.remote.RemotelyAssemblyLauncherBuilder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0002J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0015\"\u00020\u0004H\u0096@\u00a2\u0006\u0002\u0010\u0016J1\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0015\"\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/launchers/DebuggerAssemblyLauncher;", "Lcom/jetbrains/rider/launchers/inRiderEnv/CanRunInRiderEnvironment;", "Lcom/jetbrains/rider/launchers/remote/CanRunRemotely;", "assemblyName", "", "suffix32bit", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getAssemblyName", "()Ljava/lang/String;", "getRuntimeConfig", "Lcom/jetbrains/rider/PathInfo;", "binDirectory", "relativePathToExecutable", "prepareForEnvironment", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "environment", "Lcom/jetbrains/rider/environment/RiderEnvironment;", "cpuKind", "Lcom/jetbrains/rider/CPUKind;", "params", "", "(Lcom/jetbrains/rider/environment/RiderEnvironment;Lcom/jetbrains/rider/CPUKind;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareForRemoteExecution", "(Lcom/jetbrains/rider/PathInfo;Lcom/jetbrains/rider/CPUKind;[Ljava/lang/String;)Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "getConfiguration", "Lkotlin/Pair;", "", "getRelativePathToExecutableFromBinDir", "intellij.rider.rdclient.dotnet"})
public final class DebuggerAssemblyLauncher
implements CanRunInRiderEnvironment,
CanRunRemotely {
    @NotNull
    private final String assemblyName;
    @NotNull
    private final String suffix32bit;

    public DebuggerAssemblyLauncher(@NotNull String assemblyName, @NotNull String suffix32bit) {
        Intrinsics.checkNotNullParameter((Object)assemblyName, (String)"assemblyName");
        Intrinsics.checkNotNullParameter((Object)suffix32bit, (String)"suffix32bit");
        this.assemblyName = assemblyName;
        this.suffix32bit = suffix32bit;
    }

    public /* synthetic */ DebuggerAssemblyLauncher(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "32";
        }
        this(string, string2);
    }

    @NotNull
    public final String getAssemblyName() {
        return this.assemblyName;
    }

    private final PathInfo getRuntimeConfig(PathInfo binDirectory, String relativePathToExecutable) {
        char[] cArray = new char[]{binDirectory.getCpuKind().getOsKind().getPlatform().fileSeparator};
        String executableName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)relativePathToExecutable, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        String[] stringArray = StringsKt.endsWith((String)executableName, (String)".dll", (boolean)true) || StringsKt.endsWith((String)executableName, (String)".exe", (boolean)true) ? FileUtilRt.getNameWithoutExtension((String)executableName) : executableName;
        Intrinsics.checkNotNull((Object)stringArray);
        String[] executableWithoutExtensions = stringArray;
        stringArray = new String[]{(String)executableWithoutExtensions + ".runtimeconfig.json"};
        return binDirectory.appendPath(stringArray);
    }

    @Override
    @Nullable
    public Object prepareForEnvironment(@NotNull RiderEnvironment environment, @NotNull CPUKind cpuKind, @NotNull String[] params, @NotNull Continuation<? super BundledAssemblyLauncherInfo> $completion) {
        InRiderEnvironmentAssemblyLauncherBuilder.PathToExecutableStep pathToExecutableStep;
        InRiderEnvironmentAssemblyLauncherBuilder.PlatformStep builder = InRiderEnvironmentAssemblyLauncherBuilder.Companion.create(environment);
        EelDescriptor descriptor = environment.getDescriptor();
        Pair<Boolean, Boolean> pair = this.getConfiguration(cpuKind);
        boolean runOnNetCore = (Boolean)pair.component1();
        boolean useNativeLauncher = (Boolean)pair.component2();
        Path binDirectory = environment.getBundledBinDirectory();
        PathInfo binDirectoryAsPathInfo = PathInfoExtensionsKt.toPathInfo(binDirectory, cpuKind);
        String relativePathToExecutable = this.getRelativePathToExecutableFromBinDir(cpuKind);
        Path absolutePathToExecutable = binDirectory.resolve(relativePathToExecutable).toAbsolutePath();
        if (runOnNetCore) {
            EelPath runtimeConfig = PathInfoExtensionsKt.toEelPath(this.getRuntimeConfig(binDirectoryAsPathInfo, relativePathToExecutable), descriptor);
            InRiderEnvironmentAssemblyLauncherBuilder.RunOnNetCoreStep builder2 = builder.runOnNetCore(runtimeConfig);
            pathToExecutableStep = useNativeLauncher ? builder2.withNativeLauncher() : builder2.withBundledDotNet();
        } else {
            pathToExecutableStep = builder.runOnDotNetFramework();
        }
        InRiderEnvironmentAssemblyLauncherBuilder.PathToExecutableStep buildable = pathToExecutableStep;
        Intrinsics.checkNotNull((Object)absolutePathToExecutable);
        return InRiderEnvironmentAssemblyLauncherBuilder.PathToExecutableStep.withPathToExecutable$default(buildable, absolutePathToExecutable, null, 2, null).withAdditionalArguments(Arrays.copyOf(params, params.length)).build($completion);
    }

    @Override
    @NotNull
    public BundledAssemblyLauncherInfo prepareForRemoteExecution(@NotNull PathInfo binDirectory, @NotNull CPUKind cpuKind, String ... params) {
        RemotelyAssemblyLauncherBuilder.PathToExecutableStep pathToExecutableStep;
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)cpuKind), (String)"cpuKind");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        RemotelyAssemblyLauncherBuilder.PlatformStep builder = RemotelyAssemblyLauncherBuilder.Companion.create(binDirectory);
        Pair<Boolean, Boolean> pair = this.getConfiguration(cpuKind);
        boolean runOnNetCore = (Boolean)pair.component1();
        boolean useNativeLauncher = (Boolean)pair.component2();
        String relativePathToExecutable = this.getRelativePathToExecutableFromBinDir(binDirectory.getCpuKind());
        if (runOnNetCore) {
            RemotelyAssemblyLauncherBuilder.RunOnNetCoreStep builder2 = builder.runOnNetCore(this.getRuntimeConfig(binDirectory, relativePathToExecutable));
            if (useNativeLauncher) {
                pathToExecutableStep = builder2.withNativeLauncher();
            } else {
                String dotnetDir = binDirectory.getPath() + binDirectory.getCpuKind().getOsKind().getPlatform().fileSeparator + binDirectory.getCpuKind().getDotnetExecutable();
                pathToExecutableStep = builder2.withDotNet(dotnetDir);
            }
        } else {
            pathToExecutableStep = builder.runOnDotNetFramework();
        }
        RemotelyAssemblyLauncherBuilder.PathToExecutableStep buildable = pathToExecutableStep;
        return RemotelyAssemblyLauncherBuilder.PathToExecutableStep.withRelativePathToExecutableFromBinDir$default(buildable, relativePathToExecutable, null, 2, null).withAdditionalArguments(Arrays.copyOf(params, params.length)).build();
    }

    private final Pair<Boolean, Boolean> getConfiguration(CPUKind cpuKind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[cpuKind.ordinal()]) {
            case 1 -> TuplesKt.to((Object)false, (Object)true);
            case 2, 3 -> TuplesKt.to((Object)true, (Object)true);
            case 4, 5, 6, 7 -> TuplesKt.to((Object)true, (Object)true);
            case 8, 9, 10, 11, 12 -> TuplesKt.to((Object)true, (Object)false);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String getRelativePathToExecutableFromBinDir(@NotNull CPUKind cpuKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)cpuKind), (String)"cpuKind");
        return switch (WhenMappings.$EnumSwitchMapping$0[cpuKind.ordinal()]) {
            case 1 -> this.assemblyName + this.suffix32bit + ".exe";
            case 2, 3 -> cpuKind.getDirectoryName() + cpuKind.getOsKind().getPlatform().fileSeparator + this.assemblyName + ".exe";
            case 4, 5, 6, 7 -> cpuKind.getDirectoryName() + cpuKind.getOsKind().getPlatform().fileSeparator + this.assemblyName;
            case 8, 9, 10, 11, 12 -> this.assemblyName + ".exe";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CPUKind.values().length];
            try {
                nArray[CPUKind.Win32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Win64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.WinArm64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Linux64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxArm64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.MacOs64.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.MacOsArm.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Linux32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxArm32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMuslArm32.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMuslArm64.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMusl64.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

