/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.launchers;

import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.environment.RiderEnvironment;
import com.jetbrains.rider.launchers.inRiderEnv.CanRunInRiderEnvironment;
import com.jetbrains.rider.launchers.inRiderEnv.InRiderEnvironmentAssemblyLauncherBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/launchers/DefaultBundledAssemblyLauncher;", "Lcom/jetbrains/rider/launchers/inRiderEnv/CanRunInRiderEnvironment;", "assemblyPath", "Ljava/nio/file/Path;", "runOnNetCore", "", "useNativeLauncher", "<init>", "(Ljava/nio/file/Path;ZZ)V", "prepareForEnvironment", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "environment", "Lcom/jetbrains/rider/environment/RiderEnvironment;", "cpuKind", "Lcom/jetbrains/rider/CPUKind;", "params", "", "", "(Lcom/jetbrains/rider/environment/RiderEnvironment;Lcom/jetbrains/rider/CPUKind;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRuntimeConfig", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class DefaultBundledAssemblyLauncher
implements CanRunInRiderEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path assemblyPath;
    private final boolean runOnNetCore;
    private final boolean useNativeLauncher;

    public DefaultBundledAssemblyLauncher(@NotNull Path assemblyPath, boolean runOnNetCore, boolean useNativeLauncher) {
        Intrinsics.checkNotNullParameter((Object)assemblyPath, (String)"assemblyPath");
        this.assemblyPath = assemblyPath;
        this.runOnNetCore = runOnNetCore;
        this.useNativeLauncher = useNativeLauncher;
    }

    @Override
    @Nullable
    public Object prepareForEnvironment(@NotNull RiderEnvironment environment, @NotNull CPUKind cpuKind, @NotNull String[] params, @NotNull Continuation<? super BundledAssemblyLauncherInfo> $completion) {
        InRiderEnvironmentAssemblyLauncherBuilder.PathToExecutableStep pathToExecutableStep;
        InRiderEnvironmentAssemblyLauncherBuilder.PlatformStep builder = InRiderEnvironmentAssemblyLauncherBuilder.Companion.create(environment);
        if (this.runOnNetCore) {
            InRiderEnvironmentAssemblyLauncherBuilder.RunOnNetCoreStep builder2 = builder.runOnNetCore(this.getRuntimeConfig(environment.getDescriptor()));
            pathToExecutableStep = this.useNativeLauncher ? builder2.withNativeLauncher() : builder2.withBundledDotNet();
        } else {
            pathToExecutableStep = builder.runOnDotNetFramework();
        }
        InRiderEnvironmentAssemblyLauncherBuilder.PathToExecutableStep buildable = pathToExecutableStep;
        return InRiderEnvironmentAssemblyLauncherBuilder.PathToExecutableStep.withPathToExecutable$default(buildable, this.assemblyPath, null, 2, null).withAdditionalArguments(Arrays.copyOf(params, params.length)).build($completion);
    }

    private final Path getRuntimeConfig(EelDescriptor descriptor) {
        Path path = this.assemblyPath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        return Companion.getRuntimeConfig(this.assemblyPath, path, false, descriptor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/launchers/DefaultBundledAssemblyLauncher$Companion;", "", "<init>", "()V", "getRuntimeConfig", "Ljava/nio/file/Path;", "assemblyFile", "runtimeConfigDirectory", "useManagedLauncher", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path getRuntimeConfig(@NotNull Path assemblyFile, @NotNull Path runtimeConfigDirectory, boolean useManagedLauncher, @NotNull EelDescriptor descriptor) {
            String name;
            Intrinsics.checkNotNullParameter((Object)assemblyFile, (String)"assemblyFile");
            Intrinsics.checkNotNullParameter((Object)runtimeConfigDirectory, (String)"runtimeConfigDirectory");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            String runtimeConfigJson = ".runtimeconfig.json";
            String string = name = StringsKt.endsWith$default((String)PathsKt.getName((Path)assemblyFile), (String)".exe", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)PathsKt.getName((Path)assemblyFile), (String)".dll", (boolean)false, (int)2, null) ? PathsKt.getNameWithoutExtension((Path)assemblyFile) : PathsKt.getName((Path)assemblyFile);
            String middle = EelPlatformKt.isWindows((EelOsFamily)descriptor.getOsFamily()) ? ".windows" + (useManagedLauncher ? ".launcher" : "") : ".netcore";
            Path configFile = runtimeConfigDirectory.resolve(name + middle + runtimeConfigJson);
            Intrinsics.checkNotNull((Object)configFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.exists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? configFile : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

