/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.launchers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.system.CpuArch;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.environment.RiderEnvironment;
import com.jetbrains.rider.environment.RiderEnvironmentExtKt;
import com.jetbrains.rider.environment.local.NetCoreUtil;
import com.jetbrains.rider.environment.local.RiderLocalEnvironment;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import com.jetbrains.rider.launchers.DefaultBundledAssemblyLauncher;
import com.jetbrains.rider.launchers.inRiderEnv.CanRunInRiderEnvironment;
import com.jetbrains.rider.launchers.inRiderEnv.InRiderEnvironmentAssemblyLauncherBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0013H\u0002J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/launchers/RiderBackendLauncher;", "Lcom/jetbrains/rider/launchers/inRiderEnv/CanRunInRiderEnvironment;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "collectFullContainerStatistics", "", "prepareForEnvironment", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "environment", "Lcom/jetbrains/rider/environment/RiderEnvironment;", "cpuKind", "Lcom/jetbrains/rider/CPUKind;", "params", "", "", "(Lcom/jetbrains/rider/environment/RiderEnvironment;Lcom/jetbrains/rider/CPUKind;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCustomLauncherArguments", "", "getEnvironmentVariables", "", "isNetCore", "getRuntimeConfig", "Ljava/nio/file/Path;", "usingNativeLauncher", "throwIfNotLocal", "", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderBackendLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderBackendLauncher.kt\ncom/jetbrains/rider/launchers/RiderBackendLauncher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,165:1\n23#2:166\n*S KotlinDebug\n*F\n+ 1 RiderBackendLauncher.kt\ncom/jetbrains/rider/launchers/RiderBackendLauncher\n*L\n19#1:166\n*E\n"})
public final class RiderBackendLauncher
implements CanRunInRiderEnvironment {
    @NotNull
    public static final RiderBackendLauncher INSTANCE;
    @NotNull
    private static final Logger logger;
    private static final boolean collectFullContainerStatistics;

    private RiderBackendLauncher() {
    }

    @Override
    @Nullable
    public Object prepareForEnvironment(@NotNull RiderEnvironment environment, @NotNull CPUKind cpuKind, @NotNull String[] params, @NotNull Continuation<? super BundledAssemblyLauncherInfo> $completion) {
        InRiderEnvironmentAssemblyLauncherBuilder.PathToExecutableStep pathToExecutableStep;
        this.throwIfNotLocal(environment);
        InRiderEnvironmentAssemblyLauncherBuilder.PlatformStep builder = InRiderEnvironmentAssemblyLauncherBuilder.Companion.create(environment);
        boolean runningOnNetCore = NetCoreUtil.INSTANCE.runOnNetCore();
        boolean usingNativeLauncher = NetCoreUtil.INSTANCE.useNativeLauncher();
        if (runningOnNetCore) {
            InRiderEnvironmentAssemblyLauncherBuilder.RunOnNetCoreStep builder2 = builder.runOnNetCore(this.getRuntimeConfig(usingNativeLauncher));
            pathToExecutableStep = usingNativeLauncher ? builder2.withNativeLauncher() : builder2.withBundledDotNet();
        } else {
            pathToExecutableStep = builder.runOnDotNetFramework();
        }
        InRiderEnvironmentAssemblyLauncherBuilder.PathToExecutableStep buildable = pathToExecutableStep;
        Path path = RiderLocalEnvironment.INSTANCE.getRiderBackendExecutable().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return buildable.withPathToExecutable(path, this.getCustomLauncherArguments()).withEnvironment(this.getEnvironmentVariables(runningOnNetCore)).withAdditionalArguments(Arrays.copyOf(params, params.length)).build($completion);
    }

    private final List<String> getCustomLauncherArguments() {
        if (!NetCoreUtil.INSTANCE.useManagedLauncher()) {
            return null;
        }
        List arguments = new ArrayList();
        String assemblyAbsolutePath = RiderLocalEnvironment.INSTANCE.getRiderBackendExecutable().getAbsolutePath();
        String assemblyParent = RiderLocalEnvironment.INSTANCE.getRiderBackendExecutable().getParentFile().getAbsolutePath();
        String string = RiderLocalEnvironment.getBundledFile$default(RiderLocalEnvironment.INSTANCE, "JetLauncherILc.exe", false, null, false, 14, null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        arguments.add(string);
        arguments.add("/Launcher::NoSplash");
        arguments.add("/Launcher::Mode:InvokeMethod");
        arguments.add("/Launcher::Target:Assembly");
        arguments.add("/Launcher::AssemblyFile:" + assemblyAbsolutePath);
        arguments.add("/Launcher::ClassName:JetBrains.Rider.Backend.Product.RiderBackendProgram");
        arguments.add("/Launcher::MethodName:Main");
        arguments.add("/Launcher::NetCoreAdditionalProbingPaths:" + assemblyParent + ";" + assemblyParent + "\\" + (CpuArch.isArm64() ? "arm64" : "x64"));
        return arguments;
    }

    private final Map<String, String> getEnvironmentVariables(boolean isNetCore) {
        String dotnetTieredPgo;
        String string;
        String backendSchedulerImpl;
        String string2;
        String backendGracefulShutdownTimeout;
        String runtimeEventTracing;
        Map envVars = new LinkedHashMap();
        if (collectFullContainerStatistics) {
            envVars.put("COLLECT_FULL_CONTAINER_STATISTICS", "1");
        }
        if (!isNetCore) {
            if (RiderLocalEnvironment.INSTANCE.isRiderForDebug() && RiderLocalEnvironment.INSTANCE.isNotUnderTeamCity() && !PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode()) {
                envVars.put("COMPLUS_FORCEENC", "1");
                envVars.put("COMPLUS_ZapDisable", "1");
            }
            return envVars;
        }
        envVars.put("DOTNET_ROLL_FORWARD", null);
        String enabled = System.getProperty("rider.backend.JET_STARTUP_MEASURER_ENABLE_TIMELINE_API");
        if (enabled != null) {
            envVars.put("JET_STARTUP_MEASURER_ENABLE_TIMELINE_API", enabled);
        }
        if ((runtimeEventTracing = System.getProperty("rider.backend.JET_BACKEND_RUNTIME_EVENTS")) != null) {
            envVars.put("JET_BACKEND_RUNTIME_EVENTS", runtimeEventTracing);
        }
        if ((backendGracefulShutdownTimeout = System.getProperty("rider.backend.JET_GRACEFUL_SHUTDOWN_PERIOD_MS")) != null) {
            envVars.put("JET_GRACEFUL_SHUTDOWN_PERIOD_MS", backendGracefulShutdownTimeout);
        }
        if ((string2 = (backendSchedulerImpl = System.getProperty("rider.backend.shell.locks.use.task.scheduler.implementation"))) == null) {
            string2 = "";
        }
        if (((CharSequence)string2).length() > 0) {
            envVars.put("ShellLocks.Task.Scheduler.Implementation", backendSchedulerImpl);
        }
        if (NetCoreUtil.INSTANCE.getUseServerGC()) {
            int heapCount;
            envVars.put("DOTNET_gcServer", "1");
            if (NetCoreUtil.INSTANCE.getServerGCNoAffinitize()) {
                envVars.put("DOTNET_GCNoAffinitize", "1");
            }
            if ((heapCount = NetCoreUtil.INSTANCE.getServerGCHeapCount()) == -1) {
                logger.info("Enable DOTNET_GCDynamicAdaptationMode");
                envVars.put("DOTNET_GCDynamicAdaptationMode", "1");
            } else {
                logger.info("SET DOTNET_GCHeapCount = " + heapCount);
                envVars.put("DOTNET_GCHeapCount", String.valueOf(heapCount));
            }
            int conserveMemory = NetCoreUtil.INSTANCE.getConserveMemory();
            boolean bl = 1 <= conserveMemory ? conserveMemory < 10 : false;
            if (bl) {
                envVars.put("DOTNET_GCConserveMemory", String.valueOf(conserveMemory));
            }
        }
        if ((string = (dotnetTieredPgo = System.getProperty("rider.backend.DOTNET_TieredPGO"))) == null) {
            string = "0";
        }
        envVars.put("DOTNET_TieredPGO", string);
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
        for (Map.Entry property : ((Map)properties).entrySet()) {
            String propertyKey = property.getKey().toString();
            if (!StringsKt.startsWith$default((String)propertyKey, (String)"rider.backend.DOTNET_", (boolean)false, (int)2, null)) continue;
            String envVarKey = StringsKt.removePrefix((String)propertyKey, (CharSequence)"rider.backend.");
            Object v = property.getValue();
            String envVarValue = v != null ? v.toString() : null;
            if (envVarValue == null) continue;
            envVars.put(envVarKey, envVarValue);
        }
        return envVars;
    }

    private final Path getRuntimeConfig(boolean usingNativeLauncher) {
        Path assemblyFile = RiderLocalEnvironment.INSTANCE.getRiderBackendExecutable().toPath();
        Path runtimeConfigDirectory = usingNativeLauncher ? assemblyFile.getParent().getParent() : assemblyFile.getParent();
        Intrinsics.checkNotNull((Object)assemblyFile);
        Intrinsics.checkNotNull((Object)runtimeConfigDirectory);
        return DefaultBundledAssemblyLauncher.Companion.getRuntimeConfig(assemblyFile, runtimeConfigDirectory, NetCoreUtil.INSTANCE.useManagedLauncher(), RiderLocalEnvironment.INSTANCE.getDescriptor());
    }

    private final void throwIfNotLocal(RiderEnvironment environment) {
        if (!RiderEnvironmentExtKt.isLocal(environment)) {
            throw new IllegalStateException("Rider backend can be launched only in a local environment");
        }
    }

    static {
        RiderBackendLauncher $this$thisLogger$iv = INSTANCE = new RiderBackendLauncher();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RiderBackendLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderBackendLauncher.logger = logger;
        collectFullContainerStatistics = Intrinsics.areEqual((Object)System.getProperty("rider.collect.full.container.statistics"), (Object)"true");
    }
}

