/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.launchers.base;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.environment.local.NetCoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 A2\u00020\u0001:\u0002ABB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010,\u001a\u00020-2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0004J\b\u0010.\u001a\u00020-H\u0004J\b\u0010/\u001a\u00020-H\u0004J\u0010\u00100\u001a\u00020-2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u001e\u00101\u001a\u00020-2\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0017H\u0004J!\u00103\u001a\u00020-2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0&\"\u00020\u000eH\u0004\u00a2\u0006\u0002\u0010*J \u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\u000e2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010 H\u0004J\u001a\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0 08H\u0004J7\u00109\u001a\b\u0012\u0004\u0012\u00020\u000e0:2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=2\u0012\b\u0002\u0010%\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010&H\u0002\u00a2\u0006\u0002\u0010>J\u0018\u0010?\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=H\u0002J\b\u0010@\u001a\u00020=H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R*\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R\"\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R&\u0010%\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010&X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006C"}, d2={"Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder;", "", "<init>", "()V", "runOnNetCore", "", "getRunOnNetCore", "()Z", "setRunOnNetCore", "(Z)V", "useNativeLauncher", "getUseNativeLauncher", "setUseNativeLauncher", "dotnetCliPath", "", "getDotnetCliPath", "()Ljava/lang/String;", "setDotnetCliPath", "(Ljava/lang/String;)V", "runtimeConfig", "getRuntimeConfig", "setRuntimeConfig", "environmentVariables", "", "getEnvironmentVariables", "()Ljava/util/Map;", "setEnvironmentVariables", "(Ljava/util/Map;)V", "pathToExecutable", "getPathToExecutable", "setPathToExecutable", "executableArguments", "", "getExecutableArguments", "()Ljava/util/List;", "setExecutableArguments", "(Ljava/util/List;)V", "additionalArguments", "", "getAdditionalArguments", "()[Ljava/lang/String;", "setAdditionalArguments", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "runningOnNetCore", "", "runningOnNetFramework", "usingNativeLauncher", "usingDotNet", "usingEnvironment", "map", "usingAdditionalArguments", "arguments", "usingPathToExecutable", "path", "buildExecutablePathAndArguments", "Lkotlin/Pair;", "buildArguments", "", "assemblyAbsolutePath", "platform", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform;", "(Ljava/lang/String;Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform;[Ljava/lang/String;)Ljava/util/List;", "buildExecutablePath", "getPlatform", "Companion", "Platform", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nAssemblyLauncherBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssemblyLauncherBuilder.kt\ncom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n67#2,4:120\n23#2:125\n1#3:124\n*S KotlinDebug\n*F\n+ 1 AssemblyLauncherBuilder.kt\ncom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder\n*L\n57#1:120,4\n18#1:125\n*E\n"})
public abstract class AssemblyLauncherBuilder {
    @NotNull
    public static final Companion Companion;
    private boolean runOnNetCore;
    private boolean useNativeLauncher;
    @Nullable
    private String dotnetCliPath;
    @Nullable
    private String runtimeConfig;
    @Nullable
    private Map<String, String> environmentVariables;
    @Nullable
    private String pathToExecutable;
    @Nullable
    private List<String> executableArguments;
    @Nullable
    private String[] additionalArguments;
    @NotNull
    private static final Logger logger;

    protected final boolean getRunOnNetCore() {
        return this.runOnNetCore;
    }

    protected final void setRunOnNetCore(boolean bl) {
        this.runOnNetCore = bl;
    }

    protected final boolean getUseNativeLauncher() {
        return this.useNativeLauncher;
    }

    protected final void setUseNativeLauncher(boolean bl) {
        this.useNativeLauncher = bl;
    }

    @Nullable
    protected final String getDotnetCliPath() {
        return this.dotnetCliPath;
    }

    protected final void setDotnetCliPath(@Nullable String string) {
        this.dotnetCliPath = string;
    }

    @Nullable
    protected final String getRuntimeConfig() {
        return this.runtimeConfig;
    }

    protected final void setRuntimeConfig(@Nullable String string) {
        this.runtimeConfig = string;
    }

    @Nullable
    protected final Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    protected final void setEnvironmentVariables(@Nullable Map<String, String> map) {
        this.environmentVariables = map;
    }

    @Nullable
    protected final String getPathToExecutable() {
        return this.pathToExecutable;
    }

    protected final void setPathToExecutable(@Nullable String string) {
        this.pathToExecutable = string;
    }

    @Nullable
    protected final List<String> getExecutableArguments() {
        return this.executableArguments;
    }

    protected final void setExecutableArguments(@Nullable List<String> list) {
        this.executableArguments = list;
    }

    @Nullable
    protected final String[] getAdditionalArguments() {
        return this.additionalArguments;
    }

    protected final void setAdditionalArguments(@Nullable String[] stringArray) {
        this.additionalArguments = stringArray;
    }

    protected final void runningOnNetCore(@Nullable String runtimeConfig) {
        this.runOnNetCore = true;
        this.runtimeConfig = runtimeConfig;
    }

    protected final void runningOnNetFramework() {
        this.runOnNetCore = false;
    }

    protected final void usingNativeLauncher() {
        this.useNativeLauncher = true;
    }

    protected final void usingDotNet(@NotNull String dotnetCliPath) {
        Intrinsics.checkNotNullParameter((Object)dotnetCliPath, (String)"dotnetCliPath");
        this.useNativeLauncher = false;
        this.dotnetCliPath = dotnetCliPath;
    }

    protected final void usingEnvironment(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.environmentVariables = map;
    }

    protected final void usingAdditionalArguments(String ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.additionalArguments = arguments;
    }

    protected final void usingPathToExecutable(@NotNull String path, @Nullable List<String> executableArguments) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.pathToExecutable = path;
        this.executableArguments = executableArguments;
    }

    @NotNull
    protected final Pair<String, List<String>> buildExecutablePathAndArguments() {
        Platform platform = this.getPlatform();
        String string = this.pathToExecutable;
        Intrinsics.checkNotNull((Object)string);
        String executablePath = this.buildExecutablePath(string, platform);
        String string2 = this.pathToExecutable;
        Intrinsics.checkNotNull((Object)string2);
        List<String> arguments = this.buildArguments(string2, platform, this.additionalArguments);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Executable chosen: \"" + executablePath + "\". Arguments: " + CollectionsKt.joinToString$default((Iterable)arguments, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null) + ".");
        }
        return TuplesKt.to((Object)executablePath, arguments);
    }

    private final List<String> buildArguments(String assemblyAbsolutePath, Platform platform, String[] additionalArguments) {
        List arguments;
        block9: {
            arguments = new ArrayList();
            Platform platform2 = platform;
            if (platform2 instanceof Platform.DotNetCore) {
                String runtimeConfig;
                if (platform instanceof Platform.DotNetCore.WithDotNet) {
                    arguments.add("exec");
                }
                if ((runtimeConfig = ((Platform.DotNetCore)platform).getRuntimeConfig()) != null) {
                    arguments.add("--runtimeconfig");
                    arguments.add(runtimeConfig);
                }
                if (((Platform.DotNetCore)platform).getExecutableArguments() != null) {
                    arguments.addAll((Collection)((Platform.DotNetCore)platform).getExecutableArguments());
                } else if (platform instanceof Platform.DotNetCore.WithDotNet) {
                    String string = NetCoreUtil.INSTANCE.mapToNativeImage(assemblyAbsolutePath);
                    if (string == null) {
                        string = assemblyAbsolutePath;
                    }
                    arguments.add(string);
                }
            } else if (!(platform2 instanceof Platform.DotNetFramework)) {
                throw new NoWhenBranchMatchedException();
            }
            if (additionalArguments == null) break block9;
            Object[] it = additionalArguments;
            boolean bl = false;
            CollectionsKt.addAll((Collection)arguments, (Object[])it);
        }
        return arguments;
    }

    static /* synthetic */ List buildArguments$default(AssemblyLauncherBuilder assemblyLauncherBuilder, String string, Platform platform, String[] stringArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildArguments");
        }
        if ((n & 4) != 0) {
            stringArray = null;
        }
        return assemblyLauncherBuilder.buildArguments(string, platform, stringArray);
    }

    private final String buildExecutablePath(String assemblyAbsolutePath, Platform platform) {
        String string;
        Platform platform2 = platform;
        if (platform2 instanceof Platform.DotNetFramework) {
            string = assemblyAbsolutePath;
        } else if (platform2 instanceof Platform.DotNetCore.WithNativeLauncher) {
            string = assemblyAbsolutePath;
        } else if (platform2 instanceof Platform.DotNetCore.WithDotNet) {
            string = ((Platform.DotNetCore.WithDotNet)platform).getDotnetCliPath();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Platform getPlatform() {
        if (this.runOnNetCore) {
            Platform platform;
            if (this.useNativeLauncher) {
                platform = new Platform.DotNetCore.WithNativeLauncher(this.runtimeConfig, this.executableArguments);
            } else {
                String string = this.dotnetCliPath;
                Intrinsics.checkNotNull((Object)string);
                platform = new Platform.DotNetCore.WithDotNet(this.runtimeConfig, string, this.executableArguments);
            }
            return platform;
        }
        return new Platform.DotNetFramework();
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AssemblyLauncherBuilder.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform;", "", "<init>", "()V", "DotNetCore", "DotNetFramework", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetCore;", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetFramework;", "intellij.rider.rdclient.dotnet"})
    protected static abstract sealed class Platform {
        private Platform() {
        }

        public /* synthetic */ Platform(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\f\rB#\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetCore;", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform;", "runtimeConfig", "", "executableArguments", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getRuntimeConfig", "()Ljava/lang/String;", "getExecutableArguments", "()Ljava/util/List;", "WithDotNet", "WithNativeLauncher", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetCore$WithDotNet;", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetCore$WithNativeLauncher;", "intellij.rider.rdclient.dotnet"})
        public static abstract sealed class DotNetCore
        extends Platform {
            @Nullable
            private final String runtimeConfig;
            @Nullable
            private final List<String> executableArguments;

            private DotNetCore(String runtimeConfig, List<String> executableArguments) {
                super(null);
                this.runtimeConfig = runtimeConfig;
                this.executableArguments = executableArguments;
            }

            @Nullable
            public final String getRuntimeConfig() {
                return this.runtimeConfig;
            }

            @Nullable
            public final List<String> getExecutableArguments() {
                return this.executableArguments;
            }

            public /* synthetic */ DotNetCore(String runtimeConfig, List executableArguments, DefaultConstructorMarker $constructor_marker) {
                this(runtimeConfig, executableArguments);
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetCore$WithDotNet;", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetCore;", "runtimeConfig", "", "dotnetCliPath", "executableArguments", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getDotnetCliPath", "()Ljava/lang/String;", "intellij.rider.rdclient.dotnet"})
            public static final class WithDotNet
            extends DotNetCore {
                @NotNull
                private final String dotnetCliPath;

                public WithDotNet(@Nullable String runtimeConfig, @NotNull String dotnetCliPath, @Nullable List<String> executableArguments) {
                    Intrinsics.checkNotNullParameter((Object)dotnetCliPath, (String)"dotnetCliPath");
                    super(runtimeConfig, executableArguments, null);
                    this.dotnetCliPath = dotnetCliPath;
                }

                @NotNull
                public final String getDotnetCliPath() {
                    return this.dotnetCliPath;
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetCore$WithNativeLauncher;", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetCore;", "runtimeConfig", "", "executableArguments", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "intellij.rider.rdclient.dotnet"})
            public static final class WithNativeLauncher
            extends DotNetCore {
                public WithNativeLauncher(@Nullable String runtimeConfig, @Nullable List<String> executableArguments) {
                    super(runtimeConfig, executableArguments, null);
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform$DotNetFramework;", "Lcom/jetbrains/rider/launchers/base/AssemblyLauncherBuilder$Platform;", "<init>", "()V", "intellij.rider.rdclient.dotnet"})
        public static final class DotNetFramework
        extends Platform {
            public DotNetFramework() {
                super(null);
            }
        }
    }
}

