/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.launchers.inRiderEnv;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.launchers.inRiderEnv.InRiderEnvironmentBundledAssemblyLauncherKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/launchers/inRiderEnv/InRiderEnvironmentBundledAssemblyLauncher;", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "executablePath", "Lcom/intellij/platform/eel/path/EelPath;", "arguments", "", "", "envVars", "", "<init>", "(Lcom/intellij/platform/eel/path/EelPath;Ljava/util/List;Ljava/util/Map;)V", "toProcessBuilder", "Ljava/lang/ProcessBuilder;", "params", "", "([Ljava/lang/String;)Ljava/lang/ProcessBuilder;", "fillCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "cmd", "(Lcom/intellij/execution/configurations/GeneralCommandLine;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nInRiderEnvironmentBundledAssemblyLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InRiderEnvironmentBundledAssemblyLauncher.kt\ncom/jetbrains/rider/launchers/inRiderEnv/InRiderEnvironmentBundledAssemblyLauncher\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,46:1\n221#2,2:47\n221#2,2:49\n*S KotlinDebug\n*F\n+ 1 InRiderEnvironmentBundledAssemblyLauncher.kt\ncom/jetbrains/rider/launchers/inRiderEnv/InRiderEnvironmentBundledAssemblyLauncher\n*L\n26#1:47,2\n35#1:49,2\n*E\n"})
public final class InRiderEnvironmentBundledAssemblyLauncher
extends BundledAssemblyLauncherInfo {
    @NotNull
    private final EelPath executablePath;
    @NotNull
    private final List<String> arguments;
    @NotNull
    private final Map<String, String> envVars;

    public InRiderEnvironmentBundledAssemblyLauncher(@NotNull EelPath executablePath, @NotNull List<String> arguments, @NotNull Map<String, String> envVars) {
        Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(envVars, (String)"envVars");
        super(executablePath.toString(), InRiderEnvironmentBundledAssemblyLauncherKt.access$toPlatform(executablePath.getDescriptor().getOsFamily()));
        this.executablePath = executablePath;
        this.arguments = arguments;
        this.envVars = envVars;
    }

    @Override
    @NotNull
    public ProcessBuilder toProcessBuilder(String ... params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!Intrinsics.areEqual((Object)this.executablePath.getDescriptor(), (Object)LocalEelDescriptor.INSTANCE)) {
            throw new IllegalArgumentException("You are attempting to run an assembly in a remote environment, but ProcessBuilder is only supported for local environments.");
        }
        String[] stringArray = new String[]{this.executablePath.toString()};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        builder.command().addAll((Collection<String>)this.arguments);
        List<String> list = builder.command();
        Intrinsics.checkNotNullExpressionValue(list, (String)"command(...)");
        CollectionsKt.addAll((Collection)list, (Object[])params);
        Map<String, String> environment = builder.environment();
        Map<String, String> $this$forEach$iv = this.envVars;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            if (it.getValue() == null) {
                environment.remove(it.getKey());
                continue;
            }
            Intrinsics.checkNotNull(environment);
            environment.put(it.getKey(), it.getValue());
        }
        return builder;
    }

    @Override
    @NotNull
    public GeneralCommandLine fillCommandLine(@NotNull GeneralCommandLine cmd, String ... params) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        cmd.withExePath(((Object)EelNioBridgeServiceKt.asNioPath((EelPath)this.executablePath)).toString());
        cmd.addParameters(this.arguments);
        cmd.addParameters(Arrays.copyOf(params, params.length));
        Map map = cmd.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        Map environment = map;
        Map<String, String> $this$forEach$iv = this.envVars;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            if (it.getValue() == null) {
                environment.remove(it.getKey());
                continue;
            }
            environment.put(it.getKey(), it.getValue());
        }
        return cmd;
    }
}

