/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.launchers.remote;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.PathInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/launchers/remote/RemotelyBundledAssemblyLauncher;", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "pathToExecutable", "Lcom/jetbrains/rider/PathInfo;", "arguments", "", "", "envVars", "", "<init>", "(Lcom/jetbrains/rider/PathInfo;Ljava/util/List;Ljava/util/Map;)V", "toProcessBuilder", "Ljava/lang/ProcessBuilder;", "params", "", "([Ljava/lang/String;)Ljava/lang/ProcessBuilder;", "fillCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "cmd", "(Lcom/intellij/execution/configurations/GeneralCommandLine;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.rider.rdclient.dotnet"})
public final class RemotelyBundledAssemblyLauncher
extends BundledAssemblyLauncherInfo {
    @NotNull
    private final List<String> arguments;
    @NotNull
    private final Map<String, String> envVars;

    public RemotelyBundledAssemblyLauncher(@NotNull PathInfo pathToExecutable, @NotNull List<String> arguments, @NotNull Map<String, String> envVars) {
        Intrinsics.checkNotNullParameter((Object)pathToExecutable, (String)"pathToExecutable");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(envVars, (String)"envVars");
        super(pathToExecutable.getPath(), pathToExecutable.getCpuKind().getOsKind().getPlatform());
        this.arguments = arguments;
        this.envVars = envVars;
    }

    @Override
    @NotNull
    public ProcessBuilder toProcessBuilder(String ... params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String[] stringArray = new String[]{this.getPathToExecutable()};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        builder.command().addAll((Collection<String>)this.arguments);
        List<String> list = builder.command();
        Intrinsics.checkNotNullExpressionValue(list, (String)"command(...)");
        CollectionsKt.addAll((Collection)list, (Object[])params);
        builder.environment().putAll(this.envVars);
        return builder;
    }

    @Override
    @NotNull
    public GeneralCommandLine fillCommandLine(@NotNull GeneralCommandLine cmd, String ... params) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        cmd.withExePath(this.getPathToExecutable());
        cmd.addParameters(this.arguments);
        cmd.addParameters(Arrays.copyOf(params, params.length));
        cmd.getEnvironment().putAll(this.envVars);
        return cmd;
    }
}

