/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rd.util.reactive.RdFault;
import com.jetbrains.rider.ijent.extensions.PathExtKt;
import com.jetbrains.rider.model.RdAddItemData;
import com.jetbrains.rider.model.RdAddItemsCommand;
import com.jetbrains.rider.model.RdExcludeItemsCommand;
import com.jetbrains.rider.model.RdProjectModelCommand;
import com.jetbrains.rider.model.RdRenameItemData;
import com.jetbrains.rider.model.RdRenameItemsCommand;
import com.jetbrains.rider.projectView.ProjectModelEventsService;
import com.jetbrains.rider.projectView.VfsBackendRequester;
import com.jetbrains.rider.projectView.VfsToProjectModelEventsCustomizer;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/projectView/VfsToProjectModelEvents;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "getWorkspaceModel", "()Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "projectModelEventsService", "Lcom/jetbrains/rider/projectView/ProjectModelEventsService;", "getProjectModelEventsService", "()Lcom/jetbrains/rider/projectView/ProjectModelEventsService;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "onFileAdd", "Lcom/jetbrains/rider/model/RdProjectModelCommand;", "path", "", "chooseBestParent", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "parentEntities", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onFileRemove", "onFileRename", "newName", "translateEvent", "", "event", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsToProjectModelEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsToProjectModelEvents.kt\ncom/jetbrains/rider/projectView/VfsToProjectModelEvents\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,187:1\n1#2:188\n1#2:236\n1#2:253\n672#3,11:189\n672#3,11:200\n672#3,11:211\n777#3:222\n873#3,2:223\n1642#3,10:225\n1915#3:235\n1916#3:237\n1652#3:238\n777#3:239\n873#3,2:240\n1642#3,10:242\n1915#3:252\n1916#3:254\n1652#3:255\n1807#3,3:256\n58#4:259\n13#5:260\n13#6:261\n*S KotlinDebug\n*F\n+ 1 VfsToProjectModelEvents.kt\ncom/jetbrains/rider/projectView/VfsToProjectModelEvents\n*L\n153#1:236\n163#1:253\n128#1:189,11\n129#1:200,11\n136#1:211,11\n152#1:222\n152#1:223,2\n153#1:225,10\n153#1:235\n153#1:237\n153#1:238\n162#1:239\n162#1:240,2\n163#1:242,10\n163#1:252\n163#1:254\n163#1:255\n177#1:256,3\n179#1:259\n61#1:260\n61#1:261\n*E\n"})
public final class VfsToProjectModelEvents
implements BulkFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public VfsToProjectModelEvents(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final WorkspaceModel getWorkspaceModel() {
        return WorkspaceModel.Companion.getInstance(this.project);
    }

    private final ProjectModelEventsService getProjectModelEventsService() {
        return ProjectModelEventsService.Companion.getInstance(this.project);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            List commands;
            block13: {
                if (!this.translateEvent(vFileEvent)) continue;
                commands = new ArrayList();
                try {
                    RdProjectModelCommand it;
                    VFileEvent vFileEvent2 = vFileEvent;
                    if (vFileEvent2 instanceof VFileCreateEvent) {
                        String string = ((VFileCreateEvent)vFileEvent).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (this.onFileAdd(string) != null) {
                            boolean bl = false;
                            commands.add(it);
                        }
                        break block13;
                    }
                    if (vFileEvent2 instanceof VFileDeleteEvent) {
                        String string = ((VFileDeleteEvent)vFileEvent).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (this.onFileRemove(string) != null) {
                            boolean bl = false;
                            commands.add(it);
                        }
                        break block13;
                    }
                    if (vFileEvent2 instanceof VFileCopyEvent) {
                        String newPath = ((VFileCopyEvent)vFileEvent).getNewParent().getPath() + File.pathSeparator + ((VFileCopyEvent)vFileEvent).getNewChildName();
                        if (this.onFileAdd(newPath) != null) {
                            RdProjectModelCommand it2;
                            boolean bl = false;
                            commands.add(it2);
                        }
                        break block13;
                    }
                    if (vFileEvent2 instanceof VFileMoveEvent) {
                        String string = ((VFileMoveEvent)vFileEvent).getOldPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                        if (this.onFileRemove(string) != null) {
                            boolean bl = false;
                            commands.add(it);
                        }
                        String string2 = ((VFileMoveEvent)vFileEvent).getNewPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNewPath(...)");
                        if (this.onFileAdd(string2) == null) break block13;
                        boolean bl = false;
                        commands.add(it);
                        break block13;
                    }
                    if (!(vFileEvent2 instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename()) break block13;
                    String string = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                    Object object = ((VFilePropertyChangeEvent)vFileEvent).getNewValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    if (this.onFileRename(string, (String)object) == null) break block13;
                    boolean bl = false;
                    commands.add(it);
                }
                catch (Throwable t) {
                    logger.error(t);
                    continue;
                }
            }
            this.getProjectModelEventsService().addCommands(commands);
            logger.info("Translate " + vFileEvent + " to backend...");
            try {
                this.getProjectModelEventsService().flush();
            }
            catch (RdFault ex) {
                logger.warn((Throwable)ex);
            }
        }
    }

    private final RdProjectModelCommand onFileAdd(String path) {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (file.isDirectory() || file.getFileType() instanceof UnknownFileType) {
            return null;
        }
        List<ProjectModelEntity> entities = WorkspaceModelExtensionsKt.getProjectModelEntities(this.getWorkspaceModel(), file, this.project);
        if (CollectionsKt.any((Iterable)entities)) {
            return null;
        }
        WorkspaceModel workspaceModel = this.getWorkspaceModel();
        VirtualFile virtualFile2 = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
        List<ProjectModelEntity> parentEntities = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, virtualFile2, this.project);
        ProjectModelEntity parentEntity = this.chooseBestParent(parentEntities, file);
        Object object = parentEntity;
        if (object == null || (object = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)object, this.project)) == null) {
            return null;
        }
        int parentEntityId = (Integer)object;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return (RdProjectModelCommand)new RdAddItemsCommand(CollectionsKt.listOf((Object)new RdAddItemData(PathExtKt.toRdPath(string), parentEntityId, null, true)));
    }

    private final ProjectModelEntity chooseBestParent(List<? extends ProjectModelEntity> parentEntities, VirtualFile file) {
        Object v3;
        block16: {
            ProjectModelEntity singleParent;
            if (parentEntities.isEmpty()) {
                logger.warn("No parent found for file " + file.getPath());
                return null;
            }
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull(parentEntities);
            if (projectModelEntity == null) {
                Object v1;
                ProjectModelEntity it;
                boolean found$iv;
                Object single$iv;
                boolean $i$f$singleOrNull;
                Iterable $this$singleOrNull$iv;
                block14: {
                    $this$singleOrNull$iv = parentEntities;
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        it = (ProjectModelEntity)element$iv;
                        boolean bl = false;
                        if (!ProjectModelEntityExtensionsKt.isFromSharedProject(it)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block14;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                if ((projectModelEntity = (ProjectModelEntity)v1) == null) {
                    Object v2;
                    block15: {
                        $this$singleOrNull$iv = parentEntities;
                        $i$f$singleOrNull = false;
                        single$iv = null;
                        found$iv = false;
                        for (Object element$iv : $this$singleOrNull$iv) {
                            it = (ProjectModelEntity)element$iv;
                            boolean bl = false;
                            if (!ProjectModelEntityExtensionsKt.isProject(it)) continue;
                            if (found$iv) {
                                v2 = null;
                                break block15;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v2 = !found$iv ? null : single$iv;
                    }
                    projectModelEntity = v2;
                }
            }
            if ((singleParent = projectModelEntity) != null) {
                logger.trace("Chose single parent " + singleParent + " from " + parentEntities.size() + " parents for file " + file.getPath());
                return singleParent;
            }
            Iterable $this$singleOrNull$iv = parentEntities;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ProjectModelEntity it = (ProjectModelEntity)element$iv;
                boolean bl = false;
                if (!ProjectModelEntityExtensionsKt.isFromVcxProject(it)) continue;
                if (found$iv) {
                    v3 = null;
                    break block16;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v3 = !found$iv ? null : single$iv;
        }
        ProjectModelEntity singleCppParent = v3;
        if (singleCppParent != null) {
            String extension;
            String string = file.getExtension();
            if (string != null) {
                String string2 = string.toLowerCase(Locale.ROOT);
                v6 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            } else {
                v6 = extension = null;
            }
            if (extension != null && (Intrinsics.areEqual((Object)extension, (Object)"cpp") || Intrinsics.areEqual((Object)extension, (Object)"h") || Intrinsics.areEqual((Object)extension, (Object)"inl") || Intrinsics.areEqual((Object)extension, (Object)"c") || Intrinsics.areEqual((Object)extension, (Object)"hpp"))) {
                logger.trace("Chose single CPP parent " + singleCppParent + " from " + parentEntities.size() + " parents for file " + file.getPath());
                return singleCppParent;
            }
        }
        logger.warn("Failed to find parent for file " + file.getPath() + ". There are too many (" + parentEntities.size() + ") candidates.");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final RdProjectModelCommand onFileRemove(String path) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        WorkspaceModel workspaceModel = this.getWorkspaceModel();
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Iterable $this$filter$iv = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, path2, this.project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl = false;
            if (!ProjectModelEntityExtensionsKt.isProjectFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl2 = false;
            if (ProjectModelEntityExtensionsKt.getId(it, this.project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entityIds = (List)destination$iv$iv;
        if (entityIds.isEmpty()) {
            return null;
        }
        return (RdProjectModelCommand)new RdExcludeItemsCommand(entityIds);
    }

    /*
     * WARNING - void declaration
     */
    private final RdProjectModelCommand onFileRename(String path, String newName) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        WorkspaceModel workspaceModel = this.getWorkspaceModel();
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Iterable iterable = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, path2, this.project);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl = false;
            if (!ProjectModelEntityExtensionsKt.isProjectFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
            boolean bl2 = false;
            if (ProjectModelEntityExtensionsKt.getId(it, this.project) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List entityIds = (List)destination$iv$iv;
        if (entityIds.isEmpty()) {
            return null;
        }
        List renameData = new ArrayList();
        Iterator iterator2 = entityIds.iterator();
        while (iterator2.hasNext()) {
            int entityId = ((Number)iterator2.next()).intValue();
            renameData.add(new RdRenameItemData(entityId, newName));
        }
        return (RdProjectModelCommand)new RdRenameItemsCommand(renameData);
    }

    private final boolean translateEvent(VFileEvent event) {
        boolean bl;
        block7: {
            if (event.isFromRefresh()) {
                return false;
            }
            Iterable $this$any$iv = VfsToProjectModelEventsCustomizer.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VfsToProjectModelEventsCustomizer it = (VfsToProjectModelEventsCustomizer)element$iv;
                    boolean bl2 = false;
                    if (!it.accept(event)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        if (event.getRequestor() == null || event.getRequestor() instanceof VfsBackendRequester) {
            return false;
        }
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.project;
        boolean $i$f$serviceIfCreated = false;
        UndoManager it = (UndoManager)$this$serviceIfCreated$iv.getServiceIfCreated(UndoManager.class);
        boolean bl3 = false;
        boolean bl4 = it == null || it.isUndoOrRedoInProgress();
        if (bl4) {
            return false;
        }
        return CommandProcessor.getInstance().isCommandInProgress();
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VfsToProjectModelEvents.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsToProjectModelEvents.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/projectView/VfsToProjectModelEvents$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

