/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.solutionStructure;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.jetbrains.rider.projectView.solutionStructure.definitions.ProjectDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.PropertyDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SectionDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SolutionFolderDefinition;
import com.jetbrains.rider.utils.ProjectTypeGuidGuesser;
import com.jetbrains.rider.utils.UUIDUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,Bh\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012%\u0010\t\u001a!\u0012\u0015\u0012\u0013\u0018\u00010\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\u0005\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\n\u0012\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\r0\u000fj\b\u0012\u0004\u0012\u00020\r`\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010'\u001a\u00020(2\b\u0010\f\u001a\u0004\u0018\u00010\u0000J\u000e\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0018R-\u0010\t\u001a!\u0012\u0015\u0012\u0013\u0018\u00010\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\u0005\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\r0\u000fj\b\u0012\u0004\u0012\u00020\r`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u000fj\b\u0012\u0004\u0012\u00020\u0000`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0018\"\u0004\b\"\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/projectView/solutionStructure/ProjectMark;", "", "projectGuid", "Ljava/util/UUID;", "projectTypeGuid", "name", "", "isSolutionFolder", "", "pathGetter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "parent", "Ljava/nio/file/Path;", "solutionItems", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;Ljava/util/HashSet;)V", "getProjectGuid", "()Ljava/util/UUID;", "getProjectTypeGuid", "getName", "()Ljava/lang/String;", "()Z", "getSolutionItems", "()Ljava/util/HashSet;", "children", "getChildren", "getParent", "()Lcom/jetbrains/rider/projectView/solutionStructure/ProjectMark;", "setParent", "(Lcom/jetbrains/rider/projectView/solutionStructure/ProjectMark;)V", "isHiddenInFilter", "setHiddenInFilter", "(Z)V", "path", "getPath", "()Ljava/nio/file/Path;", "updateParent", "", "dump", "indent", "", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProjectMark.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectMark.kt\ncom/jetbrains/rider/projectView/solutionStructure/ProjectMark\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n777#2:80\n873#2,2:81\n*S KotlinDebug\n*F\n+ 1 ProjectMark.kt\ncom/jetbrains/rider/projectView/solutionStructure/ProjectMark\n*L\n73#1:80\n73#1:81,2\n*E\n"})
public final class ProjectMark {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID projectGuid;
    @NotNull
    private final UUID projectTypeGuid;
    @NotNull
    private final String name;
    private final boolean isSolutionFolder;
    @NotNull
    private final Function1<ProjectMark, Path> pathGetter;
    @NotNull
    private final HashSet<Path> solutionItems;
    @NotNull
    private final HashSet<ProjectMark> children;
    @Nullable
    private ProjectMark parent;
    private boolean isHiddenInFilter;

    private ProjectMark(UUID projectGuid, UUID projectTypeGuid, String name, boolean isSolutionFolder, Function1<? super ProjectMark, ? extends Path> pathGetter, HashSet<Path> solutionItems) {
        this.projectGuid = projectGuid;
        this.projectTypeGuid = projectTypeGuid;
        this.name = name;
        this.isSolutionFolder = isSolutionFolder;
        this.pathGetter = pathGetter;
        this.solutionItems = solutionItems;
        this.children = new HashSet();
    }

    @NotNull
    public final UUID getProjectGuid() {
        return this.projectGuid;
    }

    @NotNull
    public final UUID getProjectTypeGuid() {
        return this.projectTypeGuid;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isSolutionFolder() {
        return this.isSolutionFolder;
    }

    @NotNull
    public final HashSet<Path> getSolutionItems() {
        return this.solutionItems;
    }

    @NotNull
    public final HashSet<ProjectMark> getChildren() {
        return this.children;
    }

    @Nullable
    public final ProjectMark getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable ProjectMark projectMark) {
        this.parent = projectMark;
    }

    public final boolean isHiddenInFilter() {
        return this.isHiddenInFilter;
    }

    public final void setHiddenInFilter(boolean bl) {
        this.isHiddenInFilter = bl;
    }

    @Nullable
    public final Path getPath() {
        return (Path)this.pathGetter.invoke((Object)this.parent);
    }

    public final void updateParent(@Nullable ProjectMark parent) {
        block1: {
            Object object;
            Object object2 = this.parent;
            if (object2 != null && (object2 = ((ProjectMark)object2).children) != null) {
                ((HashSet)object2).remove(this);
            }
            if ((object = (this.parent = parent)) == null || (object = ((ProjectMark)object).children) == null) break block1;
            ((HashSet)object).add(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(int indent) {
        void $this$filterTo$iv$iv;
        String result2 = StringsKt.repeat((CharSequence)"  ", (int)indent) + this.name;
        Iterable iterable = this.solutionItems;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> ProjectMark.dump$lambda$1(ProjectMark::dump$lambda$0, arg_0), NaturalComparator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        for (Path solutionItem : CollectionsKt.sortedWith((Iterable)iterable, comparator)) {
            result2 = result2 + "\n";
            result2 = result2 + StringsKt.repeat((CharSequence)"  ", (int)(indent + 1)) + PathsKt.getName((Path)solutionItem);
        }
        Iterable $this$filter$iv = this.children;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectMark it = (ProjectMark)element$iv$iv;
            boolean bl = false;
            if (!(!it.isHiddenInFilter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv;
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> ProjectMark.dump$lambda$4(ProjectMark::dump$lambda$3, arg_0), NaturalComparator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing(...)");
        for (ProjectMark child : CollectionsKt.sortedWith((Iterable)iterable3, comparator2)) {
            result2 = result2 + "\n";
            result2 = result2 + child.dump(indent + 1);
        }
        return result2;
    }

    private static final String dump$lambda$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return PathsKt.getName((Path)it);
    }

    private static final String dump$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String dump$lambda$3(ProjectMark it) {
        return it.name;
    }

    private static final String dump$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    public /* synthetic */ ProjectMark(UUID projectGuid, UUID projectTypeGuid, String name, boolean isSolutionFolder, Function1 pathGetter, HashSet solutionItems, DefaultConstructorMarker $constructor_marker) {
        this(projectGuid, projectTypeGuid, name, isSolutionFolder, (Function1<? super ProjectMark, ? extends Path>)pathGetter, solutionItems);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/projectView/solutionStructure/ProjectMark$Companion;", "", "<init>", "()V", "createFromDefinition", "Lcom/jetbrains/rider/projectView/solutionStructure/ProjectMark;", "definition", "Lcom/jetbrains/rider/projectView/solutionStructure/definitions/ProjectDefinition;", "createFromPath", "path", "Ljava/nio/file/Path;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nProjectMark.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectMark.kt\ncom/jetbrains/rider/projectView/solutionStructure/ProjectMark$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1391#2:80\n1480#2,2:81\n1586#2:83\n1661#2,3:84\n1482#2,3:87\n*S KotlinDebug\n*F\n+ 1 ProjectMark.kt\ncom/jetbrains/rider/projectView/solutionStructure/ProjectMark$Companion\n*L\n36#1:80\n36#1:81,2\n37#1:83\n37#1:84,3\n36#1:87,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProjectMark createFromDefinition(@NotNull ProjectDefinition definition) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            String name = definition.getActualProjectName();
            boolean isSolutionFolder = definition instanceof SolutionFolderDefinition;
            Function1 pathGetter = arg_0 -> Companion.createFromDefinition$lambda$0(isSolutionFolder, definition, arg_0);
            Iterable $this$flatMap$iv = definition.getProjectSections("SolutionItems");
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                SectionDefinition it = (SectionDefinition)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = it.getProperties();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String itemName;
                    void projectDefinition;
                    PropertyDefinition propertyDefinition = (PropertyDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)projectDefinition.getPropertyValue()), (String)"toSystemIndependentName(...)");
                    Path path = definition.getSolutionDefinition().getLocation().getParent().resolve(itemName);
                    collection.add(path.normalize());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            HashSet solutionItems = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            return new ProjectMark(definition.getProjectGuid(), definition.getProjectTypeGuid(), name, isSolutionFolder, pathGetter, solutionItems, null);
        }

        @NotNull
        public final ProjectMark createFromPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String name = PathsKt.getNameWithoutExtension((Path)path);
            UUID projectGuid = UUIDUtils.INSTANCE.createFromString(name);
            UUID projectTypeGuid = ProjectTypeGuidGuesser.Companion.calculateTypeGuid(path);
            return new ProjectMark(projectGuid, projectTypeGuid, name, false, arg_0 -> Companion.createFromPath$lambda$0(path, arg_0), new HashSet(), null);
        }

        private static final Path createFromDefinition$lambda$0(boolean $isSolutionFolder, ProjectDefinition $definition, ProjectMark parent) {
            Path path;
            boolean bl = $isSolutionFolder;
            if (bl) {
                Path parentPath;
                ProjectMark projectMark = parent;
                Path path2 = parentPath = projectMark == null ? $definition.getSolutionDefinition().getLocation().getParent() : projectMark.getPath();
                path = path2 != null ? path2.resolve($definition.getPathString()) : null;
            } else if (!bl) {
                path = $definition.getPath();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Path path3 = path;
            return path3 != null ? path3.normalize() : null;
        }

        private static final Path createFromPath$lambda$0(Path $path, ProjectMark it) {
            return $path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

