/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.BundleBase;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ReportFeedbackService;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.JetBrainsPermanentInstallationID;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.util.MathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.dom.XmlElement;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.clrmd.ClrProcessThreadDumpUtilKt;
import com.jetbrains.rider.clrmd.CollectThreadDumpRequest;
import com.jetbrains.rider.cpp.DisableCppAction;
import com.jetbrains.rider.diagnostics.ProfilerArgs;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.DotTraceGlobalTool;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.DotnetSelfProfiler;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.DotnetSelfProfilingProcesses;
import com.jetbrains.rider.environment.local.RiderLocalEnvironment;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import com.jetbrains.rider.launchers.RiderBackendLauncher;
import com.jetbrains.rider.protocol.BackendCrashAnalyzer;
import com.jetbrains.rider.protocol.BackendCrashDiagnostics;
import com.jetbrains.rider.protocol.CriticalErrorApplicationTerminator;
import com.jetbrains.rider.protocol.InternalAutoBackendProfilingInfo;
import com.jetbrains.rider.protocol.ProtocolKeys;
import com.jetbrains.rider.protocol.ReSharperProcess;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 c2\u00020\u0001:\u0004`abcB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\"\u001a\u00020#H&J\b\u0010$\u001a\u00020#H&J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&H&J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0(H&J\u001c\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0,H\u0002J$\u0010-\u001a\u00020*2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0,2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u001c\u00100\u001a\u00020*2\u0006\u00101\u001a\u00020\u00072\f\u00102\u001a\b\u0012\u0004\u0012\u00020*03J\b\u00104\u001a\u00020*H\u0002J\u0006\u0010\u001e\u001a\u00020*J\u0016\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003J\u001d\u0010:\u001a\u00070;\u00a2\u0006\u0002\b<2\u0006\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020#H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0007H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CH\u0002J\u0006\u0010E\u001a\u00020*J\n\u0010F\u001a\u0004\u0018\u00010#H&J \u0010G\u001a\u00020*2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020#H\u0002J\b\u0010L\u001a\u00020*H\u0002J\u0010\u0010M\u001a\u00020*2\u0006\u0010N\u001a\u00020OH\u0002J\n\u0010P\u001a\u0004\u0018\u00010#H\u0002J\u000f\u0010Q\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010RJ\n\u0010S\u001a\u0004\u0018\u00010#H\u0002J\f\u0010T\u001a\u00020#*\u00020UH\u0002J\f\u0010V\u001a\u00020\u0005*\u00020#H\u0002J\b\u0010W\u001a\u00020#H\u0002J<\u0010X\u001a\u0002HY\"\u0004\b\u0000\u0010Y2'\u0010Z\u001a#\b\u0001\u0012\u0004\u0012\u00020\\\u0012\n\u0012\b\u0012\u0004\u0012\u0002HY0]\u0012\u0006\u0012\u0004\u0018\u00010\u00010[\u00a2\u0006\u0002\b^H\u0002\u00a2\u0006\u0002\u0010_R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0012\u00105\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0012\u00107\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00106\u00a8\u0006d"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "serverPort", "", "isLightweight", "", "killedEbs", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;IZLjava/lang/Long;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Ljava/lang/Long;", "resharperProcessHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "getResharperProcessHandler", "()Lcom/intellij/execution/process/BaseOSProcessHandler;", "setResharperProcessHandler", "(Lcom/intellij/execution/process/BaseOSProcessHandler;)V", "value", "Lcom/jetbrains/rider/protocol/InternalAutoBackendProfilingInfo;", "internalProfilingInfo", "getInternalProfilingInfo", "()Lcom/jetbrains/rider/protocol/InternalAutoBackendProfilingInfo;", "shutdownTimeout", "getShutdownTimeout", "()J", "getBackendPid", "requestShutdown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getRequestShutdown", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getDotNetPluginsXmlDescriptor", "", "getDotNetPluginsExtraDirs", "getExtraFlags", "", "getExtraEnvVars", "", "sanitizeEnvironment", "", "env", "", "prepareReSharperHostSystemDir", "environment", "isFirstReSharperHost", "waitFor", "async", "afterShutdown", "Lkotlin/Function0;", "copyReSharperSettings", "isInternal", "()Z", "isUnitTesting", "tryMoveDiagnosticReportToLogFolder", "pid", "createTemporaryLifetimedFile", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "prefix", "suffix", "getBackendLogConfig", "Lcom/jetbrains/rider/protocol/ReSharperProcessBase$BackendLogConfiguration;", "isFirstRiderBackend", "patchBackendConfigFile", "Ljava/nio/file/Path;", "inputFile", "start", "getLocaleForBackend", "showCrashDialog", "appEx", "Lcom/intellij/openapi/application/ex/ApplicationEx;", "errFile", "message", "contactSupport", "withBackendProfiling", "processBuilder", "Ljava/lang/ProcessBuilder;", "tryGetSnapshotKind", "getBucket", "()Ljava/lang/Integer;", "getOrGenerateDeviceId", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "asBucket", "getPathForBackendSettings", "runBlockingTryCancellable", "T", "action", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "PlaybackCrash", "BackendLogConfiguration", "VersionRecord", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperProcessBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/ReSharperProcessBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1022:1\n1#2:1023\n221#3,2:1024\n221#3,2:1035\n42#4,3:1026\n23#5:1029\n23#5:1030\n23#5:1031\n23#5:1032\n23#5:1037\n23#5:1038\n13#5:1052\n1401#6,2:1033\n27#7,3:1039\n30#7,7:1044\n13#7:1051\n1342#8,2:1042\n*S KotlinDebug\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/ReSharperProcessBase\n*L\n580#1:1024,2\n772#1:1035,2\n733#1:1026,3\n741#1:1029\n743#1:1030\n745#1:1031\n747#1:1032\n776#1:1037\n779#1:1038\n909#1:1052\n748#1:1033,2\n294#1:1039,3\n294#1:1044,7\n909#1:1051\n295#1:1042,2\n*E\n"})
public abstract class ReSharperProcessBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    private final int serverPort;
    private final boolean isLightweight;
    @Nullable
    private final Long killedEbs;
    public BaseOSProcessHandler resharperProcessHandler;
    @Nullable
    private InternalAutoBackendProfilingInfo internalProfilingInfo;
    @NotNull
    private final AtomicBoolean requestShutdown;
    @NotNull
    private static final Logger logger;
    private static int processIdIncrement;
    private static boolean shouldImportReSharperSettings;
    private static final long fullBackendShutdownTimeout;
    private static final long lightweightBackendShutdownTimeout;
    @NotNull
    private static final Lazy<Path> resharperHostConfigDir;
    @NotNull
    private static final Lazy<Path> resharperHostSystemDir;
    @NotNull
    private static final Lazy<Path> resharperHostSystemInvalidateFlag;

    public ReSharperProcessBase(@NotNull Lifetime lifetime, int serverPort, boolean isLightweight, @Nullable Long killedEbs) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.serverPort = serverPort;
        this.isLightweight = isLightweight;
        this.killedEbs = killedEbs;
        this.requestShutdown = new AtomicBoolean(false);
    }

    public /* synthetic */ ReSharperProcessBase(Lifetime lifetime, int n, boolean bl, Long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            l = null;
        }
        this(lifetime, n, bl, l);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final BaseOSProcessHandler getResharperProcessHandler() {
        BaseOSProcessHandler baseOSProcessHandler = this.resharperProcessHandler;
        if (baseOSProcessHandler != null) {
            return baseOSProcessHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resharperProcessHandler");
        return null;
    }

    public final void setResharperProcessHandler(@NotNull BaseOSProcessHandler baseOSProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)baseOSProcessHandler, (String)"<set-?>");
        this.resharperProcessHandler = baseOSProcessHandler;
    }

    @Nullable
    public final InternalAutoBackendProfilingInfo getInternalProfilingInfo() {
        return this.internalProfilingInfo;
    }

    public final long getShutdownTimeout() {
        return this.isLightweight ? lightweightBackendShutdownTimeout : fullBackendShutdownTimeout;
    }

    public final long getBackendPid() {
        return this.getResharperProcessHandler().getProcess().pid();
    }

    @NotNull
    protected final AtomicBoolean getRequestShutdown() {
        return this.requestShutdown;
    }

    @NotNull
    public abstract String getDotNetPluginsXmlDescriptor();

    @NotNull
    public abstract String getDotNetPluginsExtraDirs();

    @NotNull
    public abstract List<String> getExtraFlags();

    @NotNull
    public abstract Map<String, String> getExtraEnvVars();

    private final void sanitizeEnvironment(Map<String, String> env2) {
        env2.remove("QODANA_LICENSE");
        env2.remove("QODANA_TOKEN");
    }

    private final void prepareReSharperHostSystemDir(Map<String, String> environment, boolean isFirstReSharperHost) {
        Path systemDir = (Path)resharperHostSystemDir.getValue();
        if (isFirstReSharperHost) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists((Path)resharperHostSystemInvalidateFlag.getValue(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                logger.info("Found invalidate caches flag for R# host caches");
                logger.info("Erasing directory '" + systemDir + "'");
                try {
                    FileUtil.delete((Path)systemDir);
                }
                catch (Throwable t) {
                    logger.error("Unable to delete ReSharperHost caches directory '" + systemDir + "': " + t.getMessage(), t);
                }
            }
        }
        PathKt.createDirectories((Path)systemDir);
        if (BundleBase.SHOW_LOCALIZED_MESSAGES) {
            environment.put("JET_I18N_DEBUG", "true");
        }
        Map<String, String> map = environment;
        String string = "JET_LOCAL_APPDATA_DIR";
        Path path = systemDir.resolve("local");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String string2 = ((Object)path.toAbsolutePath()).toString();
        map.put(string, string2);
        map = environment;
        string = "JET_ROAMING_APPDATA_DIR";
        Path path2 = systemDir.resolve("roaming");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        string2 = ((Object)path2.toAbsolutePath()).toString();
        map.put(string, string2);
        map = environment;
        string = "JET_TEMP_DIR";
        Path path3 = systemDir.resolve("temp");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        string2 = ((Object)path3.toAbsolutePath()).toString();
        map.put(string, string2);
    }

    public final void waitFor(boolean async, @NotNull Function0<Unit> afterShutdown) {
        Intrinsics.checkNotNullParameter(afterShutdown, (String)"afterShutdown");
        Application app = ApplicationManager.getApplication();
        Function0 shutdownAction = () -> ReSharperProcessBase.waitFor$lambda$0(this, app, afterShutdown);
        if (async) {
            Future future = app.executeOnPooledThread(() -> ReSharperProcessBase.waitFor$lambda$1(shutdownAction));
            v1 = future;
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        } else {
            shutdownAction.invoke();
            v1 = Unit.INSTANCE;
        }
    }

    private final void copyReSharperSettings() {
        boolean isEnabled = SystemProperties.getBooleanProperty((String)"rider.enable.resharper.import", (boolean)true);
        if (!isEnabled) {
            logger.info("rider.enable.resharper.import is false, skip ReSharper setting import.");
            return;
        }
        if (PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode() || this.isUnitTesting()) {
            logger.info("Should not import resharper settings due to test environment");
            return;
        }
        if (!shouldImportReSharperSettings) {
            logger.info("Should not import resharper settings");
            return;
        }
        logger.info("Starting resharper settings import");
        if (!SystemInfo.isWindows) {
            return;
        }
        String globalSettingsStorageFile = "GlobalSettingsStorage.DotSettings";
        Path riderGlobalSettingsStorage = ((Path)resharperHostConfigDir.getValue()).resolve(globalSettingsStorageFile);
        Intrinsics.checkNotNull((Object)riderGlobalSettingsStorage);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(riderGlobalSettingsStorage, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("Global settings file already exists for Rider => skipping copying resharper settings");
            return;
        }
        String appdata = System.getenv("APPDATA");
        if (appdata == null) {
            logger.error("%APPDATA% is not defined => skipping copying resharper settings");
            return;
        }
        Object object = appdata;
        Object object2 = new String[]{"JetBrains", "Shared", "vAny", globalSettingsStorageFile};
        Path path = Paths.get((String)object, Arrays.copyOf(object2, ((String[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path resharperGlobalSettingsStorage = path;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(resharperGlobalSettingsStorage, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            logger.info("Global settings file (for ReSharper and .NET products) is not found at " + resharperGlobalSettingsStorage + " => skipping copying resharper settings");
            return;
        }
        try {
            object = resharperGlobalSettingsStorage;
            object2 = PathKt.createParentDirectories((Path)riderGlobalSettingsStorage);
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
        catch (Throwable t) {
            logger.error("Unable to copy resharper settings from " + resharperGlobalSettingsStorage + " to " + riderGlobalSettingsStorage, t);
        }
    }

    public final void requestShutdown() {
        this.requestShutdown.set(true);
    }

    public abstract boolean isInternal();

    public abstract boolean isUnitTesting();

    public final void tryMoveDiagnosticReportToLogFolder(long pid, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (!SystemInfo.isMac) {
            return;
        }
        HashSet scannedFiles = new HashSet();
        String pidStr = String.valueOf(pid);
        Regex pidRegex = new Regex("Process:\\s+dotnet\\s\\[(\\d+)]");
        Path logDirectory = RiderLocalEnvironment.INSTANCE.getLogDirectory().toPath().resolve("DiagnosticReports");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> ReSharperProcessBase.tryMoveDiagnosticReportToLogFolder$lambda$0(lifetime, scannedFiles, pidRegex, pidStr, logDirectory), (int)31, null);
    }

    private final File createTemporaryLifetimedFile(String prefix, String suffix) {
        File file;
        File it = file = FileUtil.createTempFile((String)prefix, (String)suffix);
        boolean bl = false;
        this.lifetime.onTermination(() -> ReSharperProcessBase.createTemporaryLifetimedFile$lambda$0$0(it));
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"also(...)");
        return file2;
    }

    private final BackendLogConfiguration getBackendLogConfig(boolean isFirstRiderBackend) {
        Path backendLogXmlPath;
        String envVar = System.getenv("RESHARPER_LOG_CONF");
        CharSequence charSequence = envVar;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Path path = Paths.get(envVar, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return new BackendLogConfiguration(true, path);
        }
        Path path = backendLogXmlPath = this.isLightweight ? RiderLocalEnvironment.INSTANCE.getLightweightBackendLogXmlPath() : RiderLocalEnvironment.INSTANCE.getBackendLogXmlPath();
        if (isFirstRiderBackend && PluginManagerCore.isRunningFromSources() && !this.isUnitTesting()) {
            Path backendLogConfigFile = this.patchBackendConfigFile(backendLogXmlPath);
            return new BackendLogConfiguration(false, backendLogConfigFile);
        }
        return new BackendLogConfiguration(true, backendLogXmlPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path patchBackendConfigFile(Path inputFile) {
        Object factory;
        try {
            factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            Document document = builder.parse(inputFile.toFile());
            XPathFactory xPathFactory = XPathFactory.newInstance();
            String backendLogFileName = this.isLightweight ? "lightweight-backend.log" : "backend.log";
            String backendProtocolLogFileName = this.isLightweight ? "lightweight-backend-protocol.log" : "backend-protocol.log";
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"file_verbose", (Object)("{env.RESHARPER_HOST_LOG_DIR}/" + backendLogFileName)), TuplesKt.to((Object)"file_protocol", (Object)("{env.RESHARPER_HOST_LOG_DIR}/" + backendProtocolLogFileName))};
            List appendersToReplace = CollectionsKt.listOf((Object[])objectArray);
            boolean anyReplaced = false;
            for (Object object3 : appendersToReplace) {
                Node node;
                String appenderName = (String)object3.component1();
                String logFilePath = (String)object3.component2();
                XPathExpression xPath = xPathFactory.newXPath().compile("/configuration/appender[@name='" + appenderName + "']/arg");
                Object object2 = xPath.evaluate(document, XPathConstants.NODE);
                Node node2 = node = object2 instanceof Node ? (Node)object2 : null;
                if (node == null) {
                    logger.warn("Cannot find file_verbose appender in config file \"" + inputFile + "\".");
                    continue;
                }
                node.setTextContent(logFilePath);
                anyReplaced = true;
            }
            if (!anyReplaced) {
                return inputFile;
            }
            factory = document;
        }
        catch (SAXParseException e) {
            logger.error("Unable to parse the log configuration at \"" + inputFile + "\".", (Throwable)e);
            return inputFile;
        }
        Object patchedContent = factory;
        File tempConfigFile = this.createTemporaryLifetimedFile("riderBackendLogConfig", ".xml");
        Closeable closeable = new FileOutputStream(tempConfigFile);
        Throwable throwable = null;
        try {
            Object object;
            FileOutputStream stream = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new OutputStreamWriter((OutputStream)stream, Charsets.UTF_8);
            Throwable throwable2 = null;
            try {
                Object object3;
                OutputStreamWriter writer = (OutputStreamWriter)closeable2;
                boolean bl2 = false;
                Object $this$patchBackendConfigFile_u24lambda_u240_u240_u240 = object3 = TransformerFactory.newInstance().newTransformer();
                boolean bl3 = false;
                ((Transformer)$this$patchBackendConfigFile_u24lambda_u240_u240_u240).setOutputProperty("omit-xml-declaration", "yes");
                ((Transformer)$this$patchBackendConfigFile_u24lambda_u240_u240_u240).setOutputProperty("indent", "no");
                ((Transformer)$this$patchBackendConfigFile_u24lambda_u240_u240_u240).transform(new DOMSource((Node)patchedContent), new StreamResult(writer));
                object = object3;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Object object4 = object;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        logger.info("Temporary backend configuration file emitted at \"" + tempConfigFile + "\".");
        Path path = tempConfigFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    public final void start() {
        String string;
        Object k;
        boolean overrideReSharperPaths;
        Object productCode;
        Object build22;
        Object object;
        String string2;
        Map<String, String> map;
        Map<String, String> map2;
        BundledAssemblyLauncherInfo bundledAssemblyLauncherInfo;
        this.copyReSharperSettings();
        try {
            bundledAssemblyLauncherInfo = (BundledAssemblyLauncherInfo)this.runBlockingTryCancellable((Function2)new Function2<CoroutineScope, Continuation<? super BundledAssemblyLauncherInfo>, Object>(null){
                int label;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = RiderBackendLauncher.INSTANCE.prepareForEnvironment(RiderLocalEnvironment.INSTANCE, CPUKind.Companion.getRIDER_CPU_KIND(), new String[0], (Continuation<? super BundledAssemblyLauncherInfo>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super BundledAssemblyLauncherInfo> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }
        catch (Exception ex) {
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                application.putUserData(ProtocolKeys.Companion.getProtocolManagerErrorKey(), (Object)ex.getMessage());
            }
            logger.error((Throwable)ex);
            return;
        }
        BundledAssemblyLauncherInfo executable2 = bundledAssemblyLauncherInfo;
        ProcessBuilder processBuilder = executable2.toProcessBuilder(new String[0]);
        if (Intrinsics.areEqual((Object)System.getProperty("dotcover.enabled"), (Object)"true")) {
            String dotcoverStuff = System.getProperty("dotcover.output.path");
            if (System.getProperty("dotcover.output.path") == null) {
                dotcoverStuff = FilesKt.resolve((File)RiderLocalEnvironment.INSTANCE.getLogDirectory(), (String)"dotcover").getAbsolutePath();
            }
            map2 = dotcoverStuff;
            Intrinsics.checkNotNull((Object)map2);
            Path path = Paths.get((String)((Object)map2), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            map2 = path;
            Path path2 = map2.resolve(String.valueOf(System.nanoTime()));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            reportFileNameTemplate = path2;
            processBuilder.command().remove(0);
            processBuilder.command().add(System.getProperty("dotcover.exe.path"));
            processBuilder.command().add("cover");
            processBuilder.command().add("/TargetExecutable=" + executable2.getAssemblyAbsolutePath());
            if (Intrinsics.areEqual((Object)System.getProperty("dotcover.report.type"), (Object)"dcvr")) {
                v3 = processBuilder.command().add("/Output=" + (Path)reportFileNameTemplate + ".dcvr");
            } else {
                processBuilder.command().add("/Output=" + (Path)reportFileNameTemplate + ".html");
                processBuilder.command().add("/ReportType=\"HTML\"");
                v3 = System.getProperty("dotcover.sources.search.paths") != null ? processBuilder.command().add("/SourcesSearchPaths=" + System.getProperty("dotcover.sources.search.paths")) : processBuilder.command().add("/SourcesSearchPaths=" + PathManager.getHomePath() + "\\..\\");
            }
            processBuilder.command().add("/LogFile=" + (Path)reportFileNameTemplate + ".log");
            processBuilder.command().add("/LogLevel=Verbose");
            processBuilder.command().add("/ProcessFilters=+:JetBrains*");
            processBuilder.command().add("--");
        } else if (System.getenv("RESHARPER_HOST_DEBUG_SELF_CMD_LINE") != null) {
            processBuilder.command().add(0, "--");
            Iterator<Map.Entry<String, String>> debuggerWorkerCommandLine = System.getenv("RESHARPER_HOST_DEBUG_SELF_CMD_LINE");
            logger.info("RESHARPER_HOST_DEBUG_SELF_CMD_LINE: " + (String)((Object)debuggerWorkerCommandLine));
            List<String> list = processBuilder.command();
            Intrinsics.checkNotNull((Object)debuggerWorkerCommandLine);
            reportFileNameTemplate = new char[]{'\n'};
            list.addAll(0, StringsKt.split$default((CharSequence)((CharSequence)((Object)debuggerWorkerCommandLine)), (char[])reportFileNameTemplate, (boolean)false, (int)0, (int)6, null));
        } else if (this.tryGetSnapshotKind() != null) {
            this.withBackendProfiling(processBuilder);
        }
        processBuilder.command().add("--Port=" + this.serverPort);
        if (this.isUnitTesting()) {
            processBuilder.command().add("--UnitTests");
        }
        if (PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode()) {
            processBuilder.command().add("--PerfTests");
        }
        if (this.isInternal()) {
            processBuilder.command().add("--Internal");
        }
        if (this.isLightweight) {
            processBuilder.command().add("--LightweightBackend");
        }
        for (String flag : this.getExtraFlags()) {
            processBuilder.command().add(flag);
        }
        for (Map.Entry<String, String> envVar : this.getExtraEnvVars().entrySet()) {
            Intrinsics.checkNotNullExpressionValue(processBuilder.environment(), (String)"environment(...)");
            map = envVar.getKey();
            string2 = envVar.getValue();
            map2.put((String)((Object)map), string2);
        }
        File pluginXmlDescriptorFileName = this.createTemporaryLifetimedFile("AdditionalDeployedPackages", ".xml");
        String xml = this.getDotNetPluginsXmlDescriptor();
        FilesKt.writeText$default((File)pluginXmlDescriptorFileName, (String)xml, null, (int)2, null);
        String extraDirs = this.getDotNetPluginsExtraDirs();
        if (!Intrinsics.areEqual((Object)xml, (Object)"") || !Intrinsics.areEqual((Object)extraDirs, (Object)"")) {
            Map<String, String> map3 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"environment(...)");
            map = map3;
            string2 = "JET_ADDITIONAL_DEPLOYED_PACKAGES_FILE";
            String string3 = pluginXmlDescriptorFileName.getAbsolutePath();
            map.put(string2, string3);
            Map<String, String> map4 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"environment(...)");
            map = map4;
            map.put("RIDER_PLUGIN_ADDITIONAL_PROBING_PATHS", extraDirs);
        }
        int n = processIdIncrement;
        processIdIncrement = n + 1;
        int processId = n;
        boolean isFirstBackendProcess = processId == 0;
        BackendLogConfiguration backendLogConfiguration = this.getBackendLogConfig(isFirstBackendProcess);
        Map<String, String> map5 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map5, (String)"environment(...)");
        Map<String, String> map6 = map5;
        Map<String, String> map7 = "RESHARPER_LOG_CONF";
        Map<String, String> map8 = ((Object)backendLogConfiguration.getLogConfigurationFilePath()).toString();
        map6.put((String)((Object)map7), (String)((Object)map8));
        String overriddenReSharperSettingsDir = this.getPathForBackendSettings();
        Map<String, String> map9 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map9, (String)"environment(...)");
        map7 = map9;
        map7.put("RESHARPER_HOST_CONFIG_DIR", overriddenReSharperSettingsDir);
        Map<String, String> map10 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map10, (String)"environment(...)");
        map7 = map10;
        map8 = "RESHARPER_HOST_LOG_DIR";
        Map<String, String> map11 = RiderLocalEnvironment.INSTANCE.getLogDirectory().getAbsolutePath();
        map7.put((String)((Object)map8), (String)((Object)map11));
        Map<String, String> map12 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map12, (String)"environment(...)");
        map7 = map12;
        map8 = "RESHARPER_HOST_PARENT_PROCESS_PID";
        map11 = String.valueOf(ProcessHandle.current().pid());
        map7.put((String)((Object)map8), (String)((Object)map11));
        if (!DisableCppAction.Companion.getEnabledCpp()) {
            Map<String, String> map13 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map13, (String)"environment(...)");
            map7 = map13;
            map8 = "RESHARPER_CPP_DISABLE";
            map11 = "True";
            map7.put((String)((Object)map8), (String)((Object)map11));
        }
        try {
            VersionRecord version = new VersionRecord();
            XmlElement xmlElement = ApplicationNamesInfo.initAndGetRawData();
            Intrinsics.checkNotNullExpressionValue((Object)xmlElement, (String)"initAndGetRawData(...)");
            version.loadState$intellij_rider_rdclient_dotnet(xmlElement);
            Map<String, String> map14 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map14, (String)"environment(...)");
            map8 = map14;
            map11 = "RESHARPER_REPORT_VERSION";
            object = version.getFullVersion();
            map8.put((String)((Object)map11), (String)object);
        }
        catch (Throwable version) {
            // empty catch block
        }
        try {
            boolean bl;
            BuildNumber buildNumber = ApplicationInfoImpl.getShadowInstance().getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
            build22 = buildNumber;
            Map<String, String> map15 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map15, (String)"environment(...)");
            map8 = map15;
            map11 = "RESHARPER_FUS_BUILD";
            object = this.asBuildNumber((BuildNumber)build22);
            map8.put((String)((Object)map11), (String)object);
            String string4 = build22.getProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProductCode(...)");
            productCode = string4;
            boolean bl2 = bl = ((String)productCode).length() < 10;
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            Map<String, String> map16 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map16, (String)"environment(...)");
            map11 = map16;
            map11.put("RESHARPER_FRONT_PRODUCT_CODE", (String)productCode);
        }
        catch (Throwable build22) {
            // empty catch block
        }
        try {
            String installationId;
            String deviceId;
            Object bucket;
            Map<String, String> map17 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map17, (String)"environment(...)");
            build22 = map17;
            productCode = "JET_HEADLESS_MODE";
            map11 = AppMode.isHeadless() ? "true" : "false";
            build22.put(productCode, map11);
            if (AppMode.isHeadless()) {
                Map<String, String> map18 = processBuilder.environment();
                Intrinsics.checkNotNullExpressionValue(map18, (String)"environment(...)");
                build22 = map18;
                productCode = "RESHARPER_FUS_HEADLESS";
                map11 = "true";
                build22.put(productCode, map11);
            }
            Map<String, String> map19 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map19, (String)"environment(...)");
            build22 = map19;
            productCode = "RESHARPER_FUS_SALT";
            map11 = Base64.getEncoder().encodeToString(EventLogConfiguration.Companion.getOrGenerateSaltFromPrefs("FUS"));
            build22.put(productCode, map11);
            Map<String, String> map20 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map20, (String)"environment(...)");
            build22 = map20;
            productCode = "RESHARPER_FUS_SESSION";
            map11 = EventLogConfiguration.Companion.getDefaultSessionId();
            build22.put(productCode, map11);
            if (this.killedEbs != null) {
                Map<String, String> map21 = processBuilder.environment();
                Intrinsics.checkNotNullExpressionValue(map21, (String)"environment(...)");
                build22 = map21;
                productCode = "RESHARPER_FUS_IGNOREPID";
                map11 = String.valueOf(this.killedEbs);
                build22.put(productCode, map11);
            }
            if (!AppMode.isHeadless()) {
                bucket = this.getBucket();
                if (bucket != null) {
                    Map<String, String> map22 = processBuilder.environment();
                    Intrinsics.checkNotNullExpressionValue(map22, (String)"environment(...)");
                    productCode = map22;
                    map11 = "RESHARPER_FUS_BUCKET";
                    object = String.valueOf((Integer)bucket);
                    productCode.put(map11, object);
                }
                if ((deviceId = this.getOrGenerateDeviceId()) != null) {
                    Map<String, String> map23 = processBuilder.environment();
                    Intrinsics.checkNotNullExpressionValue(map23, (String)"environment(...)");
                    map11 = map23;
                    object = "RESHARPER_FUS_DEVICEID";
                    String string5 = deviceId;
                    map11.put((String)object, string5);
                }
                String string6 = JetBrainsPermanentInstallationID.get();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"get(...)");
                installationId = string6;
                Map<String, String> map24 = processBuilder.environment();
                Intrinsics.checkNotNullExpressionValue(map24, (String)"environment(...)");
                object = map24;
                object.put("RESHARPER_FUS_USERID", installationId);
            }
            if (this.isInternal()) {
                if (Boolean.getBoolean("fus.internal.test.mode") || !((bucket = (CharSequence)System.getProperty("fus.recorder.internal.test.mode")) == null || StringsKt.isBlank(bucket))) {
                    Map<String, String> map25 = processBuilder.environment();
                    Intrinsics.checkNotNullExpressionValue(map25, (String)"environment(...)");
                    bucket = map25;
                    deviceId = "JETBRAINS_FUS_TRACE";
                    installationId = "true";
                    bucket.put((String)deviceId, (String)installationId);
                }
                if (SystemProperties.getBooleanProperty((String)"fus.internal.disable.data.submit", (boolean)false)) {
                    Map<String, String> map26 = processBuilder.environment();
                    Intrinsics.checkNotNullExpressionValue(map26, (String)"environment(...)");
                    bucket = map26;
                    deviceId = "JETBRAINS_FUS_DISABLE_DATA_SUBMIT";
                    installationId = "true";
                    bucket.put((String)deviceId, (String)installationId);
                }
            }
        }
        catch (Throwable t) {
            logger.error(t);
        }
        boolean bl = overrideReSharperPaths = ((CharSequence)overriddenReSharperSettingsDir).length() > 0;
        if (overrideReSharperPaths) {
            Map<String, String> map27 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map27, (String)"environment(...)");
            this.prepareReSharperHostSystemDir(map27, isFirstBackendProcess);
        }
        Map<String, String> map28 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map28, (String)"environment(...)");
        this.sanitizeEnvironment(map28);
        Map<String, String> envVars = processBuilder.environment();
        String string7 = this.getLocaleForBackend();
        if (string7 != null) {
            String it = string7;
            boolean bl3 = false;
            Intrinsics.checkNotNull(envVars);
            envVars.put("JET_BACKEND_CULTURE", it);
        }
        List<String> list = processBuilder.command();
        Intrinsics.checkNotNullExpressionValue(list, (String)"command(...)");
        String commandLine = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        logger.info("Start " + commandLine);
        if (logger.isTraceEnabled()) {
            logger.trace("Working directory: " + processBuilder.directory());
            Map<String, String> map29 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map29, (String)"environment(...)");
            if (!map29.isEmpty()) {
                logger.trace("Environment variables: ");
            }
            Map<String, String> map30 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map30, (String)"environment(...)");
            Map<String, String> $this$forEach$iv = map30;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry2 = element$iv = iterator.next();
                boolean bl4 = false;
                k = entry2.getKey();
                String v = entry2.getValue();
                logger.trace("  " + (String)k + "=" + v);
            }
        }
        processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        processBuilder.redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = processBuilder.start();
        long pid = process.pid();
        if (FileUtil.createDirectory((File)RiderLocalEnvironment.INSTANCE.getLogDirectory())) {
            logger.info("Log directory created: " + RiderLocalEnvironment.INSTANCE.getLogDirectory());
        }
        if (backendLogConfiguration.isPidIncludedInLogFileName()) {
            ProcessHandle processHandle = process.toHandle();
            Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"toHandle(...)");
            string = Companion.defaultLogFileNameBase(processHandle);
        } else {
            string = "backend";
        }
        String backendLogFileNameBase = string;
        Path path = RiderLocalEnvironment.INSTANCE.getLogDirectory().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path bl4 = path;
        Path path3 = bl4.resolve(backendLogFileNameBase + "-out.log");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path outFile = path3;
        Path path4 = RiderLocalEnvironment.INSTANCE.getLogDirectory().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toPath(...)");
        k = path4;
        Path path5 = k.resolve(backendLogFileNameBase + "-err.log");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        Path errFile = path5;
        this.setResharperProcessHandler(new BaseOSProcessHandler(process, commandLine, outFile, errFile, this){
            final /* synthetic */ Path $outFile;
            final /* synthetic */ Path $errFile;
            final /* synthetic */ ReSharperProcessBase this$0;
            {
                this.$outFile = $outFile;
                this.$errFile = $errFile;
                this.this$0 = $receiver;
                super($process, $commandLine, null);
            }

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
                return options;
            }

            public void notifyTextAvailable(String text, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                Key<?> key = outputType;
                if (Intrinsics.areEqual(key, (Object)ProcessOutputType.STDOUT)) {
                    File file = this.$outFile.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    FilesKt.appendText$default((File)file, (String)text, null, (int)2, null);
                } else if (Intrinsics.areEqual(key, (Object)ProcessOutputType.STDERR)) {
                    File file = this.$errFile.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    FilesKt.appendText$default((File)file, (String)text, null, (int)2, null);
                } else if (Intrinsics.areEqual(key, (Object)ProcessOutputType.SYSTEM)) {
                    File file = this.$errFile.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    FilesKt.appendText$default((File)file, (String)text, null, (int)2, null);
                } else {
                    ReSharperProcessBase.access$getLogger$cp().error("Unknown process output type for text: '" + text + "'");
                }
                InternalAutoBackendProfilingInfo internalProfilingInfo = this.this$0.getInternalProfilingInfo();
                char[] cArray = new char[]{'\ufeff'};
                String text2 = StringsKt.trimStart((String)text, (char[])cArray);
                if (internalProfilingInfo != null && StringsKt.startsWith$default((String)text2, (String)"##dotTrace[\"snapshot-saved", (boolean)false, (int)2, null)) {
                    ReSharperProcessBase.access$getLogger$cp().info("Detected snapshot saved.");
                    internalProfilingInfo.complete$intellij_rider_rdclient_dotnet();
                }
                super.notifyTextAvailable(text2, outputType);
            }
        });
        LifetimeDefinition processDefinition = new LifetimeDefinition();
        ProcessListener processListener2 = new ProcessListener(this, processDefinition, pid, errFile){
            final /* synthetic */ ReSharperProcessBase this$0;
            final /* synthetic */ LifetimeDefinition $processDefinition;
            final /* synthetic */ long $pid;
            final /* synthetic */ Path $errFile;
            {
                this.this$0 = $receiver;
                this.$processDefinition = $processDefinition;
                this.$pid = $pid;
                this.$errFile = $errFile;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.getResharperProcessHandler().removeProcessListener((ProcessListener)this);
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$processDefinition, (boolean)false, (int)1, null);
                int exitCode2 = event.getExitCode();
                if (this.this$0.getRequestShutdown().get() || !RLifetimeKt.isAlive((Lifetime)this.this$0.getLifetime())) {
                    String message = "Rider host process has exited by request with exit code " + exitCode2;
                    if (exitCode2 == 0) {
                        ReSharperProcessBase.access$getLogger$cp().info(message);
                    } else {
                        ReSharperProcessBase.access$getLogger$cp().warn(message);
                    }
                    return;
                }
                this.this$0.tryMoveDiagnosticReportToLogFolder(this.$pid, this.this$0.getLifetime());
                Attachment[] message = new Attachment[]{new Attachment("backend-err.log", PathsKt.readText$default((Path)this.$errFile, null, (int)1, null))};
                ReSharperProcessBase.access$getLogger$cp().error("Rider host (PID = " + this.$pid + ") has unexpectedly exited with exit code " + exitCode2 + ".", message);
                if (PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode()) {
                    ReSharperProcessBase.access$getLogger$cp().info("Perform exitProcess(6)");
                    String terminationDirectory = System.getenv("PROCESS_REQUEST_TERMINATION");
                    if (terminationDirectory != null) {
                        Path path = Paths.get(terminationDirectory, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        Path file = path.resolve(String.valueOf(OSProcessUtil.getCurrentProcessId()));
                        ReSharperProcessBase.access$getLogger$cp().warn("Request force termination. file: " + file);
                        Intrinsics.checkNotNull((Object)file);
                        PathsKt.writeText$default((Path)file, (CharSequence)"6", null, (OpenOption[])new OpenOption[0], (int)2, null);
                    }
                    System.exit(6);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                CriticalErrorApplicationTerminator.Companion.invokeLaterAfterAppStarted((Function2<? super ApplicationEx, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ApplicationEx, Continuation<? super Unit>, Object>(this.$errFile, this.this$0, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Path $errFile;
                    final /* synthetic */ ReSharperProcessBase this$0;
                    {
                        this.$errFile = $errFile;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        ApplicationEx applicationEx = (ApplicationEx)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void appEx;
                                ResultKt.throwOnFailure((Object)$result);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)appEx);
                                this.label = 1;
                                Object object2 = BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$errFile, this.this$0, (ApplicationEx)appEx, null){
                                    int label;
                                    final /* synthetic */ Path $errFile;
                                    final /* synthetic */ ReSharperProcessBase this$0;
                                    final /* synthetic */ ApplicationEx $appEx;
                                    {
                                        this.$errFile = $errFile;
                                        this.this$0 = $receiver;
                                        this.$appEx = $appEx;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                List possibleReasons = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])BackendCrashDiagnostics.Companion.getEP_NAME().getExtensions()), start.processListener.processTerminated.1::invokeSuspend$lambda$0));
                                                StringBuilder message = new StringBuilder();
                                                if (!((Collection)possibleReasons).isEmpty()) {
                                                    Iterable $this$forEach$iv = possibleReasons;
                                                    boolean $i$f$forEach = false;
                                                    for (T element$iv : $this$forEach$iv) {
                                                        String it = (String)element$iv;
                                                        boolean bl = false;
                                                        message.append(it).append('\n');
                                                    }
                                                } else {
                                                    message.append(RdClientDotnetBundle.INSTANCE.message("dialog.message.you.can.continue.to.work.but.full.functionality.will.be.available.after.restart", new Object[0])).append('\n');
                                                    StringBuilder $this$forEach$iv = message;
                                                    Object[] $i$f$forEach = new Object[1];
                                                    Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getProductName(), (String)"getProductName(...)");
                                                    $this$forEach$iv.append(RdClientDotnetBundle.INSTANCE.message("dialog.message.please.contact.ide.support.attach.zipped.log.folder", $i$f$forEach)).append('\n');
                                                    List crashReasons = com.jetbrains.rider.protocol.ReSharperProcessBase$Companion.access$extractCrashReasons(ReSharperProcessBase.Companion, this.$errFile);
                                                    if (!((Collection)crashReasons).isEmpty()) {
                                                        message.append('\n');
                                                        message.append(RdClientDotnetBundle.INSTANCE.message("dialog.message.possible.reasons", new Object[0])).append('\n');
                                                        Iterable $this$forEach$iv2 = crashReasons;
                                                        boolean $i$f$forEach2 = false;
                                                        for (T element$iv : $this$forEach$iv2) {
                                                            String it = (String)element$iv;
                                                            boolean bl = false;
                                                            message.append("\u2022 " + it).append('\n');
                                                        }
                                                    }
                                                }
                                                String string = message.toString();
                                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                                ReSharperProcessBase.access$showCrashDialog(this.this$0, this.$appEx, this.$errFile, string);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }

                                    private static final String invokeSuspend$lambda$0(BackendCrashAnalyzer it) {
                                        return it.tryGetFailReason();
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(ApplicationEx p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        };
        this.getResharperProcessHandler().addProcessListener(processListener2);
        this.getResharperProcessHandler().startNotify();
        RiderLocalEnvironment.INSTANCE.addRiderBackendProcess(this.getResharperProcessHandler());
        DotnetSelfProfilingProcesses.INSTANCE.add(processDefinition.getLifetime(), "Rider.Backend", (int)this.getBackendPid());
        logger.info("Rider backend PID: " + process.pid());
        if (this.getResharperProcessHandler().isProcessTerminated()) {
            logger.error("Rider host exited while initializing. See " + errFile);
        }
    }

    @Nullable
    public abstract String getLocaleForBackend();

    private final void showCrashDialog(ApplicationEx appEx, Path errFile, String message) {
        String string = RdClientDotnetBundle.INSTANCE.message("dialog.title.critical.failure.has.occurred", new Object[0]);
        String[] stringArray = new String[4];
        stringArray[0] = Messages.getOkButton();
        stringArray[1] = RdClientDotnetBundle.INSTANCE.message("button.restart", new Object[0]);
        stringArray[2] = RdClientDotnetBundle.INSTANCE.message("button.contact.support", new Object[0]);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)RevealFileAction.getFileManagerName(), (String)"getFileManagerName(...)");
        stringArray[3] = RdClientDotnetBundle.INSTANCE.message("button.show.log.in", objectArray);
        int dialogResult = MessagesEx.showDialog((String)message, (String)string, (String[])stringArray, (int)0, (Icon)UIUtil.getErrorIcon());
        switch (dialogResult) {
            case 1: {
                appEx.exit(true, false, true);
                break;
            }
            case 2: {
                this.contactSupport();
                this.showCrashDialog(appEx, errFile, message);
                break;
            }
            case 3: {
                RevealFileAction.openFile((Path)errFile);
                this.showCrashDialog(appEx, errFile, message);
            }
        }
    }

    private final void contactSupport() {
        block1: {
            Function1 function1 = ExternalProductResourceUrls.Companion.getInstance().getTechnicalSupportUrl();
            if (function1 == null) break block1;
            Function1 url2 = function1;
            boolean bl = false;
            boolean $i$f$service = false;
            Class<ReportFeedbackService> serviceClass$iv = ReportFeedbackService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            BuildersKt.launch$default((CoroutineScope)((ReportFeedbackService)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super String, ? extends Url>)url2, null){
                Object L$0;
                int label;
                final /* synthetic */ Function1<String, Url> $url;
                {
                    this.$url = $url;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = var2_3 = this.$url;
                            this.label = 1;
                            v0 = SendFeedbackAction.Companion.getDescription(null, (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            var2_3 = (Function1<String, Url>)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            BrowserUtil.browse((String)((Url)var2_3.invoke(v0)).toExternalForm());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void withBackendProfiling(ProcessBuilder processBuilder) {
        DotnetSelfProfiler.SnapshotKind kind;
        boolean useGlobalTool;
        String additionalArgs;
        Path snapshotDir;
        String snapshotKind;
        block10: {
            DotnetSelfProfiler.SnapshotKind snapshotKind2;
            snapshotKind = this.tryGetSnapshotKind();
            ReSharperProcessBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger22 = false;
            Logger logger = Logger.getInstance(ReSharperProcessBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("snapshotKind: " + snapshotKind);
            String string = System.getProperty("rider.backend.JET_SNAPSHOT_DIR");
            if (string == null) {
                string = FilesKt.resolve((File)RiderLocalEnvironment.INSTANCE.getLogDirectory(), (String)"BackendSnapshot").getAbsolutePath();
            }
            String $i$f$thisLogger22 = string;
            Intrinsics.checkNotNull((Object)$i$f$thisLogger22);
            Path path = Paths.get($i$f$thisLogger22, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            snapshotDir = path;
            ReSharperProcessBase $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(ReSharperProcessBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("snapshotDir: " + snapshotDir);
            String string2 = System.getProperty("rider.backend.JET_PROFILER_ARGS");
            if (string2 == null) {
                string2 = "";
            }
            additionalArgs = string2;
            ReSharperProcessBase $this$thisLogger$iv3 = this;
            boolean $i$f$thisLogger3 = false;
            Logger logger3 = Logger.getInstance(ReSharperProcessBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.info("additionalArgs: " + additionalArgs);
            useGlobalTool = System.getProperty(InternalAutoBackendProfilingInfo.Companion.getRIDER_BACKEND_JET_PROFILER_USE_GLOBAL()) != null;
            ReSharperProcessBase $this$thisLogger$iv4 = this;
            boolean $i$f$thisLogger4 = false;
            Logger logger4 = Logger.getInstance(ReSharperProcessBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
            logger4.info("useGlobalTool: " + useGlobalTool);
            DotnetSelfProfiler.SnapshotKind[] $this$firstOrNull$iv = DotnetSelfProfiler.SnapshotKind.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                DotnetSelfProfiler.SnapshotKind element$iv;
                DotnetSelfProfiler.SnapshotKind it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!StringsKt.equals((String)it.name(), (String)snapshotKind, (boolean)true)) continue;
                snapshotKind2 = element$iv;
                break block10;
            }
            snapshotKind2 = kind = null;
        }
        if (kind != null) {
            try {
                boolean isTestMode;
                boolean bl = isTestMode = PerformancePlaybackTestsKt.getApplicationIsPerforatorTestMode() || this.isUnitTesting() || PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode();
                if (useGlobalTool && (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) && !isTestMode) {
                    this.runBlockingTryCancellable((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                        int label;

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    ReSharperProcessBase.access$getLogger$cp().info("Install global tool");
                                    this.label = 1;
                                    v0 = DotTraceGlobalTool.INSTANCE.install((Continuation<? super Boolean>)((Continuation)this));
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl14
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl14:
                                    // 2 sources

                                    success = (Boolean)v0;
                                    ReSharperProcessBase.access$getLogger$cp().info("Install global tool is finsihed. Success = " + (success != false));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                    Path path = FileUtilRt.createTempDirectory((File)snapshotDir.toFile(), (String)"snapshot", null).toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    snapshotDir = path;
                }
                File file = FileUtilRt.createTempFile((File)snapshotDir.toFile(), (String)"input", (String)".txt", (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
                File inputFile = file;
                if (!isTestMode) {
                    File file2 = snapshotDir.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                    this.internalProfilingInfo = new InternalAutoBackendProfilingInfo(inputFile, file2);
                }
                GeneralCommandLine profilerCommandLine = DotnetSelfProfiler.Companion.startUnderProfilerCommandLine(new ProfilerArgs(kind, additionalArgs, useGlobalTool, inputFile), snapshotDir);
                List list = profilerCommandLine.getParametersList().getList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
                List args = list;
                processBuilder.command().add(0, profilerCommandLine.getExePath());
                processBuilder.command().addAll(1, args);
                processBuilder.command().add(args.size() + 2, "--");
                Map map = profilerCommandLine.getEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
                Map $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map<String, String> map2;
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(processBuilder.environment(), (String)"environment(...)");
                    Object k = it.getKey();
                    Object v = it.getValue();
                    map2.put((String)k, (String)v);
                }
            }
            catch (Throwable e) {
                ReSharperProcessBase $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ReSharperProcessBase.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e);
            }
        } else {
            ReSharperProcessBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ReSharperProcessBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("snapshotKind: " + snapshotKind + " is unknown");
        }
    }

    private final String tryGetSnapshotKind() {
        return System.getProperty(InternalAutoBackendProfilingInfo.Companion.getRIDER_BACKEND_JET_RUN_WITH_SNAPSHOT());
    }

    private final Integer getBucket() {
        String string = this.getOrGenerateDeviceId();
        if (string == null) {
            return null;
        }
        String deviceId = string;
        return this.asBucket(deviceId);
    }

    private final String getOrGenerateDeviceId() {
        String string;
        String recorderId = "FUS";
        try {
            string = DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)recorderId);
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException invalidDeviceIdTokenException) {
            logger.warn("Failed retrieving device id for " + recorderId);
            string = null;
        }
        return string;
    }

    private final String asBuildNumber(BuildNumber $this$asBuildNumber) {
        String string = $this$asBuildNumber.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringWithoutProductCodeAndSnapshot(...)");
        String str = string;
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String getPathForBackendSettings() {
        String result2 = ((Object)((Path)resharperHostConfigDir.getValue()).toAbsolutePath()).toString();
        try {
            String string = PathManager.getConfigPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConfigPath(...)");
            String string2 = string;
            Object object = new String[]{"options\\resharper.xml"};
            Path path = Paths.get(string2, Arrays.copyOf(object, ((String[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path file = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return result2;
            }
            char[] cArray = FileUtil.loadFileText((File)file.toFile(), (Charset)StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"loadFileText(...)");
            object = cArray;
            String loadFileText = new String((char[])object);
            for (String line : StringsKt.lines((CharSequence)loadFileText)) {
                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"syncWithReSharper", (boolean)false, (int)2, null)) continue;
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)"true", (boolean)false, (int)2, null)) {
                    result2 = "";
                }
                break;
            }
        }
        catch (Throwable t) {
            logger.warn("could not parse ide.general.xml with exception:\n", t);
            return result2;
        }
        logger.info("successfully parsed resharper.xml. Backend's config path will be '" + result2 + "'");
        return result2;
    }

    private final <T> T runBlockingTryCancellable(Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action2) {
        Application application = ApplicationManager.getApplication();
        return (T)(application == null ? BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(action2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$action = $action;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$runBlocking;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlocking);
                        this.label = 1;
                        Object object2 = this.$action.invoke((Object)$this$runBlocking, (Object)((Object)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)1, null) : CoroutinesKt.runBlockingMaybeCancellable((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(action2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$action = $action;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$runBlockingMaybeCancellable;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlockingMaybeCancellable);
                        this.label = 1;
                        Object object2 = this.$action.invoke((Object)$this$runBlockingMaybeCancellable, (Object)((Object)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final void waitFor$lambda$0$0(Function0 $afterShutdown) {
        $afterShutdown.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit waitFor$lambda$0(ReSharperProcessBase this$0, Application $app, Function0 $afterShutdown) {
        try {
            if (!this$0.getResharperProcessHandler().isProcessTerminated() && !this$0.getResharperProcessHandler().waitFor(this$0.getShutdownTimeout())) {
                long pid = this$0.getResharperProcessHandler().getProcess().pid();
                String backendType = this$0.isLightweight ? "lightweight" : "full";
                String message = "Rider " + backendType + " backend process (PID: " + pid + ") has not gracefully exited within " + this$0.getShutdownTimeout();
                if (!this$0.isLightweight) {
                    logger.error(message + " ms and will be killed");
                }
                ClrProcessThreadDumpUtilKt.requestThreadDumpForClrProcessesBlocking$default(CollectThreadDumpRequest.Companion.automaticAllowMainThread(message), pid, null, 4, null);
                this$0.getResharperProcessHandler().destroyProcess();
            }
        }
        finally {
            if ($app.isDispatchThread()) {
                $afterShutdown.invoke();
            } else {
                $app.invokeLater(() -> ReSharperProcessBase.waitFor$lambda$0$0($afterShutdown));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void waitFor$lambda$1(Function0 $shutdownAction) {
        $shutdownAction.invoke();
    }

    private static final Unit tryMoveDiagnosticReportToLogFolder$lambda$0(Lifetime $lifetime, HashSet $scannedFiles, Regex $pidRegex, String $pidStr, Path $logDirectory) {
        for (int i = 1; i < 11; ++i) {
            Unit unit;
            Thread.sleep(500L);
            if (RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
                return Unit.INSTANCE;
            }
            logger.info("Attempt " + i + " to attach crash report");
            Logger $this$catchWarn_u24default$iv = logger;
            String message$iv = null;
            boolean $i$f$catchWarn = false;
            try {
                String string;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)System.getProperty("user.home"), (String)"getProperty(...)");
                String[] stringArray = new String[]{"Library/Logs/DiagnosticReports"};
                Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Sequence $this$forEach$iv = PathsKt.walk((Path)path, (PathWalkOption[])new PathWalkOption[0]);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MatchResult m;
                    Path reportFile = (Path)element$iv;
                    boolean bl2 = false;
                    if (RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
                        return Unit.INSTANCE;
                    }
                    if ($scannedFiles.contains(((Object)reportFile.toAbsolutePath()).toString())) continue;
                    $scannedFiles.add(((Object)reportFile.toAbsolutePath()).toString());
                    if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)reportFile), (Object)"crash")) continue;
                    Path path2 = reportFile;
                    Object object = new LinkOption[]{};
                    FileTime fileTime = Files.getLastModifiedTime(path2, Arrays.copyOf(object, ((LinkOption[])object).length));
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                    if (Duration.between(fileTime.toInstant(), Clock.systemUTC().instant()).getSeconds() > 60L || !StringsKt.startsWith$default((String)PathsKt.getName((Path)reportFile), (String)"dotnet_", (boolean)false, (int)2, null)) continue;
                    object = reportFile;
                    Object object2 = new OpenOption[]{};
                    Comparable<Charset> comparable = Charsets.UTF_8;
                    int n = 8192;
                    String firstLine = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length)), (Charset)comparable), n).readLine();
                    System.out.println((Object)firstLine);
                    Intrinsics.checkNotNull((Object)firstLine);
                    if (Regex.find$default((Regex)$pidRegex, (CharSequence)firstLine, (int)0, (int)2, null) == null || !Intrinsics.areEqual(m.getGroupValues().get(1), (Object)$pidStr)) continue;
                    Intrinsics.checkNotNull((Object)$logDirectory);
                    comparable = $logDirectory;
                    Object object3 = new LinkOption[]{};
                    if (!Files.exists((Path)comparable, Arrays.copyOf(object3, ((LinkOption[])object3).length))) {
                        PathKt.createDirectories((Path)$logDirectory);
                    }
                    Path backendCrashReport = $logDirectory.resolve(PathsKt.getName((Path)reportFile));
                    object3 = reportFile;
                    Intrinsics.checkNotNull((Object)backendCrashReport);
                    object2 = backendCrashReport;
                    CopyOption[] copyOptionArray = new CopyOption[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object3, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                    object3 = new Attachment[]{new Attachment(PathsKt.getName((Path)reportFile), PathsKt.readText$default((Path)reportFile, null, (int)1, null))};
                    logger.error("Rider backend crashed", (Attachment[])object3);
                    return Unit.INSTANCE;
                }
                unit = Unit.INSTANCE;
                continue;
            }
            catch (ProcessCanceledException e$iv) {
                throw e$iv;
            }
            catch (CancellationException e$iv) {
                throw e$iv;
            }
            catch (Throwable e$iv) {
                $this$catchWarn_u24default$iv.warn(message$iv, e$iv);
                unit = null;
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTemporaryLifetimedFile$lambda$0$0(File $it) {
        try {
            $it.delete();
        }
        catch (Throwable ex) {
            logger.warn("Can't delete " + $it, ex);
        }
        return Unit.INSTANCE;
    }

    private static final Path resharperHostConfigDir$lambda$0() {
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        Path path2 = path;
        Path path3 = path2.resolve("resharper-host");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        return path3;
    }

    private static final Path resharperHostSystemDir$lambda$0() {
        Path path = PathManager.getSystemDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getSystemDir(...)");
        Path path2 = path;
        Path path3 = path2.resolve("resharper-host");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        return path3;
    }

    private static final Path resharperHostSystemInvalidateFlag$lambda$0() {
        return ((Path)resharperHostSystemDir.getValue()).resolve(".invalidate.all");
    }

    public static final /* synthetic */ void access$showCrashDialog(ReSharperProcessBase $this, ApplicationEx appEx, Path errFile, String message) {
        $this.showCrashDialog(appEx, errFile, message);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReSharperProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ReSharperProcessBase.logger = logger;
        shouldImportReSharperSettings = true;
        fullBackendShutdownTimeout = Duration.ofMinutes(1L).toMillis();
        lightweightBackendShutdownTimeout = Duration.ofMillis(500L).toMillis();
        resharperHostConfigDir = LazyKt.lazy(ReSharperProcessBase::resharperHostConfigDir$lambda$0);
        resharperHostSystemDir = LazyKt.lazy(ReSharperProcessBase::resharperHostSystemDir$lambda$0);
        resharperHostSystemInvalidateFlag = LazyKt.lazy(ReSharperProcessBase::resharperHostSystemInvalidateFlag$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$BackendLogConfiguration;", "", "isPidIncludedInLogFileName", "", "logConfigurationFilePath", "Ljava/nio/file/Path;", "<init>", "(ZLjava/nio/file/Path;)V", "()Z", "getLogConfigurationFilePath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rider.rdclient.dotnet"})
    public static final class BackendLogConfiguration {
        private final boolean isPidIncludedInLogFileName;
        @NotNull
        private final Path logConfigurationFilePath;

        public BackendLogConfiguration(boolean isPidIncludedInLogFileName, @NotNull Path logConfigurationFilePath) {
            Intrinsics.checkNotNullParameter((Object)logConfigurationFilePath, (String)"logConfigurationFilePath");
            this.isPidIncludedInLogFileName = isPidIncludedInLogFileName;
            this.logConfigurationFilePath = logConfigurationFilePath;
        }

        public final boolean isPidIncludedInLogFileName() {
            return this.isPidIncludedInLogFileName;
        }

        @NotNull
        public final Path getLogConfigurationFilePath() {
            return this.logConfigurationFilePath;
        }

        public final boolean component1() {
            return this.isPidIncludedInLogFileName;
        }

        @NotNull
        public final Path component2() {
            return this.logConfigurationFilePath;
        }

        @NotNull
        public final BackendLogConfiguration copy(boolean isPidIncludedInLogFileName, @NotNull Path logConfigurationFilePath) {
            Intrinsics.checkNotNullParameter((Object)logConfigurationFilePath, (String)"logConfigurationFilePath");
            return new BackendLogConfiguration(isPidIncludedInLogFileName, logConfigurationFilePath);
        }

        public static /* synthetic */ BackendLogConfiguration copy$default(BackendLogConfiguration backendLogConfiguration, boolean bl, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                bl = backendLogConfiguration.isPidIncludedInLogFileName;
            }
            if ((n & 2) != 0) {
                path = backendLogConfiguration.logConfigurationFilePath;
            }
            return backendLogConfiguration.copy(bl, path);
        }

        @NotNull
        public String toString() {
            return "BackendLogConfiguration(isPidIncludedInLogFileName=" + this.isPidIncludedInLogFileName + ", logConfigurationFilePath=" + this.logConfigurationFilePath + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isPidIncludedInLogFileName);
            result2 = result2 * 31 + ((Object)this.logConfigurationFilePath).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BackendLogConfiguration)) {
                return false;
            }
            BackendLogConfiguration backendLogConfiguration = (BackendLogConfiguration)other;
            if (this.isPidIncludedInLogFileName != backendLogConfiguration.isPidIncludedInLogFileName) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.logConfigurationFilePath, (Object)backendLogConfiguration.logConfigurationFilePath);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'2\u0006\u0010(\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "processIdIncrement", "", "getProcessIdIncrement", "()I", "setProcessIdIncrement", "(I)V", "shouldImportReSharperSettings", "", "getShouldImportReSharperSettings", "()Z", "setShouldImportReSharperSettings", "(Z)V", "fullBackendShutdownTimeout", "", "getFullBackendShutdownTimeout", "()J", "lightweightBackendShutdownTimeout", "getLightweightBackendShutdownTimeout", "resharperHostConfigDir", "Lkotlin/Lazy;", "Ljava/nio/file/Path;", "getResharperHostConfigDir", "()Lkotlin/Lazy;", "resharperHostSystemDir", "resharperHostSystemInvalidateFlag", "getResharperHostSystemInvalidateFlag", "invalidateCachesOnNextRiderStart", "", "defaultLogFileNameBase", "", "process", "Ljava/lang/ProcessHandle;", "extractCrashReasons", "", "errorLogFile", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nReSharperProcessBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/ReSharperProcessBase$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1022:1\n125#2,4:1023\n*S KotlinDebug\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/ReSharperProcessBase$Companion\n*L\n936#1:1023,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getProcessIdIncrement() {
            return processIdIncrement;
        }

        public final void setProcessIdIncrement(int n) {
            processIdIncrement = n;
        }

        public final boolean getShouldImportReSharperSettings() {
            return shouldImportReSharperSettings;
        }

        public final void setShouldImportReSharperSettings(boolean bl) {
            shouldImportReSharperSettings = bl;
        }

        public final long getFullBackendShutdownTimeout() {
            return fullBackendShutdownTimeout;
        }

        public final long getLightweightBackendShutdownTimeout() {
            return lightweightBackendShutdownTimeout;
        }

        @NotNull
        protected final Lazy<Path> getResharperHostConfigDir() {
            return resharperHostConfigDir;
        }

        @NotNull
        protected final Lazy<Path> getResharperHostSystemInvalidateFlag() {
            return resharperHostSystemInvalidateFlag;
        }

        public final void invalidateCachesOnNextRiderStart() {
            PathKt.createParentDirectories((Path)((Path)this.getResharperHostSystemInvalidateFlag().getValue()));
            PathsKt.writeText$default((Path)((Path)this.getResharperHostSystemInvalidateFlag().getValue()), (CharSequence)"", null, (OpenOption[])new OpenOption[0], (int)2, null);
        }

        @NotNull
        public final String defaultLogFileNameBase(@NotNull ProcessHandle process) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)process, (String)"process");
                    Optional<Instant> optional = process.info().startInstant();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"startInstant(...)");
                    object = (Instant)OptionalsKt.getOrNull(optional);
                    if (object == null) break block2;
                    Instant it = object;
                    boolean bl = false;
                    String string = DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmm").format(it.atZone(ZoneId.systemDefault()));
                    object = string;
                    if (string != null) break block3;
                }
                object = "0000-00-00_0000";
            }
            Object startTime = object;
            return "backend." + (String)startTime + "." + process.pid();
        }

        private final List<String> extractCrashReasons(Path errorLogFile) {
            List list;
            Object $this$extractCrashReasons_u24lambda_u240;
            Companion companion = this;
            try {
                $this$extractCrashReasons_u24lambda_u240 = companion;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(errorLogFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return CollectionsKt.emptyList();
                }
                List<String> list2 = Files.readAllLines(errorLogFile, Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
                List<String> lines = list2;
                $this$extractCrashReasons_u24lambda_u240 = Result.constructor-impl((Object)BackendCrashDiagnostics.Companion.extractCrashReasons$default(BackendCrashDiagnostics.Companion, lines, 0, 2, null));
            }
            catch (Throwable throwable) {
                $this$extractCrashReasons_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object $this$getOrHandleException$iv = $this$extractCrashReasons_u24lambda_u240;
            boolean $i$f$getOrHandleException = false;
            Object object = $this$getOrHandleException$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable e$iv = throwable;
                boolean bl = false;
                LoggerKt.rethrowControlFlowException((Throwable)e$iv);
                Throwable it = e$iv;
                boolean bl2 = false;
                logger.warn("Cannot read " + errorLogFile, it);
            }
            if ((list = (List)(Result.isFailure-impl((Object)object) ? null : object)) == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public static final /* synthetic */ List access$extractCrashReasons(Companion $this, Path errorLogFile) {
            return $this.extractCrashReasons(errorLogFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$PlaybackCrash;", "", "<init>", "()V", "BACKEND_CRASH_EXIT_CODE", "", "PROCESS_REQUEST_TERMINATION_DIRECTORY", "", "IDEA_FUS_RECORDER_INTERNAL_MODE", "IDEA_RECORDER_INTERNAL_MODE", "intellij.rider.rdclient.dotnet"})
    public static final class PlaybackCrash {
        @NotNull
        public static final PlaybackCrash INSTANCE = new PlaybackCrash();
        public static final int BACKEND_CRASH_EXIT_CODE = 6;
        @NotNull
        public static final String PROCESS_REQUEST_TERMINATION_DIRECTORY = "PROCESS_REQUEST_TERMINATION";
        @NotNull
        public static final String IDEA_FUS_RECORDER_INTERNAL_MODE = "fus.internal.test.mode";
        @NotNull
        public static final String IDEA_RECORDER_INTERNAL_MODE = "fus.recorder.internal.test.mode";

        private PlaybackCrash() {
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0011R\u0010\u0010\u0012\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0013R\u0010\u0010\u0014\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0015R\u0010\u0010\u0016\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0017R\u0010\u0010\u0018\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0019R\u0010\u0010\u001a\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u001bR\u0010\u0010\u001c\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u001d\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$VersionRecord;", "", "<init>", "()V", "myFullVersionFormat", "", "myMajorVersion", "myMinorVersion", "myMicroVersion", "myPatchVersion", "myVersionSuffix", "getFullVersion", "getChild", "Lcom/intellij/util/xml/dom/XmlElement;", "parentNode", "name", "ELEMENT_VERSION", "ELEMENT_VERSION$1", "ATTRIBUTE_MAJOR", "ATTRIBUTE_MAJOR$1", "ATTRIBUTE_MINOR", "ATTRIBUTE_MINOR$1", "ATTRIBUTE_MICRO", "ATTRIBUTE_MICRO$1", "ATTRIBUTE_PATCH", "ATTRIBUTE_PATCH$1", "ATTRIBUTE_FULL", "ATTRIBUTE_FULL$1", "ATTRIBUTE_EAP", "ATTRIBUTE_EAP$1", "loadState", "", "loadState$intellij_rider_rdclient_dotnet", "Companion", "intellij.rider.rdclient.dotnet"})
    public static final class VersionRecord {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String myFullVersionFormat;
        @Nullable
        private String myMajorVersion = "";
        @Nullable
        private String myMinorVersion = "";
        @Nullable
        private String myMicroVersion = "";
        @Nullable
        private String myPatchVersion = "";
        @Nullable
        private String myVersionSuffix = "";
        @NotNull
        private final String ELEMENT_VERSION$1;
        @NotNull
        private final String ATTRIBUTE_MAJOR$1;
        @NotNull
        private final String ATTRIBUTE_MINOR$1;
        @NotNull
        private final String ATTRIBUTE_MICRO$1;
        @NotNull
        private final String ATTRIBUTE_PATCH$1;
        @NotNull
        private final String ATTRIBUTE_FULL$1;
        @NotNull
        private final String ATTRIBUTE_EAP$1;
        @NotNull
        private static final String IDEA_PATH = "/idea/";
        @NotNull
        private static final String ELEMENT_VERSION = "version";
        @NotNull
        private static final String ATTRIBUTE_MAJOR = "major";
        @NotNull
        private static final String ATTRIBUTE_MINOR = "minor";
        @NotNull
        private static final String ATTRIBUTE_MICRO = "micro";
        @NotNull
        private static final String ATTRIBUTE_PATCH = "patch";
        @NotNull
        private static final String ATTRIBUTE_FULL = "full";
        @NotNull
        private static final String APP_INFO_XML_SUFFIX = "ApplicationInfo.xml";
        @NotNull
        private static final String ATTRIBUTE_EAP = "eap";

        public VersionRecord() {
            this.ELEMENT_VERSION$1 = ELEMENT_VERSION;
            this.ATTRIBUTE_MAJOR$1 = ATTRIBUTE_MAJOR;
            this.ATTRIBUTE_MINOR$1 = ATTRIBUTE_MINOR;
            this.ATTRIBUTE_MICRO$1 = ATTRIBUTE_MICRO;
            this.ATTRIBUTE_PATCH$1 = ATTRIBUTE_PATCH;
            this.ATTRIBUTE_FULL$1 = ATTRIBUTE_FULL;
            this.ATTRIBUTE_EAP$1 = ATTRIBUTE_EAP;
        }

        @NotNull
        public final String getFullVersion() {
            String result2;
            Object[] objectArray;
            if (this.myFullVersionFormat != null) {
                String string = this.myFullVersionFormat;
                if (string == null) {
                    string = "";
                }
                objectArray = new Object[]{this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion};
                v1 = MessageFormat.format(string, objectArray);
            } else {
                v1 = result2 = StringUtil.notNullize((String)this.myMajorVersion, (String)"0") + "." + StringUtil.notNullize((String)this.myMinorVersion, (String)"0");
            }
            if (!StringUtil.isEmpty((String)this.myVersionSuffix)) {
                result2 = result2 + " " + this.myVersionSuffix;
            }
            objectArray = result2;
            Intrinsics.checkNotNull((Object)objectArray);
            return objectArray;
        }

        private final XmlElement getChild(XmlElement parentNode, String name) {
            return parentNode.getChild(name);
        }

        public final void loadState$intellij_rider_rdclient_dotnet(@NotNull XmlElement parentNode) {
            Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
            XmlElement versionElement = this.getChild(parentNode, this.ELEMENT_VERSION$1);
            if (versionElement != null) {
                this.myMajorVersion = versionElement.getAttributeValue(this.ATTRIBUTE_MAJOR$1);
                this.myMinorVersion = versionElement.getAttributeValue(this.ATTRIBUTE_MINOR$1);
                this.myMicroVersion = versionElement.getAttributeValue(this.ATTRIBUTE_MICRO$1);
                this.myPatchVersion = versionElement.getAttributeValue(this.ATTRIBUTE_PATCH$1);
                this.myFullVersionFormat = versionElement.getAttributeValue(this.ATTRIBUTE_FULL$1);
                boolean eap = Boolean.parseBoolean(versionElement.getAttributeValue(this.ATTRIBUTE_EAP$1));
                this.myVersionSuffix = versionElement.getAttributeValue("suffix");
                if (this.myVersionSuffix == null && eap) {
                    this.myVersionSuffix = "EAP";
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$VersionRecord$Companion;", "", "<init>", "()V", "IDEA_PATH", "", "ELEMENT_VERSION", "ATTRIBUTE_MAJOR", "ATTRIBUTE_MINOR", "ATTRIBUTE_MICRO", "ATTRIBUTE_PATCH", "ATTRIBUTE_FULL", "APP_INFO_XML_SUFFIX", "ATTRIBUTE_EAP", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

