/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DetectableIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.editorActions.RiderTypedHandlersSupport;
import com.jetbrains.rider.model.IndentSettings;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.settings.RiderPrefetchedIndentOptions;
import com.jetbrains.rider.settings.RiderSmartTabsBackendSynchronizer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/settings/RiderFileIndentOptionsProvider;", "Lcom/intellij/psi/codeStyle/FileIndentOptionsProvider;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "showAutodetectIndentOptions", "", "isApplicableForFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "getIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getIndentStatusBarUiContributor", "Lcom/intellij/psi/codeStyle/IndentStatusBarUIContributor;", "indentOptions", "getActivatingAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "activeUiContributor", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleStatusBarUIContributor;", "file", "AutodetectUIContributor", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderFileIndentOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFileIndentOptionsProvider.kt\ncom/jetbrains/rider/settings/RiderFileIndentOptionsProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,189:1\n67#2,4:190\n67#2,4:194\n67#2,4:198\n67#2,4:202\n*S KotlinDebug\n*F\n+ 1 RiderFileIndentOptionsProvider.kt\ncom/jetbrains/rider/settings/RiderFileIndentOptionsProvider\n*L\n45#1:190,4\n65#1:194,4\n85#1:198,4\n128#1:202,4\n*E\n"})
public final class RiderFileIndentOptionsProvider
extends FileIndentOptionsProvider {
    @NotNull
    private final Logger logger;
    private boolean showAutodetectIndentOptions;

    public RiderFileIndentOptionsProvider() {
        Logger logger = Logger.getInstance(RiderFileIndentOptionsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    private final boolean isApplicableForFile(PsiFile psiFile) {
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        FrontendTypedHandler frontendTypedHandler = RiderTypedHandlersSupport.forLanguage(language);
        return frontendTypedHandler != null ? frontendTypedHandler.isAvailable(psiFile) : false;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        EditorSynchronizer editorSynchronizer;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        ApplicationKt.getApplication().assertReadAccessAllowed();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "` start");
        }
        if (!this.isApplicableForFile(psiFile)) {
            return null;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (project2.isDisposed()) {
            return null;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = psiDocumentManager.getDocument(psiFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Object object = settings.getIndentOptions(psiFile.getFileType()).clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.codeStyle.CommonCodeStyleSettings.IndentOptions");
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)object;
        Editor[] editorArray = EditorFactory.getInstance().getEditors(document2, project2);
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
        Editor editor = (Editor)ArraysKt.firstOrNull((Object[])editorArray);
        Object object2 = editorSynchronizer = editor != null ? DocumentExKt.getEditorSynchronizer((Editor)editor) : null;
        if (editorSynchronizer != null) {
            boolean newSmartTabs;
            boolean bl;
            Integer n = EditorSynchronizerKt.getTabSize((EditorSynchronizer)editorSynchronizer);
            int newTabSize = n != null ? n : indentOptions.TAB_SIZE;
            Logger $this$trace$iv2 = this.logger;
            boolean $i$f$trace22 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl2 = false;
                logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`. Tab size is `" + newTabSize + "`.");
            }
            boolean bl3 = $this$trace$iv2 = newTabSize >= 0;
            if (_Assertions.ENABLED && !$this$trace$iv2) {
                String $i$f$trace22 = "Assertion failed";
                throw new AssertionError((Object)$i$f$trace22);
            }
            Integer n2 = EditorSynchronizerKt.getIndentSize((EditorSynchronizer)editorSynchronizer);
            int newIndentSize = n2 != null ? n2 : indentOptions.INDENT_SIZE;
            boolean bl4 = $i$f$trace22 = newIndentSize >= 0;
            if (_Assertions.ENABLED && !$i$f$trace22) {
                String bl2 = "Assertion failed";
                throw new AssertionError((Object)bl2);
            }
            Boolean bl5 = EditorSynchronizerKt.getUseTab((EditorSynchronizer)editorSynchronizer);
            boolean newUseTab = bl5 != null ? bl5 : indentOptions.USE_TAB_CHARACTER;
            Integer n3 = EditorSynchronizerKt.getContinuousIndentSize((EditorSynchronizer)editorSynchronizer);
            int newContinuationIndentSize = n3 != null ? n3 : indentOptions.CONTINUATION_INDENT_SIZE;
            boolean bl6 = bl = newContinuationIndentSize >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean shouldSynchronizeSmartTabs = RiderSmartTabsBackendSynchronizer.Companion.shouldSynchronize(psiFile);
            if (shouldSynchronizeSmartTabs) {
                Boolean bl7 = EditorSynchronizerKt.getSmartTabs((EditorSynchronizer)editorSynchronizer);
                v14 = bl7 != null ? bl7 : indentOptions.SMART_TABS;
            } else {
                v14 = newSmartTabs = indentOptions.SMART_TABS;
            }
            if (indentOptions.TAB_SIZE != newTabSize || newIndentSize != indentOptions.INDENT_SIZE || newUseTab != indentOptions.USE_TAB_CHARACTER || newContinuationIndentSize != indentOptions.CONTINUATION_INDENT_SIZE || newSmartTabs != indentOptions.SMART_TABS || !indentOptions.isOverrideLanguageOptions()) {
                Logger $this$trace$iv3 = this.logger;
                boolean $i$f$trace3 = false;
                if ($this$trace$iv3.isTraceEnabled()) {
                    logger = $this$trace$iv3;
                    boolean bl8 = false;
                    logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`: overriding settings");
                }
                indentOptions.setOverrideLanguageOptions(true);
                indentOptions.TAB_SIZE = newTabSize;
                indentOptions.INDENT_SIZE = newIndentSize;
                indentOptions.USE_TAB_CHARACTER = newUseTab;
                indentOptions.CONTINUATION_INDENT_SIZE = newContinuationIndentSize;
                if (shouldSynchronizeSmartTabs) {
                    indentOptions.SMART_TABS = newSmartTabs;
                }
                return RiderFileIndentOptionsProvider.getIndentOptions$takeIndentResponsibilities(this, settings, indentOptions);
            }
        } else {
            VirtualFile originalFile;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            VirtualFile virtualFile2 = originalFile = virtualFile instanceof LightVirtualFile ? ((LightVirtualFile)virtualFile).getOriginalFile() : virtualFile;
            if (originalFile == null) {
                return null;
            }
            if (!PatchEngineRegistryKt.isPatchEngineEnabled() && TextBufferDocumentSynchronizer.Companion.isBackendUpdateInProgress(document2, FrontendSessionsUtilKt.getFrontendProjectSession((Project)project2).getAppSession())) {
                return null;
            }
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
            if (workspaceModel == null) {
                return null;
            }
            WorkspaceModel workspaceModel2 = workspaceModel;
            int entityId = com.jetbrains.rider.document.DocumentExKt.findBestProjectModelIdForDocument(WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel2, originalFile, project2), project2);
            if (entityId == 0) {
                return null;
            }
            RiderPrefetchedIndentOptions prefetchedIndentOptions = RiderPrefetchedIndentOptions.Companion.getInstance(project2);
            IndentSettings result2 = prefetchedIndentOptions.getIndentSettings(entityId);
            if (result2 == null) {
                return null;
            }
            boolean shouldSynchronizeSmartTabs = RiderSmartTabsBackendSynchronizer.Companion.shouldSynchronize(psiFile);
            if (indentOptions.TAB_SIZE != result2.getTabSize() || result2.getIndentSize() != indentOptions.INDENT_SIZE || result2.getUseTabs() != indentOptions.USE_TAB_CHARACTER || result2.getContinuationIndentSize() != indentOptions.CONTINUATION_INDENT_SIZE || result2.getSmartTabs() != indentOptions.SMART_TABS && shouldSynchronizeSmartTabs || !indentOptions.isOverrideLanguageOptions()) {
                Logger $this$trace$iv4 = this.logger;
                boolean $i$f$trace4 = false;
                if ($this$trace$iv4.isTraceEnabled()) {
                    logger = $this$trace$iv4;
                    boolean bl = false;
                    logger.trace("RiderFileIndentOptionsProvider.getIndentOptions for `" + psiFile.getName() + "`: overriding settings");
                }
                indentOptions.setOverrideLanguageOptions(true);
                indentOptions.TAB_SIZE = result2.getTabSize();
                indentOptions.INDENT_SIZE = result2.getIndentSize();
                indentOptions.USE_TAB_CHARACTER = result2.getUseTabs();
                indentOptions.CONTINUATION_INDENT_SIZE = result2.getContinuationIndentSize();
                if (shouldSynchronizeSmartTabs) {
                    indentOptions.SMART_TABS = result2.getSmartTabs();
                }
                return RiderFileIndentOptionsProvider.getIndentOptions$takeIndentResponsibilities(this, settings, indentOptions);
            }
        }
        return null;
    }

    @Nullable
    public IndentStatusBarUIContributor getIndentStatusBarUiContributor(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        if (this.showAutodetectIndentOptions) {
            return new AutodetectUIContributor(indentOptions);
        }
        return null;
    }

    @Nullable
    public AnAction getActivatingAction(@Nullable CodeStyleStatusBarUIContributor activeUiContributor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.isApplicableForFile(file) && activeUiContributor == null) {
            return DetectableIndentOptionsProvider.getActivatingIndentDetectionAction((CodeStyleStatusBarUIContributor)activeUiContributor, (PsiFile)file);
        }
        return null;
    }

    private static final CommonCodeStyleSettings.IndentOptions getIndentOptions$takeIndentResponsibilities(RiderFileIndentOptionsProvider this$0, CodeStyleSettings $settings, CommonCodeStyleSettings.IndentOptions indentOptions) {
        this$0.showAutodetectIndentOptions = $settings.AUTODETECT_INDENTS;
        return indentOptions;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/settings/RiderFileIndentOptionsProvider$AutodetectUIContributor;", "Lcom/intellij/psi/codeStyle/IndentStatusBarUIContributor;", "options", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "<init>", "(Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;)V", "getActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)[Lcom/intellij/openapi/actionSystem/AnAction;", "createDisableAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lorg/jetbrains/annotations/NotNull;", "project", "Lcom/intellij/openapi/project/Project;", "getIcon", "Ljavax/swing/Icon;", "getHint", "", "getActionGroupTitle", "areActionsAvailable", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.rdclient.dotnet"})
    private static final class AutodetectUIContributor
    extends IndentStatusBarUIContributor {
        public AutodetectUIContributor(@Nullable CommonCodeStyleSettings.IndentOptions options) {
            super(options);
        }

        @Nullable
        public AnAction[] getActions(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return null;
        }

        @NotNull
        public DumbAwareAction createDisableAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.disable", (Object[])new Object[0]), arg_0 -> AutodetectUIContributor.createDisableAction$lambda$1(arg_0 -> AutodetectUIContributor.createDisableAction$lambda$0(project, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
            return dumbAwareAction;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = DetectableIndentOptionsProvider.getIndentDetectionIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIndentDetectionIcon(...)");
            return icon;
        }

        @NotNull
        public String getHint() {
            String string = ApplicationBundle.message((String)"code.style.indent.option.detected", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getActionGroupTitle() {
            String string = ApplicationBundle.message((String)"code.style.indent.detector.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean areActionsAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileType fileType = file.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
            FileType fileType2 = fileType;
            if (fileType2 instanceof LanguageFileType) {
                Language language = ((LanguageFileType)fileType2).getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                FrontendTypedHandler frontendTypedHandler = RiderTypedHandlersSupport.forLanguage(language);
                if (frontendTypedHandler != null) {
                    return true;
                }
            }
            return false;
        }

        private static final Unit createDisableAction$lambda$0(Project $project, AnActionEvent it) {
            DetectableIndentOptionsProvider.setIndentDetectionEnabled((Project)$project, (boolean)false);
            return Unit.INSTANCE;
        }

        private static final void createDisableAction$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

