/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.shared.utils;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils;", "", "<init>", "()V", "cleanupSuspiciousProcesses", "", "cleanupPolicies", "", "Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$Policy;", "([Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$Policy;)V", "RunningProcessInfo", "Policy", "DefaultPolicy", "intellij.rider.test.build.shared"})
@SourceDebugExtension(value={"SMAP\nProcessCleanupUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessCleanupUtils.kt\ncom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,88:1\n777#2:89\n873#2:90\n874#2:94\n3938#3:91\n4474#3,2:92\n37#4,2:95\n*S KotlinDebug\n*F\n+ 1 ProcessCleanupUtils.kt\ncom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils\n*L\n29#1:89\n29#1:90\n29#1:94\n30#1:91\n30#1:92,2\n27#1:95,2\n*E\n"})
public final class ProcessCleanupUtils {
    @NotNull
    public static final ProcessCleanupUtils INSTANCE = new ProcessCleanupUtils();

    private ProcessCleanupUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanupSuspiciousProcesses(Policy ... cleanupPolicies) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cleanupPolicies, (String)"cleanupPolicies");
        List<RunningProcessInfo> processList = ProcessHandle.allProcesses().map(arg_0 -> ProcessCleanupUtils.cleanupSuspiciousProcesses$lambda$1(ProcessCleanupUtils::cleanupSuspiciousProcesses$lambda$0, arg_0)).toList();
        Intrinsics.checkNotNull(processList);
        Iterable $this$filter$iv = processList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void $this$filterTo$iv$iv2;
            RunningProcessInfo processInfo = (RunningProcessInfo)element$iv$iv;
            boolean bl = false;
            Policy[] $this$filter$iv2 = cleanupPolicies;
            boolean $i$f$filter2 = false;
            Policy[] policyArray = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            int n = ((void)$this$filterTo$iv$iv2).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv2;
                void policy = element$iv$iv2 = $this$filterTo$iv$iv2[i];
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)processInfo);
                if (!policy.checkProcess(processInfo)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List selectedPolicies = (List)destination$iv$iv2;
            if (!((Collection)selectedPolicies).isEmpty()) {
                System.out.println((Object)("Found suspicious process " + processInfo.getPid() + " " + processInfo.getCommandLine() + " by policies: " + CollectionsKt.joinToString$default((Iterable)selectedPolicies, null, null, null, (int)0, null, ProcessCleanupUtils::cleanupSuspiciousProcesses$lambda$2$1, (int)31, null)));
            }
            boolean bl3 = !((Collection)selectedPolicies).isEmpty();
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suspiciousProcessList = (List)destination$iv$iv;
        for (RunningProcessInfo process : suspiciousProcessList) {
            if (process.getHandle().destroy() || process.getHandle().destroyForcibly() || !process.getHandle().isAlive()) continue;
            System.out.println((Object)("Failed to destroy process " + process.getPid() + " " + process.getCommandLine()));
        }
    }

    public static /* synthetic */ void cleanupSuspiciousProcesses$default(ProcessCleanupUtils processCleanupUtils, Policy[] policyArray, int n, Object object) {
        if ((n & 1) != 0) {
            Collection $this$toTypedArray$iv = (Collection)DefaultPolicy.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            policyArray = thisCollection$iv.toArray(new DefaultPolicy[0]);
        }
        processCleanupUtils.cleanupSuspiciousProcesses(policyArray);
    }

    private static final CharSequence cleanupSuspiciousProcesses$lambda$2$1(Policy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final RunningProcessInfo cleanupSuspiciousProcesses$lambda$0(ProcessHandle it) {
        Intrinsics.checkNotNull((Object)it);
        return new RunningProcessInfo(it);
    }

    private static final RunningProcessInfo cleanupSuspiciousProcesses$lambda$1(Function1 $tmp0, Object p0) {
        return (RunningProcessInfo)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B%\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$DefaultPolicy;", "Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$Policy;", "", "value", "", "getCheckProcess", "Lkotlin/Function1;", "Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$RunningProcessInfo;", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getValue", "()Ljava/lang/String;", "getGetCheckProcess", "()Lkotlin/jvm/functions/Function1;", "VBCS", "JCEF", "MSBuild", "DPA", "Profilers", "TestProcesses", "LLDB", "Unity", "Unreal", "checkProcess", "processInfo", "intellij.rider.test.build.shared"})
    @SourceDebugExtension(value={"SMAP\nProcessCleanupUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessCleanupUtils.kt\ncom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$DefaultPolicy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1807#2,3:89\n*S KotlinDebug\n*F\n+ 1 ProcessCleanupUtils.kt\ncom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$DefaultPolicy\n*L\n83#1:89,3\n*E\n"})
    public static final class DefaultPolicy
    extends Enum<DefaultPolicy>
    implements Policy {
        @NotNull
        private final String value;
        @NotNull
        private final Function1<RunningProcessInfo, Boolean> getCheckProcess;
        public static final /* enum */ DefaultPolicy VBCS = new DefaultPolicy("vbcs", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$0));
        public static final /* enum */ DefaultPolicy JCEF = new DefaultPolicy("jcef", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$1));
        public static final /* enum */ DefaultPolicy MSBuild = new DefaultPolicy("msbuild", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$2));
        public static final /* enum */ DefaultPolicy DPA = new DefaultPolicy("dpa", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$3));
        public static final /* enum */ DefaultPolicy Profilers = new DefaultPolicy("profilers", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$4));
        public static final /* enum */ DefaultPolicy TestProcesses = new DefaultPolicy("testProcesses", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$5));
        public static final /* enum */ DefaultPolicy LLDB = new DefaultPolicy("lldb", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$6));
        public static final /* enum */ DefaultPolicy Unity = new DefaultPolicy("unity", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$7));
        public static final /* enum */ DefaultPolicy Unreal = new DefaultPolicy("unreal", (Function1<? super RunningProcessInfo, Boolean>)((Function1)DefaultPolicy::_init_$lambda$8));
        private static final /* synthetic */ DefaultPolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DefaultPolicy(String value, Function1<? super RunningProcessInfo, Boolean> getCheckProcess) {
            this.value = value;
            this.getCheckProcess = getCheckProcess;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @NotNull
        public final Function1<RunningProcessInfo, Boolean> getGetCheckProcess() {
            return this.getCheckProcess;
        }

        @Override
        public boolean checkProcess(@NotNull RunningProcessInfo processInfo) {
            Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
            return (Boolean)this.getCheckProcess.invoke((Object)processInfo);
        }

        public static DefaultPolicy[] values() {
            return (DefaultPolicy[])$VALUES.clone();
        }

        public static DefaultPolicy valueOf(String value) {
            return Enum.valueOf(DefaultPolicy.class, value);
        }

        @NotNull
        public static EnumEntries<DefaultPolicy> getEntries() {
            return $ENTRIES;
        }

        private static final boolean _init_$lambda$0(RunningProcessInfo processInfo) {
            Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
            return Intrinsics.areEqual((Object)processInfo.getExecutableName(), (Object)"VBCSCompiler.exe") || StringsKt.contains((CharSequence)processInfo.getCommandLine(), (CharSequence)"VBCSCompiler", (boolean)true) || Intrinsics.areEqual((Object)processInfo.getExecutableName(), (Object)"dotnet.exe") && (StringsKt.contains((CharSequence)processInfo.getCommandLine(), (CharSequence)"rzc.dll", (boolean)true) || StringsKt.contains((CharSequence)processInfo.getCommandLine(), (CharSequence)"msbuild.dll", (boolean)true) || StringsKt.contains((CharSequence)processInfo.getFullCommand(), (CharSequence)"rzc.dll", (boolean)true) || StringsKt.contains((CharSequence)processInfo.getFullCommand(), (CharSequence)"msbuild.dll", (boolean)true));
        }

        private static final boolean _init_$lambda$1(RunningProcessInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.checkProcessContains("cef_server");
        }

        private static final boolean _init_$lambda$2(RunningProcessInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.checkProcessContains("msbuild");
        }

        private static final boolean _init_$lambda$3(RunningProcessInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.checkProcessContains("JetBrains.Dpa");
        }

        private static final boolean _init_$lambda$4(RunningProcessInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.checkProcessContains("JetBrains.Profiler") || it.checkProcessContains("dottrace");
        }

        private static final boolean _init_$lambda$5(RunningProcessInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.checkProcessContains("JetTestRider");
        }

        private static final boolean _init_$lambda$6(RunningProcessInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.checkProcessContains("lldb");
        }

        private static final boolean _init_$lambda$7(RunningProcessInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !StringsKt.contains$default((CharSequence)it.getCommandLine(), (CharSequence)"Licensing", (boolean)false, (int)2, null) && (it.checkProcessContains("Unity/Hub/Editor") || it.checkProcessContains("Unity\\Hub\\Editor") || it.checkProcessContains("SimpleUnityGame"));
        }

        private static final boolean _init_$lambda$8(RunningProcessInfo processInfo) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
                Object[] objectArray = new String[]{"EpicGamesLauncher", "EpicWebHelper", "UE4Editor", "CrashReportClient", "CrashReportClientEditor", "UnrealEditor", "UnrealTraceServer"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!processInfo.checkProcessContains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        static {
            $VALUES = defaultPolicyArray = new DefaultPolicy[]{DefaultPolicy.VBCS, DefaultPolicy.JCEF, DefaultPolicy.MSBuild, DefaultPolicy.DPA, DefaultPolicy.Profilers, DefaultPolicy.TestProcesses, DefaultPolicy.LLDB, DefaultPolicy.Unity, DefaultPolicy.Unreal};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$Policy;", "", "value", "", "getValue", "()Ljava/lang/String;", "checkProcess", "", "processInfo", "Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$RunningProcessInfo;", "intellij.rider.test.build.shared"})
    public static interface Policy {
        @NotNull
        public String getValue();

        public boolean checkProcess(@NotNull RunningProcessInfo var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\rH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/test/shared/utils/ProcessCleanupUtils$RunningProcessInfo;", "", "handle", "Ljava/lang/ProcessHandle;", "<init>", "(Ljava/lang/ProcessHandle;)V", "getHandle", "()Ljava/lang/ProcessHandle;", "pid", "", "getPid", "()J", "commandLine", "", "getCommandLine", "()Ljava/lang/String;", "fullCommand", "getFullCommand", "executableName", "getExecutableName", "checkProcessContains", "", "text", "component1", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.test.build.shared"})
    public static final class RunningProcessInfo {
        @NotNull
        private final ProcessHandle handle;
        private final long pid;
        @NotNull
        private final String commandLine;
        @NotNull
        private final String fullCommand;
        @Nullable
        private final String executableName;

        /*
         * WARNING - void declaration
         */
        public RunningProcessInfo(@NotNull ProcessHandle handle) {
            String string;
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            this.handle = handle;
            this.pid = this.handle.pid();
            String string2 = this.handle.info().commandLine().orElse("<NULL>");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"orElse(...)");
            this.commandLine = string2;
            String string3 = this.handle.info().command().orElse("<NULL>");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"orElse(...)");
            this.fullCommand = string3;
            RunningProcessInfo runningProcessInfo = this;
            String string4 = this.handle.info().command().orElse(null);
            if (string4 != null) {
                String string5;
                String string6 = string4;
                RunningProcessInfo runningProcessInfo2 = runningProcessInfo;
                boolean bl = false;
                try {
                    void executable;
                    Path path = Path.of((String)executable, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    string5 = PathsKt.getName((Path)path);
                }
                catch (Throwable throwable) {
                    string5 = null;
                }
                string = string5;
                runningProcessInfo = runningProcessInfo2;
            } else {
                string = null;
            }
            runningProcessInfo.executableName = string;
        }

        @NotNull
        public final ProcessHandle getHandle() {
            return this.handle;
        }

        public final long getPid() {
            return this.pid;
        }

        @NotNull
        public final String getCommandLine() {
            return this.commandLine;
        }

        @NotNull
        public final String getFullCommand() {
            return this.fullCommand;
        }

        @Nullable
        public final String getExecutableName() {
            return this.executableName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean checkProcessContains(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (StringsKt.contains((CharSequence)this.commandLine, (CharSequence)text, (boolean)true)) return true;
            if (StringsKt.contains((CharSequence)this.fullCommand, (CharSequence)text, (boolean)true)) return true;
            String string = this.executableName;
            if (string == null) return false;
            if (!StringsKt.contains((CharSequence)string, (CharSequence)text, (boolean)true)) return false;
            return true;
        }

        @NotNull
        public final ProcessHandle component1() {
            return this.handle;
        }

        @NotNull
        public final RunningProcessInfo copy(@NotNull ProcessHandle handle) {
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            return new RunningProcessInfo(handle);
        }

        public static /* synthetic */ RunningProcessInfo copy$default(RunningProcessInfo runningProcessInfo, ProcessHandle processHandle, int n, Object object) {
            if ((n & 1) != 0) {
                processHandle = runningProcessInfo.handle;
            }
            return runningProcessInfo.copy(processHandle);
        }

        @NotNull
        public String toString() {
            return "RunningProcessInfo(handle=" + this.handle + ")";
        }

        public int hashCode() {
            return ((Object)this.handle).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RunningProcessInfo)) {
                return false;
            }
            RunningProcessInfo runningProcessInfo = (RunningProcessInfo)other;
            return Intrinsics.areEqual((Object)this.handle, (Object)runningProcessInfo.handle);
        }
    }
}

