/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.platform.diagnostics.RdLogTraceScenarios;
import com.jetbrains.rdclient.testFramework.TestModeFlagControlKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import com.jetbrains.rider.inTests.TestHost;
import com.jetbrains.rider.model.RdShellModel;
import com.jetbrains.rider.model.RdShellModel_PregeneratedKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.test.OpenSolutionParams;
import com.jetbrains.rider.test.asserts.ShouldAssertsKt;
import com.jetbrains.rider.test.base.PerTestSettingsTestBase;
import com.jetbrains.rider.test.facades.TestApiScopes;
import com.jetbrains.rider.test.facades.editor.EditorApiFacade;
import com.jetbrains.rider.test.facades.editor.RiderEditorApiFacade;
import com.jetbrains.rider.test.facades.solution.RiderSolutionWithFoldersApiFacade;
import com.jetbrains.rider.test.facades.solution.SolutionApiFacade;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.processor.model.IntegrationTestMethod;
import com.jetbrains.rider.test.framework.testData.TestDataStorage;
import com.jetbrains.rider.test.framework.workDirectory.CustomTestWorkDirectoryStorage;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Asserts_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_EditorKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Editor_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Memory_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_SolutionAnalysisKt;
import com.jetbrains.rider.test.scriptingApi.TextControlDumps;
import java.io.File;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010,\u001a\u00020-H\u0007J\b\u0010.\u001a\u00020-H\u0007J\u0010\u0010/\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0007J\b\u00102\u001a\u00020-H\u0007J\b\u00103\u001a\u00020-H\u0007J\b\u00104\u001a\u00020-H\u0007J\b\u00105\u001a\u00020-H\u0017J\b\u00106\u001a\u00020-H\u0007J\b\u00107\u001a\u00020-H\u0014J9\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00072\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020-0?\u00a2\u0006\u0002\bAH\u0004J9\u0010B\u001a\u00020-2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00072\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020-0?\u00a2\u0006\u0002\bAH\u0014J\u001a\u0010C\u001a\u00020-2\u0006\u0010D\u001a\u00020\u00072\b\b\u0002\u0010E\u001a\u00020)H\u0004J!\u0010F\u001a\u00020-2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020-0?\u00a2\u0006\u0002\bAH\u0014J\u001c\u0010G\u001a\u00020-2\u0006\u0010H\u001a\u00020I2\n\b\u0002\u0010J\u001a\u0004\u0018\u00010\u0007H\u0004R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u000f\u001a\u0004\b!\u0010\"R\u0018\u0010$\u001a\u0004\u0018\u00010\u0011X\u0094\u0004\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b%\u0010&R\u0016\u0010(\u001a\u0004\u0018\u00010)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006K"}, d2={"Lcom/jetbrains/rider/test/base/EditorTestBase;", "Lcom/jetbrains/rider/test/base/PerTestSettingsTestBase;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Solution;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Editor;", "<init>", "()V", "testSolution", "", "getTestSolution", "()Ljava/lang/String;", "testWorkDirectoryStorage", "Lcom/jetbrains/rider/test/framework/workDirectory/CustomTestWorkDirectoryStorage;", "getTestWorkDirectoryStorage", "()Lcom/jetbrains/rider/test/framework/workDirectory/CustomTestWorkDirectoryStorage;", "testWorkDirectoryStorage$delegate", "Lkotlin/Lazy;", "checkTextControls", "", "getCheckTextControls", "()Z", "checkSolutionLoad", "getCheckSolutionLoad", "traceCategories", "", "getTraceCategories", "()Ljava/util/List;", "solutionApiFacade", "Lcom/jetbrains/rider/test/facades/solution/SolutionApiFacade;", "getSolutionApiFacade", "()Lcom/jetbrains/rider/test/facades/solution/SolutionApiFacade;", "solutionApiFacade$delegate", "editorApiFacade", "Lcom/jetbrains/rider/test/facades/editor/EditorApiFacade;", "getEditorApiFacade", "()Lcom/jetbrains/rider/test/facades/editor/EditorApiFacade;", "editorApiFacade$delegate", "restoreNuGetPackages", "getRestoreNuGetPackages", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "backendLoadedTimeout", "Ljava/time/Duration;", "getBackendLoadedTimeout", "()Ljava/time/Duration;", "setupSolution", "", "setUpDocumentEditor", "cleanupDocumentEditorAfterTest", "result", "Lorg/testng/ITestResult;", "restoreFilesAfterTest", "cleanupSettingsAfterTest", "collectMemoryUsage", "closeSolution", "removeWorkDirectory", "beforeDoTestWithDocuments", "withOpenedScratch", "Lcom/intellij/openapi/editor/Editor;", "nameOrRelativeOrAbsolutePath", "language", "Lcom/intellij/lang/Language;", "textSource", "block", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "Lkotlin/ExtensionFunctionType;", "dumpOpenedScratch", "waitForEditorSwitch", "targetFileName", "hostTimeout", "withOpenedCSharpInteractive", "assertDocumentControls", "document", "Lcom/intellij/openapi/editor/Document;", "forceFileName", "intellij.rider.test.framework.integration.testng"})
@SourceDebugExtension(value={"SMAP\nEditorTestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTestBase.kt\ncom/jetbrains/rider/test/base/EditorTestBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
public abstract class EditorTestBase
extends PerTestSettingsTestBase
implements TestApiScopes.Solution,
TestApiScopes.Editor {
    @NotNull
    private final String testSolution;
    @NotNull
    private final Lazy testWorkDirectoryStorage$delegate = LazyKt.lazy(() -> EditorTestBase.testWorkDirectoryStorage_delegate$lambda$0(this));
    private final boolean checkTextControls;
    private final boolean checkSolutionLoad;
    @NotNull
    private final Lazy solutionApiFacade$delegate = LazyKt.lazy(() -> EditorTestBase.solutionApiFacade_delegate$lambda$0(this));
    @NotNull
    private final Lazy editorApiFacade$delegate = LazyKt.lazy(() -> EditorTestBase.editorApiFacade_delegate$lambda$0(this));
    @Nullable
    private final Boolean restoreNuGetPackages;
    @Nullable
    private final Duration backendLoadedTimeout;

    public EditorTestBase() {
        this.testSolution = "";
        this.checkTextControls = true;
        this.checkSolutionLoad = true;
    }

    @NotNull
    public String getTestSolution() {
        return this.testSolution;
    }

    @NotNull
    public CustomTestWorkDirectoryStorage getTestWorkDirectoryStorage() {
        Lazy lazy = this.testWorkDirectoryStorage$delegate;
        return (CustomTestWorkDirectoryStorage)lazy.getValue();
    }

    public boolean getCheckTextControls() {
        return this.checkTextControls;
    }

    public boolean getCheckSolutionLoad() {
        return this.checkSolutionLoad;
    }

    @Override
    @NotNull
    public List<String> getTraceCategories() {
        Object[] objectArray = new String[]{"#com.jetbrains.rider.document", "#com.jetbrains.rdclient.document", "#com.jetbrains.rider.completion.FrontendLookupListener", "#com.jetbrains.rider.test.framework.dataContextTree", "JetBrains.RdBackend.Common.Features.Documents", "JetBrains.ReSharper.Psi.Files", "JetBrains.Rider.Backend.Features.Documents", "JetBrains.RdBackend.Common.Features.TextControls", "JetBrains.ReSharper.Psi.Caches", "JetBrains.ReSharper.Psi.Caches.SymbolCache", "JetBrains.Rider.Backend.Features.TextControls", "JetBrains.Rider.Test.Framework.Core.Documents", "#com.jetbrains.rdclient.editorActions", "#com.jetbrains.rdclient.requests", "#com.jetbrains.rider.requests", "JetBrains.RdBackend.Common.Features.PatchSynchronizationEngine"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)RdLogTraceScenarios.Documents.INSTANCE.getCategories());
    }

    @NotNull
    public SolutionApiFacade getSolutionApiFacade() {
        Lazy lazy = this.solutionApiFacade$delegate;
        return (SolutionApiFacade)lazy.getValue();
    }

    @NotNull
    public EditorApiFacade getEditorApiFacade() {
        Lazy lazy = this.editorApiFacade$delegate;
        return (EditorApiFacade)lazy.getValue();
    }

    @Nullable
    protected Boolean getRestoreNuGetPackages() {
        return this.restoreNuGetPackages;
    }

    @Nullable
    protected Duration getBackendLoadedTimeout() {
        return this.backendLoadedTimeout;
    }

    @BeforeMethod(alwaysRun=true)
    public final void setupSolution() {
        Object object = ((IntegrationTestMethod)this.getTestMethod()).getSolution();
        if (object == null || (object = object.name()) == null) {
            object = this.getTestSolution();
        }
        Object sourceSolutionDirName = object;
        this.getSolutionApiFacade().prepareAndOpenSolution((String)sourceSolutionDirName, new OpenSolutionParams(), this.getTestWorkDirectory(), this.getSolutionSourceRootDirectory());
    }

    @BeforeMethod(dependsOnMethods={"setupSolution"}, alwaysRun=true)
    public final void setUpDocumentEditor() {
        TemplateManagerImpl.setTemplateTesting((Disposable)((Disposable)this.getProject()));
        this.beforeDoTestWithDocuments();
        TestFrameworkBaseKt.flushQueues$default(null, (int)1, null);
    }

    @AfterMethod(alwaysRun=true)
    public final void cleanupDocumentEditorAfterTest(@NotNull ITestResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        TestModeFlagControlKt.withAutopopup(() -> EditorTestBase.cleanupDocumentEditorAfterTest$lambda$0(this));
        TestFrameworkBaseKt.flushQueues((IProtocolHost)ApplicationProtocolKt.getProtocolHost((Project)this.getProject()));
        ScriptingAPI_Asserts_BaseKt.enableBackendAsserts((Project)this.getProject());
        ScriptingAPI_Editor_BaseKt.waitForDaemonCloseAllOpenEditors((Project)this.getProject());
        if (!result2.isSuccess() && ((IntegrationTestMethod)this.getTestMethod()).getExecutionPlan().getShouldRun()) {
            this.storeCurrentSolutionState();
        }
    }

    @AfterMethod(dependsOnMethods={"cleanupDocumentEditorAfterTest"}, alwaysRun=true)
    public final void restoreFilesAfterTest() {
        Project project = this.getProject();
        File file = this.getSolutionSourceRootDirectory();
        Object object = ((IntegrationTestMethod)this.getTestMethod()).getSolution();
        if (object == null || (object = object.name()) == null) {
            object = this.getTestSolution();
        }
        ScriptingAPI_EditorKt.restoreModifiedFiles((Project)project, (File)FilesKt.resolve((File)file, (String)object), (File)this.getActiveSolutionDirectory());
    }

    @AfterMethod(dependsOnMethods={"restoreFilesAfterTest"}, alwaysRun=true)
    public final void cleanupSettingsAfterTest() {
        ScriptingAPI_EditorKt.cleanupEditorSettings((SolutionApiFacade)((SolutionApiFacade)this));
    }

    @AfterClass(alwaysRun=true)
    public final void collectMemoryUsage() {
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Start collecting memory usage information");
        if (!this.getSolutionApiFacade().getHasProject()) {
            TestFrameworkBaseKt.getFrameworkLogger().warn("Project is NULL. Not able to collect memory usage");
            return;
        }
        RdShellModel shellModel = RdShellModel_PregeneratedKt.getRdShellModel((IProtocol)ApplicationProtocolKt.getProtocol((Project)this.getProject()));
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        ScriptingAPI_Memory_BaseKt.logMemoryUsage((RdShellModel)shellModel, (String)"Before CloseSolution", (String)string);
    }

    @AfterClass(dependsOnMethods={"collectMemoryUsage"}, alwaysRun=true)
    public void closeSolution() {
        this.getSolutionApiFacade().closeSolution();
    }

    @AfterClass(dependsOnMethods={"closeSolution"}, alwaysRun=true)
    public final void removeWorkDirectory() {
        boolean result2 = FilesKt.deleteRecursively((File)this.getTestWorkDirectory());
        if (!result2) {
            TestFrameworkBaseKt.getFrameworkLogger().warn("Error deleting '" + this.getTestWorkDirectory() + "' folder");
        }
    }

    protected void beforeDoTestWithDocuments() {
        System.gc();
    }

    @NotNull
    protected final Editor withOpenedScratch(@NotNull String nameOrRelativeOrAbsolutePath, @NotNull Language language, @NotNull String textSource, @NotNull Function1<? super EditorImpl, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)nameOrRelativeOrAbsolutePath, (String)"nameOrRelativeOrAbsolutePath");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)textSource, (String)"textSource");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        File sourceFile = new File(this.getTestCaseSourceDirectory(), textSource);
        EditorImpl editor = ScriptingAPI_EditorKt.withOpenedScratchEditor((SolutionApiFacade)((SolutionApiFacade)this), (EditorApiFacade)((EditorApiFacade)this), (TestDataStorage)((TestDataStorage)this), (String)nameOrRelativeOrAbsolutePath, (Language)language, (File)sourceFile, block);
        TestHost.Companion.getInstance(ApplicationProtocolKt.getProtocolHost((Project)this.getProject()).getSession()).backendWaitForCaches("Waiting for caches before running scratch editor block");
        ScriptingAPI_SolutionAnalysisKt.waitForAllAnalysisFinished$default((Project)this.getProject(), null, (int)2, null);
        return (Editor)editor;
    }

    protected void dumpOpenedScratch(@NotNull String nameOrRelativeOrAbsolutePath, @NotNull Language language, @NotNull String textSource, @NotNull Function1<? super EditorImpl, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)nameOrRelativeOrAbsolutePath, (String)"nameOrRelativeOrAbsolutePath");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)textSource, (String)"textSource");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Editor editor = this.withOpenedScratch(nameOrRelativeOrAbsolutePath, language, textSource, block);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.assertDocumentControls(document, FilesKt.getNameWithoutExtension((File)new File(textSource)));
    }

    protected final void waitForEditorSwitch(@NotNull String targetFileName, @NotNull Duration hostTimeout) {
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        Intrinsics.checkNotNullParameter((Object)hostTimeout, (String)"hostTimeout");
        TestFrameworkBaseKt.getFrameworkLogger().info("Waiting for editor switch");
        FileEditorManagerEx instanceEx = FileEditorManagerEx.Companion.getInstanceEx(this.getProject());
        ExtensionsKt.pumpMessages((Duration)hostTimeout, () -> EditorTestBase.waitForEditorSwitch$lambda$0(instanceEx, targetFileName));
        FileEditor fileEditor = instanceEx.getSelectedEditor();
        String name = fileEditor != null && (fileEditor = fileEditor.getFile()) != null ? fileEditor.getName() : null;
        boolean bl = Intrinsics.areEqual((Object)name, (Object)targetFileName);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Editor should be switched. Current editor: " + name + ". Expected editor: " + targetFileName + ".";
            throw new AssertionError((Object)string);
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Editor switched to " + targetFileName);
    }

    public static /* synthetic */ void waitForEditorSwitch$default(EditorTestBase editorTestBase, String string, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: waitForEditorSwitch");
        }
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(20L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        editorTestBase.waitForEditorSwitch(string, duration);
    }

    protected void withOpenedCSharpInteractive(@NotNull Function1<? super EditorImpl, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ScriptingAPI_EditorKt.withCreatedCSharpInteractiveConsole((Project)this.getProject(), arg_0 -> EditorTestBase.withOpenedCSharpInteractive$lambda$0(block, arg_0));
        TestHost.Companion.getInstance(ApplicationProtocolKt.getProtocolHost((Project)this.getProject()).getSession()).backendWaitForCaches("Waiting for caches before running scratch editor block");
        ScriptingAPI_SolutionAnalysisKt.waitForAllAnalysisFinished$default((Project)this.getProject(), null, (int)2, null);
    }

    protected final void assertDocumentControls(@NotNull Document document, @Nullable String forceFileName) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TestFrameworkBaseKt.getFrameworkLogger().info("Start checking document controls for document");
        String string = forceFileName;
        if (string == null) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            string = (String)ShouldAssertsKt.shouldNotBeNull((Object)(virtualFile != null ? virtualFile.getNameWithoutExtension() : null), (String)"Opened editor file is not defined");
        }
        String fileName = string;
        File editorGoldFile = FilesKt.resolve((File)this.getTestCaseGoldDirectory(), (String)fileName);
        GoldFilesHelperKt.executeWithGold((File)editorGoldFile, (List)this.getCustomGoldSuffixes(), arg_0 -> EditorTestBase.assertDocumentControls$lambda$0(this, arg_0));
        if (this.getCheckTextControls()) {
            TextControlDumps dumps = ScriptingAPI_EditorKt.getTextControlsDumps((Project)this.getProject());
            File ideaGoldFile = FilesKt.resolve((File)this.getTestCaseGoldDirectory(), (String)(fileName + "_idea"));
            File resharperGoldFile = FilesKt.resolve((File)this.getTestCaseGoldDirectory(), (String)(fileName + "_resharper"));
            GoldFilesHelperKt.executeWithGold((File)ideaGoldFile, (List)this.getCustomGoldSuffixes(), arg_0 -> EditorTestBase.assertDocumentControls$lambda$1(dumps, arg_0));
            GoldFilesHelperKt.executeWithGold((File)resharperGoldFile, (List)this.getCustomGoldSuffixes(), arg_0 -> EditorTestBase.assertDocumentControls$lambda$2(dumps, arg_0));
        }
    }

    public static /* synthetic */ void assertDocumentControls$default(EditorTestBase editorTestBase, Document document, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertDocumentControls");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        editorTestBase.assertDocumentControls(document, string);
    }

    private static final CustomTestWorkDirectoryStorage testWorkDirectoryStorage_delegate$lambda$0(EditorTestBase this$0) {
        return new CustomTestWorkDirectoryStorage(this$0.getTestProcessor(), "EditorTest");
    }

    private static final RiderSolutionWithFoldersApiFacade solutionApiFacade_delegate$lambda$0(EditorTestBase this$0) {
        return new RiderSolutionWithFoldersApiFacade(this$0.getTestWorkDirectoryStorage().getCustomWorkDirectoryName(), this$0.getCheckSolutionLoad());
    }

    private static final RiderEditorApiFacade editorApiFacade_delegate$lambda$0(EditorTestBase this$0) {
        return new RiderEditorApiFacade(this$0.getSolutionApiFacade(), this$0.getTestDataStorage(), this$0.getCheckTextControls());
    }

    private static final void cleanupDocumentEditorAfterTest$lambda$0$0(EditorTestBase this$0) {
        FrontendCompletionHost.Companion.getInstance(this$0.getProject()).terminateSessionsForAllEditors("End of test");
        CompletionProgressIndicator completionProgressIndicator = CompletionServiceImpl.Companion.getCurrentCompletionProgressIndicator();
        if (completionProgressIndicator != null) {
            completionProgressIndicator.closeAndFinish(true);
        }
        LastFocusedEditorSuppressor.Companion.getInstance(this$0.getProject()).forceReleaseSuppressionForLastFocusedEditor("End of test");
    }

    private static final Unit cleanupDocumentEditorAfterTest$lambda$0(EditorTestBase this$0) {
        ApplicationKt.getApplication().saveAll();
        ApplicationKt.getApplication().runWriteAction(() -> EditorTestBase.cleanupDocumentEditorAfterTest$lambda$0$0(this$0));
        return Unit.INSTANCE;
    }

    private static final boolean waitForEditorSwitch$lambda$0(FileEditorManagerEx $instanceEx, String $targetFileName) {
        FileEditor fileEditor = $instanceEx.getSelectedEditor();
        String name = fileEditor != null && (fileEditor = fileEditor.getFile()) != null ? fileEditor.getName() : null;
        return Intrinsics.areEqual((Object)name, (Object)$targetFileName);
    }

    private static final Unit withOpenedCSharpInteractive$lambda$0(Function1 $block, EditorImpl $this$withCreatedCSharpInteractiveConsole) {
        Intrinsics.checkNotNullParameter((Object)$this$withCreatedCSharpInteractiveConsole, (String)"$this$withCreatedCSharpInteractiveConsole");
        $block.invoke((Object)$this$withCreatedCSharpInteractiveConsole);
        return Unit.INSTANCE;
    }

    private static final Unit assertDocumentControls$lambda$0(EditorTestBase this$0, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        ScriptingAPI_EditorKt.dumpOpenedDocument$default((PrintStream)printStream, (Project)this$0.getProject(), (boolean)false, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit assertDocumentControls$lambda$1(TextControlDumps $dumps, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        printStream.print($dumps.getIdea());
        return Unit.INSTANCE;
    }

    private static final Unit assertDocumentControls$lambda$2(TextControlDumps $dumps, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        printStream.print($dumps.getResharper());
        return Unit.INSTANCE;
    }
}

