/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.designers.winforms.editor.WinFormsEditor;
import com.jetbrains.rider.model.DesignerDescriptor;
import com.jetbrains.rider.model.DesignerEditorState;
import com.jetbrains.rider.model.ExternalDesignerModel;
import com.jetbrains.rider.model.ExternalDesignerModel_PregeneratedKt;
import com.jetbrains.rider.model.ExternalDesignerNotification;
import com.jetbrains.rider.model.ExternalDesignerNotificationType;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.test.base.PerTestSolutionTestBase;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_EditorKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Editor_BaseKt;
import java.io.File;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0004J\"\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0004J\u0012\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0004J\u001a\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0004J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0005*\u00020\u0017H\u0004J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0017H\u0004J.\u0010\u001a\u001a\u00020\t\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00052\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0\u001eH\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/test/base/WinFormsDesignerTestBase;", "Lcom/jetbrains/rider/test/base/PerTestSolutionTestBase;", "<init>", "()V", "editorTypeId", "", "getEditorTypeId", "()Ljava/lang/String;", "waitForDesignerNotification", "", "editor", "Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditor;", "notificationType", "Lcom/jetbrains/rider/model/ExternalDesignerNotificationType;", "timeout", "Ljava/time/Duration;", "waitForDesignerLoaded", "state", "Lcom/jetbrains/rider/model/DesignerEditorState;", "waitForSavingsEnds", "openDesigner", "relativePath", "getWinFormsMark", "Lcom/intellij/openapi/vfs/VirtualFile;", "waitForDesignerDetected", "file", "waitForNull", "T", "errorMessage", "valueGetter", "Lkotlin/Function0;", "intellij.rider.test.framework.integration.testng"})
public abstract class WinFormsDesignerTestBase
extends PerTestSolutionTestBase {
    @NotNull
    private final String editorTypeId;

    public WinFormsDesignerTestBase() {
        this.editorTypeId = "WinFormsEditor";
    }

    @NotNull
    protected final String getEditorTypeId() {
        return this.editorTypeId;
    }

    protected final void waitForDesignerNotification(@NotNull WinFormsEditor editor, @Nullable ExternalDesignerNotificationType notificationType, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        TestFrameworkBaseKt.getFrameworkLogger().info("Waiting for notification from designer: " + notificationType);
        ExtensionsKt.pumpMessages((Duration)timeout, () -> WinFormsDesignerTestBase.waitForDesignerNotification$lambda$0(editor, notificationType));
        ExternalDesignerNotification externalDesignerNotification = editor.getNotification();
        AssertionsKt.assertEquals$default((Object)notificationType, (Object)(externalDesignerNotification != null ? externalDesignerNotification.getType() : null), null, (int)4, null);
        TestFrameworkBaseKt.getFrameworkLogger().info("Designer notification received: " + notificationType);
    }

    public static /* synthetic */ void waitForDesignerNotification$default(WinFormsDesignerTestBase winFormsDesignerTestBase, WinFormsEditor winFormsEditor, ExternalDesignerNotificationType externalDesignerNotificationType, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: waitForDesignerNotification");
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        winFormsDesignerTestBase.waitForDesignerNotification(winFormsEditor, externalDesignerNotificationType, duration);
    }

    protected final void waitForDesignerLoaded(@NotNull WinFormsEditor editor, @NotNull DesignerEditorState state, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        TestFrameworkBaseKt.getFrameworkLogger().info("Waiting for designer loaded: " + state);
        ExtensionsKt.pumpMessages((Duration)timeout, () -> WinFormsDesignerTestBase.waitForDesignerLoaded$lambda$0(editor, state));
        DesignerDescriptor designerDescriptor = editor.getDescriptor();
        Intrinsics.checkNotNull((Object)designerDescriptor);
        AssertionsKt.assertEquals$default((Object)state, (Object)designerDescriptor.getState().getValue(), null, (int)4, null);
        TestFrameworkBaseKt.getFrameworkLogger().info("Designer loaded: " + state);
    }

    public static /* synthetic */ void waitForDesignerLoaded$default(WinFormsDesignerTestBase winFormsDesignerTestBase, WinFormsEditor winFormsEditor, DesignerEditorState designerEditorState, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: waitForDesignerLoaded");
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        winFormsDesignerTestBase.waitForDesignerLoaded(winFormsEditor, designerEditorState, duration);
    }

    protected final void waitForSavingsEnds(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ExternalDesignerModel model = ExternalDesignerModel_PregeneratedKt.getExternalDesignerModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.getProject()));
        TestFrameworkBaseKt.getFrameworkLogger().info("Waiting for all saving ends");
        ExtensionsKt.pumpMessages((Duration)timeout, () -> WinFormsDesignerTestBase.waitForSavingsEnds$lambda$0(model));
        AssertionsKt.assertEquals$default((Object)false, (Object)model.getHasActiveSavingSessions().getValueOrNull(), null, (int)4, null);
        TestFrameworkBaseKt.getFrameworkLogger().info("All saving tasks ended");
    }

    public static /* synthetic */ void waitForSavingsEnds$default(WinFormsDesignerTestBase winFormsDesignerTestBase, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: waitForSavingsEnds");
        }
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        winFormsDesignerTestBase.waitForSavingsEnds(duration);
    }

    @NotNull
    protected final WinFormsEditor openDesigner(@NotNull String relativePath, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        VirtualFile formFile = ScriptingAPI_Editor_BaseKt.relativePathToVirtualFile((String)relativePath, (File)this.getActiveSolutionDirectory());
        FileEditor winFormsEditor = (FileEditor)ScriptingAPIKt.waitForNotNull((Duration)timeout, (String)("Can't open " + relativePath + " with provider " + this.editorTypeId), () -> WinFormsDesignerTestBase.openDesigner$lambda$0(this, formFile));
        Intrinsics.checkNotNull((Object)winFormsEditor, (String)"null cannot be cast to non-null type com.jetbrains.rider.designers.winforms.editor.WinFormsEditor");
        return (WinFormsEditor)winFormsEditor;
    }

    public static /* synthetic */ WinFormsEditor openDesigner$default(WinFormsDesignerTestBase winFormsDesignerTestBase, String string, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openDesigner");
        }
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        return winFormsDesignerTestBase.openDesigner(string, duration);
    }

    @Nullable
    protected final String getWinFormsMark(@NotNull VirtualFile $this$getWinFormsMark) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$getWinFormsMark, (String)"<this>");
        List itemsByVirtualFile = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.getProject()), (VirtualFile)$this$getWinFormsMark, (Project)this.getProject());
        boolean bl2 = bl = ((Collection)itemsByVirtualFile).size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ProjectModelEntity entity = (ProjectModelEntity)itemsByVirtualFile.get(0);
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
        Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdProjectFileDescriptor");
        RdProjectFileDescriptor descriptor = (RdProjectFileDescriptor)rdProjectModelItemDescriptor;
        return ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)((RdProjectModelItemDescriptor)descriptor), (String)"WINFORMS.TYPE");
    }

    protected final void waitForDesignerDetected(@NotNull Duration timeout, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ScriptingAPIKt.waitForNotNull((Duration)timeout, (String)("WinForms " + file.getName() + " file detection failed"), () -> WinFormsDesignerTestBase.waitForDesignerDetected$lambda$0(this, file));
    }

    protected final <T> void waitForNull(@NotNull Duration timeout, @NotNull String errorMessage, @NotNull Function0<? extends T> valueGetter) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter(valueGetter, (String)"valueGetter");
        Ref.ObjectRef value = new Ref.ObjectRef();
        ExtensionsKt.pumpMessages((Duration)timeout, () -> WinFormsDesignerTestBase.waitForNull$lambda$0(value, valueGetter));
        if (value.element != null) {
            AssertionsKt.fail((String)(errorMessage + " (timed out within " + timeout.toMillis() + " ms) with value = " + value.element));
            throw new KotlinNothingValueException();
        }
    }

    private static final boolean waitForDesignerNotification$lambda$0(WinFormsEditor $editor, ExternalDesignerNotificationType $notificationType) {
        ExternalDesignerNotification externalDesignerNotification = $editor.getNotification();
        return (externalDesignerNotification != null ? externalDesignerNotification.getType() : null) == $notificationType;
    }

    private static final boolean waitForDesignerLoaded$lambda$0(WinFormsEditor $editor, DesignerEditorState $state) {
        DesignerDescriptor designerDescriptor = $editor.getDescriptor();
        Intrinsics.checkNotNull((Object)designerDescriptor);
        return designerDescriptor.getState().getValue() == $state;
    }

    private static final boolean waitForSavingsEnds$lambda$0(ExternalDesignerModel $model) {
        return Intrinsics.areEqual((Object)$model.getHasActiveSavingSessions().getValueOrNull(), (Object)false);
    }

    private static final FileEditor openDesigner$lambda$0(WinFormsDesignerTestBase this$0, VirtualFile $formFile) {
        return ScriptingAPI_EditorKt.openFileInEditor((Project)this$0.getProject(), (VirtualFile)$formFile, (String)this$0.editorTypeId);
    }

    private static final String waitForDesignerDetected$lambda$0(WinFormsDesignerTestBase this$0, VirtualFile $file) {
        return this$0.getWinFormsMark($file);
    }

    private static final boolean waitForNull$lambda$0(Ref.ObjectRef $value, Function0 $valueGetter) {
        $value.element = $valueGetter.invoke();
        return $value.element == null;
    }
}

