/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.openapi.project.Project;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.debugger.editAndContinue.DotNetHotReloadState;
import com.jetbrains.rider.debugger.editAndContinue.EncUtilKt;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import java.time.Duration;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"waitHotReloadReadyState", "", "project", "Lcom/intellij/openapi/project/Project;", "timeout", "Ljava/time/Duration;", "waitHotReloadNotInitializeState", "waitHotReloadState", "state", "Lcom/jetbrains/rider/debugger/editAndContinue/DotNetHotReloadState;", "intellij.rider.test.framework.integration.testng"})
@SourceDebugExtension(value={"SMAP\nHotReloadTestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotReloadTestBase.kt\ncom/jetbrains/rider/test/base/HotReloadTestBaseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
public final class HotReloadTestBaseKt {
    public static final void waitHotReloadReadyState(@NotNull Project project, @NotNull Duration timeout) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        HotReloadTestBaseKt.waitHotReloadState(project, timeout, DotNetHotReloadState.Ready);
        boolean bl2 = bl = !EncUtilKt.getHotReloadManager((Project)project).isHotReloadSessionTerminated();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Hot reload session terminated";
            throw new AssertionError((Object)string);
        }
    }

    public static /* synthetic */ void waitHotReloadReadyState$default(Project project, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        HotReloadTestBaseKt.waitHotReloadReadyState(project, duration);
    }

    public static final void waitHotReloadNotInitializeState(@NotNull Project project, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        HotReloadTestBaseKt.waitHotReloadState(project, timeout, DotNetHotReloadState.NotInitialize);
        boolean bl = EncUtilKt.getHotReloadManager((Project)project).isHotReloadSessionTerminated();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Hot reload session not terminated";
            throw new AssertionError((Object)string);
        }
    }

    public static /* synthetic */ void waitHotReloadNotInitializeState$default(Project project, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        HotReloadTestBaseKt.waitHotReloadNotInitializeState(project, duration);
    }

    public static final void waitHotReloadState(@NotNull Project project, @NotNull Duration timeout, @NotNull DotNetHotReloadState state) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        TestFrameworkBaseKt.getFrameworkLogger().info("Waiting for hot reload manager to state " + state);
        ExtensionsKt.pumpMessages((Duration)timeout, () -> HotReloadTestBaseKt.waitHotReloadState$lambda$0(project, state));
        boolean bl2 = bl = EncUtilKt.getHotReloadManager((Project)project).getState().getValueOrNull() == state;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The manager's status does not match the " + state + " status. Current state of " + EncUtilKt.getHotReloadManager((Project)project).getState().getValueOrNull();
            throw new AssertionError((Object)string);
        }
    }

    private static final boolean waitHotReloadState$lambda$0(Project $project, DotNetHotReloadState $state) {
        return EncUtilKt.getHotReloadManager((Project)$project).getState().getValueOrNull() == $state;
    }
}

