/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenario;
import com.jetbrains.rdclient.testFramework.TestFrameworkKt;
import com.jetbrains.rider.test.BaseIntegrationTest;
import com.jetbrains.rider.test.annotations.Solution;
import com.jetbrains.rider.test.environment.Environment_NuGetKt;
import com.jetbrains.rider.test.facades.TestApiScopes;
import com.jetbrains.rider.test.facades.application.ApplicationApiFacade;
import com.jetbrains.rider.test.facades.application.RiderApplicationApiFacade;
import com.jetbrains.rider.test.facades.environment.ExecutionTargetFacade;
import com.jetbrains.rider.test.facades.environment.ExecutionTargetInitializationResult;
import com.jetbrains.rider.test.facades.execution.EelExecutionTargetFacade;
import com.jetbrains.rider.test.facades.settings.BackendSettingsApiFacade;
import com.jetbrains.rider.test.facades.settings.RiderBackendSettingsApiFacade;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestFrameworkSettings;
import com.jetbrains.rider.test.framework.advancedSettings.AdvancedSettingsList;
import com.jetbrains.rider.test.framework.advancedSettings.RiderTestAdvancedSettingsManager;
import com.jetbrains.rider.test.framework.advancedSettings.TestAdvancedSettingsManager;
import com.jetbrains.rider.test.framework.nugetConfig.DefaultTestNuGetConfigManager;
import com.jetbrains.rider.test.framework.nugetConfig.TestNuGetConfigManager;
import com.jetbrains.rider.test.framework.processor.model.IntegrationTestMethod;
import com.jetbrains.rider.test.framework.profiling.RiderProfilingManager;
import com.jetbrains.rider.test.framework.registrySettings.RiderTestRegistryPropertiesManager;
import com.jetbrains.rider.test.framework.registrySettings.TestRegistryPropertiesManager;
import com.jetbrains.rider.test.framework.workDirectory.ExecutionTargetAwareTestWorkDirectoryStorage;
import com.jetbrains.rider.test.framework.workDirectory.TestWorkDirectoryStorage;
import com.jetbrains.rider.test.logging.RiderTestLogManager;
import com.jetbrains.rider.test.logging.TraceSettings;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Memory_BaseKt;
import com.jetbrains.rider.test.shared.utils.ProcessCleanupUtils;
import java.io.File;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020,H\u0007J\b\u00107\u001a\u00020,H\u0007J\b\u00108\u001a\u00020,H\u0007J\b\u0010=\u001a\u00020,H\u0007J\b\u0010>\u001a\u00020,H\u0007J\b\u0010D\u001a\u00020,H\u0007J\b\u0010E\u001a\u00020,H\u0007J\b\u0010K\u001a\u00020,H\u0007J\b\u0010L\u001a\u00020,H\u0007J\b\u0010M\u001a\u00020,H\u0007J\b\u0010]\u001a\u00020,H\u0007J\b\u0010^\u001a\u00020,H\u0007J\u0010\u0010_\u001a\u00020,2\u0006\u0010`\u001a\u00020aH\u0007J\b\u0010b\u001a\u00020,H\u0007J\b\u0010c\u001a\u00020,H\u0007J\b\u0010d\u001a\u00020,H\u0007R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0016\u0012\u0004\b\u001e\u0010\u0006\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0016\u001a\u0004\b$\u0010%R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001b\u0010.\u001a\u00020/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0016\u001a\u0004\b0\u00101R\u0014\u00103\u001a\u000204X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00109\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001b\u0010?\u001a\u00020@8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010\u0016\u001a\u0004\bA\u0010BR\u001b\u0010F\u001a\u00020G8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010\u0016\u001a\u0004\bH\u0010IR\u001b\u0010N\u001a\u00020O8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bR\u0010\u0016\u001a\u0004\bP\u0010QR\u001b\u0010S\u001a\u00020T8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bW\u0010\u0016\u001a\u0004\bU\u0010VR\u001b\u0010X\u001a\u00020Y8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u0010\u0016\u001a\u0004\bZ\u0010[\u00a8\u0006e"}, d2={"Lcom/jetbrains/rider/test/base/BaseTestWithShell;", "Lcom/jetbrains/rider/test/BaseIntegrationTest;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Application;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$BackendSettings;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Execution;", "<init>", "()V", "traceScenarios", "", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenario;", "getTraceScenarios", "()Ljava/util/Set;", "traceCategories", "", "", "getTraceCategories", "()Ljava/util/List;", "profilingManager", "Lcom/jetbrains/rider/test/framework/profiling/RiderProfilingManager;", "getProfilingManager", "()Lcom/jetbrains/rider/test/framework/profiling/RiderProfilingManager;", "profilingManager$delegate", "Lkotlin/Lazy;", "testLogManager", "Lcom/jetbrains/rider/test/logging/RiderTestLogManager;", "getTestLogManager", "()Lcom/jetbrains/rider/test/logging/RiderTestLogManager;", "testLogManager$delegate", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "registryPropertiesManager", "Lcom/jetbrains/rider/test/framework/registrySettings/TestRegistryPropertiesManager;", "getRegistryPropertiesManager", "()Lcom/jetbrains/rider/test/framework/registrySettings/TestRegistryPropertiesManager;", "registryPropertiesManager$delegate", "registrySetting", "", "getRegistrySetting", "()Ljava/util/Map;", "setCustomRegistryKeys", "", "resetCustomRegistryKeys", "advancedSettingsManager", "Lcom/jetbrains/rider/test/framework/advancedSettings/TestAdvancedSettingsManager;", "getAdvancedSettingsManager", "()Lcom/jetbrains/rider/test/framework/advancedSettings/TestAdvancedSettingsManager;", "advancedSettingsManager$delegate", "advancedSettings", "Lcom/jetbrains/rider/test/framework/advancedSettings/AdvancedSettingsList;", "getAdvancedSettings", "()Lcom/jetbrains/rider/test/framework/advancedSettings/AdvancedSettingsList;", "setAdvancedSettings", "resetAdvancedSettings", "frameViewerPluginEnabled", "", "getFrameViewerPluginEnabled", "()Z", "setFrameViewerAvailability", "resetFrameViewerAvailability", "testNuGetConfigManager", "Lcom/jetbrains/rider/test/framework/nugetConfig/TestNuGetConfigManager;", "getTestNuGetConfigManager", "()Lcom/jetbrains/rider/test/framework/nugetConfig/TestNuGetConfigManager;", "testNuGetConfigManager$delegate", "cleanUpGlobalCacheDir", "dumpUsedNugets", "applicationApiFacade", "Lcom/jetbrains/rider/test/facades/application/ApplicationApiFacade;", "getApplicationApiFacade", "()Lcom/jetbrains/rider/test/facades/application/ApplicationApiFacade;", "applicationApiFacade$delegate", "initEnvironmentAndApplication", "assertSuiteMemoryUsage", "shutdownApplication", "executionTargetFacade", "Lcom/jetbrains/rider/test/facades/environment/ExecutionTargetFacade;", "getExecutionTargetFacade", "()Lcom/jetbrains/rider/test/facades/environment/ExecutionTargetFacade;", "executionTargetFacade$delegate", "testWorkDirectoryStorage", "Lcom/jetbrains/rider/test/framework/workDirectory/TestWorkDirectoryStorage;", "getTestWorkDirectoryStorage", "()Lcom/jetbrains/rider/test/framework/workDirectory/TestWorkDirectoryStorage;", "testWorkDirectoryStorage$delegate", "backendSettingsApiFacade", "Lcom/jetbrains/rider/test/facades/settings/BackendSettingsApiFacade;", "getBackendSettingsApiFacade", "()Lcom/jetbrains/rider/test/facades/settings/BackendSettingsApiFacade;", "backendSettingsApiFacade$delegate", "prepareExecutionTarget", "tearDownExecutionTargets", "cleanUpWorkDirectory", "result", "Lorg/testng/ITestResult;", "logSystemProperties", "startProfiling", "stopProfiling", "intellij.rider.test.framework.integration.testng"})
@SourceDebugExtension(value={"SMAP\nBaseTestWithShell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseTestWithShell.kt\ncom/jetbrains/rider/test/base/BaseTestWithShell\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1068#2:223\n1915#2,2:224\n*S KotlinDebug\n*F\n+ 1 BaseTestWithShell.kt\ncom/jetbrains/rider/test/base/BaseTestWithShell\n*L\n203#1:223\n204#1:224,2\n*E\n"})
public abstract class BaseTestWithShell
extends BaseIntegrationTest
implements TestApiScopes.Application,
TestApiScopes.BackendSettings,
TestApiScopes.Execution {
    @NotNull
    private final Set<LogTraceScenario> traceScenarios = SetsKt.emptySet();
    @NotNull
    private final List<String> traceCategories = CollectionsKt.emptyList();
    @NotNull
    private final Lazy profilingManager$delegate = LazyKt.lazy(() -> BaseTestWithShell.profilingManager_delegate$lambda$0(this));
    @NotNull
    private final Lazy testLogManager$delegate = LazyKt.lazy(() -> BaseTestWithShell.testLogManager_delegate$lambda$0(this));
    @NotNull
    private final Lazy logger$delegate = LazyKt.lazy(() -> BaseTestWithShell.logger_delegate$lambda$0(this));
    @NotNull
    private final Lazy registryPropertiesManager$delegate = LazyKt.lazy(BaseTestWithShell::registryPropertiesManager_delegate$lambda$0);
    @NotNull
    private final Map<String, String> registrySetting = MapsKt.emptyMap();
    @NotNull
    private final Lazy advancedSettingsManager$delegate = LazyKt.lazy(BaseTestWithShell::advancedSettingsManager_delegate$lambda$0);
    @NotNull
    private final AdvancedSettingsList advancedSettings = new AdvancedSettingsList(null, null, null, null, 15, null);
    @NotNull
    private final Lazy testNuGetConfigManager$delegate = LazyKt.lazy(() -> BaseTestWithShell.testNuGetConfigManager_delegate$lambda$0(this));
    @NotNull
    private final Lazy applicationApiFacade$delegate = LazyKt.lazy(BaseTestWithShell::applicationApiFacade_delegate$lambda$0);
    @NotNull
    private final Lazy executionTargetFacade$delegate = LazyKt.lazy(BaseTestWithShell::executionTargetFacade_delegate$lambda$0);
    @NotNull
    private final Lazy testWorkDirectoryStorage$delegate = LazyKt.lazy(() -> BaseTestWithShell.testWorkDirectoryStorage_delegate$lambda$0(this));
    @NotNull
    private final Lazy backendSettingsApiFacade$delegate = LazyKt.lazy(BaseTestWithShell::backendSettingsApiFacade_delegate$lambda$0);

    @NotNull
    public Set<LogTraceScenario> getTraceScenarios() {
        return this.traceScenarios;
    }

    @NotNull
    public List<String> getTraceCategories() {
        return this.traceCategories;
    }

    @NotNull
    public final RiderProfilingManager getProfilingManager() {
        Lazy lazy = this.profilingManager$delegate;
        return (RiderProfilingManager)lazy.getValue();
    }

    @NotNull
    public RiderTestLogManager getTestLogManager() {
        Lazy lazy = this.testLogManager$delegate;
        return (RiderTestLogManager)lazy.getValue();
    }

    @NotNull
    public final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    public static /* synthetic */ void getLogger$annotations() {
    }

    private final TestRegistryPropertiesManager getRegistryPropertiesManager() {
        Lazy lazy = this.registryPropertiesManager$delegate;
        return (TestRegistryPropertiesManager)lazy.getValue();
    }

    @NotNull
    public Map<String, String> getRegistrySetting() {
        return this.registrySetting;
    }

    @BeforeClass
    public final void setCustomRegistryKeys() {
        this.getRegistryPropertiesManager().setCustomRegistryKeys(this.getRegistrySetting());
    }

    @AfterClass
    public final void resetCustomRegistryKeys() {
        this.getRegistryPropertiesManager().resetCustomRegistryKeys();
    }

    private final TestAdvancedSettingsManager getAdvancedSettingsManager() {
        Lazy lazy = this.advancedSettingsManager$delegate;
        return (TestAdvancedSettingsManager)lazy.getValue();
    }

    @NotNull
    public AdvancedSettingsList getAdvancedSettings() {
        return this.advancedSettings;
    }

    @BeforeClass
    public final void setAdvancedSettings() {
        this.getAdvancedSettingsManager().setAdvancedSettings(this.getAdvancedSettings());
    }

    @AfterClass
    public final void resetAdvancedSettings() {
        this.getAdvancedSettingsManager().resetAdvancedSettings();
    }

    public boolean getFrameViewerPluginEnabled() {
        return false;
    }

    @BeforeClass
    public final void setFrameViewerAvailability() {
        if (this.getRegistryPropertiesManager().hasRegistryKey("frame.viewer.plugin.enabled")) {
            this.getRegistryPropertiesManager().setCustomRegistryKeys(MapsKt.mapOf((Pair)TuplesKt.to((Object)"frame.viewer.plugin.enabled", (Object)String.valueOf(this.getFrameViewerPluginEnabled()))));
        }
    }

    @AfterClass
    public final void resetFrameViewerAvailability() {
        if (this.getRegistryPropertiesManager().hasRegistryKey("frame.viewer.plugin.enabled")) {
            this.getRegistryPropertiesManager().setCustomRegistryKeys(MapsKt.mapOf((Pair)TuplesKt.to((Object)"frame.viewer.plugin.enabled", (Object)"false")));
        }
    }

    @NotNull
    public TestNuGetConfigManager getTestNuGetConfigManager() {
        Lazy lazy = this.testNuGetConfigManager$delegate;
        return (TestNuGetConfigManager)lazy.getValue();
    }

    @BeforeSuite
    public final void cleanUpGlobalCacheDir() {
        Environment_NuGetKt.resetNuGetTestCacheFolder();
    }

    @AfterSuite(alwaysRun=true)
    public final void dumpUsedNugets() {
        this.getTestNuGetConfigManager().dumpNuGetPackages();
        Environment_NuGetKt.resetNuGetTestCacheFolder();
    }

    @NotNull
    public ApplicationApiFacade getApplicationApiFacade() {
        Lazy lazy = this.applicationApiFacade$delegate;
        return (ApplicationApiFacade)lazy.getValue();
    }

    @BeforeSuite(alwaysRun=true)
    public final void initEnvironmentAndApplication() {
        if (TestFrameworkSettings.Profiling.INSTANCE.getEnableBackendProfiling()) {
            this.getProfilingManager().setupBackendProfiling();
        }
        this.getApplicationApiFacade().initEnvironment();
        this.getApplicationApiFacade().startApplication();
    }

    @AfterSuite(alwaysRun=true)
    public final void assertSuiteMemoryUsage() {
        ScriptingAPI_Memory_BaseKt.assertMemoryUsage();
    }

    @AfterSuite(dependsOnMethods={"assertSuiteMemoryUsage", "dumpUsedNugets", "logSystemProperties", "tearDownExecutionTargets"}, alwaysRun=true)
    public final void shutdownApplication() {
        this.getApplicationApiFacade().stopApplication();
        if (TestFrameworkKt.isUnderTeamCity()) {
            ProcessCleanupUtils.cleanupSuspiciousProcesses$default((ProcessCleanupUtils)ProcessCleanupUtils.INSTANCE, null, (int)1, null);
        }
    }

    @NotNull
    public ExecutionTargetFacade getExecutionTargetFacade() {
        Lazy lazy = this.executionTargetFacade$delegate;
        return (ExecutionTargetFacade)lazy.getValue();
    }

    @NotNull
    public TestWorkDirectoryStorage getTestWorkDirectoryStorage() {
        Lazy lazy = this.testWorkDirectoryStorage$delegate;
        return (TestWorkDirectoryStorage)lazy.getValue();
    }

    @NotNull
    public BackendSettingsApiFacade getBackendSettingsApiFacade() {
        Lazy lazy = this.backendSettingsApiFacade$delegate;
        return (BackendSettingsApiFacade)lazy.getValue();
    }

    @BeforeClass(alwaysRun=true)
    public final void prepareExecutionTarget() {
        ExecutionTargetInitializationResult initResult = this.getExecutionTargetFacade().initializeExecutionTarget(this.getTestClass().getExecutionTarget());
        if (initResult instanceof ExecutionTargetInitializationResult.NotAvailable) {
            throw new SkipException(((ExecutionTargetInitializationResult.NotAvailable)initResult).getReason());
        }
    }

    @AfterSuite(alwaysRun=true)
    public final void tearDownExecutionTargets() {
        this.getExecutionTargetFacade().shutdownExecutionTargets();
    }

    @AfterMethod(alwaysRun=true)
    public final void cleanUpWorkDirectory(@NotNull ITestResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!result2.isSuccess() && ((IntegrationTestMethod)this.getTestMethod()).getExecutionPlan().getShouldRun()) {
            Solution solution = ((IntegrationTestMethod)this.getTestMethod()).getSolution();
            boolean bl = solution != null ? solution.saveOnFailure() : false;
            if (bl) {
                this.storeCurrentSolutionState();
            }
        }
        if (this.getCleanTestWorkDirectory() && this.getTestWorkDirectory().exists()) {
            FilesKt.deleteRecursively((File)this.getTestWorkDirectory());
        }
    }

    @AfterSuite(alwaysRun=true)
    public final void logSystemProperties() {
        if (((CharSequence)TestFrameworkSettings.INSTANCE.getAdditionalRegistryKeys()).length() == 0) {
            return;
        }
        StringBuilder registrySettings = new StringBuilder();
        registrySettings.append("Used system registry settings:").append('\n');
        Set<Map.Entry<Object, Object>> set = System.getProperties().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKey().toString());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey().toString())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object name = entry.getKey();
            Object value = entry.getValue();
            registrySettings.append(name + ": " + value).append('\n');
        }
        TestFrameworkBaseKt.getFrameworkLogger().info(registrySettings.toString());
    }

    @BeforeClass
    public final void startProfiling() {
        if (TestFrameworkSettings.Profiling.INSTANCE.getEnableFrontendProfiling()) {
            this.getProfilingManager().startFrontendProfiling();
        }
    }

    @AfterClass(alwaysRun=true)
    public final void stopProfiling() {
        if (TestFrameworkSettings.Profiling.INSTANCE.getEnableFrontendProfiling()) {
            this.getProfilingManager().stopFrontendProfiling();
        }
    }

    private static final RiderProfilingManager profilingManager_delegate$lambda$0(BaseTestWithShell this$0) {
        return new RiderProfilingManager(this$0.getTestProcessor());
    }

    private static final RiderTestLogManager testLogManager_delegate$lambda$0(BaseTestWithShell this$0) {
        return new RiderTestLogManager(new TraceSettings(this$0.getTraceScenarios(), this$0.getTraceCategories()));
    }

    private static final Logger logger_delegate$lambda$0(BaseTestWithShell this$0) {
        Logger logger = Logger.getInstance(((Object)((Object)this$0)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final RiderTestRegistryPropertiesManager registryPropertiesManager_delegate$lambda$0() {
        return new RiderTestRegistryPropertiesManager();
    }

    private static final RiderTestAdvancedSettingsManager advancedSettingsManager_delegate$lambda$0() {
        return new RiderTestAdvancedSettingsManager();
    }

    private static final DefaultTestNuGetConfigManager testNuGetConfigManager_delegate$lambda$0(BaseTestWithShell this$0) {
        return new DefaultTestNuGetConfigManager(this$0.getTestDataStorage(), this$0.getTestWorkDirectoryStorage(), this$0.getTestProcessor());
    }

    private static final RiderApplicationApiFacade applicationApiFacade_delegate$lambda$0() {
        Duration duration = Duration.ofMinutes(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        return new RiderApplicationApiFacade(duration);
    }

    private static final EelExecutionTargetFacade executionTargetFacade_delegate$lambda$0() {
        return new EelExecutionTargetFacade();
    }

    private static final ExecutionTargetAwareTestWorkDirectoryStorage testWorkDirectoryStorage_delegate$lambda$0(BaseTestWithShell this$0) {
        return new ExecutionTargetAwareTestWorkDirectoryStorage(this$0.getExecutionTargetFacade(), this$0.getTestProcessor());
    }

    private static final RiderBackendSettingsApiFacade backendSettingsApiFacade_delegate$lambda$0() {
        return new RiderBackendSettingsApiFacade();
    }
}

