/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base.templates.sdk;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.NetworkUtils;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfiguration;
import com.jetbrains.rider.test.annotations.report.ChecklistItems;
import com.jetbrains.rider.test.base.ProjectTemplateBaseTest;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_RunCfgKt;
import com.jetbrains.rider.test.scriptingApi.TemplateIdWithVersion;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.Test;

@ChecklistItems(items={"New Solution or New Project Wizard/Project templates basic creation/Web apps"})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0017H\u0007J\b\u0010\u0019\u001a\u00020\u0017H\u0007J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/test/base/templates/sdk/BlazorAssemblyProjectTemplateTestBase;", "Lcom/jetbrains/rider/test/base/ProjectTemplateBaseTest;", "templateId", "Lcom/jetbrains/rider/test/scriptingApi/TemplateIdWithVersion;", "<init>", "(Lcom/jetbrains/rider/test/scriptingApi/TemplateIdWithVersion;)V", "getTemplateId", "()Lcom/jetbrains/rider/test/scriptingApi/TemplateIdWithVersion;", "projectName", "", "getProjectName", "()Ljava/lang/String;", "port", "", "getPort", "()I", "port$delegate", "Lkotlin/Lazy;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "prepareConfiguration", "", "runConfiguration", "runProgram", "setCompatibleBrowser", "getCompatibleBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "intellij.rider.test.framework.integration.testng"})
@SourceDebugExtension(value={"SMAP\nBlazorAssemblyProjectTemplateTestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlazorAssemblyProjectTemplateTestBase.kt\ncom/jetbrains/rider/test/base/templates/sdk/BlazorAssemblyProjectTemplateTestBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1586#2:63\n1661#2,3:64\n812#2,12:67\n777#2:79\n873#2,2:80\n1915#2,2:82\n296#2,2:84\n*S KotlinDebug\n*F\n+ 1 BlazorAssemblyProjectTemplateTestBase.kt\ncom/jetbrains/rider/test/base/templates/sdk/BlazorAssemblyProjectTemplateTestBase\n*L\n51#1:63\n51#1:64,3\n52#1:67,12\n53#1:79\n53#1:80,2\n54#1:82,2\n61#1:84,2\n*E\n"})
public abstract class BlazorAssemblyProjectTemplateTestBase
extends ProjectTemplateBaseTest {
    @NotNull
    private final TemplateIdWithVersion templateId;
    @NotNull
    private final Lazy port$delegate;

    public BlazorAssemblyProjectTemplateTestBase(@NotNull TemplateIdWithVersion templateId) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        this.templateId = templateId;
        this.port$delegate = LazyKt.lazy(BlazorAssemblyProjectTemplateTestBase::port_delegate$lambda$0);
    }

    @Override
    @NotNull
    public TemplateIdWithVersion getTemplateId() {
        return this.templateId;
    }

    @Override
    @NotNull
    public String getProjectName() {
        return "WasmBlazor";
    }

    private final int getPort() {
        Lazy lazy = this.port$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final URL getUrl() {
        return new URL(SystemInfo.isWindows ? "https://localhost:" + this.getPort() : "http://127.0.0.1:" + this.getPort());
    }

    @Test(dependsOnMethods={"createTemplateProject"})
    public final void prepareConfiguration() {
        this.setCompatibleBrowser();
    }

    @Test(dependsOnMethods={"prepareConfiguration"})
    public final void runConfiguration() {
        ScriptingAPI_RunCfgKt.checkCanExecuteSelectedRunConfiguration((Project)this.getProject());
        GoldFilesHelperKt.executeWithGold((File)this.getConfigGoldFile(), arg_0 -> BlazorAssemblyProjectTemplateTestBase.runConfiguration$lambda$0(this, arg_0));
        ScriptingAPI_RunCfgKt.selectFirstRunConfiguration((Project)this.getProject(), BlazorAssemblyProjectTemplateTestBase::runConfiguration$lambda$1);
        ScriptingAPIKt.setAspNetCoreUrl((Project)this.getProject(), (URL)this.getUrl());
        ScriptingAPI_RunCfgKt.disableBrowserLaunchInSelectedConfiguration((Project)this.getProject());
    }

    @Test(dependsOnMethods={"buildSolution", "runConfiguration"})
    public final void runProgram() {
        ScriptingAPIKt.runWebProgram$default((Project)this.getProject(), (URL)this.getUrl(), null, null, (int)12, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void setCompatibleBrowser() {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        LaunchSettingsConfiguration it;
        Iterable $this$mapTo$iv$iv;
        WebBrowser compatibleBrowser = this.getCompatibleBrowser();
        Iterable $this$map$iv = RunManagerEx.getInstanceEx((Project)this.getProject()).getAllSettings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getConfiguration());
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LaunchSettingsConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LaunchSettingsConfiguration)element$iv$iv;
            boolean bl = false;
            if (!it.isBlazorWasm()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LaunchSettingsConfiguration it2 = (LaunchSettingsConfiguration)element$iv;
            boolean bl = false;
            this.getLogger().info("Setting the browser for configuration '" + it2.getName() + "' to '" + compatibleBrowser + "'");
            it2.getParameters().getStartBrowserParameters().setBrowser(compatibleBrowser);
        }
    }

    private final WebBrowser getCompatibleBrowser() {
        Object v1;
        block1: {
            List list = WebBrowserManager.getInstance().getActiveBrowsers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActiveBrowsers(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WebBrowser it = (WebBrowser)element$iv;
                boolean bl = false;
                if (!(it.getFamily() == BrowserFamily.CHROME)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final int port_delegate$lambda$0() {
        return NetworkUtils.INSTANCE.findFreePort(5002);
    }

    private static final Unit runConfiguration$lambda$0(BlazorAssemblyProjectTemplateTestBase this$0, PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        ScriptingAPI_RunCfgKt.doTestDumpRunConfigurationsFromRunManager$default((Project)this$0.getProject(), (PrintStream)printStream, (boolean)true, (boolean)false, (boolean)true, null, (int)40, null);
        return Unit.INSTANCE;
    }

    private static final boolean runConfiguration$lambda$1(RunConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !ScriptingAPI_RunCfgKt.isIisExpressRunConfiguration((RunConfiguration)it);
    }
}

