/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.junit5.filters;

import com.jetbrains.rider.test.framework.TestEnvironmentProcessor;
import com.jetbrains.rider.test.framework.TestExecutionPlanProcessor;
import com.jetbrains.rider.test.framework.TestExecutionTargetProcessor;
import com.jetbrains.rider.test.framework.processor.model.TestExecutionPlan;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.PostDiscoveryFilter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/test/junit5/filters/TestEnvironmentFilter;", "Lorg/junit/platform/launcher/PostDiscoveryFilter;", "<init>", "()V", "testEnvironmentProcessor", "Lcom/jetbrains/rider/test/framework/TestEnvironmentProcessor;", "testExecutionTargetProcessor", "Lcom/jetbrains/rider/test/framework/TestExecutionTargetProcessor;", "testExecutionPlanProcessor", "Lcom/jetbrains/rider/test/framework/TestExecutionPlanProcessor;", "apply", "Lorg/junit/platform/engine/FilterResult;", "testDescriptor", "Lorg/junit/platform/engine/TestDescriptor;", "intellij.rider.test.framework.junit"})
public final class TestEnvironmentFilter
implements PostDiscoveryFilter {
    @NotNull
    private final TestEnvironmentProcessor testEnvironmentProcessor = new TestEnvironmentProcessor();
    @NotNull
    private final TestExecutionTargetProcessor testExecutionTargetProcessor = new TestExecutionTargetProcessor();
    @NotNull
    private final TestExecutionPlanProcessor testExecutionPlanProcessor = new TestExecutionPlanProcessor(this.testEnvironmentProcessor, this.testExecutionTargetProcessor);

    @NotNull
    public FilterResult apply(@NotNull TestDescriptor testDescriptor) {
        TestExecutionPlan executionPlan;
        Intrinsics.checkNotNullParameter((Object)testDescriptor, (String)"testDescriptor");
        TestDescriptor testDescriptor2 = testDescriptor;
        if (testDescriptor2 instanceof MethodBasedTestDescriptor) {
            Method method = ((MethodBasedTestDescriptor)testDescriptor).getTestMethod();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getTestMethod(...)");
            Class clazz = ((MethodBasedTestDescriptor)testDescriptor).getTestClass();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getTestClass(...)");
            v2 = this.testExecutionPlanProcessor.processTest(method, clazz, new Object[0]);
        } else if (testDescriptor2 instanceof ClassTestDescriptor) {
            Class clazz = ((ClassTestDescriptor)testDescriptor).getTestClass();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getTestClass(...)");
            v2 = this.testExecutionPlanProcessor.processClass(clazz);
        } else {
            v2 = executionPlan = new TestExecutionPlan();
        }
        if (executionPlan.getShouldSkip()) {
            FilterResult filterResult = FilterResult.excluded((String)executionPlan.getSkipMessage());
            Intrinsics.checkNotNullExpressionValue((Object)filterResult, (String)"excluded(...)");
            return filterResult;
        }
        FilterResult filterResult = FilterResult.included((String)"Test allowed to run");
        Intrinsics.checkNotNullExpressionValue((Object)filterResult, (String)"included(...)");
        return filterResult;
    }
}

