/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.framework.runner;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.util.TimeoutUtil;
import com.jetbrains.rider.test.TestDirectories;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestFrameworkSettings;
import com.jetbrains.rider.test.framework.TestsMutedException;
import com.jetbrains.rider.test.framework.processor.TestProcessor;
import com.jetbrains.rider.test.framework.processor.model.TestMethod;
import com.jetbrains.rider.test.framework.runner.NoSkipMethod;
import com.jetbrains.rider.test.framework.runner.TestRunner;
import com.jetbrains.rider.test.logging.RiderLoggedErrorProcessor;
import com.jetbrains.rider.test.logging.TestLoggerHelper;
import com.jetbrains.rider.test.logging.knownErrors.KnownLogErrors;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Memory_BaseKt;
import com.jetbrains.rider.test.testng.TestNgUtilsKt;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.testng.IConfigureCallBack;
import org.testng.IHookCallBack;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H$J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H$J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u001f\u001a\u00020\u0012J\u001c\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016J&\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J\u001a\u0010)\u001a\u00020\u00122\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u0016H\u0002J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00028\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u00101\u001a\u00020&*\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lcom/jetbrains/rider/test/framework/runner/BaseTestRunner;", "T", "Lcom/jetbrains/rider/test/framework/processor/model/TestMethod;", "Lcom/jetbrains/rider/test/framework/runner/TestRunner;", "testProcessor", "Lcom/jetbrains/rider/test/framework/processor/TestProcessor;", "riderLoggedErrorProcessor", "Lcom/jetbrains/rider/test/logging/RiderLoggedErrorProcessor;", "<init>", "(Lcom/jetbrains/rider/test/framework/processor/TestProcessor;Lcom/jetbrains/rider/test/logging/RiderLoggedErrorProcessor;)V", "getTestProcessor", "()Lcom/jetbrains/rider/test/framework/processor/TestProcessor;", "getRiderLoggedErrorProcessor", "()Lcom/jetbrains/rider/test/logging/RiderLoggedErrorProcessor;", "testMethod", "getTestMethod", "()Lcom/jetbrains/rider/test/framework/processor/model/TestMethod;", "runConfigurationMethod", "", "testResult", "Lorg/testng/ITestResult;", "callBack", "Lkotlin/Function0;", "runTest", "run", "Lorg/testng/IConfigureCallBack;", "fileURI", "Ljava/net/URI;", "file", "Ljava/nio/file/Path;", "Lorg/testng/IHookCallBack;", "checkTestStatus", "withAdditionalKnownErrors", "additionalKnownErrors", "Lcom/jetbrains/rider/test/logging/knownErrors/KnownLogErrors;", "runnable", "runMethod", "entityName", "", "actionName", "action", "throwExceptionsIfNotEmpty", "warningMessage", "checkFreeSpace", "methodName", "needSkipConfigurationMethod", "", "testNgMethod", "Lorg/testng/ITestNGMethod;", "methodType", "getMethodType", "(Lorg/testng/ITestNGMethod;)Ljava/lang/String;", "intellij.rider.test.framework.testng"})
@SourceDebugExtension(value={"SMAP\nBaseTestRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseTestRunner.kt\ncom/jetbrains/rider/test/framework/runner/BaseTestRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public abstract class BaseTestRunner<T extends TestMethod>
implements TestRunner {
    @NotNull
    private final TestProcessor<T> testProcessor;
    @NotNull
    private final RiderLoggedErrorProcessor riderLoggedErrorProcessor;

    public BaseTestRunner(@NotNull TestProcessor<? extends T> testProcessor, @NotNull RiderLoggedErrorProcessor riderLoggedErrorProcessor) {
        Intrinsics.checkNotNullParameter(testProcessor, (String)"testProcessor");
        Intrinsics.checkNotNullParameter((Object)riderLoggedErrorProcessor, (String)"riderLoggedErrorProcessor");
        this.testProcessor = testProcessor;
        this.riderLoggedErrorProcessor = riderLoggedErrorProcessor;
    }

    public /* synthetic */ BaseTestRunner(TestProcessor testProcessor, RiderLoggedErrorProcessor riderLoggedErrorProcessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            riderLoggedErrorProcessor = new RiderLoggedErrorProcessor(null, false, 3, null);
        }
        this(testProcessor, riderLoggedErrorProcessor);
    }

    @NotNull
    public final TestProcessor<T> getTestProcessor() {
        return this.testProcessor;
    }

    @NotNull
    public final RiderLoggedErrorProcessor getRiderLoggedErrorProcessor() {
        return this.riderLoggedErrorProcessor;
    }

    @NotNull
    protected final T getTestMethod() {
        return (T)this.testProcessor.getTestMethod();
    }

    protected abstract void runConfigurationMethod(@NotNull ITestResult var1, @NotNull Function0<Unit> var2);

    protected abstract void runTest(@NotNull ITestResult var1, @NotNull Function0<Unit> var2);

    @Override
    public void run(@NotNull IConfigureCallBack callBack, @NotNull ITestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        ITestNGMethod iTestNGMethod = testResult.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)iTestNGMethod, (String)"getMethod(...)");
        String entityName = this.getMethodType(iTestNGMethod);
        String actionName = TestNgUtilsKt.getFullTestName(testResult);
        ITestNGMethod iTestNGMethod2 = testResult.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)iTestNGMethod2, (String)"getMethod(...)");
        if (this.needSkipConfigurationMethod(iTestNGMethod2)) {
            TestFrameworkBaseKt.getFrameworkLogger().info("<" + entityName + "> '" + actionName + "' skipping...");
            testResult.setStatus(3);
            return;
        }
        ITestNGMethod iTestNGMethod3 = testResult.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)iTestNGMethod3, (String)"getMethod(...)");
        this.runMethod(this.getMethodType(iTestNGMethod3), TestNgUtilsKt.getFullTestName(testResult), (Function0<Unit>)((Function0)() -> BaseTestRunner.run$lambda$0(this, testResult, callBack)));
    }

    @NotNull
    protected final URI fileURI(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new URI("file", "", file.toUri().getPath(), null);
    }

    @Override
    public void run(@NotNull IHookCallBack callBack, @NotNull ITestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        TestFrameworkBaseKt.getFrameworkLogger().info("Validate status for test '" + this.getTestMethod().getName() + "'");
        this.checkTestStatus();
        this.runMethod("Test", this.getTestMethod().getCanonicalName(), (Function0<Unit>)((Function0)() -> BaseTestRunner.run$lambda$1(this, testResult, callBack)));
    }

    public final void checkTestStatus() {
        if (this.getTestMethod().getExecutionPlan().getShouldSkip()) {
            TestFrameworkBaseKt.getFrameworkLogger().info(this.getTestMethod().getExecutionPlan().getSkipMessage());
            throw new SkipException(this.getTestMethod().getExecutionPlan().getSkipMessage());
        }
        if (this.getTestMethod().getExecutionPlan().getShouldMute()) {
            TestFrameworkBaseKt.getFrameworkLogger().info(this.getTestMethod().getExecutionPlan().getMuteMessage());
            throw new TestsMutedException(this.getTestMethod().getExecutionPlan().getMuteMessage());
        }
    }

    public final void withAdditionalKnownErrors(@NotNull KnownLogErrors additionalKnownErrors, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter((Object)additionalKnownErrors, (String)"additionalKnownErrors");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        RiderLoggedErrorProcessor newLoggedErrorProcessor = new RiderLoggedErrorProcessor(this.riderLoggedErrorProcessor.getKnownLogErrors().plus(additionalKnownErrors), false, 2, null);
        LoggedErrorProcessor.executeWith((LoggedErrorProcessor)((LoggedErrorProcessor)newLoggedErrorProcessor), () -> BaseTestRunner.withAdditionalKnownErrors$lambda$0(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runMethod(String entityName, String actionName, Function0<Unit> action) {
        long startTime = System.nanoTime();
        TestFrameworkBaseKt.getFrameworkLogger().info("<" + entityName + ".Start> '" + actionName + "'");
        try {
            LoggedErrorProcessor.executeWith((LoggedErrorProcessor)((LoggedErrorProcessor)this.riderLoggedErrorProcessor), () -> BaseTestRunner.runMethod$lambda$0(action));
        }
        finally {
            TestFrameworkBaseKt.getFrameworkLogger().info("<" + entityName + ".Finish> '" + actionName + "' time=" + TimeoutUtil.getDurationMillis((long)startTime) + " ms");
            BaseTestRunner.throwExceptionsIfNotEmpty$default(this, null, 1, null);
        }
    }

    private final void throwExceptionsIfNotEmpty(Function0<String> warningMessage) {
        if (TestLoggerHelper.INSTANCE.getTestErrorsAccumulator().hasExceptions()) {
            Function0<String> function0 = warningMessage;
            if (function0 != null) {
                Function0<String> it = function0;
                boolean bl = false;
                TestFrameworkBaseKt.getFrameworkLogger().warn((String)it.invoke());
            }
            TestLoggerHelper.INSTANCE.getTestErrorsAccumulator().throwIfNotEmpty();
        }
    }

    static /* synthetic */ void throwExceptionsIfNotEmpty$default(BaseTestRunner baseTestRunner, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: throwExceptionsIfNotEmpty");
        }
        if ((n & 1) != 0) {
            function0 = null;
        }
        baseTestRunner.throwExceptionsIfNotEmpty((Function0<String>)function0);
    }

    protected void checkFreeSpace(@NotNull String methodName, @NotNull ITestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        File file = TestDirectories.INSTANCE.getJetTestRider().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ScriptingAPI_Memory_BaseKt.assertAndLogFreeSpace((File)file);
    }

    private final boolean needSkipConfigurationMethod(ITestNGMethod testNgMethod) {
        if (testNgMethod.getConstructorOrMethod().getMethod().isAnnotationPresent(NoSkipMethod.class)) {
            return false;
        }
        if ((testNgMethod.isBeforeClassConfiguration() || testNgMethod.isAfterClassConfiguration()) && this.testProcessor.getHasTestClass() && !this.testProcessor.getTestClass().getExecutionPlan().getShouldRun()) {
            return true;
        }
        return (testNgMethod.isBeforeMethodConfiguration() || testNgMethod.isAfterMethodConfiguration()) && this.testProcessor.getHasTestMethod() && !this.getTestMethod().getExecutionPlan().getShouldRun();
    }

    private final String getMethodType(ITestNGMethod $this$methodType) {
        return $this$methodType.isBeforeSuiteConfiguration() ? "BeforeSuite" : ($this$methodType.isBeforeGroupsConfiguration() ? "BeforeGroups" : ($this$methodType.isBeforeTestConfiguration() ? "BeforeTest" : ($this$methodType.isBeforeClassConfiguration() ? "BeforeClass" : ($this$methodType.isBeforeMethodConfiguration() ? "BeforeMethod" : ($this$methodType.isTest() ? "Test" : ($this$methodType.isAfterMethodConfiguration() ? "AfterMethod" : ($this$methodType.isAfterClassConfiguration() ? "AfterClass" : ($this$methodType.isAfterTestConfiguration() ? "AfterTest" : ($this$methodType.isAfterGroupsConfiguration() ? "AfterGroups" : ($this$methodType.isAfterSuiteConfiguration() ? "AfterSuite" : "UnknownMethod"))))))))));
    }

    private static final Unit run$lambda$0$0(IConfigureCallBack $callBack, ITestResult $testResult) {
        $callBack.runConfigurationMethod($testResult);
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$0(BaseTestRunner this$0, ITestResult $testResult, IConfigureCallBack $callBack) {
        this$0.runConfigurationMethod($testResult, (Function0<Unit>)((Function0)() -> BaseTestRunner.run$lambda$0$0($callBack, $testResult)));
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$1$0(IHookCallBack $callBack, ITestResult $testResult) {
        $callBack.runTestMethod($testResult);
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$1(BaseTestRunner this$0, ITestResult $testResult, IHookCallBack $callBack) {
        TestFrameworkBaseKt.getFrameworkLogger().info("Test log dir: " + this$0.fileURI(this$0.getTestMethod().getLogDirectory()));
        Logger logger = TestFrameworkBaseKt.getFrameworkLogger();
        Path path = TestDirectories.INSTANCE.getJetTestRiderStoredSolutions().resolve(this$0.getTestMethod().getName() + TestFrameworkSettings.Retry.INSTANCE.getRetryPostfix());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        logger.info("Failed test solution dir: " + this$0.fileURI(path));
        this$0.checkFreeSpace(this$0.getTestMethod().getName(), $testResult);
        this$0.runTest($testResult, (Function0<Unit>)((Function0)() -> BaseTestRunner.run$lambda$1$0($callBack, $testResult)));
        this$0.checkFreeSpace(this$0.getTestMethod().getName(), $testResult);
        return Unit.INSTANCE;
    }

    private static final void withAdditionalKnownErrors$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit runMethod$lambda$0$0(Function0 $action) {
        $action.invoke();
        return Unit.INSTANCE;
    }

    private static final void runMethod$lambda$0(Function0 $action) {
        ClientId.Companion.withClientId(ClientId.Companion.getLocalId(), () -> BaseTestRunner.runMethod$lambda$0$0($action));
    }
}

