/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.teamcity;

import com.jetbrains.rider.test.TestDirectories;
import com.jetbrains.rider.test.teamcity.TestServiceMessageReporter;
import com.jetbrains.rider.test.testng.TestNgUtilsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.testng.ISuite;
import org.testng.ITestResult;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u00020\u000e*\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/test/teamcity/RetryInfoReporter;", "", "serviceMessageReporter", "Lcom/jetbrains/rider/test/teamcity/TestServiceMessageReporter;", "<init>", "(Lcom/jetbrains/rider/test/teamcity/TestServiceMessageReporter;)V", "classesToRetryFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "groupsToRetryFile", "failedConfigurationsFile", "retryOnConfigurationFailure", "", "reportRetryInfo", "", "suite", "Lorg/testng/ISuite;", "appendUniqueLines", "set", "", "", "intellij.rider.test.framework.testng"})
@SourceDebugExtension(value={"SMAP\nRetryInfoReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryInfoReporter.kt\ncom/jetbrains/rider/test/teamcity/RetryInfoReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1586#2:97\n1661#2,3:98\n1391#2:101\n1480#2,5:102\n777#2:107\n873#2,2:108\n1586#2:110\n1661#2,3:111\n1391#2:114\n1480#2,5:115\n777#2:120\n873#2,2:121\n1586#2:123\n1661#2,3:124\n777#2:128\n873#2,2:129\n1#3:127\n*S KotlinDebug\n*F\n+ 1 RetryInfoReporter.kt\ncom/jetbrains/rider/test/teamcity/RetryInfoReporter\n*L\n36#1:97\n36#1:98,3\n37#1:101\n37#1:102,5\n42#1:107\n42#1:108,2\n47#1:110\n47#1:111,3\n66#1:114\n66#1:115,5\n66#1:120\n66#1:121,2\n72#1:123\n72#1:124,3\n93#1:128\n93#1:129,2\n*E\n"})
public final class RetryInfoReporter {
    @NotNull
    private final TestServiceMessageReporter serviceMessageReporter;
    private final Path classesToRetryFile;
    private final Path groupsToRetryFile;
    private final Path failedConfigurationsFile;
    private final boolean retryOnConfigurationFailure;

    public RetryInfoReporter(@NotNull TestServiceMessageReporter serviceMessageReporter) {
        Intrinsics.checkNotNullParameter((Object)serviceMessageReporter, (String)"serviceMessageReporter");
        this.serviceMessageReporter = serviceMessageReporter;
        this.classesToRetryFile = TestDirectories.INSTANCE.getJetTestRider().resolve("failedClasses.txt");
        this.groupsToRetryFile = TestDirectories.INSTANCE.getJetTestRider().resolve("failedGroups.txt");
        this.failedConfigurationsFile = TestDirectories.INSTANCE.getJetTestRider().resolve("failedConfigurations.txt");
        this.retryOnConfigurationFailure = Boolean.parseBoolean(System.getProperty("retryOnConfigurationFailure"));
    }

    /*
     * WARNING - void declaration
     */
    public final void reportRetryInfo(@NotNull ISuite suite) {
        void $this$flatMapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Iterable $this$map$iv = TestNgUtilsKt.getFailedTestResults(suite);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ITestResult iTestResult = (ITestResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTestClass().getRealClass().getName());
        }
        Set failedClasses = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Iterable $this$flatMap$iv = TestNgUtilsKt.getFailedTestResults(suite);
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean bl = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ITestResult it = (ITestResult)element$iv$iv;
            boolean bl2 = false;
            String[] stringArray = it.getTestContext().getIncludedGroups();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getIncludedGroups(...)");
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])stringArray);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set groups = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        if (this.retryOnConfigurationFailure) {
            void $this$mapTo$iv$iv2;
            Iterable destination$iv$iv3;
            List<String> list;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = TestNgUtilsKt.getFailedConfigurationResults(suite);
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection collection2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ITestResult it = (ITestResult)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getMethod().isBeforeMethodConfiguration() || it.getMethod().isAfterMethodConfiguration() || it.getMethod().isBeforeClassConfiguration() || it.getMethod().isAfterClassConfiguration())) continue;
                collection2.add(element$iv$iv);
            }
            List failedConfigurationResults = (List)collection2;
            Iterable $this$map$iv2 = failedConfigurationResults;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo222 = false;
            for (Object item$iv$iv : iterable2) {
                void it;
                ITestResult bl3 = (ITestResult)item$iv$iv;
                collection = destination$iv$iv5;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(TestNgUtilsKt.getFullTestName((ITestResult)it));
            }
            Set failedConfigurationNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv5));
            Path path = this.failedConfigurationsFile;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                List<String> list2 = Files.readAllLines(path, Charsets.UTF_8);
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
            } else {
                list = CollectionsKt.emptyList();
            }
            List<String> previousFailedConfigurationNames = list;
            for (String string : previousFailedConfigurationNames) {
                if (failedConfigurationNames.contains(string)) continue;
                this.serviceMessageReporter.testStarted(string);
                this.serviceMessageReporter.testFinishedSuccess(string, 0);
            }
            Set allFailedConfigurationNames = SetsKt.plus((Set)failedConfigurationNames, (Iterable)previousFailedConfigurationNames);
            if (!((Collection)allFailedConfigurationNames).isEmpty()) {
                void $this$filterTo$iv$iv2;
                Object it;
                Iterable $this$flatMapTo$iv$iv2;
                Iterable iterable3 = failedConfigurationResults;
                collection = groups;
                boolean $i$f$flatMap2 = false;
                Iterable $i$f$mapTo222 = iterable3;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                    it = (ITestResult)element$iv$iv;
                    boolean bl3 = false;
                    String[] stringArray = it.getTestContext().getIncludedGroups();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getIncludedGroups(...)");
                    Iterable list$iv$iv = ArraysKt.asIterable((Object[])stringArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                }
                Iterable iterable4 = (List)destination$iv$iv4;
                boolean $i$f$filter2 = false;
                $this$flatMapTo$iv$iv2 = iterable4;
                destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (String)element$iv$iv;
                    boolean bl42 = false;
                    if (!(!groups.contains(it))) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                collection.addAll((List)destination$iv$iv3);
                Path path2 = this.failedConfigurationsFile;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"failedConfigurationsFile");
                PathsKt.writeText$default((Path)path2, (CharSequence)CollectionsKt.joinToString$default((Iterable)allFailedConfigurationNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
                Path path3 = this.groupsToRetryFile;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"groupsToRetryFile");
                this.appendUniqueLines(path3, groups);
            }
            Collection collection3 = failedClasses;
            Iterable $this$map$iv3 = failedConfigurationResults;
            boolean $i$f$map3 = false;
            destination$iv$iv3 = $this$map$iv3;
            Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ITestResult bl42 = (ITestResult)item$iv$iv;
                collection = destination$iv$iv6;
                boolean bl5 = false;
                collection.add(it.getTestClass().getRealClass().getName());
            }
            Iterable iterable5 = (List)destination$iv$iv6;
            CollectionsKt.addAll((Collection)collection3, (Iterable)iterable5);
        }
        if (!((Collection)failedClasses).isEmpty()) {
            Path path = this.classesToRetryFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"classesToRetryFile");
            PathsKt.writeText$default((Path)path, (CharSequence)CollectionsKt.joinToString$default((Iterable)failedClasses, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
            if (!((Collection)groups).isEmpty()) {
                Path path4 = this.groupsToRetryFile;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"groupsToRetryFile");
                this.appendUniqueLines(path4, groups);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendUniqueLines(Path $this$appendUniqueLines, Set<String> set) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$appendUniqueLines, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.writeText$default((Path)$this$appendUniqueLines, (CharSequence)CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$appendUniqueLines_u24lambda_u240;
            Iterable<Path> iterable = $this$appendUniqueLines;
            List<String> list = Files.readAllLines(iterable, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            Iterable<Path> iterable2 = iterable = CollectionsKt.toMutableSet((Iterable)list);
            Path path = $this$appendUniqueLines;
            boolean bl = false;
            Iterable iterable3 = set;
            void var7_8 = $this$appendUniqueLines_u24lambda_u240;
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                List<String> list2 = Files.readAllLines($this$appendUniqueLines, Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
                if (!(!list2.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var7_8.addAll((List)destination$iv$iv);
            PathsKt.writeText$default((Path)path, (CharSequence)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
    }
}

