/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.rd.ide.model.UnrealEngine;
import com.jetbrains.rd.ide.model.UnrealVersion;
import com.jetbrains.rider.test.asserts.ShouldAssertsKt;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.testData.TestDataStorage;
import com.jetbrains.rider.test.scriptingApi.DebugTestExecutionContext;
import com.jetbrains.rider.test.scriptingApi.LogType;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DebugKt;
import com.jetbrains.rider.test.scriptingApi.ULogType;
import com.jetbrains.rider.test.unreal.UnrealBase;
import com.jetbrains.rider.test.unreal.suplementary.Installation;
import com.jetbrains.rider.test.unreal.suplementary.LauncherInstalledData;
import com.jetbrains.rider.test.unreal.suplementary.UnrealVersionData;
import com.jetbrains.rider.test.unreal.suplementary.UprojectData;
import com.jetbrains.rider.test.unreal.suplementary.UprojectPlugins;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.test.AssertionsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a:\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0011\u001a \u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0011\u001a\u0012\u0010\u001e\u001a\u00020\u0011*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c\u001a\u0015\u0010 \u001a\u00020!*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cH\u0086\u0002\u001aG\u0010\"\u001a\u00020\u0006*\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00060*\u00a2\u0006\u0002\b,\u001a\u001c\u0010-\u001a\u00020\u0006*\u00020\u00072\u0006\u0010.\u001a\u00020\u001b2\b\b\u0002\u0010/\u001a\u00020\u001b\u001a\u0012\u00100\u001a\u000201*\u00020\u00072\u0006\u00102\u001a\u00020\u001c\u001a\u0012\u00103\u001a\u00020\u0006*\u00020\u00072\u0006\u00104\u001a\u00020\u001b\u001a\u0012\u00105\u001a\u00020\u0006*\u00020\u00072\u0006\u0010.\u001a\u00020\u001b\u001a \u00106\u001a\u0012\u0012\u0004\u0012\u00020\u000f07j\b\u0012\u0004\u0012\u00020\u000f`82\b\b\u0002\u0010\u0015\u001a\u00020\u0011\u001a\b\u00109\u001a\u00020:H\u0002\u001a\u001a\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020:2\b\b\u0002\u0010\u0015\u001a\u00020\u0011H\u0002\u001a\u0010\u0010=\u001a\u00020\u00112\u0006\u0010<\u001a\u00020:H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006>"}, d2={"unrealAdditionalSourceDir", "Ljava/io/File;", "Lcom/jetbrains/rider/test/framework/testData/TestDataStorage;", "getUnrealAdditionalSourceDir", "(Lcom/jetbrains/rider/test/framework/testData/TestDataStorage;)Ljava/io/File;", "parseAndValidateLog", "", "Lcom/jetbrains/rider/test/unreal/UnrealBase;", "logType", "Lcom/jetbrains/rider/test/scriptingApi/ULogType;", "pattern", "Lkotlin/text/Regex;", "prepareUprojectFile", "uprojectFile", "engine", "Lcom/jetbrains/rd/ide/model/UnrealEngine;", "disableEnginePlugins", "", "plugins", "", "Lcom/jetbrains/rider/test/unreal/suplementary/UprojectPlugins;", "useJackson", "generateSolutionFromUProject", "currentEngine", "timeout", "Ljava/time/Duration;", "asString", "", "Lcom/jetbrains/rd/ide/model/UnrealVersion;", "short", "basicallyEquals", "other", "compareTo", "", "attachDebuggerToProcess", "project", "Lcom/intellij/openapi/project/Project;", "process", "Ljava/lang/Process;", "expectedDebuggerClass", "Ljava/lang/Class;", "test", "Lkotlin/Function1;", "Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext;", "Lkotlin/ExtensionFunctionType;", "copyAdditionalFilesToProject", "relativeSource", "relativeTarget", "copyAdditionalAssetsToProject", "", "engineVersion", "copyAdditionalPluginToProject", "pluginName", "copyAdditionalFileStructureToProject", "getInstalledEnginesFromFrontend", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getApplicationSettingsDir", "Ljava/nio/file/Path;", "getUnrealVersion", "path", "isInstalledBuild", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nScriptingAPI.Unreal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingAPI.Unreal.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_UnrealKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,354:1\n1869#2:355\n1870#2:364\n284#3,5:356\n1#4:361\n1#4:376\n1#4:382\n1#4:394\n1#4:407\n183#5,2:362\n116#6:365\n54#6:366\n117#6:367\n61#6,8:368\n71#6:377\n116#6:383\n54#6:384\n117#6:385\n61#6,8:386\n71#6:395\n116#6:396\n54#6:397\n117#6:398\n61#6,8:399\n71#6:408\n37#7,2:378\n13805#8,2:380\n*S KotlinDebug\n*F\n+ 1 ScriptingAPI.Unreal.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_UnrealKt\n*L\n63#1:355\n63#1:364\n63#1:356,5\n63#1:361\n78#1:376\n258#1:394\n343#1:407\n63#1:362,2\n78#1:365\n78#1:366\n78#1:367\n78#1:368,8\n78#1:377\n258#1:383\n258#1:384\n258#1:385\n258#1:386,8\n258#1:395\n343#1:396\n343#1:397\n343#1:398\n343#1:399,8\n343#1:408\n114#1:378,2\n183#1:380,2\n*E\n"})
public final class ScriptingAPI_UnrealKt {
    @NotNull
    public static final File getUnrealAdditionalSourceDir(@NotNull TestDataStorage $this$unrealAdditionalSourceDir) {
        Intrinsics.checkNotNullParameter((Object)$this$unrealAdditionalSourceDir, (String)"<this>");
        String[] stringArray = new String[]{"unreal", "additionalSource"};
        return TestFrameworkBaseKt.combine((File)$this$unrealAdditionalSourceDir.getTestDataDirectory(), (String[])stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void parseAndValidateLog(@NotNull UnrealBase $this$parseAndValidateLog, @NotNull ULogType logType, @NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$parseAndValidateLog), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (logType == ULogType.Frontend) {
            ScriptingAPIKt.parseAndValidateLog(LogType.Frontend, pattern);
            return;
        }
        if (logType == ULogType.Backend) {
            ScriptingAPIKt.parseAndValidateLog(LogType.Backend, pattern);
            return;
        }
        List logFiles = switch (WhenMappings.$EnumSwitchMapping$0[logType.ordinal()]) {
            case 1 -> {
                File v0 = $this$parseAndValidateLog.getCurrentUnrealLogDirectory(true);
                Intrinsics.checkNotNull((Object)v0);
                File uLog = FilesKt.resolve((File)v0, (String)($this$parseAndValidateLog.getActiveSolution() + ".log"));
                yield CollectionsKt.listOf((Object)uLog);
            }
            case 2 -> {
                File v2 = $this$parseAndValidateLog.getCurrentUnrealLogDirectory(false);
                Intrinsics.checkNotNull((Object)v2);
                File uLog = FilesKt.resolve((File)v2, (String)($this$parseAndValidateLog.getActiveSolution() + ".log"));
                yield CollectionsKt.listOf((Object)uLog);
            }
            default -> CollectionsKt.emptyList();
        };
        Iterable $this$forEach$iv = logFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            File $this$useLines_u24default$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object = $this$useLines_u24default$iv;
            int n = 8192;
            Object object2 = object;
            object = (object2 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv)) instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            Throwable throwable = null;
            try {
                Object v3;
                block13: {
                    BufferedReader it$iv = (BufferedReader)object;
                    boolean bl2 = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl3 = false;
                    Sequence $this$firstOrNull$iv = it;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        String it2 = (String)element$iv2;
                        boolean bl4 = false;
                        if (!pattern.containsMatchIn((CharSequence)it2)) continue;
                        v3 = element$iv2;
                        break block13;
                    }
                    v3 = null;
                }
                object2 = v3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            ShouldAssertsKt.shouldBeNull((Object)object2, (String)(pattern + " was found in " + logType + " log file (" + file + ")"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void prepareUprojectFile(@NotNull File uprojectFile, @NotNull UnrealEngine engine, boolean disableEnginePlugins, @NotNull List<UprojectPlugins> plugins, boolean useJackson) {
        Intrinsics.checkNotNullParameter((Object)uprojectFile, (String)"uprojectFile");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
        UprojectData uprojectData = null;
        String uprojectText = null;
        if (useJackson) {
            void $this$checkTypeMismatch$iv$iv;
            void $this$readValue$iv;
            ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            ObjectMapper objectMapper = mapper;
            String content$iv = FilesKt.readText$default((File)uprojectFile, null, (int)1, null);
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef22 = false;
            Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<UprojectData>(){});
            boolean $i$f$checkTypeMismatch = false;
            if (!($this$checkTypeMismatch$iv$iv instanceof UprojectData)) {
                String string;
                String nullability$iv$iv = "(non-null)";
                StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(UprojectData.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                void v1 = $this$checkTypeMismatch$iv$iv;
                if (v1 != null) {
                    void it$iv$iv;
                    void var14_16 = v1;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                    stringBuilder = stringBuilder2;
                } else {
                    string = null;
                }
                String string2 = stringBuilder.append(string).toString();
                throw new RuntimeJsonMappingException(string2);
            }
            uprojectData = (UprojectData)$this$checkTypeMismatch$iv$iv;
            uprojectData.setEngineAssociation(engine.getId());
            uprojectData.setDisableEnginePluginsByDefault(disableEnginePlugins);
            if (!((Collection)plugins).isEmpty()) {
                List list = uprojectData.getPlugins();
                if (list == null) {
                    list = new ArrayList();
                }
                uprojectData.setPlugins(CollectionsKt.plus((Collection)list, (Iterable)plugins));
            }
            String string = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)uprojectData);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            uprojectText = string;
        } else {
            Gson builder = new GsonBuilder().setPrettyPrinting().create();
            Object object = builder.fromJson(FilesKt.readText$default((File)uprojectFile, null, (int)1, null), UprojectData.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            uprojectData = (UprojectData)object;
            uprojectData.setEngineAssociation(engine.getId());
            uprojectData.setDisableEnginePluginsByDefault(disableEnginePlugins);
            if (!((Collection)plugins).isEmpty()) {
                List list = uprojectData.getPlugins();
                if (list == null) {
                    list = new ArrayList();
                }
                uprojectData.setPlugins(CollectionsKt.plus((Collection)list, (Iterable)plugins));
            }
            String string = builder.toJson((Object)uprojectData);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            uprojectText = string;
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Content of final UProject: " + uprojectText);
        FilesKt.writeText$default((File)uprojectFile, (String)uprojectText, null, (int)2, null);
    }

    public static /* synthetic */ void prepareUprojectFile$default(File file, UnrealEngine unrealEngine, boolean bl, List list, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        ScriptingAPI_UnrealKt.prepareUprojectFile(file, unrealEngine, bl, list, bl2);
    }

    public static final void generateSolutionFromUProject(@NotNull File uprojectFile, @NotNull UnrealEngine currentEngine, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)uprojectFile, (String)"uprojectFile");
        Intrinsics.checkNotNullParameter((Object)currentEngine, (String)"currentEngine");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        String engineType = currentEngine.isInstalledBuild() ? "-rocket" : "-engine";
        File unrealScript = new File(currentEngine.getPath(), "Engine\\Build\\BatchFiles\\Build.bat");
        ShouldAssertsKt.shouldExists((File)unrealScript);
        String ubtArgs = "-ProjectFiles -game -progress " + engineType + " -project=\"" + uprojectFile.getAbsolutePath() + "\"";
        TestFrameworkBaseKt.getFrameworkLogger().info("Generating sln command: " + unrealScript + " " + ubtArgs);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)unrealScript.getAbsolutePath());
        String[] stringArray = new String[]{" "};
        Object $this$toTypedArray$iv = StringsKt.split$default((CharSequence)ubtArgs, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        Process ubtProc = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])).start();
        InputStream inputStream = ubtProc.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        $this$toTypedArray$iv = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)$this$toTypedArray$iv, (Charset)object);
        int n = 8192;
        String stdInput = TextStreamsKt.readText((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)));
        if (((CharSequence)stdInput).length() > 0) {
            TestFrameworkBaseKt.getFrameworkLogger().info("UBT stdout output:\n" + stdInput);
        }
        InputStream inputStream2 = ubtProc.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        object = inputStream2;
        object2 = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)object, (Charset)object2);
        int n2 = 8192;
        String stdError = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
        TestFrameworkBaseKt.getFrameworkLogger().info("UBT stderr output:\n" + stdError);
        ubtProc.waitFor(timeout.getSeconds(), TimeUnit.SECONDS);
    }

    public static /* synthetic */ void generateSolutionFromUProject$default(File file, UnrealEngine unrealEngine, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(90L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        ScriptingAPI_UnrealKt.generateSolutionFromUProject(file, unrealEngine, duration);
    }

    @NotNull
    public static final String asString(@NotNull UnrealVersion $this$asString, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        return bl ? $this$asString.getMajor() + "." + $this$asString.getMinor() : $this$asString.getMajor() + "." + $this$asString.getMinor() + "." + $this$asString.getPatch();
    }

    public static /* synthetic */ String asString$default(UnrealVersion unrealVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ScriptingAPI_UnrealKt.asString(unrealVersion, bl);
    }

    public static final boolean basicallyEquals(@NotNull UnrealVersion $this$basicallyEquals, @NotNull UnrealVersion other) {
        Intrinsics.checkNotNullParameter((Object)$this$basicallyEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$basicallyEquals == other) {
            return true;
        }
        if ($this$basicallyEquals.getMajor() != other.getMajor()) {
            return false;
        }
        return $this$basicallyEquals.getMinor() == other.getMinor();
    }

    public static final int compareTo(@NotNull UnrealVersion $this$compareTo, @NotNull UnrealVersion other) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$compareTo.getMajor() != other.getMajor()) {
            return $this$compareTo.getMajor() - other.getMajor();
        }
        if ($this$compareTo.getMinor() != other.getMinor()) {
            return $this$compareTo.getMinor() - other.getMinor();
        }
        return $this$compareTo.getPatch() - other.getPatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void attachDebuggerToProcess(@NotNull UnrealBase $this$attachDebuggerToProcess, @NotNull Project project2, @NotNull Process process, @NotNull Duration timeout, @NotNull Class<?> expectedDebuggerClass, @NotNull Function1<? super DebugTestExecutionContext, Unit> test) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$attachDebuggerToProcess), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(expectedDebuggerClass, (String)"expectedDebuggerClass");
        Intrinsics.checkNotNullParameter(test, (String)"test");
        XDebugSession session2 = ScriptingAPI_DebugKt.attachToLocalProcess$default(project2, process, timeout, expectedDebuggerClass, false, 16, null);
        try {
            UnrealBase.executeWithUnrealGold$default($this$attachDebuggerToProcess, null, arg_0 -> ScriptingAPI_UnrealKt.attachDebuggerToProcess$lambda$0(session2, test, arg_0), 1, null);
        }
        finally {
            ScriptingAPI_DebugKt.teardownDebuggerSession(session2, false);
        }
    }

    public static final void copyAdditionalFilesToProject(@NotNull UnrealBase $this$copyAdditionalFilesToProject, @NotNull String relativeSource, @NotNull String relativeTarget) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$copyAdditionalFilesToProject), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativeSource, (String)"relativeSource");
        Intrinsics.checkNotNullParameter((Object)relativeTarget, (String)"relativeTarget");
        File source = FilesKt.resolve((File)FilesKt.resolve((File)ScriptingAPI_UnrealKt.getUnrealAdditionalSourceDir((TestDataStorage)$this$copyAdditionalFilesToProject), (String)"files"), (String)relativeSource);
        File target = FilesKt.resolve((File)$this$copyAdditionalFilesToProject.getActiveSolutionDirectory(), (String)relativeTarget);
        AssertionsKt.assertTrue((boolean)source.exists(), (String)("Not found necessary file " + source + ". Please check " + ScriptingAPI_UnrealKt.getUnrealAdditionalSourceDir((TestDataStorage)$this$copyAdditionalFilesToProject)));
        if (source.isDirectory()) {
            File[] fileArray = source.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)file);
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    FilesKt.copyTo$default((File)file, (File)FilesKt.resolve((File)target, (String)string), (boolean)true, (int)0, (int)4, null);
                }
            }
        } else {
            String string = source.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            FilesKt.copyTo$default((File)source, (File)FilesKt.resolve((File)target, (String)string), (boolean)true, (int)0, (int)4, null);
        }
    }

    public static /* synthetic */ void copyAdditionalFilesToProject$default(UnrealBase unrealBase, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        ScriptingAPI_UnrealKt.copyAdditionalFilesToProject(unrealBase, string, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Object copyAdditionalAssetsToProject(@NotNull UnrealBase $this$copyAdditionalAssetsToProject, @NotNull UnrealVersion engineVersion) {
        Object object;
        Object v0;
        String[] stringArray;
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$copyAdditionalAssetsToProject), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)engineVersion, (String)"engineVersion");
            stringArray = new String[]{"assets"};
            Sequence sequence = (Sequence)FilesKt.walk$default((File)TestFrameworkBaseKt.combine((File)ScriptingAPI_UnrealKt.getUnrealAdditionalSourceDir((TestDataStorage)$this$copyAdditionalAssetsToProject), (String[])stringArray), null, (int)1, null);
            for (Object e : sequence) {
                File it = (File)e;
                boolean bl = false;
                if (!(it.isDirectory() && Intrinsics.areEqual((Object)it.getName(), (Object)$this$copyAdditionalAssetsToProject.getActiveSolution()))) continue;
                v0 = e;
                break block4;
            }
            v0 = null;
        }
        File file = v0;
        if (file != null && (stringArray = FilesKt.walk$default((File)file, null, (int)1, null)) != null) {
            Object v1;
            block5: {
                Sequence sequence = (Sequence)stringArray;
                for (Object e : sequence) {
                    File it = (File)e;
                    boolean bl = false;
                    if (!(it.isDirectory() && Intrinsics.areEqual((Object)it.getName(), (Object)(engineVersion.getMajor() + "." + engineVersion.getMinor())))) continue;
                    v1 = e;
                    break block5;
                }
                v1 = null;
            }
            File file2 = v1;
            if (file2 != null) {
                object = FilesKt.copyRecursively$default((File)file2, (File)FilesKt.resolve((File)$this$copyAdditionalAssetsToProject.getActiveSolutionDirectory(), (String)"Content"), (boolean)false, null, (int)6, null);
                return object;
            }
        }
        TestFrameworkBaseKt.getFrameworkLogger().warn("Not found additional assets for " + $this$copyAdditionalAssetsToProject.getActiveSolution() + " in " + ScriptingAPI_UnrealKt.getUnrealAdditionalSourceDir((TestDataStorage)$this$copyAdditionalAssetsToProject));
        object = Unit.INSTANCE;
        return object;
    }

    public static final void copyAdditionalPluginToProject(@NotNull UnrealBase $this$copyAdditionalPluginToProject, @NotNull String pluginName) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$copyAdditionalPluginToProject), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        FilesKt.copyRecursively$default((File)FilesKt.resolve((File)ScriptingAPI_UnrealKt.getUnrealAdditionalSourceDir((TestDataStorage)$this$copyAdditionalPluginToProject), (String)("plugins/" + pluginName)), (File)FilesKt.resolve((File)$this$copyAdditionalPluginToProject.getActiveSolutionDirectory(), (String)("Plugins/" + pluginName)), (boolean)true, null, (int)4, null);
    }

    public static final void copyAdditionalFileStructureToProject(@NotNull UnrealBase $this$copyAdditionalFileStructureToProject, @NotNull String relativeSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$copyAdditionalFileStructureToProject), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativeSource, (String)"relativeSource");
        Path sourcePath = FilesKt.resolve((File)FilesKt.resolve((File)ScriptingAPI_UnrealKt.getUnrealAdditionalSourceDir((TestDataStorage)$this$copyAdditionalFileStructureToProject), (String)"files"), (String)relativeSource).toPath();
        Path targetPath = FilesKt.resolve((File)$this$copyAdditionalFileStructureToProject.getActiveSolutionDirectory(), (File)$this$copyAdditionalFileStructureToProject.getActiveSolutionDirectory()).toPath();
        SimpleFileVisitor<Path> visitor2 = new SimpleFileVisitor<Path>(targetPath, sourcePath, $this$copyAdditionalFileStructureToProject){
            final /* synthetic */ Path $targetPath;
            final /* synthetic */ Path $sourcePath;
            final /* synthetic */ UnrealBase $this_copyAdditionalFileStructureToProject;
            {
                this.$targetPath = $targetPath;
                this.$sourcePath = $sourcePath;
                this.$this_copyAdditionalFileStructureToProject = $receiver;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                Files.createDirectories(this.$targetPath.resolve(this.$sourcePath.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                Path relativeFilePath = this.$sourcePath.relativize(file);
                Path newPath = relativeFilePath.startsWith("Source") && relativeFilePath.getNameCount() > 1 ? this.$targetPath.resolve("Source").resolve(this.$this_copyAdditionalFileStructureToProject.getActiveSolution()).resolve(relativeFilePath.subpath(1, relativeFilePath.getNameCount())) : this.$targetPath.resolve(relativeFilePath);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(file, newPath, copyOptionArray);
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)visitor2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ArrayList<UnrealEngine> getInstalledEnginesFromFrontend(boolean useJackson) {
        ArrayList<UnrealEngine> engines = new ArrayList<UnrealEngine>();
        Path launcherInstalled = ScriptingAPI_UnrealKt.getApplicationSettingsDir().resolve("UnrealEngineLauncher").resolve("LauncherInstalled.dat");
        Intrinsics.checkNotNull((Object)launcherInstalled);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(launcherInstalled, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LauncherInstalledData installations = null;
            if (useJackson) {
                void $this$checkTypeMismatch$iv$iv;
                ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
                ObjectMapper objectMapper = mapper;
                File file = launcherInstalled.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                String content$iv = FilesKt.readText$default((File)file, null, (int)1, null);
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef232 = false;
                Object $i$f$jacksonTypeRef232 = objectMapper.readValue(content$iv, (TypeReference)new TypeReference<LauncherInstalledData>(){});
                boolean $i$f$checkTypeMismatch = false;
                if (!($this$checkTypeMismatch$iv$iv instanceof LauncherInstalledData)) {
                    String string;
                    String nullability$iv$iv = "(non-null)";
                    StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(LauncherInstalledData.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                    void v3 = $this$checkTypeMismatch$iv$iv;
                    if (v3 != null) {
                        void it$iv$iv;
                        void var11_27 = v3;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                        stringBuilder = stringBuilder2;
                    } else {
                        string = null;
                    }
                    String string2 = stringBuilder.append(string).toString();
                    throw new RuntimeJsonMappingException(string2);
                }
                installations = (LauncherInstalledData)$this$checkTypeMismatch$iv$iv;
            } else {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                File file = launcherInstalled.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                Object object = gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), LauncherInstalledData.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                installations = (LauncherInstalledData)object;
            }
            for (Installation installation : installations.getInstallationList()) {
                String id;
                Object path;
                String prefix = "UE_";
                if (!StringsKt.startsWith((String)installation.getAppName(), (String)prefix, (boolean)true)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)installation.getAppName().substring(prefix.length()), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)Paths.get(installation.getInstallLocation(), new String[0]), (String)"get(...)");
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.exists((Path)path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                engines.add(new UnrealEngine(id, path.toString(), ScriptingAPI_UnrealKt.getUnrealVersion((Path)path, useJackson), ScriptingAPI_UnrealKt.isInstalledBuild((Path)path)));
            }
        }
        if (SystemInfo.isWindows) {
            String regKey = "Software\\Epic Games\\Unreal Engine\\Builds";
            Object[] objectArray = new Pair[]{new Pair((Object)WinReg.HKEY_LOCAL_MACHINE, (Object)256), new Pair((Object)WinReg.HKEY_CURRENT_USER, (Object)256)};
            List registries = CollectionsKt.listOf((Object[])objectArray);
            for (Pair registry : registries) {
                try {
                    TreeMap values = Advapi32Util.registryGetValues((WinReg.HKEY)((WinReg.HKEY)registry.getFirst()), (String)regKey, (int)((Number)registry.getSecond()).intValue());
                    Intrinsics.checkNotNull((Object)values);
                    for (Map.Entry value : ((Map)values).entrySet()) {
                        Path pathValue;
                        Object v = value.getValue();
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                        String stringValue = (String)v;
                        Intrinsics.checkNotNullExpressionValue((Object)Paths.get(stringValue, new String[0]), (String)"get(...)");
                        LinkOption[] linkOptionArray3 = new LinkOption[]{};
                        if (!Files.exists(pathValue, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) continue;
                        Object k = value.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                        engines.add(new UnrealEngine((String)k, ((Object)pathValue).toString(), ScriptingAPI_UnrealKt.getUnrealVersion(pathValue, useJackson), ScriptingAPI_UnrealKt.isInstalledBuild(pathValue)));
                    }
                }
                catch (Exception values) {
                }
            }
        }
        if (!SystemInfo.isWindows) {
            Path installIni = ScriptingAPI_UnrealKt.getApplicationSettingsDir().resolve("UnrealEngine").resolve("Install.ini");
            Intrinsics.checkNotNull((Object)installIni);
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            if (Files.notExists(installIni, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) {
                TestFrameworkBaseKt.getFrameworkLogger().warn(installIni + " doesn't exist");
                return engines;
            }
            File file = installIni.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            for (String string : FilesKt.readLines$default((File)file, null, (int)1, null)) {
                Path valuePath;
                int splitIndex;
                if (StringsKt.startsWith$default((CharSequence)string, (char)';', (boolean)false, (int)2, null) || (splitIndex = StringsKt.indexOf$default((CharSequence)string, (char)'=', (int)0, (boolean)false, (int)6, null)) == -1) continue;
                String string3 = string.substring(splitIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String value = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)Paths.get(value, new String[0]), (String)"get(...)");
                LinkOption[] linkOptionArray5 = new LinkOption[]{};
                if (!Files.exists(valuePath, Arrays.copyOf(linkOptionArray5, linkOptionArray5.length))) continue;
                String string4 = string.substring(0, splitIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                String key = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                char[] cArray = new char[]{'{', '}'};
                String keyWithBrackets = "{" + StringsKt.trim((String)key, (char[])cArray) + "}";
                engines.add(new UnrealEngine(keyWithBrackets, ((Object)valuePath).toString(), ScriptingAPI_UnrealKt.getUnrealVersion(valuePath, useJackson), ScriptingAPI_UnrealKt.isInstalledBuild(valuePath)));
            }
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Found installed engines: " + engines);
        return engines;
    }

    public static /* synthetic */ ArrayList getInstalledEnginesFromFrontend$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return ScriptingAPI_UnrealKt.getInstalledEnginesFromFrontend(bl);
    }

    private static final Path getApplicationSettingsDir() {
        Path path;
        String programData = System.getenv("PROGRAMDATA");
        String homeDirectory = System.getProperty("user.home");
        if (SystemInfo.isWindows) {
            Path path2 = Paths.get(programData + "/Epic", new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        } else if (SystemInfo.isMac) {
            Path path3 = Paths.get(homeDirectory + "/Library/Application Support/Epic", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else if (SystemInfo.isLinux) {
            Path path4 = Paths.get(homeDirectory + "/.config/Epic", new String[0]);
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    private static final UnrealVersion getUnrealVersion(Path path, boolean useJackson) {
        Path versionFile = path.resolve("Engine").resolve("Build").resolve("Build.version");
        UnrealVersionData unrealVersion = null;
        if (useJackson) {
            void $this$checkTypeMismatch$iv$iv;
            void $this$readValue$iv;
            ObjectMapper mapper;
            ObjectMapper objectMapper = mapper = ExtensionsKt.jacksonObjectMapper();
            File file = versionFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            String content$iv = FilesKt.readText$default((File)file, null, (int)1, null);
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef22 = false;
            Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<UnrealVersionData>(){});
            boolean $i$f$checkTypeMismatch = false;
            if (!($this$checkTypeMismatch$iv$iv instanceof UnrealVersionData)) {
                String string;
                String nullability$iv$iv = "(non-null)";
                StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(UnrealVersionData.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                void v2 = $this$checkTypeMismatch$iv$iv;
                if (v2 != null) {
                    void it$iv$iv;
                    void var11_12 = v2;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                    stringBuilder = stringBuilder2;
                } else {
                    string = null;
                }
                String string2 = stringBuilder.append(string).toString();
                throw new RuntimeJsonMappingException(string2);
            }
            unrealVersion = (UnrealVersionData)$this$checkTypeMismatch$iv$iv;
        } else {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            File file = versionFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Object object = gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), UnrealVersionData.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            unrealVersion = (UnrealVersionData)object;
        }
        return new UnrealVersion(unrealVersion.getMajorVersion(), unrealVersion.getMinorVersion(), unrealVersion.getPatchVersion());
    }

    static /* synthetic */ UnrealVersion getUnrealVersion$default(Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ScriptingAPI_UnrealKt.getUnrealVersion(path, bl);
    }

    private static final boolean isInstalledBuild(Path path) {
        Path markerFile = path.resolve("Engine").resolve("Build").resolve("InstalledBuild.txt");
        Intrinsics.checkNotNull((Object)markerFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(markerFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final Unit attachDebuggerToProcess$lambda$0(XDebugSession $session, Function1 $test, PrintStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DebugTestExecutionContext context = new DebugTestExecutionContext(it, $session);
        $test.invoke((Object)context);
        context.assertDetachFinish();
        TestFrameworkBaseKt.flushQueues$default(null, (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ULogType.values().length];
            try {
                nArray[ULogType.UnrealGame.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ULogType.UnrealEditor.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

