/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenario;
import com.jetbrains.rdclient.testFramework.TestFrameworkKt;
import com.jetbrains.rider.test.BaseIntegrationTest;
import com.jetbrains.rider.test.annotations.Solution;
import com.jetbrains.rider.test.environment.Environment_NuGetKt;
import com.jetbrains.rider.test.facades.TestApiScopes;
import com.jetbrains.rider.test.facades.application.ApplicationApiFacade;
import com.jetbrains.rider.test.facades.application.RiderApplicationApiFacade;
import com.jetbrains.rider.test.facades.settings.BackendSettingsApiFacade;
import com.jetbrains.rider.test.facades.settings.RiderBackendSettingsApiFacade;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestFrameworkSettings;
import com.jetbrains.rider.test.framework.advancedSettings.AdvancedSettingsList;
import com.jetbrains.rider.test.framework.advancedSettings.RiderTestAdvancedSettingsManager;
import com.jetbrains.rider.test.framework.advancedSettings.TestAdvancedSettingsManager;
import com.jetbrains.rider.test.framework.nugetFbManager.DefaultNuGetFallbackFolderManager;
import com.jetbrains.rider.test.framework.nugetFbManager.NuGetFallbackFolderManager;
import com.jetbrains.rider.test.framework.processor.model.IntegrationTestMethod;
import com.jetbrains.rider.test.framework.profiling.RiderProfilingManager;
import com.jetbrains.rider.test.framework.registrySettings.RiderTestRegistryPropertiesManager;
import com.jetbrains.rider.test.framework.registrySettings.TestRegistryPropertiesManager;
import com.jetbrains.rider.test.logging.RiderTestLogManager;
import com.jetbrains.rider.test.logging.TraceSettings;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Memory_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Process_BaseKt;
import com.jetbrains.rider.test.scriptingApi.SuspiciousProcessCleanupPolicy;
import java.io.File;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010*\u001a\u00020+H\u0007J\b\u0010,\u001a\u00020+H\u0007J\b\u00106\u001a\u00020+H\u0007J\b\u00107\u001a\u00020+H\u0007J\b\u0010<\u001a\u00020+H\u0007J\b\u0010=\u001a\u00020+H\u0007J\b\u0010C\u001a\u00020+H\u0007J\b\u0010D\u001a\u00020+H\u0007J\b\u0010J\u001a\u00020+H\u0007J\b\u0010K\u001a\u00020+H\u0007J\b\u0010L\u001a\u00020+H\u0007J\u0010\u0010R\u001a\u00020+2\u0006\u0010S\u001a\u00020TH\u0007J\b\u0010U\u001a\u00020+H\u0007J\b\u0010V\u001a\u00020+H\u0007J\b\u0010W\u001a\u00020+H\u0007R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001b\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u0015\u0012\u0004\b\u001d\u0010\u0005\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0015\u001a\u0004\b#\u0010$R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0015\u001a\u0004\b/\u00100R\u0014\u00102\u001a\u000203X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u001b\u0010>\u001a\u00020?8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\u0015\u001a\u0004\b@\u0010AR\u001b\u0010E\u001a\u00020F8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010\u0015\u001a\u0004\bG\u0010HR\u001b\u0010M\u001a\u00020N8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010\u0015\u001a\u0004\bO\u0010P\u00a8\u0006X"}, d2={"Lcom/jetbrains/rider/test/base/BaseTestWithShell;", "Lcom/jetbrains/rider/test/BaseIntegrationTest;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$Application;", "Lcom/jetbrains/rider/test/facades/TestApiScopes$BackendSettings;", "<init>", "()V", "traceScenarios", "", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenario;", "getTraceScenarios", "()Ljava/util/Set;", "traceCategories", "", "", "getTraceCategories", "()Ljava/util/List;", "profilingManager", "Lcom/jetbrains/rider/test/framework/profiling/RiderProfilingManager;", "getProfilingManager", "()Lcom/jetbrains/rider/test/framework/profiling/RiderProfilingManager;", "profilingManager$delegate", "Lkotlin/Lazy;", "testLogManager", "Lcom/jetbrains/rider/test/logging/RiderTestLogManager;", "getTestLogManager", "()Lcom/jetbrains/rider/test/logging/RiderTestLogManager;", "testLogManager$delegate", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "registryPropertiesManager", "Lcom/jetbrains/rider/test/framework/registrySettings/TestRegistryPropertiesManager;", "getRegistryPropertiesManager", "()Lcom/jetbrains/rider/test/framework/registrySettings/TestRegistryPropertiesManager;", "registryPropertiesManager$delegate", "registrySetting", "", "getRegistrySetting", "()Ljava/util/Map;", "setCustomRegistryKeys", "", "resetCustomRegistryKeys", "advancedSettingsManager", "Lcom/jetbrains/rider/test/framework/advancedSettings/TestAdvancedSettingsManager;", "getAdvancedSettingsManager", "()Lcom/jetbrains/rider/test/framework/advancedSettings/TestAdvancedSettingsManager;", "advancedSettingsManager$delegate", "advancedSettings", "Lcom/jetbrains/rider/test/framework/advancedSettings/AdvancedSettingsList;", "getAdvancedSettings", "()Lcom/jetbrains/rider/test/framework/advancedSettings/AdvancedSettingsList;", "setAdvancedSettings", "resetAdvancedSettings", "frameViewerPluginEnabled", "", "getFrameViewerPluginEnabled", "()Z", "setFrameViewerAvailability", "resetFrameViewerAvailability", "nuGetFallbackFolderManager", "Lcom/jetbrains/rider/test/framework/nugetFbManager/NuGetFallbackFolderManager;", "getNuGetFallbackFolderManager", "()Lcom/jetbrains/rider/test/framework/nugetFbManager/NuGetFallbackFolderManager;", "nuGetFallbackFolderManager$delegate", "cleanUpGlobalCacheDir", "dumpUsedNugets", "applicationApiFacade", "Lcom/jetbrains/rider/test/facades/application/ApplicationApiFacade;", "getApplicationApiFacade", "()Lcom/jetbrains/rider/test/facades/application/ApplicationApiFacade;", "applicationApiFacade$delegate", "initEnvironmentAndApplication", "assertSuiteMemoryUsage", "shutdownApplication", "backendSettingsApiFacade", "Lcom/jetbrains/rider/test/facades/settings/BackendSettingsApiFacade;", "getBackendSettingsApiFacade", "()Lcom/jetbrains/rider/test/facades/settings/BackendSettingsApiFacade;", "backendSettingsApiFacade$delegate", "cleanUpWorkDirectory", "result", "Lorg/testng/ITestResult;", "logSystemProperties", "startProfiling", "stopProfiling", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nBaseTestWithShell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseTestWithShell.kt\ncom/jetbrains/rider/test/base/BaseTestWithShell\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1056#2:199\n1869#2,2:200\n*S KotlinDebug\n*F\n+ 1 BaseTestWithShell.kt\ncom/jetbrains/rider/test/base/BaseTestWithShell\n*L\n179#1:199\n180#1:200,2\n*E\n"})
public abstract class BaseTestWithShell
extends BaseIntegrationTest
implements TestApiScopes.Application,
TestApiScopes.BackendSettings {
    @NotNull
    private final Set<LogTraceScenario> traceScenarios = SetsKt.emptySet();
    @NotNull
    private final List<String> traceCategories = CollectionsKt.emptyList();
    @NotNull
    private final Lazy profilingManager$delegate = LazyKt.lazy(() -> BaseTestWithShell.profilingManager_delegate$lambda$0(this));
    @NotNull
    private final Lazy testLogManager$delegate = LazyKt.lazy(() -> BaseTestWithShell.testLogManager_delegate$lambda$0(this));
    @NotNull
    private final Lazy logger$delegate = LazyKt.lazy(() -> BaseTestWithShell.logger_delegate$lambda$0(this));
    @NotNull
    private final Lazy registryPropertiesManager$delegate = LazyKt.lazy(BaseTestWithShell::registryPropertiesManager_delegate$lambda$0);
    @NotNull
    private final Map<String, String> registrySetting = MapsKt.emptyMap();
    @NotNull
    private final Lazy advancedSettingsManager$delegate = LazyKt.lazy(BaseTestWithShell::advancedSettingsManager_delegate$lambda$0);
    @NotNull
    private final AdvancedSettingsList advancedSettings = new AdvancedSettingsList(null, null, null, null, 15, null);
    @NotNull
    private final Lazy nuGetFallbackFolderManager$delegate = LazyKt.lazy(() -> BaseTestWithShell.nuGetFallbackFolderManager_delegate$lambda$0(this));
    @NotNull
    private final Lazy applicationApiFacade$delegate = LazyKt.lazy(BaseTestWithShell::applicationApiFacade_delegate$lambda$0);
    @NotNull
    private final Lazy backendSettingsApiFacade$delegate = LazyKt.lazy(BaseTestWithShell::backendSettingsApiFacade_delegate$lambda$0);

    @NotNull
    public Set<LogTraceScenario> getTraceScenarios() {
        return this.traceScenarios;
    }

    @NotNull
    public List<String> getTraceCategories() {
        return this.traceCategories;
    }

    @NotNull
    public final RiderProfilingManager getProfilingManager() {
        Lazy lazy = this.profilingManager$delegate;
        return (RiderProfilingManager)lazy.getValue();
    }

    @NotNull
    public RiderTestLogManager getTestLogManager() {
        Lazy lazy = this.testLogManager$delegate;
        return (RiderTestLogManager)lazy.getValue();
    }

    @NotNull
    public final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    public static /* synthetic */ void getLogger$annotations() {
    }

    private final TestRegistryPropertiesManager getRegistryPropertiesManager() {
        Lazy lazy = this.registryPropertiesManager$delegate;
        return (TestRegistryPropertiesManager)lazy.getValue();
    }

    @NotNull
    public Map<String, String> getRegistrySetting() {
        return this.registrySetting;
    }

    @BeforeClass
    public final void setCustomRegistryKeys() {
        this.getRegistryPropertiesManager().setCustomRegistryKeys(this.getRegistrySetting());
    }

    @AfterClass
    public final void resetCustomRegistryKeys() {
        this.getRegistryPropertiesManager().resetCustomRegistryKeys();
    }

    private final TestAdvancedSettingsManager getAdvancedSettingsManager() {
        Lazy lazy = this.advancedSettingsManager$delegate;
        return (TestAdvancedSettingsManager)lazy.getValue();
    }

    @NotNull
    public AdvancedSettingsList getAdvancedSettings() {
        return this.advancedSettings;
    }

    @BeforeClass
    public final void setAdvancedSettings() {
        this.getAdvancedSettingsManager().setAdvancedSettings(this.getAdvancedSettings());
    }

    @AfterClass
    public final void resetAdvancedSettings() {
        this.getAdvancedSettingsManager().resetAdvancedSettings();
    }

    public boolean getFrameViewerPluginEnabled() {
        return false;
    }

    @BeforeClass
    public final void setFrameViewerAvailability() {
        if (this.getRegistryPropertiesManager().hasRegistryKey("frame.viewer.plugin.enabled")) {
            this.getRegistryPropertiesManager().setCustomRegistryKeys(MapsKt.mapOf((Pair)TuplesKt.to((Object)"frame.viewer.plugin.enabled", (Object)String.valueOf(this.getFrameViewerPluginEnabled()))));
        }
    }

    @AfterClass
    public final void resetFrameViewerAvailability() {
        if (this.getRegistryPropertiesManager().hasRegistryKey("frame.viewer.plugin.enabled")) {
            this.getRegistryPropertiesManager().setCustomRegistryKeys(MapsKt.mapOf((Pair)TuplesKt.to((Object)"frame.viewer.plugin.enabled", (Object)"false")));
        }
    }

    @NotNull
    public NuGetFallbackFolderManager getNuGetFallbackFolderManager() {
        Lazy lazy = this.nuGetFallbackFolderManager$delegate;
        return (NuGetFallbackFolderManager)lazy.getValue();
    }

    @BeforeSuite
    public final void cleanUpGlobalCacheDir() {
        Environment_NuGetKt.resetNuGetTestCacheFolder();
    }

    @AfterSuite(alwaysRun=true)
    public final void dumpUsedNugets() {
        this.getNuGetFallbackFolderManager().dumpUsedNugets();
    }

    @NotNull
    public ApplicationApiFacade getApplicationApiFacade() {
        Lazy lazy = this.applicationApiFacade$delegate;
        return (ApplicationApiFacade)lazy.getValue();
    }

    @BeforeSuite(alwaysRun=true)
    public final void initEnvironmentAndApplication() {
        if (TestFrameworkSettings.Profiling.INSTANCE.getEnableBackendProfiling()) {
            this.getProfilingManager().setupBackendProfiling();
        }
        this.getApplicationApiFacade().initEnvironment();
        this.getApplicationApiFacade().startApplication();
    }

    @AfterSuite(alwaysRun=true)
    public final void assertSuiteMemoryUsage() {
        ScriptingAPI_Memory_BaseKt.assertMemoryUsage();
    }

    @AfterSuite(dependsOnMethods={"assertSuiteMemoryUsage", "dumpUsedNugets", "logSystemProperties"}, alwaysRun=true)
    public final void shutdownApplication() {
        this.getApplicationApiFacade().stopApplication();
        if (TestFrameworkKt.isUnderTeamCity()) {
            ScriptingAPI_Process_BaseKt.cleanupSuspiciousProcesses((SuspiciousProcessCleanupPolicy)SuspiciousProcessCleanupPolicy.FULL);
        }
    }

    @NotNull
    public BackendSettingsApiFacade getBackendSettingsApiFacade() {
        Lazy lazy = this.backendSettingsApiFacade$delegate;
        return (BackendSettingsApiFacade)lazy.getValue();
    }

    @AfterMethod(alwaysRun=true)
    public final void cleanUpWorkDirectory(@NotNull ITestResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!result2.isSuccess() && ((IntegrationTestMethod)this.getTestMethod()).getExecutionPlan().getShouldRun()) {
            Solution solution = ((IntegrationTestMethod)this.getTestMethod()).getSolution();
            boolean bl = solution != null ? solution.saveOnFailure() : false;
            if (bl) {
                this.storeCurrentSolutionState();
            }
        }
        if (this.getCleanTestWorkDirectory() && this.getTestWorkDirectory().exists()) {
            FilesKt.deleteRecursively((File)this.getTestWorkDirectory());
        }
    }

    @AfterSuite(alwaysRun=true)
    public final void logSystemProperties() {
        if (((CharSequence)TestFrameworkSettings.INSTANCE.getAdditionalRegistryKeys()).length() == 0) {
            return;
        }
        StringBuilder registrySettings = new StringBuilder();
        registrySettings.append("Used system registry settings:").append('\n');
        Set<Map.Entry<Object, Object>> set = System.getProperties().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKey().toString());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey().toString())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object name = entry.getKey();
            Object value = entry.getValue();
            registrySettings.append(name + ": " + value).append('\n');
        }
        TestFrameworkBaseKt.getFrameworkLogger().info(registrySettings.toString());
    }

    @BeforeClass
    public final void startProfiling() {
        if (TestFrameworkSettings.Profiling.INSTANCE.getEnableFrontendProfiling()) {
            this.getProfilingManager().startFrontendProfiling();
        }
    }

    @AfterClass(alwaysRun=true)
    public final void stopProfiling() {
        if (TestFrameworkSettings.Profiling.INSTANCE.getEnableFrontendProfiling()) {
            this.getProfilingManager().stopFrontendProfiling();
        }
    }

    private static final RiderProfilingManager profilingManager_delegate$lambda$0(BaseTestWithShell this$0) {
        return new RiderProfilingManager(this$0.getTestProcessor());
    }

    private static final RiderTestLogManager testLogManager_delegate$lambda$0(BaseTestWithShell this$0) {
        return new RiderTestLogManager(new TraceSettings(this$0.getTraceScenarios(), this$0.getTraceCategories()));
    }

    private static final Logger logger_delegate$lambda$0(BaseTestWithShell this$0) {
        Logger logger = Logger.getInstance(((Object)((Object)this$0)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final RiderTestRegistryPropertiesManager registryPropertiesManager_delegate$lambda$0() {
        return new RiderTestRegistryPropertiesManager();
    }

    private static final RiderTestAdvancedSettingsManager advancedSettingsManager_delegate$lambda$0() {
        return new RiderTestAdvancedSettingsManager();
    }

    private static final DefaultNuGetFallbackFolderManager nuGetFallbackFolderManager_delegate$lambda$0(BaseTestWithShell this$0) {
        return new DefaultNuGetFallbackFolderManager(this$0.getTestDataStorage(), this$0.getTestWorkDirectoryStorage());
    }

    private static final RiderApplicationApiFacade applicationApiFacade_delegate$lambda$0() {
        Duration duration = Duration.ofMinutes(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        return new RiderApplicationApiFacade(duration);
    }

    private static final RiderBackendSettingsApiFacade backendSettingsApiFacade_delegate$lambda$0() {
        return new RiderBackendSettingsApiFacade();
    }
}

