/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.base;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemManager;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.jetbrains.rdclient.daemon.DaemonKind;
import com.jetbrains.rdclient.daemon.components.FrontendDaemonHost;
import com.jetbrains.rdclient.daemon.util.StringUtilKt;
import com.jetbrains.rider.editors.inlineDoc.configurable.RiderEditorSettingsExternalizable;
import com.jetbrains.rider.test.base.RiderFrontendDaemonTestBase;
import com.jetbrains.rider.test.facades.editor.EditorApiFacade;
import com.jetbrains.rider.test.facades.solution.SolutionApiFacade;
import com.jetbrains.rider.test.framework.GoldFilesHelperKt;
import com.jetbrains.rider.test.framework.testData.TestDataStorage;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPIKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_Editor_BaseKt;
import java.io.File;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u001e\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0004J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/test/base/InlineDocTestBase;", "Lcom/jetbrains/rider/test/base/RiderFrontendDaemonTestBase;", "<init>", "()V", "renderingSettingStateWas", "", "Ljava/lang/Boolean;", "calculateSettingsStateWas", "setUpIdeaInspections", "", "tearDownIdeaInspections", "doInlineDocTest", "fileName", "", "sourceFile", "dumpDocRenderItemsStates", "editor", "Lcom/intellij/openapi/editor/Editor;", "testSolution", "getTestSolution", "()Ljava/lang/String;", "intellij.rider.test.framework"})
public abstract class InlineDocTestBase
extends RiderFrontendDaemonTestBase {
    @Nullable
    private Boolean renderingSettingStateWas;
    @Nullable
    private Boolean calculateSettingsStateWas;
    @NotNull
    private final String testSolution;

    public InlineDocTestBase() {
        this.testSolution = "MarkupTest1";
    }

    @Override
    public void setUpIdeaInspections() {
        super.setUpIdeaInspections();
        this.calculateSettingsStateWas = RiderEditorSettingsExternalizable.Companion.getInstance().getCalculateRenderedDocCommentsInNormalEditors();
        RiderEditorSettingsExternalizable.Companion.getInstance().setCalculateRenderedDocCommentsInNormalEditors(true);
        this.renderingSettingStateWas = EditorSettingsExternalizable.getInstance().isDocCommentRenderingEnabled();
        EditorSettingsExternalizable.getInstance().setDocCommentRenderingEnabled(true);
    }

    @Override
    public void tearDownIdeaInspections() {
        super.tearDownIdeaInspections();
        RiderEditorSettingsExternalizable riderEditorSettingsExternalizable = RiderEditorSettingsExternalizable.Companion.getInstance();
        Boolean bl = this.calculateSettingsStateWas;
        Intrinsics.checkNotNull((Object)bl);
        riderEditorSettingsExternalizable.setCalculateRenderedDocCommentsInNormalEditors(bl.booleanValue());
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Boolean bl2 = this.renderingSettingStateWas;
        Intrinsics.checkNotNull((Object)bl2);
        editorSettingsExternalizable.setDocCommentRenderingEnabled(bl2.booleanValue());
    }

    protected final void doInlineDocTest(@NotNull String fileName, @Nullable String sourceFile) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ScriptingAPI_Editor_BaseKt.withOpenedEditor$default((TestDataStorage)((TestDataStorage)this), (SolutionApiFacade)((SolutionApiFacade)this), (EditorApiFacade)((EditorApiFacade)this), (String)fileName, (String)sourceFile, (boolean)false, arg_0 -> InlineDocTestBase.doInlineDocTest$lambda$0(this, arg_0), (int)32, null);
    }

    public static /* synthetic */ void doInlineDocTest$default(InlineDocTestBase inlineDocTestBase, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doInlineDocTest");
        }
        if ((n & 1) != 0) {
            string = "Program.cs";
        }
        if ((n & 2) != 0) {
            string2 = "Program.cs";
        }
        inlineDocTestBase.doInlineDocTest(string, string2);
    }

    private final String dumpDocRenderItemsStates(Editor editor) {
        StringBuilder stringBuilder;
        StringBuilder $this$dumpDocRenderItemsStates_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Collection collection = DocRenderItemManager.Companion.getInstance().getItems(editor);
        if (collection == null) {
            StringBuilder $this$dumpDocRenderItemsStates_u24lambda_u240_u240 = $this$dumpDocRenderItemsStates_u24lambda_u240;
            boolean bl2 = false;
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            $this$dumpDocRenderItemsStates_u24lambda_u240_u240.append("Items in " + StringUtilKt.presentableName((Document)document) + " are null!");
        } else {
            Collection items = collection;
            $this$dumpDocRenderItemsStates_u24lambda_u240.append("--- Doc Render Items ---\n\n");
            for (DocRenderItem it : items) {
                String text = it.getTextToRender();
                $this$dumpDocRenderItemsStates_u24lambda_u240.append("-- Item at (" + it.getHighlighter().getStartOffset() + "," + it.getHighlighter().getEndOffset() + ") --\n");
                StringBuilder stringBuilder2 = text != null ? $this$dumpDocRenderItemsStates_u24lambda_u240.append("Text:\n\n" + StringsKt.trim((CharSequence)text.subSequence(StringsKt.indexOf$default((CharSequence)text, (String)"<body>", (int)0, (boolean)false, (int)6, null) + 6, StringsKt.lastIndexOf$default((CharSequence)text, (String)"</body>", (int)0, (boolean)false, (int)6, null))) + "\n\n") : $this$dumpDocRenderItemsStates_u24lambda_u240.append("Text:\n\nNULL\n\n");
                CustomFoldRegion foldRegion = it.getFoldRegion();
                if (foldRegion == null) {
                    $this$dumpDocRenderItemsStates_u24lambda_u240.append("State: EXPANDED\n\n");
                    continue;
                }
                $this$dumpDocRenderItemsStates_u24lambda_u240.append("State: COLLAPSED, at (" + foldRegion.getStartOffset() + "," + foldRegion.getEndOffset() + ")\n\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String getTestSolution() {
        return this.testSolution;
    }

    private static final Unit doInlineDocTest$lambda$0(InlineDocTestBase this$0, EditorImpl $this$withOpenedEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$withOpenedEditor, (String)"$this$withOpenedEditor");
        Duration duration = Duration.ofMillis(1500L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        ScriptingAPIKt.waitPumping(duration);
        Project project2 = $this$withOpenedEditor.getProject();
        Intrinsics.checkNotNull((Object)project2);
        FrontendDaemonHost.Companion.getInstance(project2).restart(DaemonKind.Both, (Object)"InlineDocTest");
        Duration duration2 = Duration.ofMillis(500L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        ScriptingAPIKt.waitPumping(duration2);
        GoldFilesHelperKt.executeWithGold((File)this$0.getTestGoldFile(), arg_0 -> InlineDocTestBase.doInlineDocTest$lambda$0$0(this$0, $this$withOpenedEditor, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit doInlineDocTest$lambda$0$0(InlineDocTestBase this$0, EditorImpl $this_withOpenedEditor, PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.print(this$0.dumpDocRenderItemsStates((Editor)$this_withOpenedEditor));
        return Unit.INSTANCE;
    }
}

