/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.terminal;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.jetbrains.rider.test.terminal.Backspace;
import com.jetbrains.rider.test.terminal.CarriageReturn;
import com.jetbrains.rider.test.terminal.CursorPosition;
import com.jetbrains.rider.test.terminal.EraseEntireDisplay;
import com.jetbrains.rider.test.terminal.LineFeed;
import com.jetbrains.rider.test.terminal.ProcessText;
import com.jetbrains.rider.test.terminal.TerminalCommand;
import com.jetbrains.rider.test.terminal.TestAnsiCodeProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/test/terminal/TestAnsiCodeProcessorProxy;", "Lcom/intellij/execution/process/ProcessListener;", "processor", "Lcom/jetbrains/rider/test/terminal/TestAnsiCodeProcessor;", "consumer", "Lkotlin/Function1;", "", "", "allowOutputBuffering", "", "<init>", "(Lcom/jetbrains/rider/test/terminal/TestAnsiCodeProcessor;Lkotlin/jvm/functions/Function1;Z)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "position", "", "onTextAvailable", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "flushBuffer", "navigateTo", "line", "column", "navigateToLineBegin", "navigateToNextLine", "backspace", "insertText", "text", "Companion", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nTestAnsiCodeProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestAnsiCodeProcessor.kt\ncom/jetbrains/rider/test/terminal/TestAnsiCodeProcessorProxy\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,283:1\n67#2,4:284\n67#2,4:288\n67#2,4:292\n67#2,4:296\n13#2:300\n*S KotlinDebug\n*F\n+ 1 TestAnsiCodeProcessor.kt\ncom/jetbrains/rider/test/terminal/TestAnsiCodeProcessorProxy\n*L\n160#1:284,4\n164#1:288,4\n178#1:292,4\n211#1:296,4\n60#1:300\n*E\n"})
public class TestAnsiCodeProcessorProxy
implements ProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestAnsiCodeProcessor processor;
    @Nullable
    private final Function1<String, Unit> consumer;
    private final boolean allowOutputBuffering;
    @NotNull
    private final StringBuilder buffer;
    private int position;
    @NotNull
    private static final Logger logger;

    public TestAnsiCodeProcessorProxy(@NotNull TestAnsiCodeProcessor processor, @Nullable Function1<? super String, Unit> consumer, boolean allowOutputBuffering) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.processor = processor;
        this.consumer = consumer;
        this.allowOutputBuffering = allowOutputBuffering;
        this.buffer = new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Logger $this$trace$iv = TestAnsiCodeProcessorProxy.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("(" + event.getProcessHandler() + ", " + outputType + ") ANSI markup received: " + event.getText());
        }
        if (this.allowOutputBuffering) {
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            List commands = TestAnsiCodeProcessorProxy.Companion.parseAnsi(string);
            Logger $this$trace$iv2 = TestAnsiCodeProcessorProxy.logger;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Parsed commands: " + CollectionsKt.joinToString$default((Iterable)commands, null, null, null, (int)0, null, null, (int)63, null));
            }
            StringBuilder stringBuilder = this.buffer;
            synchronized (stringBuilder) {
                boolean bl = false;
                for (TerminalCommand command : commands) {
                    TerminalCommand terminalCommand = command;
                    if (Intrinsics.areEqual((Object)terminalCommand, (Object)Backspace.INSTANCE)) {
                        this.backspace();
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)terminalCommand, (Object)CarriageReturn.INSTANCE)) {
                        this.navigateToLineBegin();
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)terminalCommand, (Object)LineFeed.INSTANCE)) {
                        this.navigateToNextLine();
                        continue;
                    }
                    if (terminalCommand instanceof CursorPosition) {
                        this.navigateTo(((CursorPosition)command).getLine(), ((CursorPosition)command).getColumn());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)terminalCommand, (Object)EraseEntireDisplay.INSTANCE)) {
                        this.flushBuffer();
                        continue;
                    }
                    if (terminalCommand instanceof ProcessText) {
                        String string2 = ((ProcessText)command).getValue().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        this.processor.escapeText(string2, outputType, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

                            public final void invoke(String p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                TestAnsiCodeProcessorProxy.access$insertText((TestAnsiCodeProcessorProxy)this.receiver, p0);
                            }
                        }));
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                Logger $this$trace$iv3 = TestAnsiCodeProcessorProxy.logger;
                boolean $i$f$trace3 = false;
                if ($this$trace$iv3.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv3;
                    boolean bl2 = false;
                    logger2.trace("Current ANSI buffer state (p. " + this.position + "): " + this.buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            Object object = event.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.execution.process.ProcessHandler");
            if (((ProcessHandler)object).isProcessTerminated()) {
                TestAnsiCodeProcessorProxy.logger.trace("Process terminated: flushing the buffer.");
                this.flushBuffer();
            }
        } else {
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.processor.escapeText(string, outputType, (Function1<? super String, Unit>)((Function1)arg_0 -> TestAnsiCodeProcessorProxy.onTextAvailable$lambda$3(this, arg_0)));
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.info("Process terminated.");
        this.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushBuffer() {
        String $i$a$-synchronized-TestAnsiCodeProcessorProxy$flushBuffer$out$22;
        if (this.consumer == null || !this.allowOutputBuffering) {
            return;
        }
        logger.info("Flushing the current ANSI buffer.");
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            boolean $i$a$-synchronized-TestAnsiCodeProcessorProxy$flushBuffer$out$22 = false;
            String string = this.buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String result2 = string;
            StringsKt.clear((StringBuilder)this.buffer);
            this.position = 0;
            $i$a$-synchronized-TestAnsiCodeProcessorProxy$flushBuffer$out$22 = result2;
        }
        String out = $i$a$-synchronized-TestAnsiCodeProcessorProxy$flushBuffer$out$22;
        for (String line : StringsKt.lineSequence((CharSequence)((Object)StringsKt.trimEnd((CharSequence)out)).toString())) {
            String text = ((Object)StringsKt.trimEnd((CharSequence)line)).toString() + "\n";
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Passing a line to the consumer: " + text + " (" + text.length() + " characters)");
            }
            this.consumer.invoke((Object)text);
        }
    }

    private final void navigateTo(int line, int column) {
        this.position = 0;
        for (int currentY = 1; currentY < line; ++currentY) {
            int nextLineStart = StringsKt.indexOf$default((CharSequence)this.buffer, (char)'\n', (int)this.position, (boolean)false, (int)4, null);
            if (nextLineStart == -1) {
                for (int i = currentY; i < line; ++i) {
                    this.buffer.append('\n');
                    this.position = this.buffer.length();
                }
                break;
            }
            this.position = nextLineStart + 1;
        }
        int currentX = 1;
        while (currentX < column) {
            if (!StringsKt.getIndices((CharSequence)this.buffer).contains(this.position + 1) || this.buffer.charAt(this.position + 1) == '\n') {
                StringBuilder stringBuilder = this.position + 1 > this.buffer.length() ? this.buffer.append(' ') : this.buffer.insert(this.position + 1, ' ');
            }
            ++currentX;
            ++this.position;
        }
    }

    private final void navigateToLineBegin() {
        for (int i = this.position; 0 < i; --i) {
            if (this.buffer.charAt(i - 1) != '\n') continue;
            this.position = i;
            return;
        }
        this.position = 0;
    }

    private final void navigateToNextLine() {
        int n = this.buffer.length();
        for (int i = this.position; i < n; ++i) {
            if (this.buffer.charAt(i) != '\n') continue;
            this.position = i + 1;
            return;
        }
        this.buffer.append('\n');
        this.position = this.buffer.length();
    }

    private final void backspace() {
        if (this.position > 0) {
            this.position += -1;
        }
    }

    private final void insertText(String text) {
        this.buffer.replace(this.position, this.position + text.length(), text);
        this.position += text.length();
    }

    private static final Unit onTextAvailable$lambda$3(TestAnsiCodeProcessorProxy this$0, String text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Function1<String, Unit> function1 = this$0.consumer;
            if (function1 == null) break block0;
            function1.invoke((Object)text);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$insertText(TestAnsiCodeProcessorProxy $this, String text) {
        $this.insertText(text);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TestAnsiCodeProcessorProxy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TestAnsiCodeProcessorProxy.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/test/terminal/TestAnsiCodeProcessorProxy$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "parseAnsi", "", "Lcom/jetbrains/rider/test/terminal/TerminalCommand;", "input", "", "intellij.rider.test.framework"})
    public static final class Companion {
        private Companion() {
        }

        private final List<TerminalCommand> parseAnsi(String input) {
            int position = 0;
            List rawCommands = new ArrayList();
            block14: while (position < input.length()) {
                char leadingChar = input.charAt(position);
                switch (leadingChar) {
                    case '\r': {
                        boolean bl = rawCommands.add(CarriageReturn.INSTANCE);
                        break;
                    }
                    case '\n': {
                        boolean bl = rawCommands.add(LineFeed.INSTANCE);
                        break;
                    }
                    case '\b': {
                        boolean bl = rawCommands.add(Backspace.INSTANCE);
                        break;
                    }
                    case '\u001b': {
                        if (input.length() > position + 2 && input.charAt(position + 1) == '[') {
                            Iterator iterator = com.jetbrains.rider.test.terminal.TestAnsiCodeProcessorProxy$Companion.parseAnsi$tryReadArguments(input, position + 2);
                            int newPos = ((Number)iterator.component1()).intValue();
                            List arguments = (List)iterator.component2();
                            switch (input.charAt(newPos)) {
                                case 'H': {
                                    switch (arguments.size()) {
                                        case 0: {
                                            rawCommands.add(new CursorPosition(1, 1));
                                            position = newPos + 1;
                                            continue block14;
                                        }
                                        case 2: {
                                            Integer n = (Integer)arguments.get(0);
                                            Integer n2 = (Integer)arguments.get(1);
                                            rawCommands.add(new CursorPosition(n != null ? n : 1, n2 != null ? n2 : 1));
                                            position = newPos + 1;
                                            continue block14;
                                        }
                                    }
                                    logger.warn("Invalid arguments " + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)";", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null) + " for CUP.");
                                    break;
                                }
                                case 'J': {
                                    if (arguments.size() == 1) {
                                        rawCommands.add(EraseEntireDisplay.INSTANCE);
                                        position = newPos + 1;
                                        continue block14;
                                    }
                                    logger.warn("Invalid arguments " + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)";", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null) + " for ED.");
                                }
                            }
                        }
                        boolean bl = rawCommands.add(new ProcessText(leadingChar));
                        break;
                    }
                    default: {
                        boolean bl = rawCommands.add(new ProcessText(leadingChar));
                    }
                }
                ++position;
            }
            List result2 = new ArrayList();
            for (TerminalCommand command : rawCommands) {
                Comparable<Boolean> comparable;
                if (command instanceof ProcessText) {
                    TerminalCommand lastResult = (TerminalCommand)CollectionsKt.lastOrNull((List)result2);
                    if (lastResult instanceof ProcessText) {
                        comparable = ((ProcessText)lastResult).getValue().append((CharSequence)((ProcessText)command).getValue());
                        continue;
                    }
                    comparable = result2.add(command);
                    continue;
                }
                comparable = result2.add(command);
            }
            return result2;
        }

        private static final Pair<Integer, List<Integer>> parseAnsi$tryReadArguments(String $input, int fromPos) {
            int newPos;
            List args = new ArrayList();
            StringBuilder currentArg = new StringBuilder();
            for (newPos = fromPos; newPos < $input.length(); ++newPos) {
                StringBuilder stringBuilder;
                char c = $input.charAt(newPos);
                if (c == ';') {
                    Integer n;
                    if (((CharSequence)currentArg).length() == 0) {
                        n = null;
                    } else {
                        String string = currentArg.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        n = Integer.parseInt(string);
                    }
                    args.add(n);
                    stringBuilder = StringsKt.clear((StringBuilder)currentArg);
                    continue;
                }
                if (!Character.isDigit(c)) break;
                stringBuilder = currentArg.append(c);
            }
            if (((CharSequence)currentArg).length() > 0) {
                String string = currentArg.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                args.add(Integer.parseInt(string));
            }
            return TuplesKt.to((Object)newPos, (Object)args);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

