/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.DotNetDebuggerEditorsProvider;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.evaluation.DotNetExpression;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindow;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowEvaluator;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.model.debuggerWorker.ImmediateEvaluationResult;
import com.jetbrains.rider.test.scriptingApi.DebugTestExecutionContext;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DebugKt;
import java.time.Duration;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u00102\b\b\u0002\u0010\u001c\u001a\u00020\u0010J\u0010\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/ImmediateContext;", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "debugExecutionContext", "Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext;)V", "getDebugExecutionContext", "()Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext;", "immediateEvaluator", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowEvaluator;", "isImmediateIsEditor", "Lcom/jetbrains/rd/util/reactive/Property;", "", "immediateWindow", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow;", "consoleImpl", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "editorImpl", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "evaluate", "", "expression", "", "expectedBreakpoint", "isCidr", "dumpLocals", "level", "", "addWatch", "intellij.rider.test.framework"})
public final class ImmediateContext {
    @NotNull
    private final DebugTestExecutionContext debugExecutionContext;
    @NotNull
    private ImmediateWindowEvaluator immediateEvaluator;
    @NotNull
    private Property<Boolean> isImmediateIsEditor;
    @NotNull
    private final ImmediateWindow immediateWindow;
    @NotNull
    private final LanguageConsoleImpl consoleImpl;
    @NotNull
    private EditorImpl editorImpl;

    public ImmediateContext(@NotNull XDebugSession session, @NotNull Lifetime lifetime, @NotNull DebugTestExecutionContext debugExecutionContext) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)debugExecutionContext, (String)"debugExecutionContext");
        this.debugExecutionContext = debugExecutionContext;
        this.immediateEvaluator = new ImmediateWindowEvaluator(session, lifetime, DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow((XDebugSession)session).getSessionProxy());
        this.isImmediateIsEditor = new Property((Object)false);
        Project project2 = session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.immediateWindow = new ImmediateWindow(session, lifetime, lifetime, this.immediateEvaluator, new DotNetDebuggerEditorsProvider(project2, null, 2, null));
        this.consoleImpl = (LanguageConsoleImpl)this.immediateWindow.createConsole();
        EditorEx editorEx = this.consoleImpl.getConsoleEditor();
        EditorImpl editorImpl = editorEx instanceof EditorImpl ? (EditorImpl)editorEx : null;
        if (editorImpl == null) {
            throw new IllegalStateException("cannot get EditorImpl from expression combobox".toString());
        }
        this.editorImpl = editorImpl;
        this.editorImpl.getComponent().addNotify();
        this.immediateEvaluator.setEditor(this.editorImpl);
        this.isImmediateIsEditor.set((Object)true);
        lifetime.onTermination(() -> ImmediateContext._init_$lambda$0(this));
    }

    @NotNull
    public final DebugTestExecutionContext getDebugExecutionContext() {
        return this.debugExecutionContext;
    }

    public final void evaluate(@NotNull String expression, boolean expectedBreakpoint, boolean isCidr) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Semaphore s = new Semaphore(0);
        XStackFrame xStackFrame = this.debugExecutionContext.getSession().getCurrentStackFrame();
        Intrinsics.checkNotNull((Object)xStackFrame, (String)"null cannot be cast to non-null type com.jetbrains.rider.debugger.DotNetStackFrame");
        int fId = ((DotNetStackFrame)xStackFrame).getFrameProxy().getId();
        ImmediateWindowEvaluator.evaluateAsync$default((ImmediateWindowEvaluator)this.immediateEvaluator, (int)fId, (DotNetExpression)new DotNetExpression(expression, (Language)CSharpLanguage.INSTANCE, EvaluationMode.EXPRESSION), (boolean)true, null, ImmediateContext::evaluate$lambda$0, (int)8, null).onError(arg_0 -> ImmediateContext.evaluate$lambda$2(arg_0 -> ImmediateContext.evaluate$lambda$1(this, expression, s, arg_0), arg_0)).then(arg_0 -> ImmediateContext.evaluate$lambda$4(arg_0 -> ImmediateContext.evaluate$lambda$3(this, expression, s, arg_0), arg_0));
        if (expectedBreakpoint) {
            if (isCidr) {
                ScriptingAPI_DebugKt.waitForCidrPause$default(this.debugExecutionContext, false, 1, null);
            } else {
                ScriptingAPI_DebugKt.waitForPause(this.debugExecutionContext);
            }
        } else {
            Duration duration = Duration.ofSeconds(15L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            ScriptingAPI_DebugKt.waiter(s, duration, "evaluate");
        }
    }

    public static /* synthetic */ void evaluate$default(ImmediateContext immediateContext, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        immediateContext.evaluate(string, bl, bl2);
    }

    public final void dumpLocals(int level) {
        DebugTestExecutionContext.dumpLocals$default(this.debugExecutionContext, level, null, null, 6, null);
    }

    public static /* synthetic */ void dumpLocals$default(ImmediateContext immediateContext, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        immediateContext.dumpLocals(n);
    }

    public final void addWatch(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ActionsKt.runWriteAction(() -> ImmediateContext.addWatch$lambda$0(this, expression));
        this.immediateWindow.addWatch(expression);
    }

    private static final Unit _init_$lambda$0(ImmediateContext this$0) {
        this$0.consoleImpl.getConsoleEditor().getComponent().removeNotify();
        return Unit.INSTANCE;
    }

    private static final Unit evaluate$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit evaluate$lambda$1(ImmediateContext this$0, String $expression, Semaphore $s, Throwable it) {
        this$0.debugExecutionContext.printlnIndented("Error while '" + $expression + "' evaluation: " + it + "\n");
        $s.release();
        return Unit.INSTANCE;
    }

    private static final void evaluate$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit evaluate$lambda$3(ImmediateContext this$0, String $expression, Semaphore $s, ImmediateEvaluationResult it) {
        this$0.debugExecutionContext.printlnIndented("Result of '" + $expression + "' evaluation: " + it.getResultOnConsole().getValue() + "\n");
        if (it.getCreatedNewSyntheticVar()) {
            this$0.immediateEvaluator.tryReCreateSandbox();
        }
        $s.release();
        return Unit.INSTANCE;
    }

    private static final Unit evaluate$lambda$4(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit addWatch$lambda$0(ImmediateContext this$0, String $expression) {
        this$0.consoleImpl.getConsoleEditor().getDocument().setText((CharSequence)$expression);
        return Unit.INSTANCE;
    }
}

