/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import java.nio.file.Path;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u0014\u0010\u0000\u001a\u00020\u00062\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"measure", "", "timeoutMs", "", "block", "Lkotlin/Function0;", "", "assertLogIndexing", "logFile", "Ljava/nio/file/Path;", "gc", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nScriptingAPI.Performance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingAPI.Performance.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_PerformanceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n1#2:60\n1401#3,2:61\n*S KotlinDebug\n*F\n+ 1 ScriptingAPI.Performance.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_PerformanceKt\n*L\n37#1:61,2\n*E\n"})
public final class ScriptingAPI_PerformanceKt {
    public static final void measure(int timeoutMs, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long duration = ScriptingAPI_PerformanceKt.measure(block);
        TestFrameworkBaseKt.getFrameworkLogger().info("Duration is " + duration + " ms. Expected is " + timeoutMs + " ms");
        if (!((long)timeoutMs >= duration)) {
            boolean bl = false;
            String string = "Benchmark failed. Actual result (" + duration + " ms) > expected (" + timeoutMs + " ms)";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final long measure(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long startTime = System.nanoTime();
        TestFrameworkBaseKt.getFrameworkLogger().info("----------Start measuring----------");
        block.invoke();
        TestFrameworkBaseKt.getFrameworkLogger().info("----------Finish measuring----------");
        long duration = (long)((double)(System.nanoTime() - startTime) / 1000000.0);
        TestFrameworkBaseKt.getFrameworkLogger().info("Duration is " + duration + " ms.");
        System.out.println((Object)("Duration is " + duration + " ms."));
        return duration;
    }

    public static final void assertLogIndexing(@NotNull Path logFile) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        String string = ".*Scheduling indexing of.*";
        Regex fileIsIndexedRegEx = new Regex(string);
        String[] stringArray = new String[]{"file1.html", "file2.js", "file3.ts", "file4.css", "file5.txt", "file6.kt"};
        String[] noIndexFiles = stringArray;
        Scanner scanner = new Scanner(logFile, "UTF-8");
        while (scanner.hasNext()) {
            boolean bl;
            String string2;
            block2: {
                String line = scanner.nextLine();
                Intrinsics.checkNotNull((Object)line);
                if (!fileIsIndexedRegEx.matches((CharSequence)line)) continue;
                String[] $this$firstOrNull$iv = noIndexFiles;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    string2 = element$iv;
                    break block2;
                }
                string2 = null;
            }
            String match = string2;
            boolean bl3 = bl = match == null;
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl4 = false;
            String string3 = match + " shouldn't be indexed";
            throw new AssertionError((Object)string3);
        }
    }

    public static final void gc() {
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }
}

