/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.RoslynEvent;
import com.jetbrains.rider.model.RoslynEventInfo;
import com.jetbrains.rider.model.RoslynWorkerSyncStatus;
import com.jetbrains.rider.roslyn.RoslynHost;
import com.jetbrains.rider.test.facades.solution.SolutionApiFacade;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_ProjectModel_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingApi_HighlightersKt;
import java.io.PrintStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u001a\u001e\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u001a\"\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e\u001a\u0018\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001aE\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u00172\b\b\u0002\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u00192\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\u0002\u0010\u001a\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u001c"}, d2={"waitForNextRoslynReady", "", "Lcom/jetbrains/rider/test/facades/solution/SolutionApiFacade;", "idleTimeout", "Ljava/time/Duration;", "hostTimeout", "workerTimeout", "waitForRoslynReady", "project", "Lcom/intellij/openapi/project/Project;", "waitForRoslynReadyIfNeeded", "waitForRoslynSynced", "timeout", "action", "Lkotlin/Function0;", "waitRoslynProjectModel", "dumpSevereHighlighters", "Lcom/intellij/openapi/editor/Editor;", "stream", "Ljava/io/PrintStream;", "waitForRoslynEvents", "events", "", "Lcom/jetbrains/rider/model/RoslynEvent;", "clearBeforeWait", "", "(Lcom/jetbrains/rider/test/facades/solution/SolutionApiFacade;[Lcom/jetbrains/rider/model/RoslynEvent;Ljava/time/Duration;ZLkotlin/jvm/functions/Function0;)V", "clearRoslynEvents", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nScriptingAPI.Roslyn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingAPI.Roslyn.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_RoslynKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n*L\n1#1,132:1\n1#2:133\n1#2:145\n12033#3,10:134\n14060#3:144\n14061#3:146\n12043#3:147\n1915#4,2:148\n39#5,5:150\n*S KotlinDebug\n*F\n+ 1 ScriptingAPI.Roslyn.kt\ncom/jetbrains/rider/test/scriptingApi/ScriptingAPI_RoslynKt\n*L\n90#1:145\n90#1:134,10\n90#1:144\n90#1:146\n90#1:147\n96#1:148,2\n108#1:150,5\n*E\n"})
public final class ScriptingAPI_RoslynKt {
    public static final void waitForNextRoslynReady(@NotNull SolutionApiFacade $this$waitForNextRoslynReady, @NotNull Duration idleTimeout, @NotNull Duration hostTimeout, @NotNull Duration workerTimeout) {
        Intrinsics.checkNotNullParameter((Object)$this$waitForNextRoslynReady, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)idleTimeout, (String)"idleTimeout");
        Intrinsics.checkNotNullParameter((Object)hostTimeout, (String)"hostTimeout");
        Intrinsics.checkNotNullParameter((Object)workerTimeout, (String)"workerTimeout");
        RoslynHost roslynHost = RoslynHost.Companion.getInstance($this$waitForNextRoslynReady.getProject());
        if (Intrinsics.areEqual((Object)roslynHost.getModel().getRoslynReady().getValueOrNull(), (Object)true)) {
            TestFrameworkBaseKt.getFrameworkLogger().info("Roslyn host is already ready, waiting to un-ready");
            boolean gotUnready = ExtensionsKt.pumpMessages((Duration)idleTimeout, () -> ScriptingAPI_RoslynKt.waitForNextRoslynReady$lambda$0(roslynHost));
            if (!gotUnready) {
                TestFrameworkBaseKt.getFrameworkLogger().info("Roslyn host was still ready at the end of un-ready timeout");
            }
        }
        ScriptingAPI_RoslynKt.waitForRoslynReady($this$waitForNextRoslynReady, hostTimeout, workerTimeout);
    }

    public static /* synthetic */ void waitForNextRoslynReady$default(SolutionApiFacade solutionApiFacade, Duration duration, Duration duration2, Duration duration3, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration4 = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
            duration = duration4;
        }
        if ((n & 2) != 0) {
            Duration duration5 = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration5, (String)"ofSeconds(...)");
            duration2 = duration5;
        }
        if ((n & 4) != 0) {
            Duration duration6 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"ofMinutes(...)");
            duration3 = duration6;
        }
        ScriptingAPI_RoslynKt.waitForNextRoslynReady(solutionApiFacade, duration, duration2, duration3);
    }

    public static final void waitForRoslynReady(@NotNull SolutionApiFacade $this$waitForRoslynReady, @NotNull Duration hostTimeout, @NotNull Duration workerTimeout) {
        Intrinsics.checkNotNullParameter((Object)$this$waitForRoslynReady, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hostTimeout, (String)"hostTimeout");
        Intrinsics.checkNotNullParameter((Object)workerTimeout, (String)"workerTimeout");
        ScriptingAPI_RoslynKt.waitForRoslynReady($this$waitForRoslynReady.getProject(), hostTimeout, workerTimeout);
    }

    public static /* synthetic */ void waitForRoslynReady$default(SolutionApiFacade solutionApiFacade, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration3 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(...)");
            duration = duration3;
        }
        if ((n & 2) != 0) {
            Duration duration4 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofMinutes(...)");
            duration2 = duration4;
        }
        ScriptingAPI_RoslynKt.waitForRoslynReady(solutionApiFacade, duration, duration2);
    }

    public static final void waitForRoslynReady(@NotNull Project project2, @NotNull Duration hostTimeout, @NotNull Duration workerTimeout) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)hostTimeout, (String)"hostTimeout");
        Intrinsics.checkNotNullParameter((Object)workerTimeout, (String)"workerTimeout");
        TestFrameworkBaseKt.getFrameworkLogger().info("Waiting for Roslyn to get enabled");
        RoslynHost roslynHost = RoslynHost.Companion.getInstance(project2);
        ExtensionsKt.pumpMessages((Duration)hostTimeout, () -> ScriptingAPI_RoslynKt.waitForRoslynReady$lambda$0(roslynHost));
        boolean bl = Intrinsics.areEqual((Object)roslynHost.getModel().getRoslynEnabled().getValueOrNull(), (Object)true);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ScriptingAPI_RoslynKt$waitForRoslynReady$32 = false;
            String $i$a$-assert-ScriptingAPI_RoslynKt$waitForRoslynReady$32 = "Roslyn should be enabled";
            throw new AssertionError((Object)$i$a$-assert-ScriptingAPI_RoslynKt$waitForRoslynReady$32);
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Waiting for Roslyn to get ready");
        ExtensionsKt.pumpMessages((Duration)workerTimeout, () -> ScriptingAPI_RoslynKt.waitForRoslynReady$lambda$2(roslynHost));
        bl = Intrinsics.areEqual((Object)roslynHost.getModel().getRoslynReady().getValueOrNull(), (Object)true);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Roslyn should be ready";
            throw new AssertionError((Object)string);
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Roslyn is ready");
        ScriptingAPI_ProjectModel_BaseKt.waitForSyncPoints$default((Project)project2, null, (int)2, null);
    }

    public static /* synthetic */ void waitForRoslynReady$default(Project project2, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration3 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(...)");
            duration = duration3;
        }
        if ((n & 4) != 0) {
            Duration duration4 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofMinutes(...)");
            duration2 = duration4;
        }
        ScriptingAPI_RoslynKt.waitForRoslynReady(project2, duration, duration2);
    }

    public static final void waitForRoslynReadyIfNeeded(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (Intrinsics.areEqual((Object)RoslynHost.Companion.getInstance(project2).getModel().getRoslynEnabled().getValueOrNull(), (Object)true)) {
            ScriptingAPI_RoslynKt.waitForRoslynReady$default(project2, null, null, 6, null);
        }
    }

    public static final void waitForRoslynSynced(@NotNull SolutionApiFacade $this$waitForRoslynSynced, @NotNull Duration timeout, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$waitForRoslynSynced, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        RoslynHost roslynHost = RoslynHost.Companion.getInstance($this$waitForRoslynSynced.getProject());
        roslynHost.getModel().getSyncStatus().setValue(null);
        action.invoke();
        if (!ExtensionsKt.pumpMessages((Duration)timeout, () -> ScriptingAPI_RoslynKt.waitForRoslynSynced$lambda$0(roslynHost))) {
            throw new IllegalStateException(("Timeout of " + timeout.toMillis() + " ms expired while waiting for Roslyn Sync, status " + roslynHost.getModel().getSyncStatus().getValue()).toString());
        }
        if (roslynHost.getModel().getSyncStatus().getValue() == RoslynWorkerSyncStatus.Failure) {
            throw new IllegalStateException("Roslyn Sync Failure".toString());
        }
    }

    public static /* synthetic */ void waitForRoslynSynced$default(SolutionApiFacade solutionApiFacade, Duration duration, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        ScriptingAPI_RoslynKt.waitForRoslynSynced(solutionApiFacade, duration, (Function0<Unit>)function0);
    }

    public static final void waitRoslynProjectModel(@NotNull SolutionApiFacade $this$waitRoslynProjectModel, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$waitRoslynProjectModel, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        RoslynEvent[] roslynEventArray = new RoslynEvent[]{RoslynEvent.ProjectModelChangesApplied};
        ScriptingAPI_RoslynKt.waitForRoslynEvents$default($this$waitRoslynProjectModel, roslynEventArray, null, false, action, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void dumpSevereHighlighters(@NotNull Editor $this$dumpSevereHighlighters, @NotNull PrintStream stream) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$dumpSevereHighlighters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        RangeHighlighterEx[] $this$mapNotNull$iv = ScriptingApi_HighlightersKt.getMarkupContributor($this$dumpSevereHighlighters).getMarkupAdapter().getAllHighlighters();
        boolean $i$f$mapNotNull = false;
        RangeHighlighterEx[] rangeHighlighterExArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (HighlightersUtilKt.getBackendAttributeId((RangeHighlighter)((RangeHighlighter)it)) == null) {
                string = null;
            } else {
                String attributeId;
                HighlightInfo errorStripeTooltip;
                Object object = it.getErrorStripeTooltip();
                HighlightInfo highlightInfo = object instanceof HighlightInfo ? (HighlightInfo)object : null;
                string = highlightInfo == null ? null : ((errorStripeTooltip = highlightInfo).getSeverity().compareTo(HighlightSeverity.WARNING) >= 0 ? attributeId + " - (" + it.getStartOffset() + ", " + it.getEndOffset() + ") - " + errorStripeTooltip.getText() + " - " + errorStripeTooltip.getDescription() : null);
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            stream.println(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void waitForRoslynEvents(@NotNull SolutionApiFacade $this$waitForRoslynEvents, @NotNull RoslynEvent[] events, @NotNull Duration timeout, boolean clearBeforeWait, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$waitForRoslynEvents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        RoslynHost roslynHost = RoslynHost.Companion.getInstance($this$waitForRoslynEvents.getProject());
        List capturedEvents = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(events, events.length));
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime lt = def$iv.getLifetime();
            boolean bl = false;
            if (clearBeforeWait) {
                ScriptingAPI_RoslynKt.clearRoslynEvents($this$waitForRoslynEvents);
            }
            roslynHost.getModel().getLastEvents().adviseAddRemove(lt, (arg_0, arg_1, arg_2) -> ScriptingAPI_RoslynKt.waitForRoslynEvents$lambda$0$0(capturedEvents, arg_0, arg_1, arg_2));
            action.invoke();
            if (!ExtensionsKt.pumpMessages((Duration)timeout, () -> ScriptingAPI_RoslynKt.waitForRoslynEvents$lambda$0$1(capturedEvents))) {
                throw new IllegalStateException(("Timeout of " + timeout.toMillis() + " ms expired while waiting for Roslyn events \"" + ArraysKt.joinToString$default((Object[])events, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "\". Incomplete events: \"" + CollectionsKt.joinToString$default((Iterable)capturedEvents, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "\" Actual events: \"" + CollectionsKt.joinToString$default((Iterable)((Iterable)roslynHost.getModel().getLastEvents()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "\"").toString());
            }
            ScriptingAPI_ProjectModel_BaseKt.waitForSyncPoints$default((Project)$this$waitForRoslynEvents.getProject(), null, (int)2, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    public static /* synthetic */ void waitForRoslynEvents$default(SolutionApiFacade solutionApiFacade, RoslynEvent[] roslynEventArray, Duration duration, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        ScriptingAPI_RoslynKt.waitForRoslynEvents(solutionApiFacade, roslynEventArray, duration, bl, (Function0<Unit>)function0);
    }

    public static final void clearRoslynEvents(@NotNull SolutionApiFacade $this$clearRoslynEvents) {
        Intrinsics.checkNotNullParameter((Object)$this$clearRoslynEvents, (String)"<this>");
        RoslynHost roslynHost = RoslynHost.Companion.getInstance($this$clearRoslynEvents.getProject());
        roslynHost.getModel().getLastEvents().clear();
    }

    private static final boolean waitForNextRoslynReady$lambda$0(RoslynHost $roslynHost) {
        return !Intrinsics.areEqual((Object)$roslynHost.getModel().getRoslynReady().getValueOrNull(), (Object)true);
    }

    private static final boolean waitForRoslynReady$lambda$0(RoslynHost $roslynHost) {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)$roslynHost.getModel().getRoslynEnabled()));
    }

    private static final boolean waitForRoslynReady$lambda$2(RoslynHost $roslynHost) {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)$roslynHost.getModel().getRoslynReady()));
    }

    private static final boolean waitForRoslynSynced$lambda$0(RoslynHost $roslynHost) {
        return $roslynHost.getModel().getSyncStatus().getValue() == RoslynWorkerSyncStatus.Synchronized || $roslynHost.getModel().getSyncStatus().getValue() == RoslynWorkerSyncStatus.Failure;
    }

    private static final boolean waitForRoslynEvents$lambda$0$0$0(RoslynEventInfo $value, RoslynEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == $value.getEvent();
    }

    private static final boolean waitForRoslynEvents$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit waitForRoslynEvents$lambda$0$0(List $capturedEvents, AddRemove addRemove, int idx, RoslynEventInfo value) {
        Intrinsics.checkNotNullParameter((Object)addRemove, (String)"addRemove");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (addRemove == AddRemove.Add) {
            $capturedEvents.removeIf(arg_0 -> ScriptingAPI_RoslynKt.waitForRoslynEvents$lambda$0$0$1(arg_0 -> ScriptingAPI_RoslynKt.waitForRoslynEvents$lambda$0$0$0(value, arg_0), arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final boolean waitForRoslynEvents$lambda$0$1(List $capturedEvents) {
        return $capturedEvents.isEmpty();
    }
}

