/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.TerminalExecutionConsole;
import com.jediterm.terminal.TerminalStarter;
import com.jetbrains.rider.test.scriptingApi.TestConsoleWrapper;
import java.awt.Component;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/test/scriptingApi/TerminalExecutionConsoleTestWrapper;", "Lcom/jetbrains/rider/test/scriptingApi/TestConsoleWrapper;", "console", "Lcom/intellij/terminal/TerminalExecutionConsole;", "<init>", "(Lcom/intellij/terminal/TerminalExecutionConsole;)V", "getCurrentText", "", "sendInput", "", "text", "enter", "backspace", "intellij.rider.test.framework"})
public final class TerminalExecutionConsoleTestWrapper
extends TestConsoleWrapper {
    @NotNull
    private final TerminalExecutionConsole console;

    public TerminalExecutionConsoleTestWrapper(@NotNull TerminalExecutionConsole console) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        this.console = console;
    }

    @Override
    @NotNull
    public String getCurrentText() {
        return this.console.getTerminalWidget().getTerminalTextBuffer().getScreenLines();
    }

    @Override
    public void sendInput(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TerminalStarter terminalStarter = this.console.getTerminalWidget().getTerminalStarter();
        if (terminalStarter == null) {
            throw new IllegalStateException("terminalStarter is null".toString());
        }
        terminalStarter.sendString(text, true);
    }

    @Override
    public void enter() {
        JBTerminalPanel jBTerminalPanel = this.console.getTerminalWidget().getTerminalPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jBTerminalPanel, (String)"getTerminalPanel(...)");
        JBTerminalPanel panel = jBTerminalPanel;
        KeyEvent backspacePressed = new KeyEvent((Component)panel, 401, 0L, 0, 10, '\n');
        panel.handleKeyEvent(backspacePressed);
    }

    @Override
    public void backspace() {
        JBTerminalPanel jBTerminalPanel = this.console.getTerminalWidget().getTerminalPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jBTerminalPanel, (String)"getTerminalPanel(...)");
        JBTerminalPanel panel = jBTerminalPanel;
        KeyEvent backspacePressed = new KeyEvent((Component)panel, 401, 0L, 0, 8, '\b');
        panel.handleKeyEvent(backspacePressed);
    }
}

