/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.util.DebuggerWorkerModelUtilKt;
import com.jetbrains.rider.debugger.util.StackFramesUtilsKt;
import com.jetbrains.rider.model.debuggerWorker.StackFrameProxy;
import com.jetbrains.rider.test.debugger.TestTextContainer;
import com.jetbrains.rider.test.debugger.XDebuggerTestHelper;
import com.jetbrains.rider.test.debugger.XTestValueNode;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DebugKt;
import java.time.Duration;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\n\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u000b\u00a8\u0006\f"}, d2={"text", "", "Lcom/intellij/xdebugger/frame/XStackFrame;", "withLineInfo", "", "customizePresentationWithoutLine", "", "Lcom/jetbrains/rider/debugger/DotNetStackFrame;", "component", "Lcom/intellij/ui/ColoredTextContainer;", "Lcom/intellij/xdebugger/frame/XValue;", "Lcom/jetbrains/rider/test/debugger/XTestValueNode;", "intellij.rider.test.framework"})
public final class XDebugExtensionsKt {
    @NotNull
    public static final String text(@NotNull XStackFrame $this$text, boolean withLineInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        TestTextContainer testTextContainer = new TestTextContainer();
        if (withLineInfo) {
            $this$text.customizePresentation((ColoredTextContainer)testTextContainer);
        } else {
            XDebugExtensionsKt.customizePresentationWithoutLine((DotNetStackFrame)$this$text, testTextContainer);
        }
        return testTextContainer.getText();
    }

    public static /* synthetic */ String text$default(XStackFrame xStackFrame, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return XDebugExtensionsKt.text(xStackFrame, bl);
    }

    public static final void customizePresentationWithoutLine(@NotNull DotNetStackFrame $this$customizePresentationWithoutLine, @NotNull ColoredTextContainer component) {
        Intrinsics.checkNotNullParameter((Object)$this$customizePresentationWithoutLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        String methodName = $this$customizePresentationWithoutLine.getFrameProxy().getMethodName();
        String typeName = $this$customizePresentationWithoutLine.getFrameProxy().getTypeName();
        String namespace = $this$customizePresentationWithoutLine.getFrameProxy().getNamespaceName();
        String moduleName = StackFramesUtilsKt.getModuleNameOrEmpty((StackFrameProxy)$this$customizePresentationWithoutLine.getFrameProxy());
        component.append(methodName + "()", DebuggerWorkerModelUtilKt.isCollapsible((StackFrameProxy)$this$customizePresentationWithoutLine.getFrameProxy()) ? SimpleTextAttributes.DARK_TEXT : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        component.append(", " + typeName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        component.append(" (" + namespace + ")@" + moduleName, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        component.setIcon($this$customizePresentationWithoutLine.getFrameProxy().getLineBreakpointId() != null ? AllIcons.Debugger.Db_set_breakpoint : AllIcons.Debugger.Frame);
    }

    @NotNull
    public static final String text(@NotNull XValue $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        XTestValueNode valueNode = XDebuggerTestHelper.computePresentation($this$text, XDebugExtensionsKt::text$lambda$0);
        Intrinsics.checkNotNull((Object)((Object)valueNode));
        return XDebugExtensionsKt.text(valueNode);
    }

    @NotNull
    public static final String text(@NotNull XTestValueNode $this$text) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$text), (String)"<this>");
        String childrenMarker = $this$text.getMyHasChildren() ? "+" : "";
        return childrenMarker + $this$text.getMyValue();
    }

    private static final Boolean text$lambda$0(Semaphore semaphore, Duration timeoutMs) {
        Intrinsics.checkNotNull((Object)semaphore);
        Intrinsics.checkNotNull((Object)timeoutMs);
        return ScriptingAPI_DebugKt.waiter(semaphore, timeoutMs, "XValue.text");
    }
}

