/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.debugger;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.test.debugger.XTestCompositeNode;
import com.jetbrains.rider.test.debugger.XTestContainer;
import com.jetbrains.rider.test.debugger.XTestContainersCompositeNode;
import com.jetbrains.rider.test.debugger.XTestEvaluationCallback;
import com.jetbrains.rider.test.debugger.XTestValueNode;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class XDebuggerTestHelper {
    public static final Duration TIMEOUT = Duration.ofSeconds(25L);

    private XDebuggerTestHelper() {
    }

    @Nullable
    public static Promise<List<? extends XLineBreakpointType.XLineBreakpointVariant>> computeLineBreakpointVariants(Project project2, VirtualFile file, int line) {
        return (Promise)ReadAction.compute(() -> {
            List types = (List)((StreamEx)StreamEx.of((Object[])XDebuggerUtil.getInstance().getLineBreakpointTypes()).filter(type -> type.canPutAt(file, line, project2))).collect(Collectors.toCollection(SmartList::new));
            return XDebuggerUtilImpl.getLineBreakpointVariants((Project)project2, (List)types, (XSourcePosition)XSourcePositionImpl.create((VirtualFile)file, (int)line));
        });
    }

    @Nullable
    public static XLineBreakpoint toggleBreakpoint(Project project2, VirtualFile file, int line) {
        Promise breakpointPromise = (Promise)WriteAction.computeAndWait(() -> ((XDebuggerUtilImpl)XDebuggerUtil.getInstance()).toggleAndReturnLineBreakpoint(project2, file, line, false));
        try {
            try {
                ExtensionsKt.waitAndPump((Lifetime)LifetimeDisposableExKt.createLifetime((Disposable)project2), () -> breakpointPromise.getState() != Promise.State.PENDING, (Duration)TIMEOUT, () -> "Failed to insert breakpoint within " + String.valueOf(TIMEOUT));
                return (XLineBreakpoint)breakpointPromise.blockingGet(0);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static void waitForBreakpointVerified(XLineBreakpoint<? extends XBreakpointProperties<?>> breakpoint, XDebugSessionImpl session) {
        ExtensionsKt.waitAndPump((Duration)Duration.ofSeconds(3L), () -> {
            CustomizedBreakpointPresentation presentation = session.getBreakpointPresentation((XBreakpoint)breakpoint);
            if (presentation == null) {
                return false;
            }
            return XDebuggerUtilImpl.getVerifiedIcon((XBreakpoint)breakpoint) == presentation.getIcon();
        }, () -> "Breakpoint hasn't been verified within timeout");
    }

    public static <P extends XBreakpointProperties> XBreakpoint<P> insertBreakpoint(Project project2, P properties, Class<? extends XBreakpointType<XBreakpoint<P>, P>> typeClass) {
        return (XBreakpoint)WriteAction.computeAndWait(() -> XDebuggerManager.getInstance((Project)project2).getBreakpointManager().addBreakpoint((XBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(typeClass), properties));
    }

    public static void removeBreakpoint(@NotNull Project project2, @NotNull VirtualFile file, int line) {
        if (project2 == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(0);
        }
        if (file == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(1);
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        WriteAction.runAndWait(() -> {
            XLineBreakpoint breakpoint = Arrays.stream(XDebuggerUtil.getInstance().getLineBreakpointTypes()).map(t -> breakpointManager.findBreakpointAtLine(t, file, line)).filter(Objects::nonNull).findFirst().orElse(null);
            assert (breakpoint != null);
            breakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
        });
    }

    public static XExecutionStack getActiveThread(@NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(2);
        }
        return session.getSuspendContext().getActiveExecutionStack();
    }

    public static List<XExecutionStack> collectThreads(@NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(3);
        }
        return (List)XDebuggerTestHelper.collectThreadsWithErrors((XDebugSession)session).first;
    }

    public static Pair<List<XExecutionStack>, String> collectThreadsWithErrors(@NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(4);
        }
        return XDebuggerTestHelper.collectThreadsWithErrors(session, XDebuggerTestHelper::waitFor);
    }

    public static Pair<List<XExecutionStack>, String> collectThreadsWithErrors(@NotNull XDebugSession session, @NotNull BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        if (session == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(5);
        }
        if (waitFunction == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(6);
        }
        XTestExecutionStackContainer container = new XTestExecutionStackContainer();
        session.getSuspendContext().computeExecutionStacks((XSuspendContext.XExecutionStackContainer)container);
        return container.waitFor(TIMEOUT, waitFunction);
    }

    public static List<XStackFrame> collectFrames(@NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(7);
        }
        return XDebuggerTestHelper.collectFrames(null, session);
    }

    public static List<XStackFrame> collectFrames(@Nullable XExecutionStack thread, @NotNull XDebugSession session) {
        if (session == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(8);
        }
        return XDebuggerTestHelper.collectFrames(thread == null ? XDebuggerTestHelper.getActiveThread(session) : thread);
    }

    public static String getFramePresentation(XStackFrame frame) {
        TextTransferable.ColoredStringBuilder builder = new TextTransferable.ColoredStringBuilder();
        frame.customizePresentation((ColoredTextContainer)builder);
        return builder.getBuilder().toString();
    }

    public static List<XStackFrame> collectFrames(@NotNull XExecutionStack thread) {
        if (thread == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(9);
        }
        return XDebuggerTestHelper.collectFrames(thread, TIMEOUT.multipliedBy(2L));
    }

    public static List<XStackFrame> collectFrames(XExecutionStack thread, Duration timeout) {
        return XDebuggerTestHelper.collectFrames(thread, timeout, XDebuggerTestHelper::waitFor);
    }

    public static List<XStackFrame> collectFrames(XExecutionStack thread, Duration timeout, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        return (List)XDebuggerTestHelper.collectFramesWithError((XExecutionStack)thread, (Duration)timeout, waitFunction).first;
    }

    public static Pair<List<XStackFrame>, String> collectFramesWithError(XExecutionStack thread, Duration timeout) {
        return XDebuggerTestHelper.collectFramesWithError(thread, timeout, XDebuggerTestHelper::waitFor);
    }

    public static Pair<List<XStackFrame>, String> collectFramesWithError(XExecutionStack thread, Duration timeout, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        XTestStackFrameContainer container = new XTestStackFrameContainer();
        thread.computeStackFrames(0, (XExecutionStack.XStackFrameContainer)container);
        return container.waitFor(timeout, waitFunction);
    }

    public static Pair<List<XStackFrame>, XStackFrame> collectFramesWithSelected(@NotNull XDebugSession session, Duration timeout) {
        if (session == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(10);
        }
        return XDebuggerTestHelper.collectFramesWithSelected(XDebuggerTestHelper.getActiveThread(session), timeout);
    }

    public static Pair<List<XStackFrame>, XStackFrame> collectFramesWithSelected(XExecutionStack thread, Duration timeout) {
        return XDebuggerTestHelper.collectFramesWithSelected(thread, timeout, XDebuggerTestHelper::waitFor);
    }

    public static Pair<List<XStackFrame>, XStackFrame> collectFramesWithSelected(XExecutionStack thread, Duration timeout, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        XTestStackFrameContainer container = new XTestStackFrameContainer();
        thread.computeStackFrames(0, (XExecutionStack.XStackFrameContainer)container);
        List all = (List)container.waitFor((Duration)timeout, waitFunction).first;
        return Pair.create((Object)all, (Object)container.frameToSelect);
    }

    public static List<XValue> collectChildren(XValueContainer value) {
        return XDebuggerTestHelper.collectChildren(value, XDebuggerTestHelper::waitFor);
    }

    public static List<XValue> collectChildren(XValueContainer value, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        XTestCompositeNode container = new XTestCompositeNode();
        value.computeChildren((XCompositeNode)container);
        return (List)container.waitFor((Duration)XDebuggerTestHelper.TIMEOUT, waitFunction).first;
    }

    public static List<XValueContainer> collectChildrenItems(XValueContainer value) {
        return XDebuggerTestHelper.collectChildrenItems(value, XDebuggerTestHelper::waitFor);
    }

    public static List<XValueContainer> collectChildrenItems(XValueContainer value, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        XTestContainersCompositeNode container = new XTestContainersCompositeNode();
        value.computeChildren((XCompositeNode)container);
        return (List)container.waitFor((Duration)XDebuggerTestHelper.TIMEOUT, waitFunction).first;
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, XExpression expression) {
        return XDebuggerTestHelper.evaluate(session, expression, TIMEOUT);
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, XExpression expression, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        return XDebuggerTestHelper.evaluate(session, expression, TIMEOUT, waitFunction);
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, String expression) {
        return XDebuggerTestHelper.evaluate(session, expression, XDebuggerTestHelper::waitFor);
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, String expression, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        return XDebuggerTestHelper.evaluate(session, (XExpression)XExpressionImpl.fromText((String)expression), TIMEOUT, waitFunction);
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, String expression, Duration timeout) {
        return XDebuggerTestHelper.evaluate(session, expression, timeout, XDebuggerTestHelper::waitFor);
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, String expression, Duration timeout, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        return XDebuggerTestHelper.evaluate(session, (XExpression)XExpressionImpl.fromText((String)expression), timeout, waitFunction);
    }

    private static Pair<XValue, String> evaluate(XDebugSession session, XExpression expression, Duration timeout) {
        return XDebuggerTestHelper.evaluate(session, expression, timeout, XDebuggerTestHelper::waitFor);
    }

    public static Pair<XValue, String> evaluate(XDebugSession session, XExpression expression, Duration timeout, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        XStackFrame frame = session.getCurrentStackFrame();
        assert (frame != null);
        XDebuggerEvaluator evaluator = frame.getEvaluator();
        assert (evaluator != null);
        XTestEvaluationCallback callback = new XTestEvaluationCallback();
        evaluator.evaluate(expression, (XDebuggerEvaluator.XEvaluationCallback)callback, session.getCurrentPosition());
        return callback.waitFor(timeout, waitFunction);
    }

    public static void waitForSwing() throws InterruptedException {
        Semaphore s = new Semaphore();
        s.down();
        ApplicationManager.getApplication().invokeLater(() -> s.up());
        s.waitForUnsafe();
        UIUtil.invokeAndWaitIfNeeded(() -> {});
    }

    @NotNull
    public static XValue findVar(Collection<XValue> vars, String name) {
        StringBuilder names = new StringBuilder();
        for (XValue each : vars) {
            if (!(each instanceof XNamedValue)) continue;
            String eachName = ((XNamedValue)each).getName();
            if (eachName.equals(name)) {
                XValue xValue = each;
                if (xValue == null) {
                    XDebuggerTestHelper.$$$reportNull$$$0(11);
                }
                return xValue;
            }
            if (!names.isEmpty()) {
                names.append(", ");
            }
            names.append(eachName);
        }
        throw new AssertionError((Object)("var '" + name + "' not found among " + String.valueOf(names)));
    }

    public static XTestValueNode computePresentation(@NotNull XValue value) {
        if (value == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(12);
        }
        return XDebuggerTestHelper.computePresentation(value, XDebuggerTestHelper::waitFor);
    }

    public static XTestValueNode computePresentation(@NotNull XValue value, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        if (value == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(13);
        }
        return XDebuggerTestHelper.computePresentation(value, TIMEOUT, waitFunction);
    }

    public static XTestValueNode computePresentation(XValue value, Duration timeout) {
        return XDebuggerTestHelper.computePresentation(value, timeout, XDebuggerTestHelper::waitFor);
    }

    public static XTestValueNode computePresentation(XValue value, Duration timeout, BiFunction<java.util.concurrent.Semaphore, Duration, Boolean> waitFunction) {
        XTestValueNode node = new XTestValueNode();
        if (value instanceof XNamedValue) {
            node.setName(((XNamedValue)value).getName());
        }
        value.computePresentation((XValueNode)node, XValuePlace.TREE);
        node.waitFor(timeout, waitFunction);
        return node;
    }

    public static boolean waitFor(java.util.concurrent.Semaphore semaphore, Duration timeout) {
        long endNs = System.nanoTime() + timeout.toNanos();
        long remainingNs = timeout.toNanos();
        while (true) {
            try {
                return semaphore.tryAcquire(remainingNs, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException ignored) {
                if ((remainingNs = endNs - System.nanoTime()) > 0L) continue;
                return false;
            }
            break;
        }
    }

    @NotNull
    public static String getConsoleText(@NotNull ConsoleViewImpl consoleView) {
        if (consoleView == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(14);
        }
        WriteAction.runAndWait(() -> consoleView.flushDeferredText());
        String string = consoleView.getEditor().getDocument().getText();
        if (string == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static <T extends XBreakpointType, P extends XBreakpointProperties> XBreakpoint<P> addBreakpoint(@NotNull Project project2, @NotNull Class<T> exceptionType, @NotNull P properties) {
        if (project2 == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(16);
        }
        if (exceptionType == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(17);
        }
        if (properties == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(18);
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        Ref breakpoint = Ref.create(null);
        XBreakpointUtil.breakpointTypes().select(exceptionType).findFirst().ifPresent(type -> WriteAction.runAndWait(() -> breakpoint.set((Object)breakpointManager.addBreakpoint(type, properties))));
        return (XBreakpoint)breakpoint.get();
    }

    public static void removeAllBreakpoints(@NotNull Project project2) {
        XBreakpoint<?>[] breakpoints;
        if (project2 == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(19);
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        for (XBreakpoint<?> b : breakpoints = XDebuggerTestHelper.getBreakpoints(breakpointManager)) {
            WriteAction.runAndWait(() -> breakpointManager.removeBreakpoint(b));
        }
    }

    public static XBreakpoint<?>[] getBreakpoints(XBreakpointManager breakpointManager) {
        return (XBreakpoint[])ReadAction.compute(() -> ((XBreakpointManager)breakpointManager).getAllBreakpoints());
    }

    public static <B extends XBreakpoint<?>> void setDefaultBreakpointsEnabled(@NotNull Project project2, Class<? extends XBreakpointType<B, ?>> bpTypeClass, boolean enabled) {
        if (project2 == null) {
            XDebuggerTestHelper.$$$reportNull$$$0(20);
        }
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        XBreakpointType bpType = XDebuggerUtil.getInstance().findBreakpointType(bpTypeClass);
        Set defaultBreakpoints = breakpointManager.getDefaultBreakpoints(bpType);
        for (XBreakpoint defaultBreakpoint : defaultBreakpoints) {
            defaultBreakpoint.setEnabled(enabled);
        }
    }

    public static void setBreakpointCondition(Project project2, int line, String condition) {
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        for (XBreakpoint<?> breakpoint : XDebuggerTestHelper.getBreakpoints(breakpointManager)) {
            XLineBreakpoint lineBreakpoint;
            if (!(breakpoint instanceof XLineBreakpoint) || (lineBreakpoint = (XLineBreakpoint)breakpoint).getLine() != line) continue;
            WriteAction.runAndWait(() -> lineBreakpoint.setCondition(condition));
        }
    }

    public static void setBreakpointLogExpression(Project project2, int line, String logExpression) {
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        for (XBreakpoint<?> breakpoint : XDebuggerTestHelper.getBreakpoints(breakpointManager)) {
            XLineBreakpoint lineBreakpoint;
            if (!(breakpoint instanceof XLineBreakpoint) || (lineBreakpoint = (XLineBreakpoint)breakpoint).getLine() != line) continue;
            WriteAction.runAndWait(() -> {
                lineBreakpoint.setLogExpression(logExpression);
                lineBreakpoint.setLogMessage(true);
            });
        }
    }

    public static void disposeDebugSession(XDebugSession debugSession) {
        WriteAction.runAndWait(() -> {
            XDebugSessionImpl session = (XDebugSessionImpl)debugSession;
            Disposer.dispose((Disposable)session.getSessionTab());
            Disposer.dispose((Disposable)session.getConsoleView());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitFunction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rider/test/debugger/XDebuggerTestHelper";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rider/test/debugger/XDebuggerTestHelper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findVar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActiveThread";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectThreads";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectThreadsWithErrors";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectFrames";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectFramesWithSelected";
                break;
            }
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleText";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeAllBreakpoints";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultBreakpointsEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 15 -> new IllegalStateException(string);
        };
    }

    public static class XTestExecutionStackContainer
    extends XTestContainer<XExecutionStack>
    implements XSuspendContext.XExecutionStackContainer {
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                XTestExecutionStackContainer.$$$reportNull$$$0(0);
            }
            this.setErrorMessage(errorMessage);
        }

        public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
            if (executionStacks == null) {
                XTestExecutionStackContainer.$$$reportNull$$$0(1);
            }
            this.addChildren(executionStacks, last);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionStacks";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/rider/test/debugger/XDebuggerTestHelper$XTestExecutionStackContainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addExecutionStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class XTestStackFrameContainer
    extends XTestContainer<XStackFrame>
    implements XStackFrameContainerEx {
        public volatile XStackFrame frameToSelect;

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
            if (stackFrames == null) {
                XTestStackFrameContainer.$$$reportNull$$$0(0);
            }
            this.addChildren(stackFrames, last);
        }

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect, boolean last) {
            if (stackFrames == null) {
                XTestStackFrameContainer.$$$reportNull$$$0(1);
            }
            if (toSelect != null) {
                this.frameToSelect = toSelect;
            }
            this.addChildren(stackFrames, last);
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                XTestStackFrameContainer.$$$reportNull$$$0(2);
            }
            this.setErrorMessage(errorMessage);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stackFrames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/rider/test/debugger/XDebuggerTestHelper$XTestStackFrameContainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStackFrames";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

