/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.facades.execution;

import com.intellij.platform.ijent.testFramework.common.EelEnvironmentParams;
import com.intellij.platform.ijent.testFramework.common.EelTestEnvironment;
import com.intellij.platform.ijent.testFramework.common.EelTestEnvironmentHolder;
import com.intellij.platform.ijent.testFramework.functional.fixture.EelFixture;
import com.intellij.platform.ijent.testFramework.functional.fixture.IjentFixturesKt;
import com.intellij.platform.ijent.testFramework.functional.fixture.IjentWslFixture;
import com.jetbrains.rider.test.executionTargets.ExecutionTargetInstance;
import com.jetbrains.rider.test.executionTargets.LocalExecutionTargetInstance;
import com.jetbrains.rider.test.executionTargets.WslExecutionTargetInstance;
import com.jetbrains.rider.test.facades.environment.ExecutionTargetFacade;
import com.jetbrains.rider.test.facades.environment.ExecutionTargetInitializationResult;
import com.jetbrains.rider.test.facades.environment.RiderTestExecutionTarget;
import com.jetbrains.rider.test.facades.execution.FixtureFactoryCreationResult;
import com.jetbrains.rider.test.facades.execution.RiderThroughEelTestExecutionTarget;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/test/facades/execution/EelExecutionTargetFacade;", "Lcom/jetbrains/rider/test/facades/environment/ExecutionTargetFacade;", "<init>", "()V", "currentExecutionTarget", "Lcom/jetbrains/rider/test/facades/environment/RiderTestExecutionTarget;", "value", "", "isExecutionTargetReady", "()Z", "executionTarget", "getExecutionTarget", "()Lcom/jetbrains/rider/test/facades/environment/RiderTestExecutionTarget;", "initializeExecutionTarget", "Lcom/jetbrains/rider/test/facades/environment/ExecutionTargetInitializationResult;", "executionTargetInstance", "Lcom/jetbrains/rider/test/executionTargets/ExecutionTargetInstance;", "createFixtureFactory", "Lcom/jetbrains/rider/test/facades/execution/FixtureFactoryCreationResult;", "shutdownExecutionTargets", "", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nEelExecutionTargetFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelExecutionTargetFacade.kt\ncom/jetbrains/rider/test/facades/execution/EelExecutionTargetFacade\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,57:1\n184#2,2:58\n*S KotlinDebug\n*F\n+ 1 EelExecutionTargetFacade.kt\ncom/jetbrains/rider/test/facades/execution/EelExecutionTargetFacade\n*L\n47#1:58,2\n*E\n"})
public final class EelExecutionTargetFacade
implements ExecutionTargetFacade {
    @Nullable
    private RiderTestExecutionTarget currentExecutionTarget;
    private boolean isExecutionTargetReady;

    public boolean isExecutionTargetReady() {
        return this.currentExecutionTarget != null;
    }

    @NotNull
    public RiderTestExecutionTarget getExecutionTarget() {
        RiderTestExecutionTarget riderTestExecutionTarget = this.currentExecutionTarget;
        if (riderTestExecutionTarget == null) {
            throw new IllegalStateException("Test environment is not ready at this moment".toString());
        }
        return riderTestExecutionTarget;
    }

    @NotNull
    public ExecutionTargetInitializationResult initializeExecutionTarget(@NotNull ExecutionTargetInstance executionTargetInstance) {
        ExecutionTargetInitializationResult executionTargetInitializationResult;
        FixtureFactoryCreationResult creationResult;
        Intrinsics.checkNotNullParameter((Object)executionTargetInstance, (String)"executionTargetInstance");
        FixtureFactoryCreationResult fixtureFactoryCreationResult = creationResult = this.createFixtureFactory(executionTargetInstance);
        if (fixtureFactoryCreationResult instanceof FixtureFactoryCreationResult.Initialized) {
            EelTestEnvironment eelEnv = EelTestEnvironmentHolder.INSTANCE.get("/", ((FixtureFactoryCreationResult.Initialized)creationResult).getFactory(), EelEnvironmentParams.copy$default((EelEnvironmentParams)EelEnvironmentParams.Companion.getDefault(), (boolean)true, (boolean)false, (boolean)false, (int)6, null));
            this.currentExecutionTarget = new RiderThroughEelTestExecutionTarget((EelTestEnvironment<EelFixture>)eelEnv);
            executionTargetInitializationResult = (ExecutionTargetInitializationResult)ExecutionTargetInitializationResult.Initialized.INSTANCE;
        } else if (fixtureFactoryCreationResult instanceof FixtureFactoryCreationResult.NotApplicable) {
            executionTargetInitializationResult = (ExecutionTargetInitializationResult)new ExecutionTargetInitializationResult.NotAvailable(executionTargetInstance.getTarget().name() + " is not available on this machine, reason: " + ((FixtureFactoryCreationResult.NotApplicable)creationResult).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return executionTargetInitializationResult;
    }

    private final FixtureFactoryCreationResult createFixtureFactory(ExecutionTargetInstance executionTargetInstance) {
        ExecutionTargetInstance executionTargetInstance2 = executionTargetInstance;
        if (!(executionTargetInstance2 instanceof LocalExecutionTargetInstance)) {
            if (executionTargetInstance2 instanceof WslExecutionTargetInstance) {
                Object v1;
                block3: {
                    Sequence $this$firstOrNull$iv = IjentFixturesKt.getIjentWslSaneFixtures();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        IjentWslFixture.Factory it = (IjentWslFixture.Factory)element$iv;
                        boolean bl = false;
                        String string = it.getWsl().getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        if (!StringsKt.startsWith((String)string, (String)"Ubuntu", (boolean)true)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                IjentWslFixture.Factory factory = v1;
                return factory != null ? (FixtureFactoryCreationResult)new FixtureFactoryCreationResult.Initialized((EelFixture.Factory<? extends EelFixture>)((EelFixture.Factory)factory)) : (FixtureFactoryCreationResult)new FixtureFactoryCreationResult.NotApplicable("Could not find any suitable WSL (Ubuntu) installation");
            }
            throw new NoWhenBranchMatchedException();
        }
        return new FixtureFactoryCreationResult.Initialized((EelFixture.Factory<? extends EelFixture>)((EelFixture.Factory)SequencesKt.single((Sequence)IjentFixturesKt.getEelLocalFixtures())));
    }

    public void shutdownExecutionTargets() {
        EelTestEnvironmentHolder.INSTANCE.shutdown();
    }
}

