/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.facades.solution;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.projectTemplates.utils.ProjectTemplatesExpanderUtils;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.test.OpenSolutionParams;
import com.jetbrains.rider.test.asserts.ShouldAssertsKt;
import com.jetbrains.rider.test.facades.solution.RiderSolutionApiFacade;
import com.jetbrains.rider.test.framework.ProjectModelExtensionsKt;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestFrameworkKt;
import com.jetbrains.rider.test.protocol.TestProtocolExtensionsKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_BaseKt;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_ProjectModelKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J(\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/test/facades/solution/RiderSolutionWithFoldersApiFacade;", "Lcom/jetbrains/rider/test/facades/solution/RiderSolutionApiFacade;", "mainSolutionName", "", "checkSolutionLoad", "", "<init>", "(Ljava/lang/String;Z)V", "existingSolutions", "", "activeSolution", "getActiveSolution", "()Ljava/lang/String;", "setActiveSolution", "(Ljava/lang/String;)V", "activeSolutionDirectory", "Ljava/io/File;", "getActiveSolutionDirectory", "()Ljava/io/File;", "prepareAndOpenSolution", "Lcom/intellij/openapi/project/Project;", "solutionName", "params", "Lcom/jetbrains/rider/test/OpenSolutionParams;", "targetDirectory", "sourceDirectory", "prepareSolution", "generateEmptySolutionFile", "name", "path", "prepareDotSettingsFile", "", "dotSettingsFile", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nRiderSolutionWithFoldersApiFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderSolutionWithFoldersApiFacade.kt\ncom/jetbrains/rider/test/facades/solution/RiderSolutionWithFoldersApiFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1915#2,2:117\n1#3:119\n*S KotlinDebug\n*F\n+ 1 RiderSolutionWithFoldersApiFacade.kt\ncom/jetbrains/rider/test/facades/solution/RiderSolutionWithFoldersApiFacade\n*L\n79#1:117,2\n*E\n"})
public class RiderSolutionWithFoldersApiFacade
extends RiderSolutionApiFacade {
    @NotNull
    private final String mainSolutionName;
    private final boolean checkSolutionLoad;
    @NotNull
    private final List<String> existingSolutions;
    @NotNull
    private String activeSolution;

    public RiderSolutionWithFoldersApiFacade(@NotNull String mainSolutionName, boolean checkSolutionLoad) {
        Intrinsics.checkNotNullParameter((Object)mainSolutionName, (String)"mainSolutionName");
        this.mainSolutionName = mainSolutionName;
        this.checkSolutionLoad = checkSolutionLoad;
        this.existingSolutions = new ArrayList();
        this.activeSolution = "";
    }

    @NotNull
    public String getActiveSolution() {
        return this.activeSolution;
    }

    public void setActiveSolution(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.activeSolution = string;
    }

    @NotNull
    public File getActiveSolutionDirectory() {
        return FilesKt.resolve((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)this.getProject()), (String)this.getActiveSolution());
    }

    @NotNull
    public Project prepareAndOpenSolution(@NotNull String solutionName, @NotNull OpenSolutionParams params, @NotNull File targetDirectory, @NotNull File sourceDirectory) {
        Intrinsics.checkNotNullParameter((Object)solutionName, (String)"solutionName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        if (!this.getHasProject()) {
            File solutionFile2 = this.generateEmptySolutionFile(this.mainSolutionName + ".sln", targetDirectory);
            this.openSolution(solutionFile2, params);
            ScriptingAPI_ProjectModelKt.prepareProjectView(this.getProject());
        }
        this.prepareSolution(solutionName, params, targetDirectory, sourceDirectory);
        return this.getProject();
    }

    @NotNull
    public File prepareSolution(@NotNull String solutionName, @NotNull OpenSolutionParams params, @NotNull File targetDirectory, @NotNull File sourceDirectory) {
        Intrinsics.checkNotNullParameter((Object)solutionName, (String)"solutionName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        String string = new File(solutionName).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String solutionShortName = string;
        if (Intrinsics.areEqual((Object)solutionShortName, (Object)this.getActiveSolution())) {
            return SolutionHostExtensionsKt.getSolutionFile((Project)this.getProject());
        }
        this.setActiveSolution(solutionShortName);
        if (this.existingSolutions.contains(solutionShortName)) {
            ScriptingAPI_ProjectModelKt.unloadAllProjects(this.getProject());
            Project project2 = this.getProject();
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue((Object)this.getProject().getName(), (String)"getName(...)");
            stringArray[1] = solutionShortName;
            ScriptingAPI_ProjectModelKt.reloadProject(project2, stringArray);
            TestFrameworkBaseKt.getFrameworkLogger().info("Active solution: '" + this.getActiveSolution() + "'");
        } else {
            Function1 preprocessTempDirectory = params.getPreprocessTempDirectory();
            params.setPreprocessTempDirectory(arg_0 -> RiderSolutionWithFoldersApiFacade.prepareSolution$lambda$0(preprocessTempDirectory, arg_0));
            super.prepareSolution(solutionName, params, targetDirectory, sourceDirectory);
            String[] stringArray = "\\w+\\.(cs|vb|fs|vcx|njs|sh|vc)proj";
            int n = 0;
            Pattern pattern = Pattern.compile((String)stringArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            List list = FileUtil.findFilesByMask((Pattern)pattern, (File)this.getActiveSolutionDirectory());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findFilesByMask(...)");
            List projFiles = list;
            String string2 = "\\w+\\.sln\\.DotSettings";
            int n2 = 0;
            Pattern pattern2 = Pattern.compile(string2, n2);
            Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
            List list2 = FileUtil.findFilesByMask((Pattern)pattern2, (File)this.getActiveSolutionDirectory());
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"findFilesByMask(...)");
            File dotSettingsFile = (File)CollectionsKt.firstOrNull((List)list2);
            this.prepareDotSettingsFile(dotSettingsFile);
            if (!((Collection)ProjectModelExtensionsKt.getLoadedProjects((Project)this.getProject())).isEmpty()) {
                ScriptingAPI_ProjectModelKt.unloadAllProjects(this.getProject());
            }
            stringArray = new String[]{SolutionHostExtensionsKt.getSolutionName((Project)this.getProject())};
            ScriptingAPI_ProjectModelKt.addSolutionFolder(this.getProject(), stringArray, solutionShortName);
            Iterable $this$forEach$iv = projFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                Project project3 = this.getProject();
                String[] stringArray2 = new String[2];
                Intrinsics.checkNotNullExpressionValue((Object)this.getProject().getName(), (String)"getName(...)");
                stringArray2[1] = solutionShortName;
                String string3 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                ScriptingAPI_ProjectModelKt.addExistingProject(project3, stringArray2, string3);
            }
            this.existingSolutions.add(solutionShortName);
        }
        TestFrameworkKt.waitForFullStartup$default(this.getProject(), false, null, 6, null);
        if (this.checkSolutionLoad) {
            this.assertAllProjectsWereLoaded();
        }
        TestFrameworkBaseKt.getFrameworkLogger().info("Complete setting up a solution");
        return SolutionHostExtensionsKt.getSolutionFile((Project)this.getProject());
    }

    private final File generateEmptySolutionFile(String name, File path) {
        TestFrameworkBaseKt.getFrameworkLogger().info("Generating an empty solution with name: '" + name + "' and path: '" + path + "'");
        if (path.exists()) {
            TestFrameworkBaseKt.getFrameworkLogger().warn("Path already exists: '" + path + "'. Delete existing path before proceeding");
            FilesKt.deleteRecursively((File)path);
        }
        java.time.Duration duration = java.time.Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        java.time.Duration duration2 = duration;
        VirtualFile virtualFile2 = (VirtualFile)ScriptingAPI_BaseKt.runBlockingWithFlushing-8Mi8wO0((String)"", (long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFile>, Object>(name, path, null){
            int label;
            final /* synthetic */ String $name;
            final /* synthetic */ File $path;
            {
                this.$name = $name;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ProjectTemplatesExpanderUtils.INSTANCE.expandSolution(this.$name, this.$path, CollectionsKt.emptyList(), CollectionsKt.emptyList(), (IProtocolHost)TestProtocolExtensionsKt.getTestProtocolHost((Application)ApplicationKt.getApplication()), (Continuation)this);
                        if (object2 != object) return ShouldAssertsKt.shouldNotBeNull((Object)object2, (String)"Create solution failed");
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return ShouldAssertsKt.shouldNotBeNull((Object)object2, (String)"Create solution failed");
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super VirtualFile> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        File file = VfsUtil.virtualToIoFile((VirtualFile)virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        return file;
    }

    private final void prepareDotSettingsFile(File dotSettingsFile) {
        if (!this.getHasProject() || dotSettingsFile == null) {
            return;
        }
        FileUtilRt.copy((File)dotSettingsFile, (File)new File(SolutionHostExtensionsKt.getSolutionFile((Project)this.getProject()).getPath() + ".DotSettings"));
    }

    private static final Unit prepareSolution$lambda$0(Function1 $preprocessTempDirectory, File workDir) {
        block3: {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
                Sequence sequence = (Sequence)FilesKt.walk$default((File)workDir, null, (int)1, null);
                for (Object e : sequence) {
                    File it = (File)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"sln")) continue;
                    v0 = e;
                    break block2;
                }
                v0 = null;
            }
            File file = v0;
            if (file != null) {
                file.delete();
            }
            Function1 function1 = $preprocessTempDirectory;
            if (function1 == null) break block3;
            function1.invoke((Object)workDir);
        }
        return Unit.INSTANCE;
    }
}

