/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.jetbrains.rider.debugger.DotNetNamedValue;
import com.jetbrains.rider.debugger.IDotNetValue;
import com.jetbrains.rider.test.debugger.XDebuggerTestHelper;
import com.jetbrains.rider.test.debugger.XTestValueNode;
import com.jetbrains.rider.test.scriptingApi.DebugTestExecutionContext;
import com.jetbrains.rider.test.scriptingApi.PresentationWithText;
import com.jetbrains.rider.test.scriptingApi.ScriptingAPI_DebugKt;
import com.jetbrains.rider.test.scriptingApi.XDebugExtensionsKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u000b*\u00020\u0010\u001a\n\u0010\u000f\u001a\u00020\u0011*\u00020\u000e\u001a\n\u0010\u0012\u001a\u00020\u000b*\u00020\u000e\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0018"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getLocals", "", "Lcom/intellij/xdebugger/frame/XValueContainer;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "getNamedValue", "Lcom/jetbrains/rider/debugger/DotNetNamedValue;", "name", "", "getPresentationWithText", "Lcom/jetbrains/rider/test/scriptingApi/PresentationWithText;", "Lcom/intellij/xdebugger/frame/XValue;", "getPresentation", "Lcom/intellij/xdebugger/frame/XValueGroup;", "Lcom/jetbrains/rider/test/debugger/XTestValueNode;", "getPresentationText", "showLibraryFrames", "", "Lcom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContext;", "show", "", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nDebugTestExecutionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTestExecutionContext.kt\ncom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,351:1\n812#2,12:352\n672#2,11:364\n13#3:375\n13#4:376\n*S KotlinDebug\n*F\n+ 1 DebugTestExecutionContext.kt\ncom/jetbrains/rider/test/scriptingApi/DebugTestExecutionContextKt\n*L\n324#1:352,12\n324#1:364,11\n43#1:375\n43#1:376\n*E\n"})
public final class DebugTestExecutionContextKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final Logger getLogger() {
        return logger;
    }

    @NotNull
    public static final List<XValueContainer> getLocals(@NotNull XStackFrame $this$getLocals) {
        Intrinsics.checkNotNullParameter((Object)$this$getLocals, (String)"<this>");
        List<XValueContainer> list = XDebuggerTestHelper.collectChildrenItems((XValueContainer)$this$getLocals, DebugTestExecutionContextKt::getLocals$lambda$0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"collectChildrenItems(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DotNetNamedValue getNamedValue(@NotNull XStackFrame $this$getNamedValue, @NotNull String name) {
        Object v0;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getNamedValue, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$filterIsInstance$iv = DebugTestExecutionContextKt.getLocals($this$getNamedValue);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DotNetNamedValue)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                DotNetNamedValue it = (DotNetNamedValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        DotNetNamedValue dotNetNamedValue = v0;
        if (dotNetNamedValue == null) {
            AssertionsKt.fail((String)("Not found local with name: " + name));
            throw new KotlinNothingValueException();
        }
        return dotNetNamedValue;
    }

    @NotNull
    public static final PresentationWithText getPresentationWithText(@NotNull XValue $this$getPresentationWithText) {
        Intrinsics.checkNotNullParameter((Object)$this$getPresentationWithText, (String)"<this>");
        XTestValueNode presentation = XDebuggerTestHelper.computePresentation($this$getPresentationWithText, DebugTestExecutionContextKt::getPresentationWithText$lambda$0);
        Intrinsics.checkNotNull((Object)((Object)presentation));
        String text = ((Object)StringsKt.trimEnd((CharSequence)XDebugExtensionsKt.text(presentation))).toString();
        if ($this$getPresentationWithText instanceof IDotNetValue && DebugTestExecutionContext.Companion.getVariablesWithTruncatedOutputList().contains(((IDotNetValue)$this$getPresentationWithText).getObjectProxy().getName())) {
            Object[] objectArray = new String[]{"\n"};
            String string = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)text, (String[])objectArray, (boolean)false, (int)0, (int)6, null));
            objectArray = new char[1];
            objectArray[0] = (String)13;
            text = StringsKt.trimEnd((String)string, (char[])objectArray);
        }
        return new PresentationWithText(presentation, text);
    }

    @NotNull
    public static final String getPresentation(@NotNull XValueGroup $this$getPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$getPresentation, (String)"<this>");
        if ($this$getPresentation.getComment() != null) {
            return "+[" + $this$getPresentation.getName() + "] = " + $this$getPresentation.getComment();
        }
        return "+[" + $this$getPresentation.getName() + "]";
    }

    @NotNull
    public static final XTestValueNode getPresentation(@NotNull XValue $this$getPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$getPresentation, (String)"<this>");
        return DebugTestExecutionContextKt.getPresentationWithText($this$getPresentation).getPresentation();
    }

    @NotNull
    public static final String getPresentationText(@NotNull XValue $this$getPresentationText) {
        Intrinsics.checkNotNullParameter((Object)$this$getPresentationText, (String)"<this>");
        return DebugTestExecutionContextKt.getPresentationWithText($this$getPresentationText).getText();
    }

    public static final void showLibraryFrames(@NotNull DebugTestExecutionContext $this$showLibraryFrames, boolean show) {
        Intrinsics.checkNotNullParameter((Object)$this$showLibraryFrames, (String)"<this>");
        XDebuggerSettingManagerImpl.getInstanceImpl().getDataViewSettings().setShowLibraryStackFrames(show);
    }

    private static final Boolean getLocals$lambda$0(Semaphore semaphore, Duration timeout) {
        Intrinsics.checkNotNull((Object)semaphore);
        Intrinsics.checkNotNull((Object)timeout);
        return ScriptingAPI_DebugKt.waiter(semaphore, timeout, "getLocals");
    }

    private static final Boolean getPresentationWithText$lambda$0(Semaphore semaphore, Duration timeout) {
        Intrinsics.checkNotNull((Object)semaphore);
        Intrinsics.checkNotNull((Object)timeout);
        return ScriptingAPI_DebugKt.waiter(semaphore, timeout, "getPresentationWithText");
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DebugTestExecutionContext.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DebugTestExecutionContextKt.logger = logger;
    }
}

