/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.scriptingApi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.pencils.RiderPencilsManager;
import com.jetbrains.rider.pencils.RiderSeverityFilters;
import com.jetbrains.rider.pencils.SeverityFilter;
import com.jetbrains.rider.pencils.filters.PencilsFilter;
import com.jetbrains.rider.pencils.settings.PencilsSettingsStorage;
import java.time.Duration;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a(\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"waitForErrorSeverityLevel", "", "project", "Lcom/intellij/openapi/project/Project;", "timeout", "Ljava/time/Duration;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "waitForSeverityLevel", "filter", "Lcom/jetbrains/rider/pencils/SeverityFilter;", "waitForModelInitialization", "waitForSettingsReset", "intellij.rider.test.framework"})
public final class ScriptingAPI_PencilsKt {
    public static final void waitForErrorSeverityLevel(@NotNull Project project2, @NotNull Duration timeout, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        ScriptingAPI_PencilsKt.waitForSeverityLevel(project2, RiderSeverityFilters.Companion.getERRORS(), timeout, logger);
    }

    public static /* synthetic */ void waitForErrorSeverityLevel$default(Project project2, Duration duration, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        ScriptingAPI_PencilsKt.waitForErrorSeverityLevel(project2, duration, logger);
    }

    public static final void waitForSeverityLevel(@NotNull Project project2, @NotNull SeverityFilter filter, @NotNull Duration timeout, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (!RiderPencilsManager.Companion.isEnabled()) {
            return;
        }
        logger.info("waiting for severity level: " + filter.getDisplayName());
        PencilsSettingsStorage service = (PencilsSettingsStorage)project2.getService(PencilsSettingsStorage.class);
        service.changeSeverity(filter);
        ExtensionsKt.pumpMessages((Duration)timeout, () -> ScriptingAPI_PencilsKt.waitForSeverityLevel$lambda$0(service, filter));
        logger.info("finish for severity level: " + filter.getDisplayName());
    }

    public static /* synthetic */ void waitForSeverityLevel$default(Project project2, SeverityFilter severityFilter, Duration duration, Logger logger, int n, Object object) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        ScriptingAPI_PencilsKt.waitForSeverityLevel(project2, severityFilter, duration, logger);
    }

    public static final void waitForModelInitialization(@NotNull Project project2, @NotNull Duration timeout, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (!RiderPencilsManager.Companion.isEnabled()) {
            return;
        }
        logger.info("waiting for model initialization");
        RiderPencilsManager service = (RiderPencilsManager)project2.getService(RiderPencilsManager.class);
        ExtensionsKt.pumpMessages((Duration)timeout, () -> ScriptingAPI_PencilsKt.waitForModelInitialization$lambda$0(service));
        logger.info("finish for model initialization");
    }

    public static /* synthetic */ void waitForModelInitialization$default(Project project2, Duration duration, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        ScriptingAPI_PencilsKt.waitForModelInitialization(project2, duration, logger);
    }

    public static final void waitForSettingsReset(@NotNull Project project2, @NotNull Duration timeout, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (!RiderPencilsManager.Companion.isEnabled()) {
            return;
        }
        logger.info("start resetting settings");
        PencilsSettingsStorage service = (PencilsSettingsStorage)project2.getService(PencilsSettingsStorage.class);
        RiderPencilsManager manager = (RiderPencilsManager)project2.getService(RiderPencilsManager.class);
        Collection filters = manager.getFilters();
        service.changeSeverity(RiderSeverityFilters.Companion.getALL());
        for (PencilsFilter filter : filters) {
            service.changeState(filter, filter.getEnabledDefault());
        }
        logger.info("finish resetting settings");
        logger.info("start waiting changes");
        ExtensionsKt.pumpMessages((Duration)timeout, () -> ScriptingAPI_PencilsKt.waitForSettingsReset$lambda$0(service));
        for (PencilsFilter filter : filters) {
            ExtensionsKt.pumpMessages((Duration)timeout, () -> ScriptingAPI_PencilsKt.waitForSettingsReset$lambda$1(service, filter));
        }
        logger.info("finish waiting changes");
    }

    public static /* synthetic */ void waitForSettingsReset$default(Project project2, Duration duration, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        ScriptingAPI_PencilsKt.waitForSettingsReset(project2, duration, logger);
    }

    private static final boolean waitForSeverityLevel$lambda$0(PencilsSettingsStorage $service, SeverityFilter $filter) {
        return Intrinsics.areEqual((Object)$service.getActualSeverityFilter().getValue(), (Object)$filter);
    }

    private static final boolean waitForModelInitialization$lambda$0(RiderPencilsManager $service) {
        return (Boolean)$service.isInitialized().getValue();
    }

    private static final boolean waitForSettingsReset$lambda$0(PencilsSettingsStorage $service) {
        return Intrinsics.areEqual((Object)((SeverityFilter)$service.getActualSeverityFilter().getValue()).getSeverity(), (Object)RiderSeverityFilters.Companion.getALL().getSeverity());
    }

    private static final boolean waitForSettingsReset$lambda$1(PencilsSettingsStorage $service, PencilsFilter $filter) {
        return Intrinsics.areEqual((Object)$service.getConfiguration().getFiltersEnabled().get((Object)$filter.getId()), (Object)$filter.getEnabledDefault());
    }
}

