/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import com.jetbrains.rider.test.debugger.XDebuggerTestHelper;
import java.time.Duration;
import java.util.concurrent.Semaphore;
import java.util.function.BiFunction;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 52\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0011H\u0016J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0017H\u0016J6\u0010-\u001a\u00020#2\b\u0010.\u001a\u0004\u0018\u00010/2\"\b\u0002\u00100\u001a\u001c\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001d\u0012\b\b\u0000\u0012\u0004\u0018\u00010/\u0012\u0004\u0012\u00020\u001101H\u0007J\b\u00102\u001a\u00020\u0007H\u0016J\u000e\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00066"}, d2={"Lcom/jetbrains/rider/test/debugger/XTestValueNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator$ConfigurableXValueNodeImpl;", "<init>", "()V", "myIcon", "Ljavax/swing/Icon;", "myType", "", "myName", "getMyName", "()Ljava/lang/String;", "setMyName", "(Ljava/lang/String;)V", "myValue", "getMyValue", "setMyValue", "myHasChildren", "", "getMyHasChildren", "()Z", "setMyHasChildren", "(Z)V", "myFullValueEvaluator", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "getMyFullValueEvaluator", "()Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "setMyFullValueEvaluator", "(Lcom/intellij/xdebugger/frame/XFullValueEvaluator;)V", "myFinished", "Ljava/util/concurrent/Semaphore;", "presentationApplied", "Lkotlinx/coroutines/CompletableDeferred;", "getPresentationApplied", "()Lkotlinx/coroutines/CompletableDeferred;", "applyPresentation", "", "icon", "valuePresentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "hasChildren", "appendName", "text", "Lcom/intellij/ui/ColoredTextContainer;", "setFullValueEvaluator", "fullValueEvaluator", "waitFor", "timeout", "Ljava/time/Duration;", "waitFunction", "Ljava/util/function/BiFunction;", "toString", "setName", "name", "Companion", "intellij.rider.test.framework"})
public final class XTestValueNode
extends XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Icon myIcon;
    @Nullable
    private String myType;
    @Nullable
    private String myName;
    @Nullable
    private String myValue;
    private boolean myHasChildren;
    @Nullable
    private XFullValueEvaluator myFullValueEvaluator;
    @NotNull
    private final Semaphore myFinished = new Semaphore(0);
    @NotNull
    private final CompletableDeferred<XTestValueNode> presentationApplied = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    private static final int MAX_NAME_LENGTH = 100;

    @Nullable
    public final String getMyName() {
        return this.myName;
    }

    public final void setMyName(@Nullable String string) {
        this.myName = string;
    }

    @Nullable
    public final String getMyValue() {
        return this.myValue;
    }

    public final void setMyValue(@Nullable String string) {
        this.myValue = string;
    }

    public final boolean getMyHasChildren() {
        return this.myHasChildren;
    }

    public final void setMyHasChildren(boolean bl) {
        this.myHasChildren = bl;
    }

    @Nullable
    public final XFullValueEvaluator getMyFullValueEvaluator() {
        return this.myFullValueEvaluator;
    }

    public final void setMyFullValueEvaluator(@Nullable XFullValueEvaluator xFullValueEvaluator) {
        this.myFullValueEvaluator = xFullValueEvaluator;
    }

    @NotNull
    public final CompletableDeferred<XTestValueNode> getPresentationApplied() {
        return this.presentationApplied;
    }

    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresentation, boolean hasChildren) {
        Intrinsics.checkNotNullParameter((Object)valuePresentation, (String)"valuePresentation");
        this.myIcon = icon;
        this.myType = valuePresentation.getType();
        ColoredTextContainer text = (ColoredTextContainer)new SimpleColoredText();
        if (valuePresentation.isShowName()) {
            this.appendName(text);
        }
        XValueNodeImpl.buildText((XValuePresentation)valuePresentation, (ColoredTextContainer)text, (!StringUtil.isEmpty((String)this.myName) ? 1 : 0) != 0);
        this.myValue = text.toString();
        this.myHasChildren = hasChildren;
        this.myFinished.release();
        this.presentationApplied.complete((Object)this);
    }

    private final void appendName(ColoredTextContainer text) {
        if (!StringUtil.isEmpty((String)this.myName)) {
            SimpleTextAttributes attributes = XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES;
            String string = this.myName;
            Intrinsics.checkNotNull((Object)string);
            XValuePresentationUtil.renderValue((String)string, (ColoredTextContainer)text, (SimpleTextAttributes)attributes, (int)100, null);
        }
    }

    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
        Intrinsics.checkNotNullParameter((Object)fullValueEvaluator, (String)"fullValueEvaluator");
        this.myFullValueEvaluator = fullValueEvaluator;
    }

    @JvmOverloads
    public final void waitFor(@Nullable Duration timeout, @NotNull BiFunction<? super Semaphore, ? super Duration, Boolean> waitFunction) {
        Intrinsics.checkNotNullParameter(waitFunction, (String)"waitFunction");
        if (!waitFunction.apply(this.myFinished, timeout).booleanValue()) {
            throw new AssertionError((Object)"Waiting timed out");
        }
    }

    public static /* synthetic */ void waitFor$default(XTestValueNode xTestValueNode, Duration duration, BiFunction biFunction, int n, Object object) {
        if ((n & 2) != 0) {
            biFunction = XTestValueNode::waitFor$lambda$0;
        }
        xTestValueNode.waitFor(duration, biFunction);
    }

    @NotNull
    public String toString() {
        return this.myName + "{" + this.myType + "} = " + this.myValue + ", hasChildren = " + this.myHasChildren;
    }

    public final void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.myName = name;
    }

    @JvmOverloads
    public final void waitFor(@Nullable Duration timeout) {
        XTestValueNode.waitFor$default(this, timeout, null, 2, null);
    }

    private static final Boolean waitFor$lambda$0(Semaphore semaphore, Duration timeout) {
        return XDebuggerTestHelper.waitFor(semaphore, timeout);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/test/debugger/XTestValueNode$Companion;", "", "<init>", "()V", "MAX_NAME_LENGTH", "", "intellij.rider.test.framework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

