/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.test.framework.profiling;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.jetbrains.rider.model.SnapshotKind;
import com.jetbrains.rider.test.TestDirectories;
import com.jetbrains.rider.test.framework.TestFrameworkBaseKt;
import com.jetbrains.rider.test.framework.TestFrameworkSettings;
import com.jetbrains.rider.test.framework.processor.TestProcessor;
import com.jetbrains.rider.test.profiling.AsyncProfilerUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/test/framework/profiling/RiderProfilingManager;", "", "testProcessor", "Lcom/jetbrains/rider/test/framework/processor/TestProcessor;", "<init>", "(Lcom/jetbrains/rider/test/framework/processor/TestProcessor;)V", "getTestProcessor", "()Lcom/jetbrains/rider/test/framework/processor/TestProcessor;", "startFrontendProfiling", "", "stopFrontendProfiling", "setupBackendProfiling", "intellij.rider.test.framework"})
@SourceDebugExtension(value={"SMAP\nRiderProfilingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderProfilingManager.kt\ncom/jetbrains/rider/test/framework/profiling/RiderProfilingManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n1#2:61\n1400#3,2:62\n*S KotlinDebug\n*F\n+ 1 RiderProfilingManager.kt\ncom/jetbrains/rider/test/framework/profiling/RiderProfilingManager\n*L\n57#1:62,2\n*E\n"})
public final class RiderProfilingManager {
    @NotNull
    private final TestProcessor<?> testProcessor;

    public RiderProfilingManager(@NotNull TestProcessor<?> testProcessor) {
        Intrinsics.checkNotNullParameter(testProcessor, (String)"testProcessor");
        this.testProcessor = testProcessor;
    }

    @NotNull
    public final TestProcessor<?> getTestProcessor() {
        return this.testProcessor;
    }

    public final void startFrontendProfiling() {
        File file;
        File $this$startFrontendProfiling_u24lambda_u240 = file = TestDirectories.INSTANCE.getSnapshotsDirectory();
        boolean bl = false;
        Files.createDirectories($this$startFrontendProfiling_u24lambda_u240.toPath(), new FileAttribute[0]);
        File snapshotsDir = file;
        File snapshotFile = AsyncProfilerUtil.INSTANCE.getSnapshotFileName(snapshotsDir, this.testProcessor.getTestClass().getName());
        AsyncProfiler asyncProfiler = AsyncProfilerExtractor.INSTANCE.getAsyncProfilerInstance();
        if (asyncProfiler == null) {
            TestFrameworkBaseKt.getFrameworkLogger().warn("AsyncProfiler is not available, no snapshots will be dumped");
        } else {
            String string;
            TestFrameworkBaseKt.getFrameworkLogger().info("Test profile will be dumped to " + snapshotFile.getCanonicalPath());
            String it = string = TestFrameworkSettings.Profiling.INSTANCE.getAsyncProfilingOptions();
            boolean bl2 = false;
            String string2 = ((CharSequence)it).length() > 0 && !StringsKt.isBlank((CharSequence)it) ? string : null;
            if (string2 == null) {
                string2 = SystemInfo.isLinux ? AsyncProfilerUtil.INSTANCE.getNoPerfEventsAccessOptions() : AsyncProfilerUtil.INSTANCE.getDefaultOptions();
            }
            String asyncOptions = string2;
            try {
                String string3 = asyncProfiler.execute(AsyncProfilerUtil.INSTANCE.appendSnapshotPath(asyncOptions, snapshotFile));
            }
            catch (IllegalStateException e) {
                TestFrameworkBaseKt.getFrameworkLogger().warn("Failed to start async profiler: " + e.getMessage());
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void stopFrontendProfiling() {
        try {
            AsyncProfiler asyncProfiler = AsyncProfilerExtractor.INSTANCE.getAsyncProfilerInstance();
            if (asyncProfiler != null) {
                asyncProfiler.stop();
            }
        }
        catch (IllegalStateException e) {
            TestFrameworkBaseKt.getFrameworkLogger().warn("Failed to stop async profiler: " + e.getMessage());
        }
    }

    public final void setupBackendProfiling() {
        SnapshotKind snapshotKind;
        SnapshotKind snapshotKind2;
        block2: {
            String snapshotKind3 = TestFrameworkSettings.Profiling.INSTANCE.getTestProfilingKind();
            System.setProperty("rider.backend.JET_SNAPSHOT_DIR", TestDirectories.INSTANCE.getSnapshotsDirectory().getAbsolutePath());
            SnapshotKind[] $this$firstOrNull$iv = SnapshotKind.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                SnapshotKind element$iv;
                SnapshotKind it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!StringsKt.equals((String)it.name(), (String)snapshotKind3, (boolean)true)) continue;
                snapshotKind2 = element$iv;
                break block2;
            }
            snapshotKind2 = snapshotKind = null;
        }
        if (snapshotKind2 == null) {
            snapshotKind = SnapshotKind.Sampling;
        }
        SnapshotKind kind = snapshotKind;
        System.setProperty("rider.backend.JET_RUN_WITH_SNAPSHOT", kind.name());
    }
}

